/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.impl.sdk;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.hardware.SensorManager;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Environment;
import android.os.LocaleList;
import android.os.PowerManager;
import android.os.SystemClock;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.DisplayMetrics;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.aa;
import com.applovin.impl.sdk.af;
import com.applovin.impl.sdk.array.ArrayService;
import com.applovin.impl.sdk.d.c;
import com.applovin.impl.sdk.e.ab;
import com.applovin.impl.sdk.e.d;
import com.applovin.impl.sdk.e.i;
import com.applovin.impl.sdk.e.q;
import com.applovin.impl.sdk.f;
import com.applovin.impl.sdk.n;
import com.applovin.impl.sdk.network.b;
import com.applovin.impl.sdk.utils.CollectionUtils;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.d;
import com.applovin.impl.sdk.utils.h;
import com.applovin.impl.sdk.utils.m;
import com.applovin.impl.sdk.utils.p;
import com.applovin.impl.sdk.utils.t;
import com.applovin.impl.sdk.utils.u;
import com.applovin.impl.sdk.w;
import com.applovin.impl.sdk.x;
import com.applovin.sdk.AppLovinBidTokenCollectionListener;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONObject;

public class o {
    private final n sdk;
    private final x logger;
    private final Context E;
    private final Map<String, Object> aDP;
    private final Object aDQ = new Object();
    private final Map<String, Object> awM;
    private boolean aDR;
    private static final AtomicReference<d.a> aDS = new AtomicReference();
    private final AtomicReference<Integer> aDT = new AtomicReference();
    private static final AtomicReference<a> aDU = new AtomicReference();

    protected o(n n2) {
        if (n2 == null) {
            throw new IllegalArgumentException("No sdk specified");
        }
        this.sdk = n2;
        this.logger = n2.Ci();
        this.E = n.getApplicationContext();
        this.aDP = this.Du();
        this.awM = this.Dy();
    }

    protected String getBidToken() {
        JSONObject jSONObject = new JSONObject(this.Do());
        byte[] byArray = jSONObject.toString().getBytes(Charset.defaultCharset());
        String string2 = Base64.encodeToString((byte[])byArray, (int)2);
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aRu).booleanValue()) {
            long l2 = u.Q(this.sdk);
            return p.a(string2, l2, p.a.gX(this.sdk.a(com.applovin.impl.sdk.c.b.aRv)), this.sdk.getSdkKey(), this.sdk);
        }
        return string2;
    }

    protected void collectBidToken(AppLovinBidTokenCollectionListener appLovinBidTokenCollectionListener) {
        Boolean bl = this.sdk.a(com.applovin.impl.sdk.c.b.aQg);
        this.sdk.Cj().a((d)new ab(this.sdk, bl, "DataCollector", () -> {
            String string2;
            try {
                string2 = this.getBidToken();
            }
            catch (Throwable throwable) {
                String string3 = "Failed to collect bid token";
                o o2 = this;
                if (o2.logger.FL()) {
                    this.logger.c("DataCollector", "Failed to collect bid token", throwable);
                }
                this.sdk.CN().d("DataCollector", "collectBidToken", throwable);
                m.b(appLovinBidTokenCollectionListener, "Failed to collect bid token");
                return;
            }
            if (StringUtils.isValidString(string2)) {
                this.sdk.Ci();
                if (x.FL()) {
                    this.sdk.Ci().f("DataCollector", "Successfully retrieved bid token");
                }
                m.a(appLovinBidTokenCollectionListener, string2);
            } else {
                String string4 = "Empty bid token";
                this.sdk.Ci();
                if (x.FL()) {
                    this.sdk.Ci().i("DataCollector", "Empty bid token");
                }
                m.b(appLovinBidTokenCollectionListener, "Empty bid token");
            }
        }), q.a.aVJ);
    }

    private Map<String, String> Do() {
        return u.r(this.a(null, true, false));
    }

    public Map<String, Object> a(@Nullable Map<String, String> map, boolean bl, boolean bl2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(64);
        Map<String, Object> map2 = this.aM(bl);
        Map<String, Object> map3 = this.Dx();
        Map<String, Object> map4 = this.DB();
        Map<String, Object> map5 = this.DC();
        Map<String, String> map6 = this.sdk.BX().getAllData();
        if (bl2) {
            hashMap.put("device_info", map2);
            hashMap.put("app_info", map3);
            if (map4 != null) {
                hashMap.put("connection_info", map4);
            }
            if (map != null) {
                hashMap.put("ad_info", map);
            }
            if (map5 != null) {
                hashMap.put("location_info", map5);
            }
            if (!map6.isEmpty()) {
                hashMap.put("targeting_data", map6);
            }
        } else {
            hashMap.putAll(map2);
            hashMap.putAll(map3);
            if (map4 != null) {
                hashMap.putAll(map4);
            }
            if (map != null) {
                hashMap.putAll(map);
            }
            if (map5 != null) {
                hashMap.putAll(map5);
            }
            if (!map6.isEmpty()) {
                hashMap.putAll(map6);
            }
        }
        hashMap.put("accept", "custom_size,launch_app,video");
        hashMap.put("format", "json");
        CollectionUtils.putStringIfValid("mediation_provider", this.sdk.getMediationProvider(), hashMap);
        CollectionUtils.putStringIfValid("mediation_provider_v2", this.sdk.Dh(), hashMap);
        CollectionUtils.putStringIfValid("plugin_version", this.sdk.a(com.applovin.impl.sdk.c.b.aQf), hashMap);
        CollectionUtils.putLongIfValid("tssf_ms", this.sdk.BT(), hashMap);
        if (!this.sdk.a(com.applovin.impl.sdk.c.b.aRs).booleanValue()) {
            hashMap.put("sdk_key", this.sdk.getSdkKey());
        }
        hashMap.putAll(this.DA());
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aQT).booleanValue()) {
            com.applovin.impl.sdk.d.d d2 = this.sdk.Cm();
            hashMap.put("li", d2.b(c.aTT));
            hashMap.put("si", d2.b(c.aTW));
            hashMap.put("mad", d2.b(c.aTU));
            hashMap.put("msad", d2.b(c.aTX));
            hashMap.put("pf", d2.b(c.aUb));
            hashMap.put("mpf", d2.b(c.aUi));
            hashMap.put("gpf", d2.b(c.aUc));
            hashMap.put("asoac", d2.b(c.aUg));
        }
        hashMap.put("rid", UUID.randomUUID().toString());
        return hashMap;
    }

    public Map<String, Object> Dp() {
        return CollectionUtils.map(this.aDP);
    }

    public Map<String, Object> Dq() {
        return CollectionUtils.map(this.awM);
    }

    public Map<String, Object> Dr() {
        return this.aM(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> aM(boolean bl) {
        Map<String, Object> map;
        Object object = this.aDQ;
        synchronized (object) {
            map = CollectionUtils.map(this.aDP);
        }
        return this.a(map, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Ds() {
        Object object = this.aDQ;
        synchronized (object) {
            this.g(this.aDP);
        }
    }

    public String Dt() {
        return AppLovinSdkUtils.isFireOS(this.E) ? "fireos" : "android";
    }

    private Map<String, Object> Du() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(34);
        hashMap.put("api_level", Build.VERSION.SDK_INT);
        hashMap.put("brand", Build.MANUFACTURER);
        hashMap.put("brand_name", Build.BRAND);
        hashMap.put("hardware", Build.HARDWARE);
        hashMap.put("sim", AppLovinSdkUtils.isEmulator());
        hashMap.put("aida", com.applovin.impl.sdk.utils.d.LH());
        hashMap.put("locale", Locale.getDefault().toString());
        hashMap.put("model", Build.MODEL);
        hashMap.put("os", Build.VERSION.RELEASE);
        hashMap.put("platform", this.Dt());
        hashMap.put("revision", Build.DEVICE);
        hashMap.put("tz_offset", this.DO());
        hashMap.put("gy", this.DP());
        hashMap.put("country_code", this.DQ());
        hashMap.put("mcc", this.DR());
        hashMap.put("mnc", this.DS());
        hashMap.put("carrier", this.DT());
        hashMap.put("is_tablet", AppLovinSdkUtils.isTablet(this.E));
        hashMap.put("tv", AppLovinSdkUtils.isTv(this.E));
        hashMap.put("pc", Runtime.getRuntime().availableProcessors());
        hashMap.put("hdr", this.DV());
        hashMap.put("supported_abis", this.DW());
        DisplayMetrics displayMetrics = this.E.getResources().getDisplayMetrics();
        if (displayMetrics != null) {
            hashMap.put("adns", Float.valueOf(displayMetrics.density));
            hashMap.put("adnsd", displayMetrics.densityDpi);
            hashMap.put("xdpi", Float.valueOf(displayMetrics.xdpi));
            hashMap.put("ydpi", Float.valueOf(displayMetrics.ydpi));
            Point point = h.Y(this.E);
            double d2 = Math.sqrt(Math.pow(point.x, 2.0) + Math.pow(point.y, 2.0));
            hashMap.put("screen_size_in", d2 / (double)displayMetrics.xdpi);
            h.a a2 = h.a(this.E, this.sdk);
            if (a2 != null) {
                hashMap.put("tl_cr", a2.LZ());
                hashMap.put("tr_cr", a2.Ma());
                hashMap.put("bl_cr", a2.Mb());
                hashMap.put("br_cr", a2.Mc());
            }
        }
        hashMap.put("bt_ms", System.currentTimeMillis() - SystemClock.elapsedRealtime());
        hashMap.put("tbalsi_ms", this.sdk.Df() - n.Dd());
        CollectionUtils.putBooleanIfValid("psase", aa.M(this.E), hashMap);
        this.g(hashMap);
        return hashMap;
    }

    private void g(Map<String, Object> map) {
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aQn).booleanValue() && !map.containsKey("af")) {
            map.put("af", this.DH());
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aQo).booleanValue() && !map.containsKey("font")) {
            map.put("font", Float.valueOf(this.DI()));
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aQv).booleanValue() && u.T(this.sdk)) {
            af.A(this.sdk);
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aQH).booleanValue()) {
            af.B(this.sdk);
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aQu).booleanValue() && !map.containsKey("sua")) {
            map.put("sua", System.getProperty("http.agent"));
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aQq).booleanValue() && !map.containsKey("network_restricted")) {
            map.put("network_restricted", this.DD());
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aQy).booleanValue()) {
            boolean bl = this.E.getResources().getConfiguration().keyboard == 2;
            boolean bl2 = this.E.getPackageManager().hasSystemFeature("com.google.android.play.feature.HPE_EXPERIENCE");
            boolean bl3 = this.E.getPackageManager().hasSystemFeature("android.hardware.type.pc");
            map.put("is_pc", bl && (bl2 || bl3));
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aQJ).booleanValue()) {
            CollectionUtils.putStringIfValid("oglv", this.DX(), map);
        }
    }

    private Map<String, Object> a(Map<String, Object> map, boolean bl) {
        ArrayService arrayService;
        PowerManager powerManager;
        String string2;
        Map<String, Object> map2;
        block38: {
            block37: {
                block36: {
                    Object object;
                    Boolean bl2;
                    Boolean bl3;
                    Boolean bl4;
                    Object object2;
                    Object object3;
                    map2 = CollectionUtils.map(map);
                    Point point = h.Y(this.E);
                    map2.put("dx", point.x);
                    map2.put("dy", point.y);
                    if (bl) {
                        object3 = aDS.get();
                        if (object3 != null) {
                            object2 = object3;
                            this.Ea();
                        } else if (u.Mp()) {
                            object2 = new d.a();
                            map2.put("inc", true);
                        } else {
                            object2 = this.DE();
                        }
                    } else {
                        object2 = this.DE();
                    }
                    object3 = ((d.a)object2).LJ();
                    if (StringUtils.isValidString((String)object3)) {
                        map2.put("idfa", object3);
                    }
                    map2.put("dnt", ((d.a)object2).LI());
                    map2.put("dnt_code", ((d.a)object2).LK().LL());
                    a a2 = aDU.get();
                    if (this.sdk.a(com.applovin.impl.sdk.c.b.aPU).booleanValue() && a2 != null) {
                        map2.put("idfv", a2.do);
                        map2.put("idfv_scope", a2.aDW);
                    }
                    if ((bl4 = com.applovin.impl.privacy.a.Ah().B(this.E)) != null) {
                        map2.put("huc", bl4);
                    }
                    if ((bl3 = com.applovin.impl.privacy.a.Ag().B(this.E)) != null) {
                        map2.put("aru", bl3);
                    }
                    if ((bl2 = com.applovin.impl.privacy.a.Ai().B(this.E)) != null) {
                        map2.put("dns", bl2);
                    }
                    if (this.sdk.a(com.applovin.impl.sdk.c.b.aQh).booleanValue()) {
                        object = this.DG();
                        CollectionUtils.putIntegerIfValid("act", ((b)object).aDX, map2);
                        CollectionUtils.putIntegerIfValid("acm", ((b)object).adn, map2);
                        CollectionUtils.putBooleanIfValid("sowpie", ((b)object).aDY, map2);
                    }
                    if (this.sdk.a(com.applovin.impl.sdk.c.b.aQp).booleanValue()) {
                        map2.put("mtl", this.sdk.Cz().getLastTrimMemoryLevel());
                    }
                    if (this.sdk.a(com.applovin.impl.sdk.c.b.aQs).booleanValue()) {
                        map2.put("adr", this.DU());
                    }
                    Object object4 = object = bl ? this.aDT.get() : this.DL();
                    if (object != null) {
                        map2.put("volume", object);
                    }
                    CollectionUtils.putBooleanIfValid("ma", this.DM(), map2);
                    CollectionUtils.putBooleanIfValid("spo", this.DN(), map2);
                    CollectionUtils.putBooleanIfValid("aif", !this.sdk.Cz().isApplicationPaused(), map2);
                    CollectionUtils.putLongIfValid("af_ts_ms", this.sdk.Cz().getAppEnteredForegroundTimeMillis(), map2);
                    CollectionUtils.putLongIfValid("ab_ts_ms", this.sdk.Cz().getAppEnteredBackgroundTimeMillis(), map2);
                    try {
                        int n2 = Settings.System.getInt((ContentResolver)this.E.getContentResolver(), (String)"screen_brightness");
                        float f2 = (float)n2 / 255.0f;
                        map2.put("sb", (int)(f2 * 100.0f));
                    }
                    catch (Settings.SettingNotFoundException settingNotFoundException) {
                        o o2 = this;
                        if (!o2.logger.FL()) break block36;
                        this.logger.c("DataCollector", "Unable to collect screen brightness", settingNotFoundException);
                    }
                }
                if (this.sdk.a(com.applovin.impl.sdk.c.b.aQv).booleanValue() && u.T(this.sdk)) {
                    af.A(this.sdk);
                    String string3 = af.FW();
                    if (StringUtils.isValidString(string3)) {
                        map2.put("ua", string3);
                    }
                }
                if (this.sdk.a(com.applovin.impl.sdk.c.b.aQH).booleanValue()) {
                    af.B(this.sdk);
                    CollectionUtils.putIntegerIfValid("wvvc", af.FY(), map2);
                    CollectionUtils.putStringIfValid("wvv", af.FZ(), map2);
                    CollectionUtils.putStringIfValid("wvpn", af.Ga(), map2);
                }
                if (this.sdk.a(com.applovin.impl.sdk.c.b.aQj).booleanValue()) {
                    try {
                        map2.put("fs", Environment.getDataDirectory().getFreeSpace());
                        map2.put("tds", Environment.getDataDirectory().getTotalSpace());
                    }
                    catch (Throwable throwable) {
                        map2.put("fs", -1);
                        map2.put("tds", -1);
                        o o3 = this;
                        if (!o3.logger.FL()) break block37;
                        this.logger.c("DataCollector", "Unable to collect total & free space.", throwable);
                    }
                }
            }
            if (this.sdk.a(com.applovin.impl.sdk.c.b.aQk).booleanValue()) {
                ActivityManager activityManager = (ActivityManager)this.E.getSystemService("activity");
                ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
                if (activityManager != null) {
                    try {
                        activityManager.getMemoryInfo(memoryInfo);
                        map2.put("fm", memoryInfo.availMem);
                        map2.put("tm", memoryInfo.totalMem);
                        map2.put("lmt", memoryInfo.threshold);
                        map2.put("lm", memoryInfo.lowMemory);
                    }
                    catch (Throwable throwable) {
                        map2.put("fm", -1);
                        map2.put("tm", -1);
                        map2.put("lmt", -1);
                        o o4 = this;
                        if (!o4.logger.FL()) break block38;
                        this.logger.c("DataCollector", "Unable to collect memory info.", throwable);
                    }
                }
            }
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aQl).booleanValue() && h.d("android.permission.READ_PHONE_STATE", this.E) && h.LR()) {
            TelephonyManager telephonyManager = (TelephonyManager)this.E.getSystemService("phone");
            int n3 = telephonyManager.getDataNetworkType();
            map2.put("rat", n3);
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aQi).booleanValue() && !TextUtils.isEmpty((CharSequence)(string2 = this.DJ()))) {
            map2.put("so", string2);
        }
        map2.put("orientation_lock", this.Dv());
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aQm).booleanValue()) {
            map2.put("vs", u.Mr());
        }
        if (h.LP() && (powerManager = (PowerManager)this.E.getSystemService("power")) != null) {
            map2.put("lpm", powerManager.isPowerSaveMode() ? 1 : 0);
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aQw).booleanValue() && this.sdk.CD() != null) {
            map2.put("da", Float.valueOf(this.sdk.CD().Mk()));
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aQx).booleanValue() && this.sdk.CD() != null) {
            map2.put("dm", Float.valueOf(this.sdk.CD().Mj()));
        }
        map2.put("mute_switch", this.sdk.CE().Bq());
        map2.put("network", com.applovin.impl.sdk.utils.i.J(this.sdk));
        String string4 = this.DK();
        if (StringUtils.isValidString(string4)) {
            map2.put("kb", string4);
        }
        if ((arrayService = this.sdk.CM()).isAppHubInstalled()) {
            if (arrayService.getIsDirectDownloadEnabled() != null) {
                map2.put("ah_dd_enabled", arrayService.getIsDirectDownloadEnabled());
            }
            map2.put("ah_sdk_version_code", arrayService.getAppHubVersionCode());
            map2.put("ah_random_user_token", StringUtils.emptyIfNull(arrayService.getRandomUserToken()));
            map2.put("ah_sdk_package_name", StringUtils.emptyIfNull(arrayService.getAppHubPackageName()));
        }
        return map2;
    }

    private String Dv() {
        String string2 = "none";
        int n2 = AppLovinSdkUtils.getOrientation(this.E);
        if (n2 == 1) {
            string2 = "portrait";
        } else if (n2 == 2) {
            string2 = "landscape";
        }
        return string2;
    }

    public boolean Dw() {
        return this.aDR;
    }

    public Map<String, Object> Dx() {
        String string2;
        Map<String, Object> map = CollectionUtils.map(this.awM);
        map.put("first_install", this.sdk.Dg());
        map.put("first_install_v2", !this.sdk.Cg());
        map.put("test_ads", this.aDR);
        map.put("muted", this.sdk.getSettings().isMuted());
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPV).booleanValue()) {
            CollectionUtils.putStringIfValid("cuid", this.sdk.BU(), map);
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPY).booleanValue()) {
            map.put("compass_random_token", this.sdk.BV());
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aQa).booleanValue()) {
            map.put("applovin_random_token", this.sdk.BW());
        }
        if (StringUtils.isValidString(string2 = this.sdk.getUserSegment().getName())) {
            map.put("user_segment_name", string2);
        }
        map.putAll(this.Dz());
        if (this.sdk.Cs() != null) {
            CollectionUtils.putJsonArrayIfValid("ps_topics", this.sdk.Cs().FR(), map);
        }
        return map;
    }

    private Map<String, Object> Dy() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        PackageManager packageManager = this.E.getPackageManager();
        ApplicationInfo applicationInfo = this.E.getApplicationInfo();
        File file = new File(applicationInfo.sourceDir);
        long l2 = file.lastModified();
        PackageInfo packageInfo = null;
        String string2 = null;
        try {
            packageInfo = packageManager.getPackageInfo(this.E.getPackageName(), 0);
            string2 = packageManager.getInstallerPackageName(applicationInfo.packageName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        hashMap.put("app_name", packageManager.getApplicationLabel(applicationInfo));
        hashMap.put("app_version", packageInfo != null ? packageInfo.versionName : "");
        hashMap.put("app_version_code", packageInfo != null ? packageInfo.versionCode : -1);
        hashMap.put("package_name", applicationInfo.packageName);
        hashMap.put("vz", StringUtils.toShortSHA1Hash(applicationInfo.packageName));
        hashMap.put("installer_name", string2 != null ? string2 : "");
        hashMap.put("tg", t.P(this.sdk));
        o o2 = this;
        hashMap.put("debug", u.b(o2.sdk.getApplicationContext(), this.sdk));
        hashMap.put("ia", l2);
        hashMap.put("alts_ms", n.Dd());
        hashMap.put("j8", n.De());
        hashMap.put("ps_tpg", aa.O(this.E));
        hashMap.put("ps_apg", aa.P(this.E));
        hashMap.put("ps_capg", aa.Q(this.E));
        hashMap.put("ps_aipg", aa.R(this.E));
        Long l3 = this.sdk.a(com.applovin.impl.sdk.c.d.aSS);
        if (l3 != null) {
            hashMap.put("ia_v2", l3);
        } else {
            this.sdk.a(com.applovin.impl.sdk.c.d.aSS, l2);
        }
        hashMap.put("sdk_version", AppLovinSdk.VERSION);
        hashMap.put("omid_sdk_version", this.sdk.CK().getSdkVersion());
        CollectionUtils.putStringIfValid("ad_review_sdk_version", f.getVersion(), hashMap);
        hashMap.put("api_did", this.sdk.a(com.applovin.impl.sdk.c.b.aLu));
        hashMap.put("first_install_v3_ms", packageInfo != null ? Long.valueOf(packageInfo.firstInstallTime) : "");
        hashMap.put("target_sdk", applicationInfo.targetSdkVersion);
        hashMap.put("epv", u.Mu());
        return hashMap;
    }

    private Map<String, Object> Dz() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        CollectionUtils.putIntegerIfValid("IABTCF_gdprApplies", this.sdk.CH().AM(), hashMap);
        CollectionUtils.putStringIfValid("IABTCF_TCString", this.sdk.CH().AN(), hashMap);
        CollectionUtils.putStringIfValid("IABTCF_AddtlConsent", this.sdk.CH().AO(), hashMap);
        return hashMap;
    }

    public Map<String, Object> DA() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("sc", this.sdk.a(com.applovin.impl.sdk.c.b.aLF));
        hashMap.put("sc2", this.sdk.a(com.applovin.impl.sdk.c.b.aLG));
        hashMap.put("sc3", this.sdk.a(com.applovin.impl.sdk.c.b.aLH));
        hashMap.put("server_installed_at", this.sdk.a(com.applovin.impl.sdk.c.b.aLI));
        String string2 = this.sdk.a(com.applovin.impl.sdk.c.d.aTu);
        CollectionUtils.putStringIfValid("persisted_data", string2, hashMap);
        return hashMap;
    }

    @Nullable
    public Map<String, Object> DB() {
        b.c c2 = this.sdk.Cl().IG();
        if (c2 == null) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("lrm_ts_ms", String.valueOf(c2.II()));
        hashMap.put("lrm_url", c2.IJ());
        hashMap.put("lrm_ct_ms", String.valueOf(c2.IL()));
        hashMap.put("lrm_rs", String.valueOf(c2.IK()));
        return hashMap;
    }

    @Nullable
    public Map<String, Object> DC() {
        if (!this.sdk.getSettings().isLocationCollectionEnabled()) {
            return null;
        }
        if (!this.sdk.a(com.applovin.impl.sdk.c.b.aQQ).booleanValue()) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        w w2 = this.sdk.CL();
        boolean bl = w2.FG();
        hashMap.put("loc_services_enabled", bl);
        if (!bl) {
            return hashMap;
        }
        hashMap.put("loc_auth", w2.FF());
        if (w2.FH()) {
            hashMap.put("loc_lat", u.a(w2.FJ(), this.sdk.a(com.applovin.impl.sdk.c.b.aQS)));
            hashMap.put("loc_long", u.a(w2.FK(), this.sdk.a(com.applovin.impl.sdk.c.b.aQS)));
        }
        return hashMap;
    }

    private boolean DD() {
        block4: {
            if (!h.LR()) {
                return false;
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)this.E.getSystemService("connectivity");
            if (connectivityManager != null) {
                try {
                    int n2 = connectivityManager.getRestrictBackgroundStatus();
                    return n2 == 3;
                }
                catch (Throwable throwable) {
                    this.sdk.Ci();
                    if (!x.FL()) break block4;
                    this.sdk.Ci().c("DataCollector", "Unable to collect constrained network info.", throwable);
                }
            }
        }
        return false;
    }

    public d.a DE() {
        List<String> list;
        d.a a2 = com.applovin.impl.sdk.utils.d.U(this.E);
        if (a2 == null) {
            return new d.a();
        }
        if (this.sdk.a(com.applovin.impl.sdk.c.b.aPT).booleanValue()) {
            boolean bl = a2.LI();
            if (bl && !this.sdk.a(com.applovin.impl.sdk.c.b.aPS).booleanValue()) {
                a2.dE("");
            }
            aDS.set(a2);
        } else {
            a2 = new d.a();
        }
        this.aDR = StringUtils.isValidString(a2.LJ()) ? (list = this.sdk.getSettings().getTestDeviceAdvertisingIds()) != null && list.contains(a2.LJ()) : false;
        return a2;
    }

    public static void a(d.a a2) {
        aDS.set(a2);
    }

    @Nullable
    public a DF() {
        return aDU.get();
    }

    public static void a(a a2) {
        aDU.set(a2);
    }

    private b DG() {
        int n2;
        int n3;
        int n4;
        b b2 = new b();
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = this.E.registerReceiver(null, intentFilter);
        int n5 = intent != null ? intent.getIntExtra("level", -1) : -1;
        int n6 = n4 = intent != null ? intent.getIntExtra("scale", -1) : -1;
        if (n5 > 0 && n4 > 0) {
            float f2 = (float)n5 / (float)n4;
            b2.adn = (int)(f2 * 100.0f);
        } else {
            b2.adn = -1;
        }
        int n7 = b2.aDX = intent != null ? intent.getIntExtra("status", -1) : -1;
        b2.aDY = h.LN() ? Boolean.valueOf(Settings.Global.getInt((ContentResolver)this.E.getContentResolver(), (String)"stay_on_while_plugged_in", (int)-1) > 0) : Boolean.valueOf((n3 = (n2 = intent.getIntExtra("plugged", -1)) & 1 | 2 | 4 | 8) > 0);
        return b2;
    }

    private long DH() {
        int n2;
        int n3;
        String string2 = StringUtils.emptyIfNull(Settings.Secure.getString((ContentResolver)this.E.getContentResolver(), (String)"enabled_accessibility_services"));
        List<String> list = Arrays.asList(string2.split(":"));
        long l2 = 0L;
        if (list.contains("AccessibilityMenuService")) {
            l2 |= 0x100L;
        }
        if (list.contains("SelectToSpeakService")) {
            l2 |= 0x200L;
        }
        if (list.contains("SoundAmplifierService")) {
            l2 |= 2L;
        }
        if (list.contains("SpeechToTextAccessibilityService")) {
            l2 |= 0x80L;
        }
        if (list.contains("SwitchAccessService")) {
            l2 |= 4L;
        }
        if ((n3 = this.E.getResources().getConfiguration().uiMode & 0x30) == 32) {
            l2 |= 0x400L;
        }
        if (this.cE("accessibility_enabled")) {
            l2 |= 8L;
        }
        if (this.cE("touch_exploration_enabled")) {
            l2 |= 0x10L;
        }
        if (h.LP()) {
            if (this.cE("accessibility_display_inversion_enabled")) {
                l2 |= 0x20L;
            }
            if (this.cE("skip_first_use_hints")) {
                l2 |= 0x40L;
            }
        }
        if (this.cE("lock_screen_allow_remote_input")) {
            l2 |= 0x800L;
        }
        if (this.cE("enabled_accessibility_audio_description_by_default")) {
            l2 |= 0x1000L;
        }
        if (this.cE("accessibility_shortcut_on_lock_screen")) {
            l2 |= 0x2000L;
        }
        if (this.cE("wear_talkback_enabled")) {
            l2 |= 0x4000L;
        }
        if (this.cE("hush_gesture_used")) {
            l2 |= 0x8000L;
        }
        if (this.cE("high_text_contrast_enabled")) {
            l2 |= 0x10000L;
        }
        if (this.cE("accessibility_display_magnification_enabled")) {
            l2 |= 0x20000L;
        }
        if (this.cE("accessibility_display_magnification_navbar_enabled")) {
            l2 |= 0x40000L;
        }
        if (this.cE("accessibility_captioning_enabled")) {
            l2 |= 0x80000L;
        }
        if (this.cE("accessibility_display_daltonizer_enabled")) {
            l2 |= 0x100000L;
        }
        if (this.cE("accessibility_autoclick_enabled")) {
            l2 |= 0x200000L;
        }
        if (this.cE("accessibility_large_pointer_icon")) {
            l2 |= 0x400000L;
        }
        if (this.cE("reduce_bright_colors_activated")) {
            l2 |= 0x800000L;
        }
        if (this.cE("reduce_bright_colors_persist_across_reboots")) {
            l2 |= 0x1000000L;
        }
        if (this.cE("tty_mode_enabled")) {
            l2 |= 0x2000000L;
        }
        if (this.cE("rtt_calling_mode")) {
            l2 |= 0x4000000L;
        }
        if (this.cE("accessibility_floating_menu_fade_enabled")) {
            l2 |= 0x8000000L;
        }
        if (this.cE("accessibility_show_window_magnification_prompt")) {
            l2 |= 0x10000000L;
        }
        if (this.cE("accessibility_floating_menu_migration_tooltip_prompt")) {
            l2 |= 0x20000000L;
        }
        if ((n2 = this.cF("accessibility_magnification_mode")) == 0) {
            l2 |= 0x40000000L;
        } else if (n2 == 1) {
            l2 |= 0x80000000L;
        } else if (n2 == 2) {
            l2 |= 0x100000000L;
        } else if (n2 == 3) {
            l2 |= 0x200000000L;
        }
        int n4 = this.cF("accessibility_button_mode");
        if (n4 == 0) {
            l2 |= 0x400000000L;
        } else if (n4 == 1) {
            l2 |= 0x800000000L;
        }
        int n5 = this.cF("accessibility_floating_menu_size");
        if (n5 == 0) {
            l2 |= 0x1000000000L;
        } else if (n5 == 1) {
            l2 |= 0x2000000000L;
        }
        int n6 = this.cF("accessibility_floating_menu_icon_type");
        if (n6 == 0) {
            l2 |= 0x4000000000L;
        } else if (n6 == 1) {
            l2 |= 0x8000000000L;
        }
        return l2;
    }

    private boolean cE(String string2) {
        return this.cF(string2) == 1;
    }

    private int cF(String string2) {
        try {
            return Settings.Secure.getInt((ContentResolver)this.E.getContentResolver(), (String)string2);
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    private float DI() {
        try {
            return Settings.System.getFloat((ContentResolver)this.E.getContentResolver(), (String)"font_scale");
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            o o2 = this;
            if (o2.logger.FL()) {
                this.logger.c("DataCollector", "Error collecting font scale", settingNotFoundException);
            }
            return -1.0f;
        }
    }

    private String DJ() {
        AudioManager audioManager = (AudioManager)this.E.getSystemService("audio");
        if (audioManager != null) {
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            if (h.LQ()) {
                for (AudioDeviceInfo audioDeviceInfo : object = audioManager.getDevices(2)) {
                    stringBuilder.append(audioDeviceInfo.getType());
                    stringBuilder.append(",");
                }
            } else {
                if (audioManager.isWiredHeadsetOn()) {
                    stringBuilder.append(3);
                    stringBuilder.append(",");
                }
                if (audioManager.isBluetoothScoOn()) {
                    stringBuilder.append(7);
                    stringBuilder.append(",");
                }
                if (audioManager.isBluetoothA2dpOn()) {
                    stringBuilder.append(8);
                }
            }
            if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            if (TextUtils.isEmpty((CharSequence)(object = stringBuilder.toString()))) {
                o o2 = this;
                if (o2.logger.FL()) {
                    this.logger.f("DataCollector", "No sound outputs detected");
                }
            }
            return object;
        }
        return null;
    }

    private String DK() {
        if (!h.LR()) {
            return null;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder();
            LocaleList localeList = this.E.getResources().getConfiguration().getLocales();
            for (int i2 = 0; i2 < localeList.size(); ++i2) {
                stringBuilder.append(localeList.get(i2));
                stringBuilder.append(",");
            }
            if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == ',') {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            return stringBuilder.toString();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Nullable
    private Integer DL() {
        AudioManager audioManager = (AudioManager)this.E.getSystemService("audio");
        if (audioManager == null) {
            return null;
        }
        Float f2 = this.sdk.a(com.applovin.impl.sdk.c.b.aQt);
        try {
            return (int)((float)audioManager.getStreamVolume(3) * f2.floatValue());
        }
        catch (Throwable throwable) {
            this.sdk.Ci();
            if (x.FL()) {
                this.sdk.Ci().c("DataCollector", "Unable to collect device volume", throwable);
            }
            return null;
        }
    }

    @Nullable
    private Boolean DM() {
        AudioManager audioManager = (AudioManager)this.E.getSystemService("audio");
        if (audioManager == null) {
            return null;
        }
        return audioManager.isMusicActive();
    }

    @Nullable
    private Boolean DN() {
        AudioManager audioManager = (AudioManager)this.E.getSystemService("audio");
        if (audioManager == null) {
            return null;
        }
        return audioManager.isSpeakerphoneOn();
    }

    private double DO() {
        TimeZone timeZone = TimeZone.getDefault();
        Date date = new Date();
        double d2 = timeZone.getOffset(date.getTime());
        return (double)Math.round(10.0 * d2 / 3600000.0) / 10.0;
    }

    private boolean DP() {
        SensorManager sensorManager = (SensorManager)this.E.getSystemService("sensor");
        return sensorManager != null && sensorManager.getDefaultSensor(4) != null;
    }

    private String DQ() {
        TelephonyManager telephonyManager = (TelephonyManager)this.E.getSystemService("phone");
        return telephonyManager != null ? telephonyManager.getSimCountryIso().toUpperCase(Locale.ENGLISH) : "";
    }

    private String DR() {
        block3: {
            TelephonyManager telephonyManager = (TelephonyManager)this.E.getSystemService("phone");
            if (telephonyManager != null) {
                try {
                    String string2 = telephonyManager.getNetworkOperator();
                    int n2 = Math.min(3, string2.length());
                    return string2.substring(0, n2);
                }
                catch (Throwable throwable) {
                    o o2 = this;
                    if (!o2.logger.FL()) break block3;
                    this.logger.c("DataCollector", "Unable to collect mobile country code", throwable);
                }
            }
        }
        return "";
    }

    private String DS() {
        block3: {
            TelephonyManager telephonyManager = (TelephonyManager)this.E.getSystemService("phone");
            if (telephonyManager != null) {
                try {
                    String string2 = telephonyManager.getNetworkOperator();
                    int n2 = Math.min(3, string2.length());
                    return string2.substring(n2);
                }
                catch (Throwable throwable) {
                    o o2 = this;
                    if (!o2.logger.FL()) break block3;
                    this.logger.c("DataCollector", "Unable to collect mobile network code", throwable);
                }
            }
        }
        return "";
    }

    private String DT() {
        block3: {
            TelephonyManager telephonyManager = (TelephonyManager)this.E.getSystemService("phone");
            if (telephonyManager != null) {
                try {
                    return telephonyManager.getNetworkOperatorName();
                }
                catch (Throwable throwable) {
                    o o2 = this;
                    if (!o2.logger.FL()) break block3;
                    this.logger.c("DataCollector", "Unable to collect carrier", throwable);
                }
            }
        }
        return "";
    }

    private boolean DU() {
        try {
            return this.DY() || this.DZ();
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Nullable
    private Boolean DV() {
        if (!h.LS()) {
            return null;
        }
        return this.E.getResources().getConfiguration().isScreenHdr();
    }

    private JSONArray DW() {
        if (h.LP()) {
            return CollectionUtils.toJSONArray(Build.SUPPORTED_ABIS);
        }
        JSONArray jSONArray = new JSONArray();
        JsonUtils.putStringIfValid(jSONArray, Build.CPU_ABI);
        JsonUtils.putStringIfValid(jSONArray, Build.CPU_ABI2);
        return jSONArray;
    }

    @Nullable
    public String DX() {
        ActivityManager activityManager = (ActivityManager)this.E.getSystemService("activity");
        if (activityManager == null) {
            return null;
        }
        return activityManager.getDeviceConfigurationInfo().getGlEsVersion();
    }

    private boolean DY() {
        String string2 = "lz}$blpz";
        String string3 = Build.TAGS;
        return string3 != null && string3.contains(this.cG("lz}$blpz"));
    }

    private boolean DZ() {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{"&zpz}ld&hyy&Z|yl{|zl{'hyb", "&zk`g&z|", "&zpz}ld&k`g&z|", "&zpz}ld&qk`g&z|", "&mh}h&efjhe&qk`g&z|", "&mh}h&efjhe&k`g&z|", "&zpz}ld&zm&qk`g&z|", "&zpz}ld&k`g&oh`ezhol&z|", "&mh}h&efjhe&z|"}) {
            String string3 = this.cG(string2);
            if (!new File(string3).exists()) continue;
            return true;
        }
        return false;
    }

    private String cG(String string2) {
        int n2 = string2.length();
        int[] nArray = new int[]{11, 12, 10, 3, 2, 1, 15, 10, 15, 14};
        int n3 = nArray.length;
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = string2.charAt(i2);
            for (int i3 = n3 - 1; i3 >= 0; --i3) {
                int n4 = i2;
                cArray[n4] = (char)(cArray[n4] ^ nArray[i3]);
            }
        }
        return new String(cArray);
    }

    public void Ea() {
        this.sdk.Cj().a((d)new i(this.sdk, new i.a(){

            @Override
            public void b(d.a a2) {
                aDS.set(a2);
            }
        }), q.a.aVN);
        this.sdk.Cj().a((d)new ab(this.sdk, true, "setDeviceVolume", () -> this.aDT.set(this.DL())), q.a.aVN);
    }

    public static class b {
        public int aDX = -1;
        public int adn = -1;
        public Boolean aDY = null;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class a {
        public final String do;
        public final int aDW;

        public a(String string2, int n2) {
            this.do = string2;
            this.aDW = n2;
        }
    }
}

