/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.applovin.impl.mediation.e.c;
import com.applovin.impl.sdk.x;
import com.applovin.sdk.AppLovinSdkUtils;

public class MaxAdFormat {
    public static final MaxAdFormat BANNER = new MaxAdFormat("BANNER", "Banner");
    public static final MaxAdFormat MREC = new MaxAdFormat("MREC", "MREC");
    public static final MaxAdFormat LEADER = new MaxAdFormat("LEADER", "Leader");
    public static final MaxAdFormat INTERSTITIAL = new MaxAdFormat("INTER", "Interstitial");
    public static final MaxAdFormat APP_OPEN = new MaxAdFormat("APPOPEN", "App Open");
    public static final MaxAdFormat REWARDED = new MaxAdFormat("REWARDED", "Rewarded");
    public static final MaxAdFormat REWARDED_INTERSTITIAL = new MaxAdFormat("REWARDED_INTER", "Rewarded Interstitial");
    public static final MaxAdFormat NATIVE = new MaxAdFormat("NATIVE", "Native");
    private final String dp;
    private final String aoU;

    @Nullable
    public static MaxAdFormat formatFromString(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        if (string2.equalsIgnoreCase("banner")) {
            return BANNER;
        }
        if (string2.equalsIgnoreCase("mrec")) {
            return MREC;
        }
        if (string2.equalsIgnoreCase("native")) {
            return NATIVE;
        }
        if (string2.equalsIgnoreCase("leaderboard") || string2.equalsIgnoreCase("leader")) {
            return LEADER;
        }
        if (string2.equalsIgnoreCase("interstitial") || string2.equalsIgnoreCase("inter")) {
            return INTERSTITIAL;
        }
        if (string2.equalsIgnoreCase("appopen") || string2.equalsIgnoreCase("app_open")) {
            return APP_OPEN;
        }
        if (string2.equalsIgnoreCase("rewarded") || string2.equalsIgnoreCase("reward")) {
            return REWARDED;
        }
        if (string2.equalsIgnoreCase("rewarded_inter") || string2.equalsIgnoreCase("rewarded_interstitial")) {
            return REWARDED_INTERSTITIAL;
        }
        x.I("AppLovinSdk", "Unknown ad format: " + string2);
        return null;
    }

    private MaxAdFormat(String string2, String string3) {
        this.dp = string2;
        this.aoU = string3;
    }

    public String getLabel() {
        return this.dp;
    }

    public AppLovinSdkUtils.Size getSize() {
        if (this == BANNER) {
            return new AppLovinSdkUtils.Size(320, 50);
        }
        if (this == LEADER) {
            return new AppLovinSdkUtils.Size(728, 90);
        }
        if (this == MREC) {
            return new AppLovinSdkUtils.Size(300, 250);
        }
        return new AppLovinSdkUtils.Size(0, 0);
    }

    public AppLovinSdkUtils.Size getAdaptiveSize(Activity activity) {
        return this.getAdaptiveSize(-1, (Context)activity);
    }

    public AppLovinSdkUtils.Size getAdaptiveSize(int n2, Context context) {
        if (this == BANNER || this == LEADER) {
            return c.a(n2, this, context);
        }
        return this.getSize();
    }

    public boolean isFullscreenAd() {
        return this == INTERSTITIAL || this == APP_OPEN || this == REWARDED || this == REWARDED_INTERSTITIAL;
    }

    public boolean isAdViewAd() {
        return this == BANNER || this == MREC || this == LEADER;
    }

    public boolean isBannerOrLeaderAd() {
        return this == BANNER || this == LEADER;
    }

    public String toString() {
        return "MaxAdFormat{label='" + this.dp + '\'' + '}';
    }

    @Deprecated
    public String getDisplayName() {
        return this.aoU;
    }
}

