/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.sdk;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.impl.privacy.a.c;
import com.applovin.impl.privacy.a.d;
import com.applovin.impl.sdk.AppLovinSdkSettingsBase;
import com.applovin.impl.sdk.n;
import com.applovin.impl.sdk.utils.CollectionUtils;
import com.applovin.impl.sdk.utils.JsonUtils;
import com.applovin.impl.sdk.utils.StringUtils;
import com.applovin.impl.sdk.utils.u;
import com.applovin.impl.sdk.x;
import com.applovin.sdk.AppLovinSdkConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class AppLovinSdkSettings
extends AppLovinSdkSettingsBase {
    private boolean bas;
    private boolean it;
    private boolean bat = true;
    private boolean bau = true;
    private boolean bav = true;
    private boolean baw = true;
    private String bax;
    private final Map<String, Object> localSettings = new HashMap<String, Object>();
    private final Map<String, String> metaData = new HashMap<String, String>();
    private List<String> bay = Collections.emptyList();
    private List<String> baz = Collections.emptyList();
    private final Map<String, String> extraParameters = new HashMap<String, String>();
    private final Object baA = new Object();
    @Nullable
    private n sdk;
    private String abm = "";

    public AppLovinSdkSettings(Context context) {
        if (context == null) {
            x.I("AppLovinSdkSettings", "context cannot be null. Please provide a valid context.");
        }
        Context context2 = u.an(context);
        this.bas = u.ae(context2);
        this.backingConsentFlowSettings = c.D(context2);
        this.abm = context2.getPackageName();
        this.ap(context2);
    }

    public TermsAndPrivacyPolicyFlowSettings getTermsAndPrivacyPolicyFlowSettings() {
        d d2 = (d)this.backingConsentFlowSettings;
        d2.a(d.a.ayE);
        return this.backingConsentFlowSettings;
    }

    public void setTestDeviceAdvertisingIds(List<String> list) {
        x.logApiCall("AppLovinSdkSettings", "setTestDeviceAdvertisingIds(testDeviceAdvertisingIds=" + list + ")");
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string2 : list) {
                if (string2 != null && string2.length() == 36) {
                    arrayList.add(string2);
                    continue;
                }
                x.I("AppLovinSdkSettings", "Unable to set test device advertising id (" + string2 + ") - please make sure it is in the format of xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx");
            }
            this.bay = arrayList;
        } else {
            this.bay = Collections.emptyList();
        }
    }

    public List<String> getTestDeviceAdvertisingIds() {
        return this.bay;
    }

    public void setInitializationAdUnitIds(List<String> list) {
        x.logApiCall("AppLovinSdkSettings", "setInitializationAdUnitIds(initializationAdUnitIds=" + list + ")");
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string2 : list) {
                if (!StringUtils.isValidString(string2) || string2.length() <= 0) continue;
                if (string2.length() == 16) {
                    arrayList.add(string2);
                    continue;
                }
                x.I("AppLovinSdkSettings", "Unable to set initialization ad unit id (" + string2 + ") - please make sure it is in the format of XXXXXXXXXXXXXXXX");
            }
            this.baz = arrayList;
        } else {
            this.baz = Collections.emptyList();
        }
    }

    public List<String> getInitializationAdUnitIds() {
        return this.baz;
    }

    public void setVerboseLogging(boolean bl) {
        x.logApiCall("AppLovinSdkSettings", "setVerboseLogging(isVerboseLoggingEnabled=" + bl + ")");
        if (u.Mo()) {
            x.I("AppLovinSdkSettings", "Ignoring setting of verbose logging - it is configured from Android manifest already.");
            if (u.ae(null) != bl) {
                x.I("AppLovinSdkSettings", "Attempted to programmatically set verbose logging flag to value different from value configured in Android Manifest.");
            }
        } else {
            this.bas = bl;
        }
    }

    public boolean isVerboseLoggingEnabled() {
        return this.bas;
    }

    public boolean isMuted() {
        return this.it;
    }

    public void setMuted(boolean bl) {
        x.logApiCall("AppLovinSdkSettings", "setMuted(muted=" + bl + ")");
        this.it = bl;
    }

    public void setCreativeDebuggerEnabled(boolean bl) {
        x.logApiCall("AppLovinSdkSettings", "setCreativeDebuggerEnabled(creativeDebuggerEnabled=" + bl + ")");
        if (this.bat == bl) {
            return;
        }
        this.bat = bl;
        if (this.sdk == null) {
            return;
        }
        if (bl) {
            this.sdk.CJ().tG();
        } else {
            this.sdk.CJ().tH();
        }
    }

    public boolean isCreativeDebuggerEnabled() {
        return this.bat;
    }

    public void setExceptionHandlerEnabled(boolean bl) {
        x.logApiCall("AppLovinSdkSettings", "setExceptionHandlerEnabled(exceptionHandlerEnabled=" + bl + ")");
        this.bau = bl;
    }

    public boolean isExceptionHandlerEnabled() {
        return this.bau;
    }

    public void setLocationCollectionEnabled(boolean bl) {
        x.logApiCall("AppLovinSdkSettings", "setLocationCollectionEnabled(locationCollectionEnabled=" + bl + ")");
        this.bav = bl;
    }

    public boolean isLocationCollectionEnabled() {
        return this.bav;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getExtraParameters() {
        Object object = this.baA;
        synchronized (object) {
            return CollectionUtils.map(this.extraParameters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExtraParameter(String string2, @Nullable String string3) {
        String string4;
        x.logApiCall("AppLovinSdkSettings", "setExtraParameter(key=" + string2 + ", value=" + string3 + ")");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            x.I("AppLovinSdkSettings", "Failed to set extra parameter for null or empty key: " + string2);
            return;
        }
        String string5 = string4 = string3 != null ? string3.trim() : null;
        if ("test_mode_network".equalsIgnoreCase(string2)) {
            if (this.sdk != null) {
                if (StringUtils.isValidString(string4)) {
                    this.sdk.Da().C(Arrays.asList(string4.split(",")));
                } else {
                    this.sdk.Da().bU(null);
                }
            } else {
                this.bax = string4;
            }
        } else if (("fan".equals(string2) || "esc".equals(string2)) && !this.abm.startsWith("com.unity.")) {
            return;
        }
        Object object = this.baA;
        synchronized (object) {
            this.extraParameters.put(string2, string4);
        }
    }

    public void setShouldFailAdDisplayIfDontKeepActivitiesIsEnabled(boolean bl) {
        x.logApiCall("AppLovinSdkSettings", "setShouldFailAdDisplayIfDontKeepActivitiesIsEnabled(shouldFailAdDisplayIfDontKeepActivitiesIsEnabled=" + bl + ")");
        this.baw = bl;
    }

    public boolean shouldFailAdDisplayIfDontKeepActivitiesIsEnabled() {
        return this.baw;
    }

    protected void attachAppLovinSdk(n n2) {
        this.sdk = n2;
        if (StringUtils.isValidString(this.bax)) {
            n2.Da().C(Arrays.asList(this.bax.split(",")));
            this.bax = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"DiscouragedApi"})
    private void ap(Context context) {
        int n2 = context.getResources().getIdentifier("applovin_settings", "raw", context.getPackageName());
        if (n2 == 0) {
            return;
        }
        String string2 = u.a(n2, context, null);
        JSONObject jSONObject = StringUtils.isValidString(string2) ? JsonUtils.jsonObjectFromJsonString(string2, new JSONObject()) : new JSONObject();
        Map<String, String> map = JsonUtils.tryToStringMap(jSONObject);
        Object object = this.baA;
        synchronized (object) {
            this.extraParameters.putAll(map);
        }
    }

    @Deprecated
    public TermsFlowSettings getTermsFlowSettings() {
        d d2 = (d)this.backingConsentFlowSettings;
        d2.a(d.a.ayD);
        return this.backingConsentFlowSettings;
    }

    @NonNull
    public String toString() {
        return "AppLovinSdkSettings{isVerboseLoggingEnabled=" + this.bas + ", muted=" + this.it + ", testDeviceAdvertisingIds=" + this.bay.toString() + ", initializationAdUnitIds=" + this.baz.toString() + ", creativeDebuggerEnabled=" + this.bat + ", exceptionHandlerEnabled=" + this.bau + ", locationCollectionEnabled=" + this.bav + '}';
    }

    public static interface TermsFlowSettings {
        public boolean isEnabled();

        public void setEnabled(boolean var1);

        @Nullable
        public Uri getPrivacyPolicyUri();

        public void setPrivacyPolicyUri(Uri var1);

        @Nullable
        public Uri getTermsOfServiceUri();

        public void setTermsOfServiceUri(Uri var1);
    }

    public static interface TermsAndPrivacyPolicyFlowSettings
    extends TermsFlowSettings {
        public AppLovinSdkConfiguration.ConsentFlowUserGeography getDebugUserGeography();

        public void setDebugUserGeography(AppLovinSdkConfiguration.ConsentFlowUserGeography var1);
    }
}

