/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.WindowMetrics;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.impl.sdk.utils.BundleUtils;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxRewardedInterstitialAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxAppOpenAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxNativeAdAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkUtils;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdError;
import com.google.android.gms.ads.AdFormat;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.MediaContent;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.RequestConfiguration;
import com.google.android.gms.ads.ResponseInfo;
import com.google.android.gms.ads.appopen.AppOpenAd;
import com.google.android.gms.ads.initialization.AdapterStatus;
import com.google.android.gms.ads.initialization.InitializationStatus;
import com.google.android.gms.ads.initialization.OnInitializationCompleteListener;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.google.android.gms.ads.nativead.MediaView;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdOptions;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.google.android.gms.ads.query.QueryInfo;
import com.google.android.gms.ads.query.QueryInfoGenerationCallback;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.google.android.gms.ads.rewardedinterstitial.RewardedInterstitialAd;
import com.google.android.gms.ads.rewardedinterstitial.RewardedInterstitialAdLoadCallback;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class GoogleMediationAdapter
extends MediationAdapterBase
implements MaxSignalProvider,
MaxInterstitialAdapter,
MaxRewardedInterstitialAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter {
    private static final int TITLE_LABEL_TAG = 1;
    private static final int MEDIA_VIEW_CONTAINER_TAG = 2;
    private static final int ICON_VIEW_TAG = 3;
    private static final int BODY_VIEW_TAG = 4;
    private static final int CALL_TO_ACTION_VIEW_TAG = 5;
    private static final int ADVERTISER_VIEW_TAG = 8;
    private static final AtomicBoolean initialized = new AtomicBoolean();
    private static MaxAdapter.InitializationStatus status;
    private InterstitialAd interstitialAd;
    private AppOpenAd appOpenAd;
    private InterstitialAd appOpenInterstitialAd;
    private RewardedInterstitialAd rewardedInterstitialAd;
    private RewardedAd rewardedAd;
    private AdView adView;
    private NativeAd nativeAd;
    private NativeAdView nativeAdView;
    private AppOpenAdListener appOpenAdListener;
    private AppOpenAdListener appOpenInterstitialAdListener;
    private RewardedInterstitialAdListener rewardedInterstitialAdListener;
    private RewardedAdListener rewardedAdListener;

    public GoogleMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    @SuppressLint(value={"MissingPermission"})
    public void initialize(MaxAdapterInitializationParameters parameters, Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        this.log("Initializing Google SDK...");
        if (initialized.compareAndSet(false, true)) {
            Context context = this.getContext(activity);
            MobileAds.disableMediationAdapterInitialization((Context)context);
            if (parameters.getServerParameters().getBoolean("init_without_callback", false)) {
                status = MaxAdapter.InitializationStatus.DOES_NOT_APPLY;
                MobileAds.initialize((Context)context);
                onCompletionListener.onCompletion(status, null);
            } else {
                status = MaxAdapter.InitializationStatus.INITIALIZING;
                MobileAds.initialize((Context)context, (OnInitializationCompleteListener)new OnInitializationCompleteListener(){

                    public void onInitializationComplete(@NonNull InitializationStatus initializationStatus) {
                        AdapterStatus googleAdsStatus = (AdapterStatus)initializationStatus.getAdapterStatusMap().get("com.google.android.gms.ads.MobileAds");
                        AdapterStatus.State googleAdsState = googleAdsStatus != null ? googleAdsStatus.getInitializationState() : null;
                        GoogleMediationAdapter.this.log("Initialization complete with status " + googleAdsState);
                        status = AdapterStatus.State.READY == googleAdsState ? MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS : MaxAdapter.InitializationStatus.INITIALIZED_UNKNOWN;
                        onCompletionListener.onCompletion(status, null);
                    }
                });
            }
        } else {
            onCompletionListener.onCompletion(status, null);
        }
    }

    public String getSdkVersion() {
        return String.valueOf(MobileAds.getVersion());
    }

    public String getAdapterVersion() {
        return "22.3.0.0";
    }

    public void onDestroy() {
        this.log("Destroy called for adapter " + (Object)((Object)this));
        if (this.interstitialAd != null) {
            this.interstitialAd.setFullScreenContentCallback(null);
            this.interstitialAd = null;
        }
        if (this.appOpenAd != null) {
            this.appOpenAd.setFullScreenContentCallback(null);
            this.appOpenAd = null;
            this.appOpenAdListener = null;
        }
        if (this.appOpenInterstitialAd != null) {
            this.appOpenInterstitialAd.setFullScreenContentCallback(null);
            this.appOpenInterstitialAd = null;
            this.appOpenInterstitialAdListener = null;
        }
        if (this.rewardedInterstitialAd != null) {
            this.rewardedInterstitialAd.setFullScreenContentCallback(null);
            this.rewardedInterstitialAd = null;
            this.rewardedInterstitialAdListener = null;
        }
        if (this.rewardedAd != null) {
            this.rewardedAd.setFullScreenContentCallback(null);
            this.rewardedAd = null;
            this.rewardedAdListener = null;
        }
        if (this.adView != null) {
            this.adView.destroy();
            this.adView = null;
        }
        if (this.nativeAd != null) {
            this.nativeAd.destroy();
            this.nativeAd = null;
        }
        if (this.nativeAdView != null) {
            this.nativeAdView.destroy();
            this.nativeAdView = null;
        }
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, Activity activity, final MaxSignalCollectionListener callback) {
        this.setRequestConfiguration((MaxAdapterParameters)parameters);
        Context context = this.getContext(activity);
        AdRequest adRequest = this.createAdRequestWithParameters(true, parameters.getAdFormat(), (MaxAdapterParameters)parameters, context);
        QueryInfo.generate((Context)context, (AdFormat)this.toAdFormat(parameters), (AdRequest)adRequest, (QueryInfoGenerationCallback)new QueryInfoGenerationCallback(){

            public void onSuccess(@NonNull QueryInfo queryInfo) {
                GoogleMediationAdapter.this.log("Signal collection successful");
                callback.onSignalCollected(queryInfo.getQuery());
            }

            public void onFailure(@NonNull String errorMessage) {
                GoogleMediationAdapter.this.log("Signal collection failed with error: " + errorMessage);
                callback.onSignalCollectionFailed(errorMessage);
            }
        });
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, final MaxInterstitialAdapterListener listener) {
        final String placementId = parameters.getThirdPartyAdPlacementId();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)parameters.getBidResponse());
        this.log("Loading " + (isBiddingAd ? "bidding " : "") + "interstitial ad: " + placementId + "...");
        GoogleMediationAdapter.updateMuteState(parameters);
        this.setRequestConfiguration((MaxAdapterParameters)parameters);
        AdRequest adRequest = this.createAdRequestWithParameters(isBiddingAd, MaxAdFormat.INTERSTITIAL, (MaxAdapterParameters)parameters, (Context)activity);
        InterstitialAd.load((Context)activity, (String)placementId, (AdRequest)adRequest, (InterstitialAdLoadCallback)new InterstitialAdLoadCallback(){

            public void onAdLoaded(@NonNull InterstitialAd ad) {
                String responseId;
                GoogleMediationAdapter.this.log("Interstitial ad loaded: " + placementId + "...");
                GoogleMediationAdapter.this.interstitialAd = ad;
                GoogleMediationAdapter.this.interstitialAd.setFullScreenContentCallback((FullScreenContentCallback)new InterstitialAdListener(placementId, listener));
                ResponseInfo responseInfo = GoogleMediationAdapter.this.interstitialAd.getResponseInfo();
                String string = responseId = responseInfo != null ? responseInfo.getResponseId() : null;
                if (AppLovinSdk.VERSION_CODE >= 9150000 && AppLovinSdkUtils.isValidString((String)responseId)) {
                    Bundle extraInfo = new Bundle(1);
                    extraInfo.putString("creative_id", responseId);
                    listener.onInterstitialAdLoaded(extraInfo);
                } else {
                    listener.onInterstitialAdLoaded();
                }
            }

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                MaxAdapterError adapterError = GoogleMediationAdapter.toMaxError((AdError)loadAdError);
                GoogleMediationAdapter.this.log("Interstitial ad (" + placementId + ") failed to load with error: " + adapterError);
                listener.onInterstitialAdLoadFailed(adapterError);
            }
        });
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing interstitial ad: " + placementId + "...");
        if (this.interstitialAd != null) {
            this.interstitialAd.show(activity);
        } else {
            this.log("Interstitial ad failed to show: " + placementId);
            listener.onInterstitialAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Interstitial ad not ready"));
        }
    }

    public void loadAppOpenAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, final MaxAppOpenAdapterListener listener) {
        final String placementId = parameters.getThirdPartyAdPlacementId();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)parameters.getBidResponse());
        boolean isInterstitial = parameters.getServerParameters().getBoolean("is_inter_placement");
        this.log("Loading " + (isBiddingAd ? "bidding " : "") + "app open " + (isInterstitial ? "interstitial " : "") + "ad: " + placementId + "...");
        GoogleMediationAdapter.updateMuteState(parameters);
        this.setRequestConfiguration((MaxAdapterParameters)parameters);
        Context context = this.getContext(activity);
        if (isInterstitial) {
            AdRequest adRequest = this.createAdRequestWithParameters(isBiddingAd, MaxAdFormat.INTERSTITIAL, (MaxAdapterParameters)parameters, (Context)activity);
            InterstitialAd.load((Context)context, (String)placementId, (AdRequest)adRequest, (InterstitialAdLoadCallback)new InterstitialAdLoadCallback(){

                public void onAdLoaded(@NonNull InterstitialAd ad) {
                    String responseId;
                    GoogleMediationAdapter.this.log("App open interstitial ad loaded: " + placementId + "...");
                    GoogleMediationAdapter.this.appOpenInterstitialAd = ad;
                    GoogleMediationAdapter.this.appOpenInterstitialAdListener = new AppOpenAdListener(placementId, listener);
                    GoogleMediationAdapter.this.appOpenInterstitialAd.setFullScreenContentCallback((FullScreenContentCallback)GoogleMediationAdapter.this.appOpenInterstitialAdListener);
                    ResponseInfo responseInfo = GoogleMediationAdapter.this.appOpenInterstitialAd.getResponseInfo();
                    String string = responseId = responseInfo != null ? responseInfo.getResponseId() : null;
                    if (AppLovinSdkUtils.isValidString((String)responseId)) {
                        Bundle extraInfo = new Bundle(1);
                        extraInfo.putString("creative_id", responseId);
                        listener.onAppOpenAdLoaded(extraInfo);
                    } else {
                        listener.onAppOpenAdLoaded();
                    }
                }

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    MaxAdapterError adapterError = GoogleMediationAdapter.toMaxError((AdError)loadAdError);
                    GoogleMediationAdapter.this.log("App open interstitial ad (" + placementId + ") failed to load with error: " + adapterError);
                    listener.onAppOpenAdLoadFailed(adapterError);
                }
            });
        } else {
            AdRequest adRequest = this.createAdRequestWithParameters(isBiddingAd, MaxAdFormat.APP_OPEN, (MaxAdapterParameters)parameters, (Context)activity);
            int orientation = AppLovinSdkUtils.getOrientation((Context)context);
            AppOpenAd.load((Context)context, (String)placementId, (AdRequest)adRequest, (int)orientation, (AppOpenAd.AppOpenAdLoadCallback)new AppOpenAd.AppOpenAdLoadCallback(){

                public void onAdLoaded(@NonNull AppOpenAd ad) {
                    String responseId;
                    GoogleMediationAdapter.this.log("App open ad loaded: " + placementId + "...");
                    GoogleMediationAdapter.this.appOpenAd = ad;
                    GoogleMediationAdapter.this.appOpenAdListener = new AppOpenAdListener(placementId, listener);
                    ad.setFullScreenContentCallback((FullScreenContentCallback)GoogleMediationAdapter.this.appOpenAdListener);
                    ResponseInfo responseInfo = GoogleMediationAdapter.this.appOpenAd.getResponseInfo();
                    String string = responseId = responseInfo != null ? responseInfo.getResponseId() : null;
                    if (AppLovinSdkUtils.isValidString((String)responseId)) {
                        Bundle extraInfo = new Bundle(1);
                        extraInfo.putString("creative_id", responseId);
                        listener.onAppOpenAdLoaded(extraInfo);
                    } else {
                        listener.onAppOpenAdLoaded();
                    }
                }

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    MaxAdapterError adapterError = GoogleMediationAdapter.toMaxError((AdError)loadAdError);
                    GoogleMediationAdapter.this.log("App open ad (" + placementId + ") failed to load with error: " + adapterError);
                    listener.onAppOpenAdLoadFailed(adapterError);
                }
            });
        }
    }

    public void showAppOpenAd(MaxAdapterResponseParameters parameters, @Nullable Activity activity, MaxAppOpenAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        boolean isInterstitial = parameters.getServerParameters().getBoolean("is_inter_placement");
        this.log("Showing app open " + (isInterstitial ? "interstitial " : "") + "ad: " + placementId + "...");
        if (this.appOpenInterstitialAd != null) {
            this.appOpenInterstitialAd.show(activity);
        } else if (this.appOpenAd != null) {
            this.appOpenAd.show(activity);
        } else {
            this.log("App open ad failed to show: " + placementId);
            listener.onAppOpenAdLoadFailed(new MaxAdapterError(-4205, "Ad display failed", 0, "App open ad not ready"));
        }
    }

    public void loadRewardedInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, final MaxRewardedInterstitialAdapterListener listener) {
        final String placementId = parameters.getThirdPartyAdPlacementId();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)parameters.getBidResponse());
        this.log("Loading " + (isBiddingAd ? "bidding " : "") + "rewarded interstitial ad: " + placementId + "...");
        GoogleMediationAdapter.updateMuteState(parameters);
        this.setRequestConfiguration((MaxAdapterParameters)parameters);
        AdRequest adRequest = this.createAdRequestWithParameters(isBiddingAd, MaxAdFormat.REWARDED_INTERSTITIAL, (MaxAdapterParameters)parameters, (Context)activity);
        RewardedInterstitialAd.load((Context)activity, (String)placementId, (AdRequest)adRequest, (RewardedInterstitialAdLoadCallback)new RewardedInterstitialAdLoadCallback(){

            public void onAdLoaded(@NonNull RewardedInterstitialAd ad) {
                String responseId;
                GoogleMediationAdapter.this.log("Rewarded interstitial ad loaded: " + placementId);
                GoogleMediationAdapter.this.rewardedInterstitialAd = ad;
                GoogleMediationAdapter.this.rewardedInterstitialAdListener = new RewardedInterstitialAdListener(placementId, listener);
                GoogleMediationAdapter.this.rewardedInterstitialAd.setFullScreenContentCallback((FullScreenContentCallback)GoogleMediationAdapter.this.rewardedInterstitialAdListener);
                ResponseInfo responseInfo = GoogleMediationAdapter.this.rewardedInterstitialAd.getResponseInfo();
                String string = responseId = responseInfo != null ? responseInfo.getResponseId() : null;
                if (AppLovinSdk.VERSION_CODE > 9150000 && AppLovinSdkUtils.isValidString((String)responseId)) {
                    Bundle extraInfo = new Bundle(1);
                    extraInfo.putString("creative_id", responseId);
                    listener.onRewardedInterstitialAdLoaded(extraInfo);
                } else {
                    listener.onRewardedInterstitialAdLoaded();
                }
            }

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                MaxAdapterError adapterError = GoogleMediationAdapter.toMaxError((AdError)loadAdError);
                GoogleMediationAdapter.this.log("Rewarded interstitial ad (" + placementId + ") failed to load with error: " + adapterError);
                listener.onRewardedInterstitialAdLoadFailed(adapterError);
            }
        });
    }

    public void showRewardedInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedInterstitialAdapterListener listener) {
        final String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing rewarded interstitial ad: " + placementId + "...");
        if (this.rewardedInterstitialAd != null) {
            this.configureReward(parameters);
            this.rewardedInterstitialAd.show(activity, new OnUserEarnedRewardListener(){

                public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
                    GoogleMediationAdapter.this.log("Rewarded interstitial ad user earned reward: " + placementId);
                    GoogleMediationAdapter.this.rewardedInterstitialAdListener.hasGrantedReward = true;
                }
            });
        } else {
            this.log("Rewarded interstitial ad failed to show: " + placementId);
            listener.onRewardedInterstitialAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Rewarded Interstitial ad not ready"));
        }
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, final MaxRewardedAdapterListener listener) {
        final String placementId = parameters.getThirdPartyAdPlacementId();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)parameters.getBidResponse());
        this.log("Loading " + (isBiddingAd ? "bidding " : "") + "rewarded ad: " + placementId + "...");
        GoogleMediationAdapter.updateMuteState(parameters);
        this.setRequestConfiguration((MaxAdapterParameters)parameters);
        AdRequest adRequest = this.createAdRequestWithParameters(isBiddingAd, MaxAdFormat.REWARDED, (MaxAdapterParameters)parameters, (Context)activity);
        RewardedAd.load((Context)activity, (String)placementId, (AdRequest)adRequest, (RewardedAdLoadCallback)new RewardedAdLoadCallback(){

            public void onAdLoaded(@NonNull RewardedAd ad) {
                String responseId;
                GoogleMediationAdapter.this.log("Rewarded ad loaded: " + placementId + "...");
                GoogleMediationAdapter.this.rewardedAd = ad;
                GoogleMediationAdapter.this.rewardedAdListener = new RewardedAdListener(placementId, listener);
                GoogleMediationAdapter.this.rewardedAd.setFullScreenContentCallback((FullScreenContentCallback)GoogleMediationAdapter.this.rewardedAdListener);
                ResponseInfo responseInfo = GoogleMediationAdapter.this.rewardedAd.getResponseInfo();
                String string = responseId = responseInfo != null ? responseInfo.getResponseId() : null;
                if (AppLovinSdk.VERSION_CODE >= 9150000 && AppLovinSdkUtils.isValidString((String)responseId)) {
                    Bundle extraInfo = new Bundle(1);
                    extraInfo.putString("creative_id", responseId);
                    listener.onRewardedAdLoaded(extraInfo);
                } else {
                    listener.onRewardedAdLoaded();
                }
            }

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                MaxAdapterError adapterError = GoogleMediationAdapter.toMaxError((AdError)loadAdError);
                GoogleMediationAdapter.this.log("Rewarded ad (" + placementId + ") failed to load with error: " + adapterError);
                listener.onRewardedAdLoadFailed(adapterError);
            }
        });
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        final String placementId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing rewarded ad: " + placementId + "...");
        if (this.rewardedAd != null) {
            this.configureReward(parameters);
            this.rewardedAd.show(activity, new OnUserEarnedRewardListener(){

                public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
                    GoogleMediationAdapter.this.log("Rewarded ad user earned reward: " + placementId);
                    GoogleMediationAdapter.this.rewardedAdListener.hasGrantedReward = true;
                }
            });
        } else {
            this.log("Rewarded ad failed to show: " + placementId);
            listener.onRewardedAdDisplayFailed(new MaxAdapterError(-4205, "Ad Display Failed", 0, "Rewarded ad not ready"));
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, Activity activity, MaxAdViewAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)parameters.getBidResponse());
        boolean isNative = parameters.getServerParameters().getBoolean("is_native");
        this.log("Loading " + (isBiddingAd ? "bidding " : "") + (isNative ? "native " : "") + adFormat.getLabel() + " ad for placement id: " + placementId + "...");
        this.setRequestConfiguration((MaxAdapterParameters)parameters);
        Context context = this.getContext(activity);
        AdRequest adRequest = this.createAdRequestWithParameters(isBiddingAd, adFormat, (MaxAdapterParameters)parameters, context);
        if (isNative) {
            NativeAdOptions.Builder nativeAdOptionsBuilder = new NativeAdOptions.Builder();
            nativeAdOptionsBuilder.setAdChoicesPlacement(this.getAdChoicesPlacement(parameters));
            nativeAdOptionsBuilder.setRequestMultipleImages(adFormat == MaxAdFormat.MREC);
            NativeAdViewListener nativeAdViewListener = new NativeAdViewListener(parameters, adFormat, activity, listener);
            AdLoader adLoader = new AdLoader.Builder(context, placementId).withNativeAdOptions(nativeAdOptionsBuilder.build()).forNativeAd((NativeAd.OnNativeAdLoadedListener)nativeAdViewListener).withAdListener((AdListener)nativeAdViewListener).build();
            adLoader.loadAd(adRequest);
        } else {
            this.adView = new AdView(context);
            this.adView.setAdUnitId(placementId);
            this.adView.setAdListener((AdListener)new AdViewListener(placementId, adFormat, listener));
            boolean isAdaptiveBanner = parameters.getServerParameters().getBoolean("adaptive_banner", false);
            this.adView.setAdSize(this.toAdSize(adFormat, isAdaptiveBanner, (MaxAdapterParameters)parameters, context));
            this.adView.loadAd(adRequest);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void loadNativeAd(MaxAdapterResponseParameters parameters, Activity activity, MaxNativeAdAdapterListener listener) {
        String placementId = parameters.getThirdPartyAdPlacementId();
        boolean isBiddingAd = AppLovinSdkUtils.isValidString((String)parameters.getBidResponse());
        this.log("Loading " + (isBiddingAd ? "bidding " : "") + " native ad for placement id: " + placementId + "...");
        this.setRequestConfiguration((MaxAdapterParameters)parameters);
        Context applicationContext = activity != null ? activity.getApplicationContext() : this.getApplicationContext();
        AdRequest adRequest = this.createAdRequestWithParameters(isBiddingAd, MaxAdFormat.NATIVE, (MaxAdapterParameters)parameters, applicationContext);
        NativeAdOptions.Builder nativeAdOptionsBuilder = new NativeAdOptions.Builder();
        nativeAdOptionsBuilder.setAdChoicesPlacement(this.getAdChoicesPlacement(parameters));
        String template = BundleUtils.getString((String)"template", (String)"", (Bundle)parameters.getServerParameters());
        nativeAdOptionsBuilder.setRequestMultipleImages(template.contains("medium"));
        NativeAdListener nativeAdListener = new NativeAdListener(parameters, applicationContext, listener);
        AdLoader adLoader = new AdLoader.Builder(applicationContext, placementId).withNativeAdOptions(nativeAdOptionsBuilder.build()).forNativeAd((NativeAd.OnNativeAdLoadedListener)nativeAdListener).withAdListener((AdListener)nativeAdListener).build();
        adLoader.loadAd(adRequest);
    }

    private static MaxAdapterError toMaxError(AdError googleAdsError) {
        int googleErrorCode = googleAdsError.getCode();
        MaxAdapterError adapterError = MaxAdapterError.UNSPECIFIED;
        switch (googleErrorCode) {
            case 3: 
            case 9: {
                adapterError = MaxAdapterError.NO_FILL;
                break;
            }
            case 2: {
                adapterError = MaxAdapterError.NO_CONNECTION;
                break;
            }
            case 0: {
                adapterError = MaxAdapterError.INTERNAL_ERROR;
                break;
            }
            case 1: 
            case 10: {
                adapterError = MaxAdapterError.BAD_REQUEST;
                break;
            }
            case 8: 
            case 11: {
                adapterError = MaxAdapterError.INVALID_CONFIGURATION;
            }
        }
        return new MaxAdapterError(adapterError.getErrorCode(), adapterError.getErrorMessage(), googleErrorCode, googleAdsError.getMessage());
    }

    private AdSize toAdSize(MaxAdFormat adFormat, boolean isAdaptiveBanner, MaxAdapterParameters parameters, Context context) {
        if (adFormat == MaxAdFormat.BANNER || adFormat == MaxAdFormat.LEADER) {
            if (isAdaptiveBanner) {
                return AdSize.getCurrentOrientationAnchoredAdaptiveBannerAdSize((Context)context, (int)this.getAdaptiveBannerWidth(parameters, context));
            }
            return adFormat == MaxAdFormat.BANNER ? AdSize.BANNER : AdSize.LEADERBOARD;
        }
        if (adFormat == MaxAdFormat.MREC) {
            return AdSize.MEDIUM_RECTANGLE;
        }
        throw new IllegalArgumentException("Unsupported ad format: " + adFormat);
    }

    private int getAdaptiveBannerWidth(MaxAdapterParameters parameters, Context context) {
        if (AppLovinSdk.VERSION_CODE >= 11000000) {
            Map localExtraParameters = parameters.getLocalExtraParameters();
            Object widthObj = localExtraParameters.get("adaptive_banner_width");
            if (widthObj instanceof Integer) {
                return (Integer)widthObj;
            }
            if (widthObj != null) {
                this.e("Expected parameter \"adaptive_banner_width\" to be of type Integer, received: " + widthObj.getClass());
            }
        }
        int deviceWidthPx = GoogleMediationAdapter.getApplicationWindowWidth(context);
        return AppLovinSdkUtils.pxToDp((Context)context, (int)deviceWidthPx);
    }

    public static int getApplicationWindowWidth(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (Build.VERSION.SDK_INT >= 30) {
            WindowMetrics windowMetrics = windowManager.getCurrentWindowMetrics();
            Rect applicationBounds = windowMetrics.getBounds();
            return applicationBounds.width();
        }
        Display display = windowManager.getDefaultDisplay();
        DisplayMetrics outMetrics = new DisplayMetrics();
        display.getMetrics(outMetrics);
        return outMetrics.widthPixels;
    }

    private AdFormat toAdFormat(MaxAdapterSignalCollectionParameters parameters) {
        boolean isNative;
        MaxAdFormat adFormat = parameters.getAdFormat();
        boolean bl = isNative = parameters.getServerParameters().getBoolean("is_native") || adFormat == MaxAdFormat.NATIVE;
        if (isNative) {
            return AdFormat.NATIVE;
        }
        if (adFormat.isAdViewAd()) {
            return AdFormat.BANNER;
        }
        if (adFormat == MaxAdFormat.INTERSTITIAL) {
            return AdFormat.INTERSTITIAL;
        }
        if (adFormat == MaxAdFormat.REWARDED) {
            return AdFormat.REWARDED;
        }
        if (adFormat == MaxAdFormat.REWARDED_INTERSTITIAL) {
            return AdFormat.REWARDED_INTERSTITIAL;
        }
        if (adFormat == MaxAdFormat.APP_OPEN) {
            return AdFormat.APP_OPEN_AD;
        }
        return AdFormat.UNKNOWN;
    }

    private void setRequestConfiguration(MaxAdapterParameters parameters) {
        RequestConfiguration.Builder requestConfigurationBuilder = MobileAds.getRequestConfiguration().toBuilder();
        Boolean isAgeRestrictedUser = parameters.isAgeRestrictedUser();
        if (isAgeRestrictedUser != null) {
            int ageRestrictedUserTag = isAgeRestrictedUser != false ? 1 : 0;
            requestConfigurationBuilder.setTagForChildDirectedTreatment(ageRestrictedUserTag);
        }
        MobileAds.setRequestConfiguration((RequestConfiguration)requestConfigurationBuilder.build());
    }

    @SuppressLint(value={"ApplySharedPref"})
    private AdRequest createAdRequestWithParameters(boolean isBiddingAd, MaxAdFormat adFormat, MaxAdapterParameters parameters, Context context) {
        Boolean isDoNotSell;
        Boolean hasUserConsent;
        String eventId;
        AdRequest.Builder requestBuilder = new AdRequest.Builder();
        Bundle serverParameters = parameters.getServerParameters();
        Bundle networkExtras = new Bundle(6);
        boolean isDv360Bidding = false;
        if (isBiddingAd) {
            String bidResponse;
            Object isAdaptiveBannerObj;
            String bidderType = BundleUtils.getString((String)"bidder", (String)"", (Bundle)serverParameters);
            if ("dv360".equalsIgnoreCase(bidderType)) {
                isDv360Bidding = true;
            }
            networkExtras.putString("query_info_type", isDv360Bidding ? "requester_type_3" : "requester_type_2");
            if (AppLovinSdk.VERSION_CODE >= 11000000 && adFormat.isAdViewAd() && (isAdaptiveBannerObj = parameters.getLocalExtraParameters().get("adaptive_banner")) instanceof String && "true".equalsIgnoreCase((String)isAdaptiveBannerObj)) {
                AdSize adaptiveAdSize = this.toAdSize(adFormat, true, parameters, context);
                networkExtras.putInt("adaptive_banner_w", adaptiveAdSize.getWidth());
                networkExtras.putInt("adaptive_banner_h", adaptiveAdSize.getHeight());
            }
            if (parameters instanceof MaxAdapterResponseParameters && AppLovinSdkUtils.isValidString((String)(bidResponse = ((MaxAdapterResponseParameters)parameters).getBidResponse()))) {
                requestBuilder.setAdString(bidResponse);
            }
        }
        if (serverParameters.getBoolean("set_mediation_identifier", true)) {
            requestBuilder.setRequestAgent(isDv360Bidding ? "applovin_dv360" : "applovin");
        }
        if (AppLovinSdkUtils.isValidString((String)(eventId = BundleUtils.getString((String)"event_id", (Bundle)serverParameters)))) {
            networkExtras.putString("placement_req_id", eventId);
        }
        if ((hasUserConsent = parameters.hasUserConsent()) != null && !hasUserConsent.booleanValue()) {
            networkExtras.putString("npa", "1");
        }
        if ((isDoNotSell = parameters.isDoNotSell()) != null && isDoNotSell.booleanValue()) {
            networkExtras.putInt("rdp", 1);
            PreferenceManager.getDefaultSharedPreferences((Context)context).edit().putInt("gad_rdp", 1).commit();
        } else {
            PreferenceManager.getDefaultSharedPreferences((Context)context).edit().remove("gad_rdp").commit();
        }
        if (AppLovinSdk.VERSION_CODE >= 11000000) {
            Object neighbouringContentUrlStringsObject;
            Object contentUrlString;
            Map localExtraParameters = parameters.getLocalExtraParameters();
            Object maxContentRating = localExtraParameters.get("google_max_ad_content_rating");
            if (maxContentRating instanceof String) {
                networkExtras.putString("max_ad_content_rating", (String)maxContentRating);
            }
            if ((contentUrlString = localExtraParameters.get("google_content_url")) instanceof String) {
                requestBuilder.setContentUrl((String)contentUrlString);
            }
            if ((neighbouringContentUrlStringsObject = localExtraParameters.get("google_neighbouring_content_url_strings")) instanceof List) {
                try {
                    requestBuilder.setNeighboringContentUrls((List)neighbouringContentUrlStringsObject);
                }
                catch (Throwable th) {
                    this.e("Neighbouring content URL strings extra param needs to be of type List<String>.", th);
                }
            }
        }
        requestBuilder.addNetworkExtrasBundle(AdMobAdapter.class, networkExtras);
        return requestBuilder.build();
    }

    private static void updateMuteState(MaxAdapterResponseParameters parameters) {
        Bundle serverParameters = parameters.getServerParameters();
        if (serverParameters.containsKey("is_muted")) {
            MobileAds.setAppMuted((boolean)serverParameters.getBoolean("is_muted"));
        }
    }

    private int getAdChoicesPlacement(MaxAdapterResponseParameters parameters) {
        if (AppLovinSdk.VERSION_CODE >= 11000000) {
            Map localExtraParams = parameters.getLocalExtraParameters();
            Object adChoicesPlacementObj = localExtraParams != null ? localExtraParams.get("admob_ad_choices_placement") : null;
            return this.isValidAdChoicesPlacement(adChoicesPlacementObj) ? (Integer)adChoicesPlacementObj : 1;
        }
        return 1;
    }

    private boolean isValidAdChoicesPlacement(Object placementObj) {
        return placementObj instanceof Integer && ((Integer)placementObj == 0 || (Integer)placementObj == 1 || (Integer)placementObj == 3 || (Integer)placementObj == 2);
    }

    private Context getContext(@Nullable Activity activity) {
        return activity != null ? activity.getApplicationContext() : this.getApplicationContext();
    }

    private class MaxGoogleNativeAd
    extends MaxNativeAd {
        public MaxGoogleNativeAd(MaxNativeAd.Builder builder) {
            super(builder);
        }

        public void prepareViewForInteraction(MaxNativeAdView maxNativeAdView) {
            this.prepareForInteraction(Collections.emptyList(), (ViewGroup)maxNativeAdView);
        }

        public boolean prepareForInteraction(List<View> clickableViews, ViewGroup container) {
            NativeAd nativeAd = GoogleMediationAdapter.this.nativeAd;
            if (nativeAd == null) {
                GoogleMediationAdapter.this.e("Failed to register native ad views: native ad is null.");
                return false;
            }
            GoogleMediationAdapter.this.nativeAdView = new NativeAdView(container.getContext());
            if (container instanceof MaxNativeAdView) {
                MaxNativeAdView maxNativeAdView = (MaxNativeAdView)container;
                View mainView = maxNativeAdView.getMainView();
                maxNativeAdView.removeView(mainView);
                GoogleMediationAdapter.this.nativeAdView.addView(mainView);
                maxNativeAdView.addView((View)GoogleMediationAdapter.this.nativeAdView);
                GoogleMediationAdapter.this.nativeAdView.setIconView((View)maxNativeAdView.getIconImageView());
                GoogleMediationAdapter.this.nativeAdView.setHeadlineView((View)maxNativeAdView.getTitleTextView());
                GoogleMediationAdapter.this.nativeAdView.setAdvertiserView((View)maxNativeAdView.getAdvertiserTextView());
                GoogleMediationAdapter.this.nativeAdView.setBodyView((View)maxNativeAdView.getBodyTextView());
                GoogleMediationAdapter.this.nativeAdView.setCallToActionView((View)maxNativeAdView.getCallToActionButton());
                View mediaView = this.getMediaView();
                if (mediaView instanceof MediaView) {
                    GoogleMediationAdapter.this.nativeAdView.setMediaView((MediaView)mediaView);
                } else if (mediaView instanceof ImageView) {
                    GoogleMediationAdapter.this.nativeAdView.setImageView(mediaView);
                }
                GoogleMediationAdapter.this.nativeAdView.setNativeAd(nativeAd);
            } else {
                ViewGroup midContainer;
                for (View view : clickableViews) {
                    Object viewTag = view.getTag();
                    if (viewTag == null) continue;
                    int tag = (Integer)viewTag;
                    if (tag == 1) {
                        GoogleMediationAdapter.this.nativeAdView.setHeadlineView(view);
                        continue;
                    }
                    if (tag == 3) {
                        GoogleMediationAdapter.this.nativeAdView.setIconView(view);
                        continue;
                    }
                    if (tag == 4) {
                        GoogleMediationAdapter.this.nativeAdView.setBodyView(view);
                        continue;
                    }
                    if (tag == 5) {
                        GoogleMediationAdapter.this.nativeAdView.setCallToActionView(view);
                        continue;
                    }
                    if (tag != 8) continue;
                    GoogleMediationAdapter.this.nativeAdView.setAdvertiserView(view);
                }
                View mediaView = this.getMediaView();
                ViewGroup viewGroup = midContainer = mediaView != null ? (ViewGroup)mediaView.getParent() : null;
                if (midContainer != null && container.findViewById(midContainer.getId()) != null) {
                    midContainer.removeView(mediaView);
                    GoogleMediationAdapter.this.nativeAdView.addView(mediaView);
                    midContainer.addView((View)GoogleMediationAdapter.this.nativeAdView);
                    if (mediaView instanceof MediaView) {
                        GoogleMediationAdapter.this.nativeAdView.setMediaView((MediaView)mediaView);
                    } else if (mediaView instanceof ImageView) {
                        GoogleMediationAdapter.this.nativeAdView.setImageView(mediaView);
                    }
                    GoogleMediationAdapter.this.nativeAdView.setNativeAd(nativeAd);
                    GoogleMediationAdapter.this.nativeAdView.measure(View.MeasureSpec.makeMeasureSpec((int)midContainer.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)midContainer.getHeight(), (int)0x40000000));
                    GoogleMediationAdapter.this.nativeAdView.layout(0, 0, midContainer.getWidth(), midContainer.getHeight());
                }
            }
            return true;
        }
    }

    private class NativeAdListener
    extends AdListener
    implements NativeAd.OnNativeAdLoadedListener {
        final String placementId;
        final Bundle serverParameters;
        final Context context;
        final MaxNativeAdAdapterListener listener;

        public NativeAdListener(MaxAdapterResponseParameters parameters, Context context, MaxNativeAdAdapterListener listener) {
            this.placementId = parameters.getThirdPartyAdPlacementId();
            this.serverParameters = parameters.getServerParameters();
            this.context = context;
            this.listener = listener;
        }

        public void onNativeAdLoaded(final @NonNull NativeAd nativeAd) {
            GoogleMediationAdapter.this.log("Native ad loaded: " + this.placementId);
            GoogleMediationAdapter.this.nativeAd = nativeAd;
            String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)this.serverParameters);
            boolean isTemplateAd = AppLovinSdkUtils.isValidString((String)templateName);
            if (isTemplateAd && TextUtils.isEmpty((CharSequence)nativeAd.getHeadline())) {
                GoogleMediationAdapter.this.e("Native ad (" + nativeAd + ") does not have required assets.");
                this.listener.onNativeAdLoadFailed(new MaxAdapterError(-5400, "Missing Native Ad Assets"));
                return;
            }
            AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    MediaView mediaView = null;
                    MediaContent mediaContent = nativeAd.getMediaContent();
                    List images = nativeAd.getImages();
                    Drawable mainImage = null;
                    float mediaContentAspectRatio = 0.0f;
                    if (mediaContent != null) {
                        MediaView googleMediaView = new MediaView(NativeAdListener.this.context);
                        googleMediaView.setMediaContent(mediaContent);
                        mediaView = googleMediaView;
                        mainImage = mediaContent.getMainImage();
                        mediaContentAspectRatio = mediaContent.getAspectRatio();
                    } else if (images != null && images.size() > 0) {
                        NativeAd.Image mediaImage = (NativeAd.Image)images.get(0);
                        ImageView mediaImageView = new ImageView(NativeAdListener.this.context);
                        Drawable mediaImageDrawable = mediaImage.getDrawable();
                        if (mediaImageDrawable != null) {
                            mediaImageView.setImageDrawable(mediaImageDrawable);
                            mediaView = mediaImageView;
                            mediaContentAspectRatio = (float)mediaImageDrawable.getIntrinsicWidth() / (float)mediaImageDrawable.getIntrinsicHeight();
                        }
                    }
                    NativeAd.Image icon = nativeAd.getIcon();
                    MaxNativeAd.MaxNativeAdImage iconImage = null;
                    if (icon != null) {
                        iconImage = icon.getDrawable() != null ? new MaxNativeAd.MaxNativeAdImage(icon.getDrawable()) : new MaxNativeAd.MaxNativeAdImage(icon.getUri());
                    }
                    MaxNativeAd.Builder builder = new MaxNativeAd.Builder().setAdFormat(MaxAdFormat.NATIVE).setTitle(nativeAd.getHeadline()).setAdvertiser(nativeAd.getAdvertiser()).setBody(nativeAd.getBody()).setCallToAction(nativeAd.getCallToAction()).setIcon(iconImage).setMediaView((View)mediaView);
                    if (AppLovinSdk.VERSION_CODE >= 11040399) {
                        builder.setMainImage(new MaxNativeAd.MaxNativeAdImage(mainImage));
                    }
                    if (AppLovinSdk.VERSION_CODE >= 11040000) {
                        builder.setMediaContentAspectRatio(mediaContentAspectRatio);
                    }
                    if (AppLovinSdk.VERSION_CODE >= 11070000) {
                        builder.setStarRating(nativeAd.getStarRating());
                    }
                    MaxGoogleNativeAd maxNativeAd = new MaxGoogleNativeAd(builder);
                    ResponseInfo responseInfo = nativeAd.getResponseInfo();
                    String responseId = responseInfo != null ? responseInfo.getResponseId() : null;
                    Bundle extraInfo = new Bundle(1);
                    extraInfo.putString("creative_id", responseId);
                    NativeAdListener.this.listener.onNativeAdLoaded((MaxNativeAd)maxNativeAd, extraInfo);
                }
            });
        }

        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            MaxAdapterError adapterError = GoogleMediationAdapter.toMaxError((AdError)loadAdError);
            GoogleMediationAdapter.this.log("Native ad (" + this.placementId + ") failed to load with error: " + adapterError);
            this.listener.onNativeAdLoadFailed(adapterError);
        }

        public void onAdImpression() {
            GoogleMediationAdapter.this.log("Native ad shown");
            this.listener.onNativeAdDisplayed(null);
        }

        public void onAdClicked() {
            GoogleMediationAdapter.this.log("Native ad clicked");
            this.listener.onNativeAdClicked();
        }

        public void onAdOpened() {
            GoogleMediationAdapter.this.log("Native ad opened");
        }

        public void onAdClosed() {
            GoogleMediationAdapter.this.log("Native ad closed");
        }
    }

    private class NativeAdViewListener
    extends AdListener
    implements NativeAd.OnNativeAdLoadedListener {
        final String placementId;
        final MaxAdFormat adFormat;
        final Bundle serverParameters;
        final WeakReference<Activity> activityRef;
        final MaxAdViewAdapterListener listener;

        NativeAdViewListener(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, Activity activity, MaxAdViewAdapterListener listener) {
            this.placementId = parameters.getThirdPartyAdPlacementId();
            this.serverParameters = parameters.getServerParameters();
            this.activityRef = new WeakReference<Activity>(activity);
            this.adFormat = adFormat;
            this.listener = listener;
        }

        public void onNativeAdLoaded(final @NonNull NativeAd nativeAd) {
            GoogleMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad loaded: " + this.placementId);
            if (TextUtils.isEmpty((CharSequence)nativeAd.getHeadline())) {
                GoogleMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad failed to load: Google native ad is missing one or more required assets");
                this.listener.onAdViewAdLoadFailed(MaxAdapterError.INVALID_CONFIGURATION);
                nativeAd.destroy();
                return;
            }
            GoogleMediationAdapter.this.nativeAd = nativeAd;
            final Activity activity = (Activity)this.activityRef.get();
            final Context context = GoogleMediationAdapter.this.getContext(activity);
            final MediaView mediaView = new MediaView(context);
            MediaContent mediaContent = nativeAd.getMediaContent();
            if (mediaContent != null) {
                mediaView.setMediaContent(mediaContent);
            }
            NativeAd.Image icon = nativeAd.getIcon();
            MaxNativeAd.MaxNativeAdImage maxNativeAdImage = null;
            if (icon != null) {
                maxNativeAdImage = icon.getDrawable() != null ? new MaxNativeAd.MaxNativeAdImage(icon.getDrawable()) : new MaxNativeAd.MaxNativeAdImage(icon.getUri());
            }
            final MaxNativeAd maxNativeAd = new MaxNativeAd.Builder().setAdFormat(this.adFormat).setTitle(nativeAd.getHeadline()).setBody(nativeAd.getBody()).setCallToAction(nativeAd.getCallToAction()).setIcon(maxNativeAdImage).setMediaView((View)mediaView).build();
            final String templateName = BundleUtils.getString((String)"template", (String)"", (Bundle)this.serverParameters);
            if (templateName.contains("vertical") && AppLovinSdk.VERSION_CODE < 9140500) {
                GoogleMediationAdapter.this.log("Vertical native banners are only supported on MAX SDK 9.14.5 and above. Default horizontal native template will be used.");
            }
            AppLovinSdkUtils.runOnUiThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    String responseId;
                    MaxNativeAdView maxNativeAdView = AppLovinSdk.VERSION_CODE >= 11010000 ? new MaxNativeAdView(maxNativeAd, templateName, context) : new MaxNativeAdView(maxNativeAd, templateName, activity);
                    GoogleMediationAdapter.this.nativeAdView = new NativeAdView(context);
                    GoogleMediationAdapter.this.nativeAdView.setIconView((View)maxNativeAdView.getIconContentView());
                    GoogleMediationAdapter.this.nativeAdView.setHeadlineView((View)maxNativeAdView.getTitleTextView());
                    GoogleMediationAdapter.this.nativeAdView.setBodyView((View)maxNativeAdView.getBodyTextView());
                    GoogleMediationAdapter.this.nativeAdView.setMediaView(mediaView);
                    GoogleMediationAdapter.this.nativeAdView.setCallToActionView((View)maxNativeAdView.getCallToActionButton());
                    GoogleMediationAdapter.this.nativeAdView.setNativeAd(nativeAd);
                    GoogleMediationAdapter.this.nativeAdView.addView((View)maxNativeAdView);
                    ResponseInfo responseInfo = nativeAd.getResponseInfo();
                    String string = responseId = responseInfo != null ? responseInfo.getResponseId() : null;
                    if (AppLovinSdk.VERSION_CODE >= 9150000 && AppLovinSdkUtils.isValidString((String)responseId)) {
                        Bundle extraInfo = new Bundle(1);
                        extraInfo.putString("creative_id", responseId);
                        NativeAdViewListener.this.listener.onAdViewAdLoaded((View)GoogleMediationAdapter.this.nativeAdView, extraInfo);
                    } else {
                        NativeAdViewListener.this.listener.onAdViewAdLoaded((View)GoogleMediationAdapter.this.nativeAdView);
                    }
                }
            });
        }

        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            MaxAdapterError adapterError = GoogleMediationAdapter.toMaxError((AdError)loadAdError);
            GoogleMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad (" + this.placementId + ") failed to load with error: " + adapterError);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onAdImpression() {
            GoogleMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad shown");
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdClicked() {
            GoogleMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad clicked");
            this.listener.onAdViewAdClicked();
        }

        public void onAdOpened() {
            GoogleMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad opened");
            this.listener.onAdViewAdExpanded();
        }

        public void onAdClosed() {
            GoogleMediationAdapter.this.log("Native " + this.adFormat.getLabel() + " ad closed");
            this.listener.onAdViewAdCollapsed();
        }
    }

    private class AdViewListener
    extends AdListener {
        final String placementId;
        final MaxAdFormat adFormat;
        final MaxAdViewAdapterListener listener;

        AdViewListener(String placementId, MaxAdFormat adFormat, MaxAdViewAdapterListener listener) {
            this.placementId = placementId;
            this.adFormat = adFormat;
            this.listener = listener;
        }

        public void onAdLoaded() {
            GoogleMediationAdapter.this.log(this.adFormat.getLabel() + " ad loaded: " + this.placementId);
            if (AppLovinSdk.VERSION_CODE >= 9150000) {
                AdSize adSize;
                String responseId;
                Bundle extraInfo = new Bundle(3);
                ResponseInfo responseInfo = GoogleMediationAdapter.this.adView.getResponseInfo();
                String string = responseId = responseInfo != null ? responseInfo.getResponseId() : null;
                if (AppLovinSdkUtils.isValidString((String)responseId)) {
                    extraInfo.putString("creative_id", responseId);
                }
                if ((adSize = GoogleMediationAdapter.this.adView.getAdSize()) != null) {
                    extraInfo.putInt("ad_width", adSize.getWidth());
                    extraInfo.putInt("ad_height", adSize.getHeight());
                }
                this.listener.onAdViewAdLoaded((View)GoogleMediationAdapter.this.adView, extraInfo);
            } else {
                this.listener.onAdViewAdLoaded((View)GoogleMediationAdapter.this.adView);
            }
        }

        public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
            MaxAdapterError adapterError = GoogleMediationAdapter.toMaxError((AdError)loadAdError);
            GoogleMediationAdapter.this.log(this.adFormat.getLabel() + " ad (" + this.placementId + ") failed to load with error code: " + adapterError);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onAdImpression() {
            GoogleMediationAdapter.this.log(this.adFormat.getLabel() + " ad shown: " + this.placementId);
            this.listener.onAdViewAdDisplayed();
        }

        public void onAdOpened() {
            GoogleMediationAdapter.this.log(this.adFormat.getLabel() + " ad opened");
            this.listener.onAdViewAdClicked();
        }

        public void onAdClosed() {
            GoogleMediationAdapter.this.log(this.adFormat.getLabel() + " ad closed");
        }
    }

    private class RewardedAdListener
    extends FullScreenContentCallback {
        private final String placementId;
        private final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward;

        RewardedAdListener(String placementId, MaxRewardedAdapterListener listener) {
            this.placementId = placementId;
            this.listener = listener;
        }

        public void onAdShowedFullScreenContent() {
            GoogleMediationAdapter.this.log("Rewarded ad shown: " + this.placementId);
            this.listener.onRewardedAdVideoStarted();
        }

        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            MaxAdapterError adapterError = new MaxAdapterError(-4205, "Ad Display Failed", adError.getCode(), adError.getMessage());
            GoogleMediationAdapter.this.log("Rewarded ad (" + this.placementId + ") failed to show with error: " + adapterError);
            this.listener.onRewardedAdDisplayFailed(adapterError);
        }

        public void onAdImpression() {
            GoogleMediationAdapter.this.log("Rewarded ad impression recorded: " + this.placementId);
            this.listener.onRewardedAdDisplayed();
        }

        public void onAdClicked() {
            GoogleMediationAdapter.this.log("Rewarded ad clicked: " + this.placementId);
            this.listener.onRewardedAdClicked();
        }

        public void onAdDismissedFullScreenContent() {
            this.listener.onRewardedAdVideoCompleted();
            if (this.hasGrantedReward || GoogleMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward reward = GoogleMediationAdapter.this.getReward();
                GoogleMediationAdapter.this.log("Rewarded user with reward: " + reward);
                this.listener.onUserRewarded(reward);
            }
            GoogleMediationAdapter.this.log("Rewarded ad hidden: " + this.placementId);
            this.listener.onRewardedAdHidden();
        }
    }

    private class RewardedInterstitialAdListener
    extends FullScreenContentCallback {
        private final String placementId;
        private final MaxRewardedInterstitialAdapterListener listener;
        private boolean hasGrantedReward;

        private RewardedInterstitialAdListener(String placementId, MaxRewardedInterstitialAdapterListener listener) {
            this.placementId = placementId;
            this.listener = listener;
        }

        public void onAdShowedFullScreenContent() {
            GoogleMediationAdapter.this.log("Rewarded interstitial ad shown: " + this.placementId);
            this.listener.onRewardedInterstitialAdVideoStarted();
        }

        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            MaxAdapterError adapterError = new MaxAdapterError(-4205, "Ad Display Failed", adError.getCode(), adError.getMessage());
            GoogleMediationAdapter.this.log("Rewarded interstitial ad (" + this.placementId + ") failed to show with error: " + adapterError);
            this.listener.onRewardedInterstitialAdDisplayFailed(adapterError);
        }

        public void onAdImpression() {
            GoogleMediationAdapter.this.log("Rewarded interstitial ad impression recorded: " + this.placementId);
            this.listener.onRewardedInterstitialAdDisplayed();
        }

        public void onAdClicked() {
            GoogleMediationAdapter.this.log("Rewarded interstitial ad clicked: " + this.placementId);
            this.listener.onRewardedInterstitialAdClicked();
        }

        public void onAdDismissedFullScreenContent() {
            this.listener.onRewardedInterstitialAdVideoCompleted();
            if (this.hasGrantedReward || GoogleMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward reward = GoogleMediationAdapter.this.getReward();
                GoogleMediationAdapter.this.log("Rewarded interstitial ad rewarded user with reward: " + reward);
                this.listener.onUserRewarded(reward);
            }
            GoogleMediationAdapter.this.log("Rewarded interstitial ad hidden: " + this.placementId);
            this.listener.onRewardedInterstitialAdHidden();
        }
    }

    private class AppOpenAdListener
    extends FullScreenContentCallback {
        private final String placementId;
        private final MaxAppOpenAdapterListener listener;

        AppOpenAdListener(String placementId, MaxAppOpenAdapterListener listener) {
            this.placementId = placementId;
            this.listener = listener;
        }

        public void onAdShowedFullScreenContent() {
            GoogleMediationAdapter.this.log("App open ad shown: " + this.placementId);
        }

        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            MaxAdapterError adapterError = new MaxAdapterError(-4205, "Ad display failed", adError.getCode(), adError.getMessage());
            GoogleMediationAdapter.this.log("App open ad (" + this.placementId + ") failed to show with error: " + adapterError);
            this.listener.onAppOpenAdDisplayFailed(adapterError);
        }

        public void onAdImpression() {
            GoogleMediationAdapter.this.log("App open ad impression recorded: " + this.placementId);
            this.listener.onAppOpenAdDisplayed();
        }

        public void onAdClicked() {
            GoogleMediationAdapter.this.log("App open ad clicked: " + this.placementId);
            this.listener.onAppOpenAdClicked();
        }

        public void onAdDismissedFullScreenContent() {
            GoogleMediationAdapter.this.log("App open ad hidden: " + this.placementId);
            this.listener.onAppOpenAdHidden();
        }
    }

    private class InterstitialAdListener
    extends FullScreenContentCallback {
        private final String placementId;
        private final MaxInterstitialAdapterListener listener;

        InterstitialAdListener(String placementId, MaxInterstitialAdapterListener listener) {
            this.placementId = placementId;
            this.listener = listener;
        }

        public void onAdShowedFullScreenContent() {
            GoogleMediationAdapter.this.log("Interstitial ad shown: " + this.placementId);
        }

        public void onAdFailedToShowFullScreenContent(@NonNull AdError adError) {
            MaxAdapterError adapterError = new MaxAdapterError(-4205, "Ad Display Failed", adError.getCode(), adError.getMessage());
            GoogleMediationAdapter.this.log("Interstitial ad (" + this.placementId + ") failed to show with error: " + adapterError);
            this.listener.onInterstitialAdDisplayFailed(adapterError);
        }

        public void onAdImpression() {
            GoogleMediationAdapter.this.log("Interstitial ad impression recorded: " + this.placementId);
            this.listener.onInterstitialAdDisplayed();
        }

        public void onAdClicked() {
            GoogleMediationAdapter.this.log("Interstitial ad clicked: " + this.placementId);
            this.listener.onInterstitialAdClicked();
        }

        public void onAdDismissedFullScreenContent() {
            GoogleMediationAdapter.this.log("Interstitial ad hidden: " + this.placementId);
            this.listener.onInterstitialAdHidden();
        }
    }
}

