/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.mediation.adapters.MediationAdapterRouter;
import com.applovin.sdk.AppLovinSdk;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.demandOnly.ISDemandOnlyBannerLayout;
import com.ironsource.mediationsdk.demandOnly.ISDemandOnlyBannerListener;
import com.ironsource.mediationsdk.demandOnly.ISDemandOnlyInterstitialListener;
import com.ironsource.mediationsdk.demandOnly.ISDemandOnlyRewardedVideoListener;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.utils.IronSourceUtils;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class IronSourceMediationAdapter
extends MediationAdapterBase
implements MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter {
    private static final IronSourceRouter ROUTER = new IronSourceRouter();
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean();
    private String mRouterPlacementIdentifier;
    private ISDemandOnlyBannerLayout adView;
    private static final Application.ActivityLifecycleCallbacks activityLifecycleCallbacks = new Application.ActivityLifecycleCallbacks(){

        public void onActivityResumed(Activity activity) {
            if (!activity.getClass().getName().startsWith("com.ironsource.sdk")) {
                IronSource.onResume((Activity)activity);
            }
        }

        public void onActivityPaused(Activity activity) {
            if (!activity.getClass().getName().startsWith("com.ironsource.sdk")) {
                IronSource.onPause((Activity)activity);
            }
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    };

    public IronSourceMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public void initialize(MaxAdapterInitializationParameters parameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        if (INITIALIZED.compareAndSet(false, true)) {
            Boolean isAgeRestrictedUser;
            String appKey = parameters.getServerParameters().getString("app_key");
            this.log("Initializing IronSource SDK with app key: " + appKey + "...");
            if (parameters.getServerParameters().getBoolean("set_mediation_identifier")) {
                IronSource.setMediationType((String)IronSourceMediationAdapter.mediationTag());
            }
            this.setPrivacySettings((MaxAdapterParameters)parameters);
            Boolean isDoNotSell = parameters.isDoNotSell();
            if (isDoNotSell != null) {
                IronSource.setMetaData((String)"do_not_sell", (String)Boolean.toString(isDoNotSell));
            }
            if ((isAgeRestrictedUser = parameters.isAgeRestrictedUser()) != null) {
                IronSource.setMetaData((String)"is_child_directed", (String)Boolean.toString(isAgeRestrictedUser));
            }
            IronSource.setAdaptersDebug((boolean)parameters.isTesting());
            IronSource.setISDemandOnlyInterstitialListener((ISDemandOnlyInterstitialListener)ROUTER);
            IronSource.setISDemandOnlyRewardedVideoListener((ISDemandOnlyRewardedVideoListener)ROUTER);
            Application application = activity != null ? activity.getApplication() : (Application)this.getApplicationContext();
            IronSource.initISDemandOnly((Context)application, (String)appKey, (IronSource.AD_UNIT[])this.getAdFormatsToInitialize(parameters));
            application.registerActivityLifecycleCallbacks(activityLifecycleCallbacks);
        }
        onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.DOES_NOT_APPLY, null);
    }

    public String getSdkVersion() {
        return IronSourceUtils.getSDKVersion();
    }

    public String getAdapterVersion() {
        return "7.3.0.1.0";
    }

    public void onDestroy() {
        ROUTER.removeAdapter((MaxAdapter)this, this.mRouterPlacementIdentifier);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        this.setPrivacySettings((MaxAdapterParameters)parameters);
        String instanceId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading ironSource interstitial for instance ID: " + instanceId);
        this.mRouterPlacementIdentifier = IronSourceRouter.getInterstitialRouterIdentifier(instanceId);
        ROUTER.addInterstitialAdapter((MaxAdapter)this, listener, this.mRouterPlacementIdentifier);
        if (IronSource.isISDemandOnlyInterstitialReady((String)instanceId)) {
            this.log("Ad is available already for instance ID: " + instanceId);
            ROUTER.onAdLoaded(this.mRouterPlacementIdentifier);
        } else {
            IronSource.loadISDemandOnlyInterstitial((Activity)activity, (String)instanceId);
        }
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        String instanceId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing ironSource interstitial for instance ID: " + instanceId);
        ROUTER.addShowingAdapter((MaxAdapter)this);
        if (IronSource.isISDemandOnlyInterstitialReady((String)instanceId)) {
            IronSource.showISDemandOnlyInterstitial((String)instanceId);
        } else {
            this.log("Unable to show ironSource interstitial - no ad loaded for instance ID: " + instanceId);
            ROUTER.onAdDisplayFailed(IronSourceRouter.getInterstitialRouterIdentifier(instanceId), new MaxAdapterError(-4205, "Ad Display Failed", 0, "Interstitial ad not ready"));
        }
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        this.setPrivacySettings((MaxAdapterParameters)parameters);
        String instanceId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading ironSource rewarded for instance ID: " + instanceId);
        this.mRouterPlacementIdentifier = IronSourceRouter.getRewardedVideoRouterIdentifier(instanceId);
        ROUTER.addRewardedAdapter((MaxAdapter)this, listener, this.mRouterPlacementIdentifier);
        if (IronSource.isISDemandOnlyRewardedVideoAvailable((String)instanceId)) {
            this.log("Ad is available already for instance ID: " + instanceId);
            ROUTER.onAdLoaded(this.mRouterPlacementIdentifier);
        } else {
            IronSource.loadISDemandOnlyRewardedVideo((Activity)activity, (String)instanceId);
        }
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        String instanceId = parameters.getThirdPartyAdPlacementId();
        this.log("Showing ironSource rewarded for instance ID: " + instanceId);
        ROUTER.addShowingAdapter((MaxAdapter)this);
        if (IronSource.isISDemandOnlyRewardedVideoAvailable((String)instanceId)) {
            this.configureReward(parameters);
            IronSource.showISDemandOnlyRewardedVideo((String)instanceId);
        } else {
            this.log("Unable to show ironSource rewarded - no ad loaded...");
            ROUTER.onAdDisplayFailed(IronSourceRouter.getRewardedVideoRouterIdentifier(instanceId), new MaxAdapterError(-4205, "Ad Display Failed", 0, "Rewarded ad not ready"));
        }
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, Activity activity, MaxAdViewAdapterListener listener) {
        this.setPrivacySettings((MaxAdapterParameters)parameters);
        String instanceId = parameters.getThirdPartyAdPlacementId();
        this.log("Loading " + adFormat.getLabel() + " ad for instance ID: " + instanceId);
        this.adView = IronSource.createBannerForDemandOnly((Activity)activity, (ISBannerSize)this.toISBannerSize(adFormat));
        this.adView.setBannerDemandOnlyListener((ISDemandOnlyBannerListener)new AdViewListener(listener));
        IronSource.loadISDemandOnlyBanner((Activity)activity, (ISDemandOnlyBannerLayout)this.adView, (String)instanceId);
    }

    private void setPrivacySettings(MaxAdapterParameters parameters) {
        Boolean hasUserConsent = parameters.hasUserConsent();
        if (hasUserConsent != null) {
            IronSource.setConsent((boolean)hasUserConsent);
        }
    }

    private IronSource.AD_UNIT[] getAdFormatsToInitialize(MaxAdapterInitializationParameters parameters) {
        ArrayList adFormats = parameters.getServerParameters().getStringArrayList("init_ad_formats");
        if (adFormats == null || adFormats.isEmpty()) {
            return new IronSource.AD_UNIT[]{IronSource.AD_UNIT.INTERSTITIAL, IronSource.AD_UNIT.REWARDED_VIDEO, IronSource.AD_UNIT.BANNER};
        }
        ArrayList<IronSource.AD_UNIT> adFormatsToInitialize = new ArrayList<IronSource.AD_UNIT>();
        if (adFormats.contains("inter")) {
            adFormatsToInitialize.add(IronSource.AD_UNIT.INTERSTITIAL);
        }
        if (adFormats.contains("rewarded")) {
            adFormatsToInitialize.add(IronSource.AD_UNIT.REWARDED_VIDEO);
        }
        if (adFormats.contains("banner")) {
            adFormatsToInitialize.add(IronSource.AD_UNIT.BANNER);
        }
        return adFormatsToInitialize.toArray(new IronSource.AD_UNIT[adFormatsToInitialize.size()]);
    }

    private ISBannerSize toISBannerSize(MaxAdFormat adFormat) {
        if (adFormat == MaxAdFormat.BANNER) {
            return ISBannerSize.BANNER;
        }
        if (adFormat == MaxAdFormat.LEADER) {
            return ISBannerSize.LARGE;
        }
        if (adFormat == MaxAdFormat.MREC) {
            return ISBannerSize.RECTANGLE;
        }
        throw new IllegalArgumentException("Invalid ad format: " + adFormat);
    }

    private class AdViewListener
    implements ISDemandOnlyBannerListener {
        private final MaxAdViewAdapterListener listener;

        AdViewListener(MaxAdViewAdapterListener listener) {
            this.listener = listener;
        }

        public void onBannerAdLoaded(String instanceId) {
            IronSourceMediationAdapter.this.log("AdView loaded for instance ID: " + instanceId);
            this.listener.onAdViewAdLoaded((View)IronSourceMediationAdapter.this.adView);
        }

        public void onBannerAdLoadFailed(String instanceId, IronSourceError ironSourceError) {
            MaxAdapterError adapterError = IronSourceRouter.toMaxError(ironSourceError);
            IronSourceMediationAdapter.this.log("AdView ad failed to load for instance ID: " + instanceId + " with error: " + adapterError);
            this.listener.onAdViewAdLoadFailed(adapterError);
        }

        public void onBannerAdShown(String instanceId) {
            IronSourceMediationAdapter.this.log("AdView ad displayed for instance ID: " + instanceId);
            this.listener.onAdViewAdDisplayed();
        }

        public void onBannerAdClicked(String instanceId) {
            IronSourceMediationAdapter.this.log("AdView ad clicked for instance ID: " + instanceId);
            this.listener.onAdViewAdClicked();
        }

        public void onBannerAdLeftApplication(String instanceId) {
            IronSourceMediationAdapter.this.log("AdView ad left application for instance ID: " + instanceId);
        }
    }

    private static class IronSourceRouter
    extends MediationAdapterRouter
    implements ISDemandOnlyInterstitialListener,
    ISDemandOnlyRewardedVideoListener {
        private boolean hasGrantedReward;

        private IronSourceRouter() {
        }

        void initialize(MaxAdapterInitializationParameters parameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        }

        public void onInterstitialAdReady(String instanceId) {
            this.log("Interstitial loaded for instance ID: " + instanceId);
            this.onAdLoaded(IronSourceRouter.getInterstitialRouterIdentifier(instanceId));
        }

        public void onInterstitialAdLoadFailed(String instanceId, IronSourceError ironSourceError) {
            this.log("Interstitial ad failed to load for instance ID: " + instanceId + " with error: " + ironSourceError);
            this.onAdLoadFailed(IronSourceRouter.getInterstitialRouterIdentifier(instanceId), IronSourceRouter.toMaxError(ironSourceError));
        }

        public void onInterstitialAdOpened(String instanceId) {
            this.log("Interstitial ad displayed for instance ID: " + instanceId);
            this.onAdDisplayed(IronSourceRouter.getInterstitialRouterIdentifier(instanceId));
        }

        public void onInterstitialAdClosed(String instanceId) {
            this.log("Interstitial ad closed for instance ID: " + instanceId);
            this.onAdHidden(IronSourceRouter.getInterstitialRouterIdentifier(instanceId));
        }

        public void onInterstitialAdShowFailed(String instanceId, IronSourceError ironSourceError) {
            MaxAdapterError adapterError = new MaxAdapterError(-4205, "Ad Display Failed", ironSourceError.getErrorCode(), ironSourceError.getErrorMessage());
            this.log("Interstitial ad failed to show for instance ID: " + instanceId + " with error: " + adapterError);
            this.onAdDisplayFailed(IronSourceRouter.getInterstitialRouterIdentifier(instanceId), adapterError);
        }

        public void onInterstitialAdClicked(String instanceId) {
            this.log("Interstitial ad clicked for instance ID: " + instanceId);
            this.onAdClicked(IronSourceRouter.getInterstitialRouterIdentifier(instanceId));
        }

        public void onRewardedVideoAdOpened(String instanceId) {
            this.log("Rewarded ad shown for instance ID: " + instanceId);
            String routerPlacementId = IronSourceRouter.getRewardedVideoRouterIdentifier(instanceId);
            this.onAdDisplayed(routerPlacementId);
            this.onRewardedAdVideoStarted(routerPlacementId);
        }

        public void onRewardedVideoAdClosed(String instanceId) {
            String routerPlacementId = IronSourceRouter.getRewardedVideoRouterIdentifier(instanceId);
            if (this.hasGrantedReward || this.shouldAlwaysRewardUser(routerPlacementId)) {
                MaxReward reward = this.getReward(routerPlacementId);
                this.log("Rewarded  ad rewarded user with reward: " + reward + " for instance ID: " + instanceId);
                this.onUserRewarded(routerPlacementId, reward);
                this.hasGrantedReward = false;
            }
            this.log("Rewarded ad hidden for instance ID: " + instanceId);
            this.onAdHidden(routerPlacementId);
        }

        public void onRewardedVideoAdLoadSuccess(String instanceId) {
            this.log("Rewarded ad loaded for instance ID: " + instanceId);
            this.onAdLoaded(IronSourceRouter.getRewardedVideoRouterIdentifier(instanceId));
        }

        public void onRewardedVideoAdLoadFailed(String instanceId, IronSourceError ironSourceError) {
            this.log("Rewarded ad failed to load for instance ID: " + instanceId);
            this.onAdLoadFailed(IronSourceRouter.getRewardedVideoRouterIdentifier(instanceId), IronSourceRouter.toMaxError(ironSourceError));
        }

        public void onRewardedVideoAdRewarded(String instanceId) {
            this.log("Rewarded ad granted reward for instance ID: " + instanceId);
            this.onRewardedAdVideoCompleted(IronSourceRouter.getRewardedVideoRouterIdentifier(instanceId));
            this.hasGrantedReward = true;
        }

        public void onRewardedVideoAdShowFailed(String instanceId, IronSourceError ironSourceError) {
            MaxAdapterError adapterError = new MaxAdapterError(-4205, "Ad Display Failed", ironSourceError.getErrorCode(), ironSourceError.getErrorMessage());
            this.log("Rewarded ad failed to show for instance ID: " + instanceId + " with error: " + adapterError);
            this.onAdDisplayFailed(IronSourceRouter.getRewardedVideoRouterIdentifier(instanceId), adapterError);
        }

        public void onRewardedVideoAdClicked(String instanceId) {
            this.log("Rewarded ad clicked for instance ID: " + instanceId);
            this.onAdClicked(IronSourceRouter.getRewardedVideoRouterIdentifier(instanceId));
        }

        private static MaxAdapterError toMaxError(IronSourceError ironSourceError) {
            int ironSourceErrorCode = ironSourceError.getErrorCode();
            MaxAdapterError adapterError = MaxAdapterError.UNSPECIFIED;
            switch (ironSourceErrorCode) {
                case 1: 
                case 527: 
                case 605: 
                case 610: 
                case 611: 
                case 613: 
                case 614: 
                case 1000: 
                case 1001: 
                case 1002: 
                case 1003: 
                case 1004: 
                case 1005: 
                case 1007: 
                case 1008: 
                case 1028: 
                case 1030: 
                case 1034: 
                case 1038: 
                case 1039: 
                case 1040: 
                case 1041: 
                case 1060: 
                case 1061: {
                    adapterError = MaxAdapterError.INTERNAL_ERROR;
                    break;
                }
                case 501: 
                case 502: 
                case 505: 
                case 506: 
                case 615: 
                case 616: 
                case 1020: 
                case 1021: 
                case 1029: 
                case 1031: {
                    adapterError = MaxAdapterError.INVALID_CONFIGURATION;
                    break;
                }
                case 508: 
                case 600: 
                case 601: 
                case 602: 
                case 603: 
                case 607: 
                case 612: 
                case 1010: {
                    adapterError = MaxAdapterError.NOT_INITIALIZED;
                    break;
                }
                case 509: 
                case 606: 
                case 1024: 
                case 1035: 
                case 1058: 
                case 1158: {
                    adapterError = MaxAdapterError.NO_FILL;
                    break;
                }
                case 510: {
                    adapterError = MaxAdapterError.UNSPECIFIED;
                    break;
                }
                case 520: {
                    adapterError = MaxAdapterError.NO_CONNECTION;
                    break;
                }
                case 524: 
                case 526: 
                case 604: {
                    adapterError = MaxAdapterError.AD_FREQUENCY_CAPPED;
                    break;
                }
                case 608: 
                case 609: 
                case 1032: 
                case 1033: 
                case 1052: 
                case 1055: {
                    adapterError = MaxAdapterError.TIMEOUT;
                    break;
                }
                case 1006: {
                    adapterError = MaxAdapterError.SIGNAL_COLLECTION_TIMEOUT;
                    break;
                }
                case 1022: 
                case 1023: 
                case 1026: 
                case 1027: 
                case 1036: 
                case 1037: 
                case 1050: 
                case 1053: 
                case 1056: {
                    adapterError = MaxAdapterError.INVALID_LOAD_STATE;
                    break;
                }
                case 1051: 
                case 1054: {
                    adapterError = MaxAdapterError.AD_NOT_READY;
                    break;
                }
                case 1057: {
                    adapterError = MaxAdapterError.AD_EXPIRED;
                }
            }
            return new MaxAdapterError(adapterError.getErrorCode(), adapterError.getErrorMessage(), ironSourceErrorCode, ironSourceError.getErrorMessage());
        }

        private static String getInterstitialRouterIdentifier(String instanceId) {
            return instanceId + "-" + IronSource.AD_UNIT.INTERSTITIAL.toString();
        }

        private static String getRewardedVideoRouterIdentifier(String instanceId) {
            return instanceId + "-" + IronSource.AD_UNIT.REWARDED_VIDEO.toString();
        }
    }
}

