/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdViewAdapter;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxAdViewAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.my.target.ads.InterstitialAd;
import com.my.target.ads.MyTargetView;
import com.my.target.ads.Reward;
import com.my.target.ads.RewardedAd;
import com.my.target.common.MyTargetManager;
import com.my.target.common.MyTargetPrivacy;
import java.lang.reflect.Method;

public class MyTargetMediationAdapter
extends MediationAdapterBase
implements MaxSignalProvider,
MaxInterstitialAdapter,
MaxRewardedAdapter,
MaxAdViewAdapter {
    private InterstitialAd interstitialAd;
    private RewardedAd rewardedAd;
    private MyTargetView adView;

    public MyTargetMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public String getSdkVersion() {
        return "5.13.4";
    }

    public String getAdapterVersion() {
        return "5.13.4.0";
    }

    public void onDestroy() {
        if (this.interstitialAd != null) {
            this.interstitialAd.destroy();
            this.interstitialAd = null;
        }
        if (this.rewardedAd != null) {
            this.rewardedAd.destroy();
            this.rewardedAd = null;
        }
        if (this.adView != null) {
            this.adView.destroy();
            this.adView = null;
        }
    }

    public void initialize(MaxAdapterInitializationParameters parameters, Activity activity, MaxAdapter.OnCompletionListener onCompletionListener) {
        this.checkExistence(new Class[]{MyTargetPrivacy.class, InterstitialAd.class, MyTargetView.class});
        if (parameters.isTesting()) {
            MyTargetManager.setDebugMode((boolean)true);
        }
        onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.DOES_NOT_APPLY, null);
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, Activity activity, MaxSignalCollectionListener callback) {
        this.log("Collecting signal...");
        String signal = MyTargetManager.getBidderToken((Context)activity);
        callback.onSignalCollected(signal);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        int slotId = Integer.parseInt(parameters.getThirdPartyAdPlacementId());
        this.log("Loading interstitial ad for slot id: " + slotId + "...");
        this.interstitialAd = new InterstitialAd(slotId, (Context)activity);
        this.interstitialAd.setListener((InterstitialAd.InterstitialAdListener)new InterstitialListener(listener));
        this.interstitialAd.getCustomParams().setCustomParam("mediation", "7");
        this.updatePrivacyStates(parameters);
        String bidResponse = parameters.getBidResponse();
        if (!TextUtils.isEmpty((CharSequence)bidResponse)) {
            this.log("Loading bidding interstitial ad...");
            this.interstitialAd.loadFromBid(bidResponse);
        } else {
            this.log("Loading mediated interstitial ad...");
            this.interstitialAd.load();
        }
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        this.log("Showing interstitial ad...");
        if (this.interstitialAd != null) {
            this.interstitialAd.show();
        } else {
            this.log("Interstitial ad is null");
            listener.onInterstitialAdDisplayFailed(MaxAdapterError.UNSPECIFIED);
        }
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        int slotId = Integer.parseInt(parameters.getThirdPartyAdPlacementId());
        this.log("Loading rewarded ad for slot id: " + slotId + "...");
        this.rewardedAd = new RewardedAd(slotId, (Context)activity);
        this.rewardedAd.setListener((RewardedAd.RewardedAdListener)new RewardedAdListener(listener));
        this.rewardedAd.getCustomParams().setCustomParam("mediation", "7");
        this.updatePrivacyStates(parameters);
        String bidResponse = parameters.getBidResponse();
        if (!TextUtils.isEmpty((CharSequence)bidResponse)) {
            this.log("Loading bidding rewarded ad...");
            this.rewardedAd.loadFromBid(bidResponse);
        } else {
            this.log("Loading mediated rewarded ad...");
            this.rewardedAd.load();
        }
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        this.log("Showing rewarded ad...");
        if (this.rewardedAd != null) {
            this.configureReward(parameters);
            this.rewardedAd.show();
        } else {
            this.log("Rewarded ad is null");
            listener.onRewardedAdDisplayFailed(MaxAdapterError.UNSPECIFIED);
        }
    }

    public void loadAdViewAd(MaxAdapterResponseParameters parameters, MaxAdFormat adFormat, Activity activity, MaxAdViewAdapterListener listener) {
        int slotId = Integer.parseInt(parameters.getThirdPartyAdPlacementId());
        this.log("Loading ad view with format: " + adFormat.getLabel() + " for slot id: " + slotId + "...");
        this.adView = new MyTargetView((Context)activity);
        this.adView.setSlotId(slotId);
        this.adView.setAdSize(MyTargetMediationAdapter.getBannerSize(adFormat));
        this.adView.setRefreshAd(false);
        this.adView.setListener((MyTargetView.MyTargetViewListener)new AdViewListener(listener));
        this.adView.getCustomParams().setCustomParam("mediation", "7");
        this.updatePrivacyStates(parameters);
        String bidResponse = parameters.getBidResponse();
        if (!TextUtils.isEmpty((CharSequence)bidResponse)) {
            this.log("Loading bidding ad view...");
            this.adView.loadFromBid(bidResponse);
        } else {
            this.log("Loading mediated ad view...");
            this.adView.load();
        }
    }

    private void updatePrivacyStates(MaxAdapterResponseParameters parameters) {
        Boolean hasUserConsent;
        Boolean isAgeRestrictedUser = this.getPrivacySetting("isAgeRestrictedUser", (MaxAdapterParameters)parameters);
        if (isAgeRestrictedUser != null) {
            MyTargetPrivacy.setUserAgeRestricted((boolean)isAgeRestrictedUser);
        }
        if (this.getWrappingSdk().getConfiguration().getConsentDialogState() == AppLovinSdkConfiguration.ConsentDialogState.APPLIES && (hasUserConsent = this.getPrivacySetting("hasUserConsent", (MaxAdapterParameters)parameters)) != null) {
            MyTargetPrivacy.setUserConsent((boolean)hasUserConsent);
        }
    }

    private Boolean getPrivacySetting(String privacySetting, MaxAdapterParameters parameters) {
        try {
            Class<?> parametersClass = parameters.getClass();
            Method privacyMethod = parametersClass.getMethod(privacySetting, new Class[0]);
            return (Boolean)privacyMethod.invoke((Object)parameters, new Object[0]);
        }
        catch (Exception exception) {
            this.log("Error getting privacy setting " + privacySetting + " with exception: ", exception);
            return AppLovinSdk.VERSION_CODE >= 9140000 ? null : Boolean.valueOf(false);
        }
    }

    private static MyTargetView.AdSize getBannerSize(MaxAdFormat maxAdFormat) {
        if (maxAdFormat == MaxAdFormat.BANNER) {
            return MyTargetView.AdSize.ADSIZE_320x50;
        }
        if (maxAdFormat == MaxAdFormat.MREC) {
            return MyTargetView.AdSize.ADSIZE_300x250;
        }
        if (maxAdFormat == MaxAdFormat.LEADER) {
            return MyTargetView.AdSize.ADSIZE_728x90;
        }
        return MyTargetView.AdSize.ADSIZE_320x50;
    }

    private static MaxAdapterError toMaxError(String myTargetError) {
        return new MaxAdapterError(MaxAdapterError.NO_FILL.getErrorCode(), MaxAdapterError.NO_FILL.getErrorMessage(), 0, myTargetError);
    }

    private class AdViewListener
    implements MyTargetView.MyTargetViewListener {
        private final MaxAdViewAdapterListener listener;

        AdViewListener(MaxAdViewAdapterListener listener) {
            this.listener = listener;
        }

        public void onLoad(@NonNull MyTargetView myTargetView) {
            MyTargetMediationAdapter.this.log("Ad view loaded");
            this.listener.onAdViewAdLoaded((View)myTargetView);
        }

        public void onNoAd(@NonNull String reason, @NonNull MyTargetView myTargetView) {
            MyTargetMediationAdapter.this.log("Ad view failed to load with reason: " + reason);
            this.listener.onAdViewAdLoadFailed(MyTargetMediationAdapter.toMaxError(reason));
        }

        public void onShow(@NonNull MyTargetView myTargetView) {
            MyTargetMediationAdapter.this.log("Ad view displayed");
            this.listener.onAdViewAdDisplayed();
        }

        public void onClick(@NonNull MyTargetView myTargetView) {
            MyTargetMediationAdapter.this.log("Ad view clicked");
            this.listener.onAdViewAdClicked();
        }
    }

    private class RewardedAdListener
    implements RewardedAd.RewardedAdListener {
        private final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward = false;

        RewardedAdListener(MaxRewardedAdapterListener listener) {
            this.listener = listener;
        }

        public void onLoad(@NonNull RewardedAd rewardedAd) {
            MyTargetMediationAdapter.this.log("Rewarded ad loaded");
            this.listener.onRewardedAdLoaded();
        }

        public void onNoAd(@NonNull String reason, @NonNull RewardedAd rewardedAd) {
            MyTargetMediationAdapter.this.log("Rewarded ad failed to load with reason: " + reason);
            this.listener.onRewardedAdLoadFailed(MyTargetMediationAdapter.toMaxError(reason));
        }

        public void onDisplay(@NonNull RewardedAd rewardedAd) {
            MyTargetMediationAdapter.this.log("Rewarded ad displayed");
            this.listener.onRewardedAdDisplayed();
            this.listener.onRewardedAdVideoStarted();
        }

        public void onClick(@NonNull RewardedAd rewardedAd) {
            MyTargetMediationAdapter.this.log("Rewarded ad clicked");
            this.listener.onRewardedAdClicked();
        }

        public void onReward(@NonNull Reward reward, @NonNull RewardedAd rewardedAd) {
            MyTargetMediationAdapter.this.log("Rewarded ad reward granted");
            this.hasGrantedReward = true;
        }

        public void onDismiss(@NonNull RewardedAd rewardedAd) {
            if (this.hasGrantedReward || MyTargetMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward reward = MyTargetMediationAdapter.this.getReward();
                MyTargetMediationAdapter.this.log("Rewarded user with reward: " + reward);
                this.listener.onUserRewarded(reward);
            }
            MyTargetMediationAdapter.this.log("Rewarded ad dismissed");
            this.listener.onRewardedAdHidden();
        }
    }

    private class InterstitialListener
    implements InterstitialAd.InterstitialAdListener {
        private final MaxInterstitialAdapterListener listener;

        InterstitialListener(MaxInterstitialAdapterListener listener) {
            this.listener = listener;
        }

        public void onLoad(@NonNull InterstitialAd interstitialAd) {
            MyTargetMediationAdapter.this.log("Interstitial loaded");
            this.listener.onInterstitialAdLoaded();
        }

        public void onNoAd(@NonNull String reason, @NonNull InterstitialAd interstitialAd) {
            MyTargetMediationAdapter.this.log("Interstitial failed to load with reason: " + reason);
            this.listener.onInterstitialAdLoadFailed(MyTargetMediationAdapter.toMaxError(reason));
        }

        public void onDisplay(@NonNull InterstitialAd interstitialAd) {
            MyTargetMediationAdapter.this.log("Interstitial displayed");
            this.listener.onInterstitialAdDisplayed();
        }

        public void onClick(@NonNull InterstitialAd interstitialAd) {
            MyTargetMediationAdapter.this.log("Interstitial clicked");
            this.listener.onInterstitialAdClicked();
        }

        public void onVideoCompleted(@NonNull InterstitialAd interstitialAd) {
            MyTargetMediationAdapter.this.log("Interstitial video completed");
        }

        public void onDismiss(@NonNull InterstitialAd interstitialAd) {
            MyTargetMediationAdapter.this.log("Interstitial dismissed");
            this.listener.onInterstitialAdHidden();
        }
    }
}

