/*
 * Decompiled with CFR 0.152.
 */
package com.applovin.mediation.adapters;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.MaxSignalProvider;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxSignalCollectionListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterSignalCollectionParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.applovin.sdk.AppLovinSdkUtils;
import com.tapjoy.TJActionRequest;
import com.tapjoy.TJConnectListener;
import com.tapjoy.TJError;
import com.tapjoy.TJPlacement;
import com.tapjoy.TJPlacementListener;
import com.tapjoy.TJPlacementVideoListener;
import com.tapjoy.TJPrivacyPolicy;
import com.tapjoy.Tapjoy;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.json.JSONObject;

public class TapjoyMediationAdapter
extends MediationAdapterBase
implements MaxSignalProvider,
MaxInterstitialAdapter,
MaxRewardedAdapter {
    private TJPlacement interstitialPlacement;
    private TJPlacement rewardedPlacement;

    public TapjoyMediationAdapter(AppLovinSdk sdk) {
        super(sdk);
    }

    public String getSdkVersion() {
        return Tapjoy.getVersion();
    }

    public String getAdapterVersion() {
        return "12.8.1.0";
    }

    public void onDestroy() {
    }

    public void initialize(MaxAdapterInitializationParameters parameters, Activity activity, final MaxAdapter.OnCompletionListener onCompletionListener) {
        this.checkExistence(new Class[]{Tapjoy.class, TJPlacement.class});
        if (!Tapjoy.isConnected()) {
            String sdkKey = parameters.getServerParameters().getString("sdk_key");
            this.log("Initializing Tapjoy SDK with sdk key: " + sdkKey + "...");
            Tapjoy.setDebugEnabled((boolean)parameters.isTesting());
            Hashtable<String, String> connectFlags = new Hashtable<String, String>(1);
            connectFlags.put("TJC_OPTION_ENABLE_LOGGING", String.valueOf(parameters.isTesting()));
            this.updateConsentAndActivity((MaxAdapterParameters)parameters, activity);
            Tapjoy.connect((Context)activity, (String)sdkKey, connectFlags, (TJConnectListener)new TJConnectListener(){

                public void onConnectSuccess() {
                    TapjoyMediationAdapter.this.log("Tapjoy SDK initialized");
                    onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS, null);
                }

                public void onConnectFailure() {
                    TapjoyMediationAdapter.this.log("Tapjoy SDK failed to initialized");
                    onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZED_FAILURE, null);
                }
            });
        } else {
            this.updateConsentAndActivity((MaxAdapterParameters)parameters, activity);
            onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS, null);
        }
    }

    public void collectSignal(MaxAdapterSignalCollectionParameters parameters, Activity activity, MaxSignalCollectionListener callback) {
        this.updateConsentAndActivity((MaxAdapterParameters)parameters, activity);
        String token = Tapjoy.getUserToken();
        callback.onSignalCollected(token);
    }

    public void loadInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        this.log("Loading interstitial...");
        if (!Tapjoy.isConnected()) {
            this.log("Tapjoy SDK is not initialized");
            listener.onInterstitialAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
            return;
        }
        this.updateConsentAndActivity((MaxAdapterParameters)parameters, activity);
        this.interstitialPlacement = this.createPlacement(activity, parameters, new InterstitialListener(listener));
        if (this.interstitialPlacement != null) {
            this.interstitialPlacement.requestContent();
        } else {
            listener.onInterstitialAdLoadFailed(MaxAdapterError.BAD_REQUEST);
        }
    }

    public void showInterstitialAd(MaxAdapterResponseParameters parameters, Activity activity, MaxInterstitialAdapterListener listener) {
        this.log("Showing interstitial...");
        if (this.interstitialPlacement.isContentReady()) {
            this.interstitialPlacement.showContent();
        } else {
            this.log("Interstitial ad not ready");
            listener.onInterstitialAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
        }
    }

    public void loadRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        this.log("Loading rewarded ad...");
        if (!Tapjoy.isConnected()) {
            this.log("Tapjoy SDK is not initialized");
            listener.onRewardedAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
            return;
        }
        this.updateConsentAndActivity((MaxAdapterParameters)parameters, activity);
        this.rewardedPlacement = this.createPlacement(activity, parameters, new RewardedListener(listener));
        if (this.rewardedPlacement != null) {
            this.rewardedPlacement.requestContent();
        } else {
            listener.onRewardedAdLoadFailed(MaxAdapterError.BAD_REQUEST);
        }
    }

    public void showRewardedAd(MaxAdapterResponseParameters parameters, Activity activity, MaxRewardedAdapterListener listener) {
        this.log("Showing rewarded ad...");
        if (this.rewardedPlacement.isContentReady()) {
            this.configureReward(parameters);
            this.rewardedPlacement.showContent();
        } else {
            this.log("Rewarded ad not ready");
            listener.onRewardedAdDisplayFailed(MaxAdapterError.AD_NOT_READY);
        }
    }

    private void updateConsentAndActivity(MaxAdapterParameters parameters, Activity activity) {
        TJPrivacyPolicy tjPrivacyPolicy = Tapjoy.getPrivacyPolicy();
        Boolean isAgeRestrictedUser = this.getPrivacySetting("isAgeRestrictedUser", parameters);
        if (isAgeRestrictedUser != null) {
            tjPrivacyPolicy.setBelowConsentAge(isAgeRestrictedUser.booleanValue());
        }
        if (this.getWrappingSdk().getConfiguration().getConsentDialogState() == AppLovinSdkConfiguration.ConsentDialogState.APPLIES) {
            tjPrivacyPolicy.setSubjectToGDPR(true);
            Boolean hasUserConsent = this.getPrivacySetting("hasUserConsent", parameters);
            if (hasUserConsent != null) {
                tjPrivacyPolicy.setUserConsent(hasUserConsent != false ? "1" : "0");
            }
        } else if (this.getWrappingSdk().getConfiguration().getConsentDialogState() == AppLovinSdkConfiguration.ConsentDialogState.DOES_NOT_APPLY) {
            tjPrivacyPolicy.setSubjectToGDPR(false);
        }
        Tapjoy.setActivity((Activity)activity);
    }

    private Boolean getPrivacySetting(String privacySetting, MaxAdapterParameters parameters) {
        try {
            Class<?> parametersClass = parameters.getClass();
            Method privacyMethod = parametersClass.getMethod(privacySetting, new Class[0]);
            return (Boolean)privacyMethod.invoke((Object)parameters, new Object[0]);
        }
        catch (Exception exception) {
            this.log("Error getting privacy setting " + privacySetting + " with exception: ", exception);
            return AppLovinSdk.VERSION_CODE >= 9140000 ? null : Boolean.valueOf(false);
        }
    }

    private TJPlacement createPlacement(Activity activity, MaxAdapterResponseParameters parameters, TJPlacementListener listener) {
        TJPlacement placement = new TJPlacement((Context)activity, parameters.getThirdPartyAdPlacementId(), listener);
        placement.setMediationName("applovin");
        placement.setAdapterVersion("12.8.1.0");
        if (listener instanceof TJPlacementVideoListener) {
            placement.setVideoListener((TJPlacementVideoListener)listener);
        }
        if (!TextUtils.isEmpty((CharSequence)parameters.getBidResponse())) {
            try {
                JSONObject auctionData = new JSONObject(parameters.getBidResponse());
                Map auctionDataMap = AppLovinSdkUtils.toMap((JSONObject)auctionData);
                placement.setAuctionData((HashMap)auctionDataMap);
            }
            catch (Throwable th) {
                this.log("Failed to load ad due to JSON deserialization error: ", th);
                return null;
            }
        }
        return placement;
    }

    private static MaxAdapterError toMaxError(TJError tapjoyError) {
        String tapjoyErrorMessage;
        int tapjoyErrorCode;
        if (tapjoyError != null) {
            tapjoyErrorCode = tapjoyError.code;
            tapjoyErrorMessage = tapjoyError.message;
        } else {
            tapjoyErrorCode = 0;
            tapjoyErrorMessage = "";
        }
        MaxAdapterError adapterError = tapjoyErrorCode == 204 ? MaxAdapterError.NO_FILL : (tapjoyErrorCode == -1011 ? MaxAdapterError.NOT_INITIALIZED : MaxAdapterError.UNSPECIFIED);
        return new MaxAdapterError(adapterError.getErrorCode(), adapterError.getErrorMessage(), tapjoyErrorCode, tapjoyErrorMessage);
    }

    private class RewardedListener
    implements TJPlacementListener,
    TJPlacementVideoListener {
        final MaxRewardedAdapterListener listener;
        private boolean hasGrantedReward;

        RewardedListener(MaxRewardedAdapterListener listener) {
            this.listener = listener;
        }

        public void onRequestSuccess(TJPlacement tjPlacement) {
            if (tjPlacement.isContentAvailable()) {
                TapjoyMediationAdapter.this.log("Rewarded request succeeded");
            } else {
                TapjoyMediationAdapter.this.log("Rewarded request failed");
                this.listener.onRewardedAdLoadFailed(MaxAdapterError.NO_FILL);
            }
        }

        public void onRequestFailure(TJPlacement tjPlacement, TJError tjError) {
            TapjoyMediationAdapter.this.log("Rewarded failed to load with error code: " + tjError.code + " and message: " + tjError.message);
            MaxAdapterError adapterErrorCode = TapjoyMediationAdapter.toMaxError(tjError);
            this.listener.onRewardedAdLoadFailed(adapterErrorCode);
        }

        public void onContentReady(TJPlacement tjPlacement) {
            TapjoyMediationAdapter.this.log("Rewarded loaded");
            this.listener.onRewardedAdLoaded();
        }

        public void onContentShow(TJPlacement tjPlacement) {
            TapjoyMediationAdapter.this.log("Rewarded shown");
        }

        public void onClick(TJPlacement tjPlacement) {
            TapjoyMediationAdapter.this.log("Rewarded clicked");
            this.listener.onRewardedAdClicked();
        }

        public void onContentDismiss(TJPlacement tjPlacement) {
            if (this.hasGrantedReward || TapjoyMediationAdapter.this.shouldAlwaysRewardUser()) {
                MaxReward reward = TapjoyMediationAdapter.this.getReward();
                TapjoyMediationAdapter.this.log("Rewarded user with reward: " + reward);
                this.listener.onUserRewarded(reward);
            }
            TapjoyMediationAdapter.this.log("Rewarded hidden");
            this.listener.onRewardedAdHidden();
        }

        public void onPurchaseRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s) {
        }

        public void onRewardRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s, int i) {
        }

        public void onVideoStart(TJPlacement tjPlacement) {
            TapjoyMediationAdapter.this.log("Rewarded video began");
            this.listener.onRewardedAdDisplayed();
            this.listener.onRewardedAdVideoStarted();
        }

        public void onVideoError(TJPlacement tjPlacement, String s) {
            TapjoyMediationAdapter.this.log("Rewarded failed with error message: " + s);
            MaxAdapterError adapterError = new MaxAdapterError(MaxAdapterError.UNSPECIFIED.getErrorCode(), MaxAdapterError.UNSPECIFIED.getErrorMessage(), 0, s);
            this.listener.onRewardedAdDisplayFailed(adapterError);
        }

        public void onVideoComplete(TJPlacement tjPlacement) {
            TapjoyMediationAdapter.this.log("Rewarded video completed");
            this.listener.onRewardedAdVideoCompleted();
            this.hasGrantedReward = true;
        }
    }

    private class InterstitialListener
    implements TJPlacementListener,
    TJPlacementVideoListener {
        final MaxInterstitialAdapterListener listener;

        InterstitialListener(MaxInterstitialAdapterListener listener) {
            this.listener = listener;
        }

        public void onRequestSuccess(TJPlacement tjPlacement) {
            if (tjPlacement.isContentAvailable()) {
                TapjoyMediationAdapter.this.log("Interstitial request succeeded");
            } else {
                TapjoyMediationAdapter.this.log("Interstitial request failed");
                this.listener.onInterstitialAdLoadFailed(MaxAdapterError.NO_FILL);
            }
        }

        public void onRequestFailure(TJPlacement tjPlacement, TJError tjError) {
            TapjoyMediationAdapter.this.log("Interstitial failed to load with error code: " + tjError.code + " and message: " + tjError.message);
            MaxAdapterError adapterErrorCode = TapjoyMediationAdapter.toMaxError(tjError);
            this.listener.onInterstitialAdLoadFailed(adapterErrorCode);
        }

        public void onContentReady(TJPlacement tjPlacement) {
            TapjoyMediationAdapter.this.log("Interstitial loaded");
            this.listener.onInterstitialAdLoaded();
        }

        public void onContentShow(TJPlacement tjPlacement) {
            TapjoyMediationAdapter.this.log("Interstitial shown");
        }

        public void onClick(TJPlacement tjPlacement) {
            TapjoyMediationAdapter.this.log("Interstitial clicked");
            this.listener.onInterstitialAdClicked();
        }

        public void onContentDismiss(TJPlacement tjPlacement) {
            TapjoyMediationAdapter.this.log("Interstitial hidden");
            this.listener.onInterstitialAdHidden();
        }

        public void onVideoStart(TJPlacement tjPlacement) {
            TapjoyMediationAdapter.this.log("Interstitial video start");
            this.listener.onInterstitialAdDisplayed();
        }

        public void onVideoError(TJPlacement tjPlacement, String s) {
            TapjoyMediationAdapter.this.log("Interstitial failed with error message: " + s);
            MaxAdapterError adapterError = new MaxAdapterError(MaxAdapterError.UNSPECIFIED.getErrorCode(), MaxAdapterError.UNSPECIFIED.getErrorMessage(), 0, s);
            this.listener.onInterstitialAdDisplayFailed(adapterError);
        }

        public void onVideoComplete(TJPlacement tjPlacement) {
            TapjoyMediationAdapter.this.log("Interstitial video completed");
        }

        public void onPurchaseRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s) {
        }

        public void onRewardRequest(TJPlacement tjPlacement, TJActionRequest tjActionRequest, String s, int i) {
        }
    }
}

