/*
 * Decompiled with CFR 0.152.
 */
package com.appsflyer.deeplink;

import android.support.annotation.Nullable;
import com.appsflyer.deeplink.DeepLink;
import org.json.JSONException;
import org.json.JSONObject;

public class DeepLinkResult {
    private final Error error;
    private final DeepLink deepLink;
    private final Status status;

    public DeepLinkResult(@Nullable DeepLink deepLink, @Nullable Error error) {
        this.deepLink = deepLink;
        this.error = error;
        this.status = error != null ? Status.ERROR : (deepLink != null ? Status.FOUND : Status.NOT_FOUND);
    }

    public Error getError() {
        return this.error;
    }

    public DeepLink getDeepLink() {
        return this.deepLink;
    }

    public Status getStatus() {
        return this.status;
    }

    public String toString() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("deepLink", (Object)this.deepLink);
            jSONObject.put("error", (Object)this.error);
            jSONObject.put("status", (Object)this.status);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject.toString();
    }

    public static enum Error {
        TIMEOUT,
        NETWORK,
        HTTP_STATUS_CODE,
        UNEXPECTED;

    }

    public static enum Status {
        FOUND,
        NOT_FOUND,
        ERROR;

    }
}

