/*
 * Decompiled with CFR 0.152.
 */
package sg.bigo.ads.common.view;

import android.content.Context;
import android.graphics.Canvas;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.Gravity;
import android.widget.TextView;

public class VerticalTextView
extends TextView {
    private boolean a = true;

    public VerticalTextView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        int n2 = this.getGravity();
        if (Gravity.isVertical((int)n2) && (n2 & 0x70) == 80) {
            this.setGravity(n2 & 7 | 0x30);
            this.a = false;
            return;
        }
        this.a = true;
    }

    protected void onMeasure(int n2, int n3) {
        super.onMeasure(n3, n2);
        VerticalTextView verticalTextView = this;
        verticalTextView.setMeasuredDimension(verticalTextView.getMeasuredHeight(), this.getMeasuredWidth());
    }

    protected void onDraw(Canvas canvas) {
        TextPaint textPaint = this.getPaint();
        textPaint.setColor(this.getCurrentTextColor());
        textPaint.drawableState = this.getDrawableState();
        canvas.save();
        if (this.a) {
            canvas.translate((float)this.getWidth(), 0.0f);
            canvas.rotate(90.0f);
        } else {
            canvas.translate(0.0f, (float)this.getHeight());
            canvas.rotate(-90.0f);
        }
        canvas.translate((float)this.getCompoundPaddingLeft(), (float)this.getExtendedPaddingTop());
        this.getLayout().draw(canvas);
        canvas.restore();
    }
}

