/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit.internal;

import android.content.Context;
import android.util.AttributeSet;
import com.blacksquircle.ui.editorkit.R;
import com.blacksquircle.ui.editorkit.internal.SyntaxHighlightEditText;
import com.blacksquircle.ui.editorkit.listener.OnUndoRedoChangedListener;
import com.blacksquircle.ui.editorkit.model.TextChange;
import com.blacksquircle.ui.editorkit.utils.LinesCollection;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0002J*\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u001d\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00162\u0006\u0010\u000f\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u0006\u0010\u001c\u001a\u00020\fR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/blacksquircle/ui/editorkit/internal/AutoIndentEditText;", "Lcom/blacksquircle/ui/editorkit/internal/SyntaxHighlightEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "isAutoIndenting", "", "newText", "", "completeIndentation", "", "start", "count", "doOnTextChanged", "text", "", "before", "executeIndentation", "", "(I)[Ljava/lang/String;", "getIndentationForLine", "line", "getIndentationForOffset", "offset", "tab", "editorkit_release"})
public abstract class AutoIndentEditText
extends SyntaxHighlightEditText {
    @NotNull
    private String newText;
    private boolean isAutoIndenting;

    @JvmOverloads
    public AutoIndentEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.newText = "";
    }

    public /* synthetic */ AutoIndentEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.autoCompleteTextViewStyle;
        }
        this(context, attributeSet, n);
    }

    @Override
    public void doOnTextChanged(@Nullable CharSequence text, int start, int before, int count) {
        CharSequence charSequence = text;
        this.newText = String.valueOf(charSequence == null ? null : charSequence.subSequence(start, start + count));
        this.completeIndentation(start, count);
        super.doOnTextChanged(text, start, before, count);
        this.newText = "";
    }

    @NotNull
    public final String tab() {
        return this.getEditorConfig().getUseSpacesInsteadOfTabs() ? StringsKt.repeat((CharSequence)" ", (int)this.getEditorConfig().getTabWidth()) : "\t";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void completeIndentation(int start, int count) {
        int n;
        String string;
        String preText;
        String string2;
        if (this.isDoingUndoRedo() || this.isAutoIndenting) return;
        String[] result = this.executeIndentation(start);
        if (result[0] != null || result[1] != null) {
            String postText;
            string2 = result[0];
            preText = string2 == null ? "" : string2;
            String string3 = result[1];
            String string4 = postText = string3 == null ? "" : string3;
            if (Intrinsics.areEqual((Object)preText, (Object)"") && Intrinsics.areEqual((Object)postText, (Object)"")) return;
            string = preText + this.newText + postText;
        } else {
            if (result[2] == null) return;
            preText = result[2];
            string = preText == null ? "" : preText;
        }
        String replacementValue = string;
        if (result[3] != null) {
            string2 = result[3];
            Intrinsics.checkNotNull((Object)string2);
            boolean bl = false;
            n = Integer.parseInt(string2);
        } else {
            n = start + replacementValue.length();
        }
        int newCursorPosition = n;
        this.post(() -> AutoIndentEditText.completeIndentation$lambda-0(this, start, count, replacementValue, newCursorPosition));
    }

    private final String[] executeIndentation(int start) {
        String[] strArr = null;
        if (Intrinsics.areEqual((Object)this.newText, (Object)"\n") && this.getEditorConfig().getAutoIndentation()) {
            String prevLineIndentation = this.getIndentationForOffset(start);
            StringBuilder indentation = new StringBuilder(prevLineIndentation);
            int newCursorPosition = indentation.length() + start + 1;
            if (start > 0 && this.getText().charAt(start - 1) == '{') {
                indentation.append(this.tab());
                newCursorPosition = indentation.length() + start + 1;
            }
            if (start + 1 < this.getText().length() && this.getText().charAt(start + 1) == '}') {
                indentation.append("\n").append(prevLineIndentation);
            }
            strArr = new String[4];
            strArr[1] = indentation.toString();
            strArr[3] = String.valueOf(newCursorPosition);
            return strArr;
        }
        if (Intrinsics.areEqual((Object)this.newText, (Object)"\"") && this.getEditorConfig().getAutoCloseQuotes()) {
            if (start + 1 >= this.getText().length()) {
                strArr = new String[4];
                strArr[1] = "\"";
                strArr[3] = String.valueOf(start + 1);
                return strArr;
            }
            if (this.getText().charAt(start + 1) == '\"' && this.getText().charAt(start - 1) != '\\') {
                strArr = new String[4];
                strArr[2] = "";
                strArr[3] = String.valueOf(start + 1);
                return strArr;
            }
            if (this.getText().charAt(start + 1) != '\"' || this.getText().charAt(start - 1) != '\\') {
                strArr = new String[4];
                strArr[1] = "\"";
                strArr[3] = String.valueOf(start + 1);
                return strArr;
            }
        } else if (Intrinsics.areEqual((Object)this.newText, (Object)"'") && this.getEditorConfig().getAutoCloseQuotes()) {
            if (start + 1 >= this.getText().length()) {
                strArr = new String[4];
                strArr[1] = "'";
                strArr[3] = String.valueOf(start + 1);
                return strArr;
            }
            if (start + 1 >= this.getText().length()) {
                strArr = new String[4];
                strArr[1] = "'";
                strArr[3] = String.valueOf(start + 1);
                return strArr;
            }
            if (this.getText().charAt(start + 1) == '\'' && start > 0 && this.getText().charAt(start - 1) != '\\') {
                strArr = new String[4];
                strArr[2] = "";
                strArr[3] = String.valueOf(start + 1);
                return strArr;
            }
            if (this.getText().charAt(start + 1) != '\'' || start <= 0 || this.getText().charAt(start - 1) != '\\') {
                strArr = new String[4];
                strArr[1] = "'";
                strArr[3] = String.valueOf(start + 1);
                return strArr;
            }
        } else {
            if (Intrinsics.areEqual((Object)this.newText, (Object)"{") && this.getEditorConfig().getAutoCloseBrackets()) {
                strArr = new String[4];
                strArr[1] = "}";
                strArr[3] = String.valueOf(start + 1);
                return strArr;
            }
            if (Intrinsics.areEqual((Object)this.newText, (Object)"}") && this.getEditorConfig().getAutoCloseBrackets()) {
                if (start + 1 < this.getText().length() && this.getText().charAt(start + 1) == '}') {
                    strArr = new String[4];
                    strArr[2] = "";
                    strArr[3] = String.valueOf(start + 1);
                    return strArr;
                }
            } else {
                if (Intrinsics.areEqual((Object)this.newText, (Object)"(") && this.getEditorConfig().getAutoCloseBrackets()) {
                    strArr = new String[4];
                    strArr[1] = ")";
                    strArr[3] = String.valueOf(start + 1);
                    return strArr;
                }
                if (Intrinsics.areEqual((Object)this.newText, (Object)")") && this.getEditorConfig().getAutoCloseBrackets()) {
                    if (start + 1 < this.getText().length() && this.getText().charAt(start + 1) == ')') {
                        strArr = new String[4];
                        strArr[2] = "";
                        strArr[3] = String.valueOf(start + 1);
                        return strArr;
                    }
                } else {
                    if (Intrinsics.areEqual((Object)this.newText, (Object)"[") && this.getEditorConfig().getAutoCloseBrackets()) {
                        strArr = new String[4];
                        strArr[1] = "]";
                        strArr[3] = String.valueOf(start + 1);
                        return strArr;
                    }
                    if (Intrinsics.areEqual((Object)this.newText, (Object)"]") && this.getEditorConfig().getAutoCloseBrackets() && start + 1 < this.getText().length() && this.getText().charAt(start + 1) == ']') {
                        strArr = new String[4];
                        strArr[2] = "";
                        strArr[3] = String.valueOf(start + 1);
                        return strArr;
                    }
                }
            }
        }
        return new String[4];
    }

    private final String getIndentationForOffset(int offset) {
        return this.getIndentationForLine(this.getLines().getLineForIndex(offset));
    }

    private final String getIndentationForLine(int line) {
        char c;
        int start;
        LinesCollection.Line realLine = this.getLines().getLine(line);
        int i = start = realLine.getStart();
        while (i < this.getText().length() && CharsKt.isWhitespace((char)(c = this.getText().charAt(i))) && c != '\n') {
            int n = i;
            i = n + 1;
        }
        return ((Object)this.getText().subSequence(start, i)).toString();
    }

    @JvmOverloads
    public AutoIndentEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public AutoIndentEditText(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void completeIndentation$lambda-0(AutoIndentEditText this$0, int $start, int $count, String $replacementValue, int $newCursorPosition) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$replacementValue, (String)"$replacementValue");
        this$0.isAutoIndenting = true;
        this$0.getText().replace($start, $start + $count, (CharSequence)$replacementValue);
        this$0.getUndoStack().pop();
        TextChange change = this$0.getUndoStack().pop();
        if (!Intrinsics.areEqual((Object)$replacementValue, (Object)"")) {
            change.setNewText($replacementValue);
            this$0.getUndoStack().push(change);
        }
        this$0.setSelection($newCursorPosition);
        OnUndoRedoChangedListener onUndoRedoChangedListener = this$0.getOnUndoRedoChangedListener();
        if (onUndoRedoChangedListener != null) {
            onUndoRedoChangedListener.onUndoRedoChanged();
        }
        this$0.isAutoIndenting = false;
    }
}

