/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit.internal;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.widget.ListAdapter;
import androidx.core.text.PrecomputedTextCompat;
import com.blacksquircle.ui.editorkit.R;
import com.blacksquircle.ui.editorkit.adapter.SuggestionAdapter;
import com.blacksquircle.ui.editorkit.internal.AutoIndentEditText;
import com.blacksquircle.ui.editorkit.utils.SymbolsTokenizer;
import com.blacksquircle.ui.language.base.Language;
import com.blacksquircle.ui.language.base.provider.SuggestionProvider;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\r\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0016J*\u0010\u0016\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0007H\u0016J\b\u0010\u001c\u001a\u00020\u0007H\u0002J\u0018\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\b\u0010 \u001a\u00020\u0010H\u0002J(\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0007H\u0014J\u0010\u0010&\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J \u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0018H\u0016J\u0010\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u0010H\u0016R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006/"}, d2={"Lcom/blacksquircle/ui/editorkit/internal/CodeSuggestsEditText;", "Lcom/blacksquircle/ui/editorkit/internal/AutoIndentEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "suggestionAdapter", "Lcom/blacksquircle/ui/editorkit/adapter/SuggestionAdapter;", "getSuggestionAdapter", "()Lcom/blacksquircle/ui/editorkit/adapter/SuggestionAdapter;", "setSuggestionAdapter", "(Lcom/blacksquircle/ui/editorkit/adapter/SuggestionAdapter;)V", "addLine", "", "lineNumber", "lineStart", "lineLength", "colorize", "configure", "doOnTextChanged", "text", "", "start", "before", "count", "getVisibleHeight", "onDropDownSizeChange", "width", "height", "onPopupChangePosition", "onSizeChanged", "w", "h", "oldw", "oldh", "removeLine", "replaceText", "newStart", "newEnd", "newText", "setTextContent", "textParams", "Landroidx/core/text/PrecomputedTextCompat;", "showDropDown", "editorkit_release"})
public abstract class CodeSuggestsEditText
extends AutoIndentEditText {
    @Nullable
    private SuggestionAdapter suggestionAdapter;

    @JvmOverloads
    public CodeSuggestsEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
    }

    public /* synthetic */ CodeSuggestsEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.autoCompleteTextViewStyle;
        }
        this(context, attributeSet, n);
    }

    @Nullable
    public final SuggestionAdapter getSuggestionAdapter() {
        return this.suggestionAdapter;
    }

    public final void setSuggestionAdapter(@Nullable SuggestionAdapter suggestionAdapter) {
        this.suggestionAdapter = suggestionAdapter;
    }

    public void showDropDown() {
        if (!this.isPopupShowing() && this.hasFocus()) {
            super.showDropDown();
        }
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.getEditorConfig().getCodeCompletion()) {
            this.onDropDownSizeChange(w, h);
        }
    }

    @Override
    public void doOnTextChanged(@Nullable CharSequence text, int start, int before, int count) {
        super.doOnTextChanged(text, start, before, count);
        if (this.getEditorConfig().getCodeCompletion()) {
            this.onPopupChangePosition();
        }
    }

    @Override
    public void configure() {
        super.configure();
        if (this.getEditorConfig().getCodeCompletion()) {
            this.setAdapter((ListAdapter)this.suggestionAdapter);
            this.setTokenizer(new SymbolsTokenizer());
        } else {
            this.setTokenizer(null);
        }
    }

    @Override
    public void colorize() {
        SuggestionAdapter suggestionAdapter = this.suggestionAdapter;
        if (suggestionAdapter != null) {
            suggestionAdapter.setColorScheme(this.getColorScheme());
        }
        super.colorize();
    }

    @Override
    public void setTextContent(@NotNull PrecomputedTextCompat textParams) {
        SuggestionProvider suggestionProvider;
        Intrinsics.checkNotNullParameter((Object)textParams, (String)"textParams");
        Language language = this.getLanguage();
        if (language != null && (suggestionProvider = language.getProvider()) != null) {
            suggestionProvider.clearLines();
        }
        super.setTextContent(textParams);
        language = this.getLanguage();
        if (language != null) {
            suggestionProvider = language;
            boolean bl = false;
            boolean bl2 = false;
            SuggestionProvider it = suggestionProvider;
            boolean bl3 = false;
            SuggestionAdapter suggestionAdapter = this.getSuggestionAdapter();
            if (suggestionAdapter != null) {
                suggestionAdapter.setSuggestionProvider(it.getProvider());
            }
        }
    }

    @Override
    public void addLine(int lineNumber, int lineStart, int lineLength) {
        SuggestionProvider suggestionProvider;
        super.addLine(lineNumber, lineStart, lineLength);
        Language language = this.getLanguage();
        if (language != null && (suggestionProvider = language.getProvider()) != null) {
            Object object = this.getText();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"text");
            object = (CharSequence)object;
            int n = lineStart + lineLength;
            boolean bl = false;
            suggestionProvider.processLine(lineNumber, ((Object)object.subSequence(lineStart, n)).toString());
        }
    }

    @Override
    public void removeLine(int lineNumber) {
        SuggestionProvider suggestionProvider;
        Language language = this.getLanguage();
        if (language != null && (suggestionProvider = language.getProvider()) != null) {
            suggestionProvider.deleteLine(this.getLines().getIndexForLine(lineNumber));
        }
        super.removeLine(lineNumber);
    }

    @Override
    public void replaceText(int newStart, int newEnd, @NotNull CharSequence newText) {
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        super.replaceText(newStart, newEnd, newText);
        int startLine = this.getLines().getLineForIndex(newStart);
        int endLine = this.getLines().getLineForIndex(newText.length() + newStart);
        int n = startLine;
        if (n <= endLine) {
            int currentLine;
            do {
                SuggestionProvider suggestionProvider;
                Language language;
                int lineEnd;
                int lineStart;
                if ((lineStart = this.getIndexForStartOfLine(currentLine = n++)) > (lineEnd = this.getIndexForEndOfLine(currentLine)) || lineEnd > this.getText().length() || (language = this.getLanguage()) == null || (suggestionProvider = language.getProvider()) == null) continue;
                Object object = this.getText();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"text");
                object = (CharSequence)object;
                boolean bl = false;
                suggestionProvider.processLine(currentLine, ((Object)object.subSequence(lineStart, lineEnd)).toString());
            } while (currentLine != endLine);
        }
    }

    private final void onDropDownSizeChange(int width, int height) {
        this.setDropDownWidth(width * 1 / 2);
        this.setDropDownHeight(height * 1 / 2);
        this.onPopupChangePosition();
    }

    private final void onPopupChangePosition() {
        if (this.getLayout() != null) {
            int line = this.getLayout().getLineForOffset(this.getSelectionStart());
            float x = this.getLayout().getPrimaryHorizontal(this.getSelectionStart());
            int y = this.getLayout().getLineBaseline(line);
            float offsetHorizontal = x + (float)this.getPaddingStart();
            this.setDropDownHorizontalOffset((int)offsetHorizontal);
            int offsetVertical = y - this.getScrollY();
            int temp = offsetVertical + this.getDropDownHeight();
            this.setDropDownVerticalOffset(temp < this.getVisibleHeight() ? offsetVertical : offsetVertical - this.getDropDownHeight());
        }
    }

    private final int getVisibleHeight() {
        Rect rect = new Rect();
        this.getWindowVisibleDisplayFrame(rect);
        return rect.bottom - rect.top;
    }

    @JvmOverloads
    public CodeSuggestsEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public CodeSuggestsEditText(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

