/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit.internal;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.core.text.PrecomputedTextCompat;
import androidx.core.widget.TextViewCompat;
import com.blacksquircle.ui.editorkit.R;
import com.blacksquircle.ui.editorkit.internal.LineNumbersEditText;
import com.blacksquircle.ui.editorkit.internal.ScalableEditText;
import com.blacksquircle.ui.editorkit.listener.OnTextChangedListener;
import com.blacksquircle.ui.editorkit.model.ColorScheme;
import com.blacksquircle.ui.editorkit.theme.EditorTheme;
import com.blacksquircle.ui.editorkit.utils.ExtensionsKt;
import com.blacksquircle.ui.editorkit.utils.LinesCollection;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u007f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\r\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001&\b&\u0018\u00002\u00020\u00012\u00020\u0002B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\bH\u0016J\b\u0010-\u001a\u00020)H\u0016J\b\u0010.\u001a\u00020)H\u0016J\u0012\u0010/\u001a\u00020)2\b\u00100\u001a\u0004\u0018\u00010\u001eH\u0016J*\u00101\u001a\u00020)2\b\u00100\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00020\bH\u0016J*\u00106\u001a\u00020)2\b\u00100\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\b2\u0006\u00107\u001a\u00020\b2\u0006\u00104\u001a\u00020\bH\u0016J\u0006\u00108\u001a\u00020\bJ\u000e\u00109\u001a\u00020\b2\u0006\u0010*\u001a\u00020\bJ\u000e\u0010:\u001a\u00020\b2\u0006\u0010*\u001a\u00020\bJ\u0006\u0010;\u001a\u00020\bJ\u0012\u0010<\u001a\u00020)2\b\u0010=\u001a\u0004\u0018\u00010>H\u0014J\u0010\u0010?\u001a\u00020)2\u0006\u0010*\u001a\u00020\bH\u0016J \u0010@\u001a\u00020)2\u0006\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020\b2\u0006\u0010C\u001a\u000202H\u0016J\u0010\u0010D\u001a\u00020)2\u0006\u0010E\u001a\u00020FH\u0016J\u000e\u0010D\u001a\u00020)2\u0006\u00100\u001a\u000202J\u0010\u0010G\u001a\u00020)2\u0006\u0010H\u001a\u00020IH\u0016J\u0012\u0010J\u001a\u00020)2\b\u0010K\u001a\u0004\u0018\u00010LH\u0016J\b\u0010M\u001a\u00020)H\u0002R$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u00020&X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010'\u00a8\u0006N"}, d2={"Lcom/blacksquircle/ui/editorkit/internal/LineNumbersEditText;", "Lcom/blacksquircle/ui/editorkit/internal/ScalableEditText;", "Lcom/blacksquircle/ui/editorkit/listener/OnTextChangedListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "value", "Lcom/blacksquircle/ui/editorkit/model/ColorScheme;", "colorScheme", "getColorScheme", "()Lcom/blacksquircle/ui/editorkit/model/ColorScheme;", "setColorScheme", "(Lcom/blacksquircle/ui/editorkit/model/ColorScheme;)V", "gutterCurrentLineNumberPaint", "Landroid/graphics/Paint;", "gutterDigitCount", "gutterDividerPaint", "gutterMargin", "gutterPaint", "gutterTextPaint", "gutterWidth", "lines", "Lcom/blacksquircle/ui/editorkit/utils/LinesCollection;", "getLines", "()Lcom/blacksquircle/ui/editorkit/utils/LinesCollection;", "processedText", "Landroid/text/Editable;", "kotlin.jvm.PlatformType", "selectedLinePaint", "textChangeEnd", "textChangeStart", "textChangedNewText", "", "textWatcher", "com/blacksquircle/ui/editorkit/internal/LineNumbersEditText$textWatcher$1", "Lcom/blacksquircle/ui/editorkit/internal/LineNumbersEditText$textWatcher$1;", "addLine", "", "lineNumber", "lineStart", "lineLength", "clearText", "colorize", "doAfterTextChanged", "text", "doBeforeTextChanged", "", "start", "count", "after", "doOnTextChanged", "before", "getBottomVisibleLine", "getIndexForEndOfLine", "getIndexForStartOfLine", "getTopVisibleLine", "onDraw", "canvas", "Landroid/graphics/Canvas;", "removeLine", "replaceText", "newStart", "newEnd", "newText", "setTextContent", "textParams", "Landroidx/core/text/PrecomputedTextCompat;", "setTextSize", "size", "", "setTypeface", "tf", "Landroid/graphics/Typeface;", "updateGutter", "editorkit_release"})
public abstract class LineNumbersEditText
extends ScalableEditText
implements OnTextChangedListener {
    @NotNull
    private ColorScheme colorScheme;
    @NotNull
    private final LinesCollection lines;
    private final Editable processedText;
    @NotNull
    private final Paint selectedLinePaint;
    @NotNull
    private final Paint gutterPaint;
    @NotNull
    private final Paint gutterDividerPaint;
    @NotNull
    private final Paint gutterCurrentLineNumberPaint;
    @NotNull
    private final Paint gutterTextPaint;
    @NotNull
    private final textWatcher.1 textWatcher;
    private final int gutterMargin;
    private int gutterWidth;
    private int gutterDigitCount;
    private int textChangeStart;
    private int textChangeEnd;
    @NotNull
    private String textChangedNewText;

    @JvmOverloads
    public LineNumbersEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.colorScheme = EditorTheme.INSTANCE.getDARCULA();
        this.lines = new LinesCollection();
        this.processedText = Editable.Factory.getInstance().newEditable((CharSequence)"");
        this.selectedLinePaint = new Paint();
        this.gutterPaint = new Paint();
        this.gutterDividerPaint = new Paint();
        this.gutterCurrentLineNumberPaint = new Paint();
        this.gutterTextPaint = new Paint();
        this.textWatcher = new TextWatcher(this){
            final /* synthetic */ LineNumbersEditText this$0;
            {
                this.this$0 = $receiver;
            }

            public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
                this.this$0.doBeforeTextChanged(s, start, count, after);
            }

            public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
                this.this$0.doOnTextChanged(s, start, before, count);
            }

            public void afterTextChanged(@Nullable Editable s) {
                this.this$0.doAfterTextChanged(s);
            }
        };
        this.gutterMargin = ExtensionsKt.dpToPx(4);
        this.textChangedNewText = "";
        this.setGravity(0x800033);
    }

    public /* synthetic */ LineNumbersEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.autoCompleteTextViewStyle;
        }
        this(context, attributeSet, n);
    }

    @NotNull
    public final ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public final void setColorScheme(@NotNull ColorScheme value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.colorScheme = value;
        this.colorize();
    }

    @NotNull
    protected final LinesCollection getLines() {
        return this.lines;
    }

    protected void onDraw(@Nullable Canvas canvas) {
        if (this.getLayout() != null) {
            int currentLineStart = this.lines.getLineForIndex(this.getSelectionStart());
            if (this.getEditorConfig().getHighlightCurrentLine() && currentLineStart == this.lines.getLineForIndex(this.getSelectionEnd())) {
                int selectedLineStartIndex = this.getIndexForStartOfLine(currentLineStart);
                int selectedLineEndIndex = this.getIndexForEndOfLine(currentLineStart);
                int topVisualLine = this.getLayout().getLineForOffset(selectedLineStartIndex);
                int bottomVisualLine = this.getLayout().getLineForOffset(selectedLineEndIndex);
                int lineTop = this.getLayout().getLineTop(topVisualLine) + this.getPaddingTop();
                int lineBottom = this.getLayout().getLineBottom(bottomVisualLine) + this.getPaddingTop();
                int width = this.getLayout().getWidth() + this.getPaddingLeft() + this.getPaddingRight();
                Canvas canvas2 = canvas;
                if (canvas2 != null) {
                    canvas2.drawRect((float)this.gutterWidth, (float)lineTop, (float)width, (float)lineBottom, this.selectedLinePaint);
                }
            }
            this.updateGutter();
            super.onDraw(canvas);
            if (this.getEditorConfig().getLineNumbers()) {
                Canvas selectedLineStartIndex = canvas;
                if (selectedLineStartIndex != null) {
                    selectedLineStartIndex.drawRect((float)this.getScrollX(), (float)this.getScrollY(), (float)(this.gutterWidth + this.getScrollX()), (float)(this.getScrollY() + this.getHeight()), this.gutterPaint);
                }
                int bottomVisibleLine = this.getBottomVisibleLine();
                int topVisibleLine = this.getTopVisibleLine();
                topVisibleLine = topVisibleLine >= 2 ? (topVisibleLine -= 2) : 0;
                int prevLineNumber = -1;
                int textRight = this.gutterWidth - this.gutterMargin / 2 + this.getScrollX();
                while (topVisibleLine <= bottomVisibleLine) {
                    Canvas canvas3;
                    int number = this.lines.getLineForIndex(this.getLayout().getLineStart(topVisibleLine));
                    if (number != prevLineNumber && (canvas3 = canvas) != null) {
                        canvas3.drawText(String.valueOf(number + 1), (float)textRight, (float)(this.getLayout().getLineBaseline(topVisibleLine) + this.getPaddingTop()), number == currentLineStart && this.getEditorConfig().getHighlightCurrentLine() ? this.gutterCurrentLineNumberPaint : this.gutterTextPaint);
                    }
                    prevLineNumber = number;
                    int n = topVisibleLine;
                    topVisibleLine = n + 1;
                }
                Canvas canvas4 = canvas;
                if (canvas4 != null) {
                    canvas4.drawLine((float)(this.gutterWidth + this.getScrollX()), (float)this.getScrollY(), (float)(this.gutterWidth + this.getScrollX()), (float)(this.getScrollY() + this.getHeight()), this.gutterDividerPaint);
                }
            }
        }
    }

    public void setTextSize(float size) {
        super.setTextSize(size);
        this.post(() -> LineNumbersEditText.setTextSize$lambda-0(this));
    }

    public void setTypeface(@Nullable Typeface tf) {
        super.setTypeface(tf);
        this.post(() -> LineNumbersEditText.setTypeface$lambda-1(this, tf));
    }

    @Override
    public void doBeforeTextChanged(@Nullable CharSequence text, int start, int count, int after) {
        this.textChangeStart = start;
        this.textChangeEnd = start + count;
    }

    @Override
    public void doOnTextChanged(@Nullable CharSequence text, int start, int before, int count) {
        CharSequence charSequence = text;
        this.textChangedNewText = String.valueOf(charSequence == null ? null : charSequence.subSequence(start, start + count));
        this.replaceText(this.textChangeStart, this.textChangeEnd, this.textChangedNewText);
    }

    @Override
    public void doAfterTextChanged(@Nullable Editable text) {
        this.updateGutter();
    }

    public void colorize() {
        this.setTextColor(this.colorScheme.getTextColor());
        this.setBackgroundColor(this.colorScheme.getBackgroundColor());
        this.setHighlightColor(this.colorScheme.getSelectionColor());
        this.selectedLinePaint.setColor(this.colorScheme.getSelectedLineColor());
        this.selectedLinePaint.setAntiAlias(false);
        this.selectedLinePaint.setDither(false);
        this.gutterPaint.setColor(this.colorScheme.getGutterColor());
        this.gutterPaint.setAntiAlias(false);
        this.gutterPaint.setDither(false);
        this.gutterDividerPaint.setColor(this.colorScheme.getGutterDividerColor());
        this.gutterDividerPaint.setAntiAlias(false);
        this.gutterDividerPaint.setDither(false);
        this.gutterDividerPaint.setStyle(Paint.Style.STROKE);
        this.gutterDividerPaint.setStrokeWidth(2.6f);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        this.gutterCurrentLineNumberPaint.setTextSize(ExtensionsKt.getScaledDensity(context) * this.getEditorConfig().getFontSize());
        this.gutterCurrentLineNumberPaint.setColor(this.colorScheme.getGutterCurrentLineNumberColor());
        this.gutterCurrentLineNumberPaint.setAntiAlias(true);
        this.gutterCurrentLineNumberPaint.setDither(false);
        this.gutterCurrentLineNumberPaint.setTextAlign(Paint.Align.RIGHT);
        context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        this.gutterTextPaint.setTextSize(ExtensionsKt.getScaledDensity(context) * this.getEditorConfig().getFontSize());
        this.gutterTextPaint.setColor(this.colorScheme.getGutterTextColor());
        this.gutterTextPaint.setAntiAlias(true);
        this.gutterTextPaint.setDither(false);
        this.gutterTextPaint.setTextAlign(Paint.Align.RIGHT);
    }

    public void setTextContent(@NotNull PrecomputedTextCompat textParams) {
        Intrinsics.checkNotNullParameter((Object)textParams, (String)"textParams");
        this.abortFling();
        this.removeTextChangedListener(this.textWatcher);
        this.setText((CharSequence)textParams);
        this.processedText.clear();
        int n = this.processedText.length();
        String string = textParams.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"textParams.toString()");
        this.replaceText(0, n, string);
        this.lines.clear();
        int lineNumber = 0;
        int lineStart = 0;
        Editable editable = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)editable, (String)"text");
        Iterable $this$forEach$iv = StringsKt.lines((CharSequence)((CharSequence)editable));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            this.addLine(lineNumber, lineStart, line.length());
            lineStart += line.length() + 1;
            int n2 = lineNumber;
            lineNumber = n2 + 1;
        }
        this.lines.add(lineNumber, lineStart);
        this.addTextChangedListener(this.textWatcher);
    }

    public void clearText() {
        this.setTextContent("");
    }

    public void replaceText(int newStart, int newEnd, @NotNull CharSequence newText) {
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        int start = newStart < 0 ? 0 : newStart;
        int end = newEnd >= this.processedText.length() ? this.processedText.length() : newEnd;
        int newCharCount = newText.length() - (end - start);
        int startLine = this.lines.getLineForIndex(start);
        int n = start;
        if (n < end) {
            do {
                int i;
                if (this.processedText.charAt(i = n++) != '\n') continue;
                this.removeLine(startLine + 1);
            } while (n < end);
        }
        this.lines.shiftIndexes(this.lines.getLineForIndex(start) + 1, newCharCount);
        n = 0;
        int n2 = newText.length() + -1;
        if (n <= n2) {
            do {
                int i;
                if (newText.charAt(i = n++) != '\n') continue;
                this.lines.add(this.lines.getLineForIndex(start + i) + 1, start + i + 1);
            } while (n <= n2);
        }
        this.processedText.replace(start, end, newText);
    }

    public void addLine(int lineNumber, int lineStart, int lineLength) {
        this.lines.add(lineNumber, lineStart);
    }

    public void removeLine(int lineNumber) {
        this.lines.remove(lineNumber);
    }

    public final void setTextContent(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        PrecomputedTextCompat.Params params = TextViewCompat.getTextMetricsParams((TextView)((TextView)this));
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"getTextMetricsParams(this)");
        PrecomputedTextCompat.Params textParams = params;
        PrecomputedTextCompat precomputedText = PrecomputedTextCompat.create((CharSequence)text, (PrecomputedTextCompat.Params)textParams);
        Intrinsics.checkNotNullExpressionValue((Object)precomputedText, (String)"precomputedText");
        this.setTextContent(precomputedText);
    }

    public final int getIndexForStartOfLine(int lineNumber) {
        return this.lines.getIndexForLine(lineNumber);
    }

    public final int getIndexForEndOfLine(int lineNumber) {
        return lineNumber == this.getLineCount() - 1 ? this.processedText.length() : this.lines.getIndexForLine(lineNumber + 1) - 1;
    }

    public final int getTopVisibleLine() {
        if (this.getLineHeight() == 0) {
            return 0;
        }
        int line = this.getLayout().getLineForVertical(this.getScrollY());
        if (line < 0) {
            return 0;
        }
        return line >= this.getLineCount() ? this.getLineCount() - 1 : line;
    }

    public final int getBottomVisibleLine() {
        if (this.getLineHeight() == 0) {
            return 0;
        }
        int line = this.getLayout().getLineForVertical(this.getScrollY() + this.getHeight());
        if (line < 0) {
            return 0;
        }
        return line >= this.getLineCount() ? this.getLineCount() - 1 : line;
    }

    private final void updateGutter() {
        if (this.getEditorConfig().getLineNumbers()) {
            int count = 3;
            int widestNumber = 0;
            float widestWidth = 0.0f;
            this.gutterDigitCount = String.valueOf(this.lines.getLineCount()).length();
            int n = 0;
            do {
                int i = n++;
                float width = this.getPaint().measureText(String.valueOf(i));
                if (!(width > widestWidth)) continue;
                widestNumber = i;
                widestWidth = width;
            } while (n <= 9);
            if (this.gutterDigitCount >= count) {
                count = this.gutterDigitCount;
            }
            StringBuilder builder = new StringBuilder();
            int n2 = 0;
            if (n2 < count) {
                do {
                    int i = n2++;
                    builder.append(String.valueOf(widestNumber));
                } while (n2 < count);
            }
            this.gutterWidth = (int)this.getPaint().measureText(builder.toString());
            LineNumbersEditText lineNumbersEditText = this;
            lineNumbersEditText.gutterWidth += this.gutterMargin;
        }
        if (this.getPaddingStart() != this.gutterWidth + this.gutterMargin) {
            this.setPadding(this.gutterWidth + this.gutterMargin, this.gutterMargin, this.getPaddingEnd(), this.getPaddingBottom());
        }
    }

    @JvmOverloads
    public LineNumbersEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public LineNumbersEditText(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void setTextSize$lambda-0(LineNumbersEditText this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.gutterCurrentLineNumberPaint.setTextSize(this$0.getTextSize());
        this$0.gutterTextPaint.setTextSize(this$0.getTextSize());
    }

    private static final void setTypeface$lambda-1(LineNumbersEditText this$0, Typeface $tf) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.gutterCurrentLineNumberPaint.setTypeface($tf);
        this$0.gutterTextPaint.setTypeface($tf);
    }
}

