/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit.internal;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import android.widget.Scroller;
import com.blacksquircle.ui.editorkit.R;
import com.blacksquircle.ui.editorkit.internal.ConfigurableEditText;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001&B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\rJ\b\u0010\u0016\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J(\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0014J(\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007H\u0014J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0017R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/blacksquircle/ui/editorkit/internal/ScrollableEditText;", "Lcom/blacksquircle/ui/editorkit/internal/ConfigurableEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "maximumVelocity", "", "scrollListeners", "", "Lcom/blacksquircle/ui/editorkit/internal/ScrollableEditText$OnScrollChangedListener;", "textScroller", "Landroid/widget/Scroller;", "velocityTracker", "Landroid/view/VelocityTracker;", "abortFling", "", "addOnScrollChangedListener", "listener", "computeScroll", "configure", "onScrollChanged", "horiz", "vert", "oldHoriz", "oldVert", "onSizeChanged", "w", "h", "oldw", "oldh", "onTouchEvent", "", "event", "Landroid/view/MotionEvent;", "OnScrollChangedListener", "editorkit_release"})
public abstract class ScrollableEditText
extends ConfigurableEditText {
    @NotNull
    private final Scroller textScroller;
    @NotNull
    private final List<OnScrollChangedListener> scrollListeners;
    private final float maximumVelocity;
    @Nullable
    private VelocityTracker velocityTracker;

    @JvmOverloads
    public ScrollableEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.textScroller = new Scroller(context);
        boolean bl = false;
        this.scrollListeners = new ArrayList();
        this.maximumVelocity = (float)ViewConfiguration.get((Context)context).getScaledMaximumFlingVelocity() * 100.0f;
    }

    public /* synthetic */ ScrollableEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.autoCompleteTextViewStyle;
        }
        this(context, attributeSet, n);
    }

    @Override
    public void configure() {
        this.setImeOptions(this.getEditorConfig().getSoftKeyboard() ? 0 : 0x10000000);
        this.setInputType(655361);
        this.setTextSize(this.getEditorConfig().getFontSize());
        this.setTypeface(this.getEditorConfig().getFontType());
        this.setHorizontallyScrolling(!this.getEditorConfig().getWordWrap());
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        for (OnScrollChangedListener listener : this.scrollListeners) {
            listener.onScrollChanged(this.getScrollX(), this.getScrollY(), this.getScrollX(), this.getScrollY());
        }
    }

    /*
     * Unable to fully structure code
     */
    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        var2_2 = event.getAction();
        switch (var2_2) {
            case 0: {
                this.abortFling();
                var3_3 = this.velocityTracker;
                if (var3_3 != null) {
                    var3_3.clear();
                }
                if (this.velocityTracker != null) break;
                this.velocityTracker = VelocityTracker.obtain();
                break;
            }
            case 1: {
                var3_4 = this.velocityTracker;
                if (var3_4 != null) {
                    var3_4.computeCurrentVelocity(1000, this.maximumVelocity);
                }
                if (!this.getEditorConfig().getWordWrap()) {
                    var5_7 = this.velocityTracker;
                    v0 = var4_11 = var5_7 == null ? null : Float.valueOf(var5_7.getXVelocity());
                    v1 = var4_11 == null ? 0 : (var5_8 = (int)var4_11.floatValue());
                } else {
                    v1 = 0;
                }
                velocityX = v1;
                var6_13 = this.velocityTracker;
                var5_7 = var6_13 == null ? null : Float.valueOf(var6_13.getYVelocity());
                velocityY = var5_7 == null ? 0 : (var6_14 = (int)var5_7.floatValue());
                var5_9 = false;
                if (Math.abs(velocityY) < 0) ** GOTO lbl30
                var5_9 = false;
                if (Math.abs(velocityX) >= 0) ** GOTO lbl33
lbl30:
                // 2 sources

                if ((var5_10 = this.velocityTracker) != null) {
                    var5_10.recycle();
                }
                this.velocityTracker = null;
lbl33:
                // 2 sources

                if (this.getLayout() == null) break;
                this.textScroller.fling(this.getScrollX(), this.getScrollY(), -velocityX, -velocityY, 0, this.getLayout().getWidth() - this.getWidth() + this.getPaddingStart() + this.getPaddingEnd(), 0, this.getLayout().getHeight() - this.getHeight() + this.getPaddingTop() + this.getPaddingBottom());
                break;
            }
            case 2: {
                var3_6 = this.velocityTracker;
                if (var3_6 == null) break;
                var3_6.addMovement(event);
            }
        }
        return super.onTouchEvent(event);
    }

    protected void onScrollChanged(int horiz, int vert, int oldHoriz, int oldVert) {
        super.onScrollChanged(horiz, vert, oldHoriz, oldVert);
        for (OnScrollChangedListener listener : this.scrollListeners) {
            listener.onScrollChanged(horiz, vert, oldHoriz, oldVert);
        }
    }

    public void computeScroll() {
        if (!this.isInEditMode() && this.textScroller.computeScrollOffset()) {
            this.scrollTo(this.textScroller.getCurrX(), this.textScroller.getCurrY());
            this.postInvalidate();
        }
    }

    public final void addOnScrollChangedListener(@NotNull OnScrollChangedListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.scrollListeners.add(listener);
    }

    public final void abortFling() {
        if (!this.textScroller.isFinished()) {
            this.textScroller.abortAnimation();
        }
    }

    @JvmOverloads
    public ScrollableEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ScrollableEditText(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H&\u00a8\u0006\t"}, d2={"Lcom/blacksquircle/ui/editorkit/internal/ScrollableEditText$OnScrollChangedListener;", "", "onScrollChanged", "", "x", "", "y", "oldX", "oldY", "editorkit_release"})
    public static interface OnScrollChangedListener {
        public void onScrollChanged(int var1, int var2, int var3, int var4);
    }
}

