/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit.internal;

import android.content.Context;
import android.text.Editable;
import android.text.Spanned;
import android.text.style.BackgroundColorSpan;
import android.util.AttributeSet;
import androidx.core.text.PrecomputedTextCompat;
import com.blacksquircle.ui.editorkit.R;
import com.blacksquircle.ui.editorkit.internal.UndoRedoEditText;
import com.blacksquircle.ui.editorkit.model.FindParams;
import com.blacksquircle.ui.editorkit.span.ErrorSpan;
import com.blacksquircle.ui.editorkit.span.FindResultSpan;
import com.blacksquircle.ui.editorkit.span.TabWidthSpan;
import com.blacksquircle.ui.language.base.Language;
import com.blacksquircle.ui.language.base.span.StyleSpan;
import com.blacksquircle.ui.language.base.span.SyntaxHighlightSpan;
import com.blacksquircle.ui.language.base.styler.LanguageStyler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020\u0007H\u0002J\u0006\u0010$\u001a\u00020!J\b\u0010%\u001a\u00020!H\u0016J\u0012\u0010&\u001a\u00020!2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J*\u0010)\u001a\u00020!2\b\u0010'\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u0007H\u0016J*\u0010.\u001a\u00020!2\b\u0010'\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010/\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u0007H\u0016J\u0016\u00100\u001a\u00020!2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204J\u0006\u00105\u001a\u00020!J\u0006\u00106\u001a\u00020!J(\u00107\u001a\u00020!2\u0006\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020\u00072\u0006\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u0007H\u0014J\u0018\u0010<\u001a\u00020!2\u0006\u0010=\u001a\u00020\u00072\u0006\u0010>\u001a\u00020\u0007H\u0014J(\u0010?\u001a\u00020!2\u0006\u0010@\u001a\u00020\u00072\u0006\u0010A\u001a\u00020\u00072\u0006\u0010B\u001a\u00020\u00072\u0006\u0010C\u001a\u00020\u0007H\u0014J\u000e\u0010D\u001a\u00020!2\u0006\u0010E\u001a\u000202J\u000e\u0010F\u001a\u00020!2\u0006\u0010E\u001a\u000202J\b\u0010G\u001a\u00020!H\u0002J\b\u0010H\u001a\u00020!H\u0002J\u000e\u0010I\u001a\u00020!2\u0006\u0010J\u001a\u00020\u0007J\u0010\u0010K\u001a\u00020!2\u0006\u0010L\u001a\u00020MH\u0016J\u0018\u0010N\u001a\u00020!2\u0006\u0010O\u001a\u00020\u00072\u0006\u0010P\u001a\u00020\u0007H\u0002J\u0018\u0010Q\u001a\u00020!2\u0006\u0010R\u001a\u00020\u00072\u0006\u0010S\u001a\u00020\u0007H\u0002J\b\u0010T\u001a\u00020!H\u0002J\b\u0010U\u001a\u00020!H\u0002R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/blacksquircle/ui/editorkit/internal/SyntaxHighlightEditText;", "Lcom/blacksquircle/ui/editorkit/internal/UndoRedoEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "addedTextCount", "closedDelimiterSpan", "Landroid/text/style/BackgroundColorSpan;", "delimiters", "", "findResultSpans", "", "Lcom/blacksquircle/ui/editorkit/span/FindResultSpan;", "findResultStyleSpan", "Lcom/blacksquircle/ui/language/base/span/StyleSpan;", "isErrorSpansVisible", "", "isSyntaxHighlighting", "language", "Lcom/blacksquircle/ui/language/base/Language;", "getLanguage", "()Lcom/blacksquircle/ui/language/base/Language;", "setLanguage", "(Lcom/blacksquircle/ui/language/base/Language;)V", "openDelimiterSpan", "selectedFindResult", "syntaxHighlightSpans", "Lcom/blacksquircle/ui/language/base/span/SyntaxHighlightSpan;", "cancelSyntaxHighlighting", "", "checkMatchingBracket", "pos", "clearFindResultSpans", "colorize", "doAfterTextChanged", "text", "Landroid/text/Editable;", "doBeforeTextChanged", "", "start", "count", "after", "doOnTextChanged", "before", "find", "findText", "", "findParams", "Lcom/blacksquircle/ui/editorkit/model/FindParams;", "findNext", "findPrevious", "onScrollChanged", "horiz", "vert", "oldHoriz", "oldVert", "onSelectionChanged", "selStart", "selEnd", "onSizeChanged", "w", "h", "oldw", "oldh", "replaceAllFindResults", "replaceText", "replaceFindResult", "scrollToFindResult", "selectResult", "setErrorLine", "lineNumber", "setTextContent", "textParams", "Landroidx/core/text/PrecomputedTextCompat;", "shiftSpans", "from", "byHowMuch", "showBracket", "i", "j", "syntaxHighlight", "updateSyntaxHighlighting", "editorkit_release"})
public abstract class SyntaxHighlightEditText
extends UndoRedoEditText {
    @Nullable
    private Language language;
    @NotNull
    private final List<SyntaxHighlightSpan> syntaxHighlightSpans;
    @NotNull
    private final List<FindResultSpan> findResultSpans;
    @NotNull
    private final char[] delimiters;
    @Nullable
    private StyleSpan findResultStyleSpan;
    @Nullable
    private BackgroundColorSpan openDelimiterSpan;
    @Nullable
    private BackgroundColorSpan closedDelimiterSpan;
    private int addedTextCount;
    private int selectedFindResult;
    private boolean isSyntaxHighlighting;
    private boolean isErrorSpansVisible;

    @JvmOverloads
    public SyntaxHighlightEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        boolean bl = false;
        this.syntaxHighlightSpans = new ArrayList();
        bl = false;
        this.findResultSpans = new ArrayList();
        char[] cArray = new char[]{'{', '[', '(', '}', ']', ')'};
        this.delimiters = cArray;
    }

    public /* synthetic */ SyntaxHighlightEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.autoCompleteTextViewStyle;
        }
        this(context, attributeSet, n);
    }

    @Nullable
    public final Language getLanguage() {
        return this.language;
    }

    public final void setLanguage(@Nullable Language language) {
        this.language = language;
    }

    @Override
    public void colorize() {
        this.findResultStyleSpan = new StyleSpan(this.getColorScheme().getFindResultBackgroundColor(), false, false, false, false, 30, null);
        this.openDelimiterSpan = new BackgroundColorSpan(this.getColorScheme().getDelimiterBackgroundColor());
        this.closedDelimiterSpan = new BackgroundColorSpan(this.getColorScheme().getDelimiterBackgroundColor());
        super.colorize();
    }

    @Override
    public void setTextContent(@NotNull PrecomputedTextCompat textParams) {
        Intrinsics.checkNotNullParameter((Object)textParams, (String)"textParams");
        this.syntaxHighlightSpans.clear();
        this.findResultSpans.clear();
        super.setTextContent(textParams);
        this.syntaxHighlight();
    }

    protected void onSelectionChanged(int selStart, int selEnd) {
        super.onSelectionChanged(selStart, selEnd);
        if (selStart == selEnd) {
            this.checkMatchingBracket(selStart);
        }
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.updateSyntaxHighlighting();
        super.onSizeChanged(w, h, oldw, oldh);
    }

    @Override
    protected void onScrollChanged(int horiz, int vert, int oldHoriz, int oldVert) {
        super.onScrollChanged(horiz, vert, oldHoriz, oldVert);
        this.updateSyntaxHighlighting();
    }

    @Override
    public void doBeforeTextChanged(@Nullable CharSequence text, int start, int count, int after) {
        SyntaxHighlightEditText syntaxHighlightEditText = this;
        syntaxHighlightEditText.addedTextCount -= count;
        this.cancelSyntaxHighlighting();
        if (!this.isSyntaxHighlighting) {
            super.doBeforeTextChanged(text, start, count, after);
        }
        this.abortFling();
    }

    @Override
    public void doOnTextChanged(@Nullable CharSequence text, int start, int before, int count) {
        SyntaxHighlightEditText syntaxHighlightEditText = this;
        syntaxHighlightEditText.addedTextCount += count;
        if (!this.isSyntaxHighlighting) {
            super.doOnTextChanged(text, start, before, count);
        }
    }

    @Override
    public void doAfterTextChanged(@Nullable Editable text) {
        super.doAfterTextChanged(text);
        if (!this.isSyntaxHighlighting) {
            this.shiftSpans(this.getSelectionStart(), this.addedTextCount);
        }
        this.addedTextCount = 0;
        this.syntaxHighlight();
    }

    /*
     * WARNING - void declaration
     */
    public final void clearFindResultSpans() {
        FindResultSpan[] spans;
        void start$iv;
        void $this$getSpans$iv;
        this.selectedFindResult = 0;
        this.findResultSpans.clear();
        FindResultSpan[] findResultSpanArray = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)findResultSpanArray, (String)"text");
        findResultSpanArray = (Spanned)findResultSpanArray;
        int n = 0;
        int end$iv = this.getText().length();
        boolean $i$f$getSpans = false;
        Object[] objectArray = $this$getSpans$iv.getSpans((int)start$iv, end$iv, FindResultSpan.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSpans(start, end, T::class.java)");
        for (FindResultSpan span : spans = (FindResultSpan[])objectArray) {
            this.getText().removeSpan((Object)span);
        }
    }

    public final void setErrorLine(int lineNumber) {
        if (lineNumber > 0) {
            int lineStart = this.getIndexForStartOfLine(lineNumber - 1);
            int lineEnd = this.getIndexForEndOfLine(lineNumber - 1);
            if (lineStart < this.getText().length() && lineEnd < this.getText().length() && lineStart > -1 && lineEnd > -1) {
                this.isErrorSpansVisible = true;
                this.getText().setSpan((Object)new ErrorSpan(0.0f, 0.0f, 0, 7, null), lineStart, lineEnd, 33);
            }
        }
    }

    public final void find(@NotNull String findText, @NotNull FindParams findParams) {
        Intrinsics.checkNotNullParameter((Object)findText, (String)"findText");
        Intrinsics.checkNotNullParameter((Object)findParams, (String)"findParams");
        CharSequence charSequence = findText;
        boolean bl = false;
        if (charSequence.length() > 0) {
            try {
                Object object;
                Pattern pattern = findParams.getRegex() ? (findParams.getMatchCase() ? Pattern.compile(findText) : Pattern.compile(findText, 66)) : (findParams.getWordsOnly() ? (findParams.getMatchCase() ? Pattern.compile("\\s" + findText + "\\s") : Pattern.compile("\\s" + Pattern.quote(findText) + "\\s", 66)) : (findParams.getMatchCase() ? Pattern.compile(Pattern.quote(findText)) : Pattern.compile(Pattern.quote(findText), 66)));
                Matcher matcher = pattern.matcher((CharSequence)this.getText());
                while (matcher.find()) {
                    object = this.findResultStyleSpan;
                    if (object == null) continue;
                    Object object2 = object;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Object it = object2;
                    boolean bl4 = false;
                    FindResultSpan findResultSpan = new FindResultSpan((StyleSpan)it, matcher.start(), matcher.end());
                    this.findResultSpans.add(findResultSpan);
                    this.getText().setSpan((Object)findResultSpan, findResultSpan.getStart(), findResultSpan.getEnd(), 33);
                }
                object = this.findResultSpans;
                boolean bl5 = false;
                if (!object.isEmpty()) {
                    this.selectResult();
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
    }

    public final void findNext() {
        if (this.selectedFindResult < this.findResultSpans.size() - 1) {
            SyntaxHighlightEditText syntaxHighlightEditText = this;
            ++syntaxHighlightEditText.selectedFindResult;
            this.selectResult();
        }
    }

    public final void findPrevious() {
        if (this.selectedFindResult > 0 && this.selectedFindResult < this.findResultSpans.size()) {
            SyntaxHighlightEditText syntaxHighlightEditText = this;
            --syntaxHighlightEditText.selectedFindResult;
            this.selectResult();
        }
    }

    public final void replaceFindResult(@NotNull String replaceText) {
        Intrinsics.checkNotNullParameter((Object)replaceText, (String)"replaceText");
        Collection collection = this.findResultSpans;
        boolean bl = false;
        if (!collection.isEmpty()) {
            FindResultSpan findResult = this.findResultSpans.get(this.selectedFindResult);
            this.getText().replace(findResult.getStart(), findResult.getEnd(), (CharSequence)replaceText);
            this.findResultSpans.remove((Object)findResult);
            if (this.selectedFindResult >= this.findResultSpans.size()) {
                SyntaxHighlightEditText syntaxHighlightEditText = this;
                int n = syntaxHighlightEditText.selectedFindResult;
                syntaxHighlightEditText.selectedFindResult = n + -1;
            }
        }
    }

    public final void replaceAllFindResults(@NotNull String replaceText) {
        Intrinsics.checkNotNullParameter((Object)replaceText, (String)"replaceText");
        Collection collection = this.findResultSpans;
        int n = 0;
        if (!collection.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder((CharSequence)this.getText());
            n = this.findResultSpans.size() - 1;
            if (0 <= n) {
                do {
                    int index = n--;
                    FindResultSpan findResultSpan = this.findResultSpans.get(index);
                    stringBuilder.replace(findResultSpan.getStart(), findResultSpan.getEnd(), replaceText);
                    this.findResultSpans.remove(index);
                } while (0 <= n);
            }
            this.setText(stringBuilder.toString());
        }
    }

    private final void selectResult() {
        FindResultSpan findResult = this.findResultSpans.get(this.selectedFindResult);
        this.setSelection(findResult.getStart(), findResult.getEnd());
        this.scrollToFindResult();
    }

    private final void scrollToFindResult() {
        if (this.selectedFindResult < this.findResultSpans.size()) {
            FindResultSpan findResult = this.findResultSpans.get(this.selectedFindResult);
            int topVisibleLine = this.getTopVisibleLine();
            int bottomVisibleLine = this.getBottomVisibleLine();
            if (findResult.getStart() >= this.getLayout().getLineStart(topVisibleLine) && findResult.getEnd() <= this.getLayout().getLineEnd(bottomVisibleLine)) {
                return;
            }
            int height = this.getLayout().getHeight() - this.getHeight() + this.getPaddingBottom() + this.getPaddingTop();
            int lineTop = this.getLayout().getLineTop(this.getLayout().getLineForOffset(findResult.getStart()));
            if (lineTop > height) {
                lineTop = height;
            }
            int scrollX = !this.getEditorConfig().getWordWrap() ? (int)this.getLayout().getPrimaryHorizontal(findResult.getStart()) : this.getScrollX();
            this.scrollTo(scrollX, lineTop);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void shiftSpans(int from, int byHowMuch) {
        Object object;
        for (SyntaxHighlightSpan span : this.syntaxHighlightSpans) {
            if (span.getStart() >= from) {
                object = span;
                object.setStart(object.getStart() + byHowMuch);
            }
            if (span.getEnd() < from) continue;
            object = span;
            object.setEnd(object.getEnd() + byHowMuch);
        }
        for (FindResultSpan findResult : this.findResultSpans) {
            if (findResult.getStart() > from) {
                object = findResult;
                ((FindResultSpan)((Object)object)).setStart(((FindResultSpan)((Object)object)).getStart() + byHowMuch);
            }
            if (findResult.getEnd() < from) continue;
            object = findResult;
            ((FindResultSpan)((Object)object)).setEnd(((FindResultSpan)((Object)object)).getEnd() + byHowMuch);
        }
        if (this.isErrorSpansVisible) {
            ErrorSpan[] spans;
            void start$iv;
            void $this$getSpans$iv;
            FindResultSpan findResult;
            findResult = this.getText();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)findResult), (String)"text");
            findResult = (Spanned)findResult;
            int n = 0;
            int end$iv = this.getText().length();
            boolean $i$f$getSpans = false;
            Object[] objectArray = $this$getSpans$iv.getSpans((int)start$iv, end$iv, ErrorSpan.class);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSpans(start, end, T::class.java)");
            for (ErrorSpan span : spans = (ErrorSpan[])objectArray) {
                this.getText().removeSpan((Object)span);
            }
            this.isErrorSpansVisible = false;
        }
    }

    private final void updateSyntaxHighlighting() {
        if (this.getLayout() != null) {
            boolean isInText;
            int start$iv;
            Object $this$getSpans$iv;
            boolean isInText2;
            int start$iv2;
            Object $this$getSpans$iv2;
            int topVisibleLine = this.getTopVisibleLine();
            int bottomVisibleLine = this.getBottomVisibleLine();
            int lineStart = this.getLayout().getLineStart(topVisibleLine);
            int lineEnd = this.getLayout().getLineEnd(bottomVisibleLine);
            this.isSyntaxHighlighting = true;
            Editable editable = this.getText();
            Intrinsics.checkNotNullExpressionValue((Object)editable, (String)"text");
            editable = (Spanned)editable;
            boolean bl = false;
            int end$iv = this.getText().length();
            boolean $i$f$getSpans = false;
            Object[] objectArray = $this$getSpans$iv2.getSpans(start$iv2, end$iv, SyntaxHighlightSpan.class);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSpans(start, end, T::class.java)");
            SyntaxHighlightSpan[] textSyntaxSpans = (SyntaxHighlightSpan[])objectArray;
            for (SyntaxHighlightSpan span : textSyntaxSpans) {
                this.getText().removeSpan((Object)span);
            }
            for (SyntaxHighlightSpan span : this.syntaxHighlightSpans) {
                boolean isVisible;
                isInText2 = span.getStart() >= 0 && span.getEnd() <= this.getText().length();
                boolean isValid = span.getStart() <= span.getEnd();
                int n = span.getStart();
                boolean bl2 = isVisible = (lineStart <= n ? n <= lineEnd : false) || span.getStart() <= lineEnd && span.getEnd() >= lineStart;
                if (!isInText2 || !isValid || !isVisible) continue;
                this.getText().setSpan((Object)span, span.getStart() < lineStart ? lineStart : span.getStart(), span.getEnd() > lineEnd ? lineEnd : span.getEnd(), 33);
            }
            this.isSyntaxHighlighting = false;
            Editable span = this.getText();
            Intrinsics.checkNotNullExpressionValue((Object)span, (String)"text");
            span = (Spanned)span;
            isInText2 = false;
            int end$iv2 = this.getText().length();
            boolean $i$f$getSpans2 = false;
            Object[] objectArray2 = $this$getSpans$iv.getSpans(start$iv, end$iv2, FindResultSpan.class);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"getSpans(start, end, T::class.java)");
            FindResultSpan[] textFindSpans = (FindResultSpan[])objectArray2;
            for (FindResultSpan span2 : textFindSpans) {
                this.getText().removeSpan((Object)span2);
            }
            for (FindResultSpan span3 : this.findResultSpans) {
                boolean isVisible;
                isInText = span3.getStart() >= 0 && span3.getEnd() <= this.getText().length();
                boolean isValid = span3.getStart() <= span3.getEnd();
                int n = span3.getStart();
                boolean bl3 = isVisible = (lineStart <= n ? n <= lineEnd : false) || span3.getStart() <= lineEnd && span3.getEnd() >= lineStart;
                if (!isInText || !isValid || !isVisible) continue;
                this.getText().setSpan((Object)span3, span3.getStart() < lineStart ? lineStart : span3.getStart(), span3.getEnd() > lineEnd ? lineEnd : span3.getEnd(), 33);
            }
            if (!this.getEditorConfig().getUseSpacesInsteadOfTabs()) {
                TabWidthSpan[] textTabSpans;
                int start$iv3;
                TabWidthSpan[] $this$getSpans$iv3;
                Editable span3 = this.getText();
                Intrinsics.checkNotNullExpressionValue((Object)span3, (String)"text");
                span3 = (Spanned)span3;
                isInText = false;
                int end$iv3 = this.getText().length();
                boolean $i$f$getSpans3 = false;
                Object[] objectArray3 = $this$getSpans$iv3.getSpans(start$iv3, end$iv3, TabWidthSpan.class);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"getSpans(start, end, T::class.java)");
                for (TabWidthSpan span4 : textTabSpans = (TabWidthSpan[])objectArray3) {
                    this.getText().removeSpan((Object)span4);
                }
                Pattern tabPattern = Pattern.compile("\t");
                Matcher matcher = tabPattern.matcher(this.getText().subSequence(lineStart, lineEnd));
                while (matcher.find()) {
                    int start = matcher.start() + lineStart;
                    int end = matcher.end() + lineStart;
                    if (start < 0 || end > this.getText().length()) continue;
                    this.getText().setSpan((Object)new TabWidthSpan(this.getEditorConfig().getTabWidth()), start, end, 18);
                }
            }
        }
    }

    private final void syntaxHighlight() {
        LanguageStyler languageStyler;
        this.cancelSyntaxHighlighting();
        Language language = this.language;
        if (language != null && (languageStyler = language.getStyler()) != null) {
            languageStyler.enqueue(this.getText().toString(), this.getColorScheme().getSyntaxScheme(), (Function1)new Function1<List<? extends SyntaxHighlightSpan>, Unit>(this){
                final /* synthetic */ SyntaxHighlightEditText this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull List<SyntaxHighlightSpan> spans) {
                    Intrinsics.checkNotNullParameter(spans, (String)"spans");
                    SyntaxHighlightEditText.access$getSyntaxHighlightSpans$p(this.this$0).clear();
                    SyntaxHighlightEditText.access$getSyntaxHighlightSpans$p(this.this$0).addAll((Collection)spans);
                    SyntaxHighlightEditText.access$updateSyntaxHighlighting(this.this$0);
                }
            });
        }
    }

    private final void cancelSyntaxHighlighting() {
        LanguageStyler languageStyler;
        Language language = this.language;
        if (language != null && (languageStyler = language.getStyler()) != null) {
            languageStyler.cancel();
        }
    }

    private final void checkMatchingBracket(int pos) {
        if (this.getLayout() != null) {
            if (this.openDelimiterSpan != null && this.closedDelimiterSpan != null) {
                this.getText().removeSpan((Object)this.openDelimiterSpan);
                this.getText().removeSpan((Object)this.closedDelimiterSpan);
            }
            if (this.getEditorConfig().getHighlightDelimiters() && pos > 0 && pos <= this.getText().length()) {
                char c1 = this.getText().charAt(pos - 1);
                int n = 0;
                int n2 = this.delimiters.length + -1;
                if (n <= n2) {
                    block0: do {
                        int n3;
                        int i;
                        if (this.delimiters[i = n++] != c1) continue;
                        boolean open = i <= 2;
                        char c2 = this.delimiters[(i + 3) % 6];
                        int k = pos;
                        if (open) {
                            int nob = 1;
                            while (k < this.getText().length()) {
                                if (this.getText().charAt(k) == c2) {
                                    n3 = nob;
                                    nob = n3 + -1;
                                }
                                if (this.getText().charAt(k) == c1) {
                                    n3 = nob;
                                    nob = n3 + 1;
                                }
                                if (nob == 0) {
                                    this.showBracket(pos - 1, k);
                                    continue block0;
                                }
                                n3 = k;
                                k = n3 + 1;
                            }
                        } else {
                            int ncb = 1;
                            k -= 2;
                            while (k >= 0) {
                                if (this.getText().charAt(k) == c2) {
                                    n3 = ncb;
                                    ncb = n3 + -1;
                                }
                                if (this.getText().charAt(k) == c1) {
                                    n3 = ncb;
                                    ncb = n3 + 1;
                                }
                                if (ncb == 0) {
                                    this.showBracket(k, pos - 1);
                                    continue block0;
                                }
                                n3 = k;
                                k = n3 + -1;
                            }
                        }
                    } while (n <= n2);
                }
            }
        }
    }

    private final void showBracket(int i, int j) {
        if (this.openDelimiterSpan != null && this.closedDelimiterSpan != null) {
            this.getText().setSpan((Object)this.openDelimiterSpan, i, i + 1, 33);
            this.getText().setSpan((Object)this.closedDelimiterSpan, j, j + 1, 33);
        }
    }

    @JvmOverloads
    public SyntaxHighlightEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public SyntaxHighlightEditText(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    public static final /* synthetic */ List access$getSyntaxHighlightSpans$p(SyntaxHighlightEditText $this) {
        return $this.syntaxHighlightSpans;
    }

    public static final /* synthetic */ void access$updateSyntaxHighlighting(SyntaxHighlightEditText $this) {
        $this.updateSyntaxHighlighting();
    }
}

