/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit.internal;

import android.content.Context;
import android.util.AttributeSet;
import androidx.core.text.PrecomputedTextCompat;
import com.blacksquircle.ui.editorkit.R;
import com.blacksquircle.ui.editorkit.internal.LineNumbersEditText;
import com.blacksquircle.ui.editorkit.listener.OnUndoRedoChangedListener;
import com.blacksquircle.ui.editorkit.model.TextChange;
import com.blacksquircle.ui.editorkit.utils.UndoStack;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001f\u001a\u00020\nJ\u0006\u0010 \u001a\u00020\nJ\b\u0010!\u001a\u00020\"H\u0016J*\u0010#\u001a\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0007H\u0016J*\u0010)\u001a\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007H\u0016J\u0006\u0010+\u001a\u00020\"J\u0010\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020.H\u0016J\u0006\u0010/\u001a\u00020\"R\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0017\"\u0004\b\u001e\u0010\u0019\u00a8\u00060"}, d2={"Lcom/blacksquircle/ui/editorkit/internal/UndoRedoEditText;", "Lcom/blacksquircle/ui/editorkit/internal/LineNumbersEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "isDoingUndoRedo", "", "()Z", "setDoingUndoRedo", "(Z)V", "onUndoRedoChangedListener", "Lcom/blacksquircle/ui/editorkit/listener/OnUndoRedoChangedListener;", "getOnUndoRedoChangedListener", "()Lcom/blacksquircle/ui/editorkit/listener/OnUndoRedoChangedListener;", "setOnUndoRedoChangedListener", "(Lcom/blacksquircle/ui/editorkit/listener/OnUndoRedoChangedListener;)V", "redoStack", "Lcom/blacksquircle/ui/editorkit/utils/UndoStack;", "getRedoStack", "()Lcom/blacksquircle/ui/editorkit/utils/UndoStack;", "setRedoStack", "(Lcom/blacksquircle/ui/editorkit/utils/UndoStack;)V", "textLastChange", "Lcom/blacksquircle/ui/editorkit/model/TextChange;", "undoStack", "getUndoStack", "setUndoStack", "canRedo", "canUndo", "clearText", "", "doBeforeTextChanged", "text", "", "start", "count", "after", "doOnTextChanged", "before", "redo", "setTextContent", "textParams", "Landroidx/core/text/PrecomputedTextCompat;", "undo", "editorkit_release"})
public abstract class UndoRedoEditText
extends LineNumbersEditText {
    @NotNull
    private UndoStack undoStack;
    @NotNull
    private UndoStack redoStack;
    @Nullable
    private OnUndoRedoChangedListener onUndoRedoChangedListener;
    private boolean isDoingUndoRedo;
    @Nullable
    private TextChange textLastChange;

    @JvmOverloads
    public UndoRedoEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.undoStack = new UndoStack();
        this.redoStack = new UndoStack();
    }

    public /* synthetic */ UndoRedoEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.autoCompleteTextViewStyle;
        }
        this(context, attributeSet, n);
    }

    @NotNull
    public final UndoStack getUndoStack() {
        return this.undoStack;
    }

    public final void setUndoStack(@NotNull UndoStack undoStack) {
        Intrinsics.checkNotNullParameter((Object)undoStack, (String)"<set-?>");
        this.undoStack = undoStack;
    }

    @NotNull
    public final UndoStack getRedoStack() {
        return this.redoStack;
    }

    public final void setRedoStack(@NotNull UndoStack undoStack) {
        Intrinsics.checkNotNullParameter((Object)undoStack, (String)"<set-?>");
        this.redoStack = undoStack;
    }

    @Nullable
    public final OnUndoRedoChangedListener getOnUndoRedoChangedListener() {
        return this.onUndoRedoChangedListener;
    }

    public final void setOnUndoRedoChangedListener(@Nullable OnUndoRedoChangedListener onUndoRedoChangedListener) {
        this.onUndoRedoChangedListener = onUndoRedoChangedListener;
    }

    protected final boolean isDoingUndoRedo() {
        return this.isDoingUndoRedo;
    }

    protected final void setDoingUndoRedo(boolean bl) {
        this.isDoingUndoRedo = bl;
    }

    @Override
    public void doBeforeTextChanged(@Nullable CharSequence text, int start, int count, int after) {
        super.doBeforeTextChanged(text, start, count, after);
        if (!this.isDoingUndoRedo) {
            TextChange textChange;
            if (count < Integer.MAX_VALUE) {
                CharSequence charSequence = text;
                CharSequence charSequence2 = charSequence == null ? null : charSequence.subSequence(start, start + count);
                textChange = new TextChange("", String.valueOf(charSequence2), start);
            } else {
                this.undoStack.removeAll();
                this.redoStack.removeAll();
                textChange = null;
            }
            this.textLastChange = textChange;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void doOnTextChanged(@Nullable CharSequence text, int start, int before, int count) {
        Object object;
        block13: {
            block12: {
                block14: {
                    Boolean bl;
                    boolean bl2;
                    CharSequence charSequence;
                    String string;
                    Boolean bl3;
                    Object object2;
                    super.doOnTextChanged(text, start, before, count);
                    if (this.isDoingUndoRedo) return;
                    if (this.textLastChange == null) return;
                    if (count >= Integer.MAX_VALUE) break block12;
                    object = this.textLastChange;
                    if (object != null) {
                        object2 = text;
                        ((TextChange)object).setNewText(String.valueOf(object2 == null ? null : object2.subSequence(start, start + count)));
                    }
                    Integer n = (object = this.textLastChange) == null ? null : Integer.valueOf(((TextChange)object).getStart());
                    if (n == null || start != n) break block13;
                    object2 = this.textLastChange;
                    if (object2 == null) {
                        bl3 = null;
                    } else {
                        string = ((TextChange)object2).getOldText();
                        if (string == null) {
                            bl3 = null;
                        } else {
                            charSequence = string;
                            bl2 = false;
                            bl3 = charSequence.length() > 0;
                        }
                    }
                    object = bl3;
                    Intrinsics.checkNotNull((Object)object);
                    if (((Boolean)object).booleanValue()) break block14;
                    object2 = this.textLastChange;
                    if (object2 == null) {
                        bl = null;
                    } else {
                        string = ((TextChange)object2).getNewText();
                        if (string == null) {
                            bl = null;
                        } else {
                            charSequence = string;
                            bl2 = false;
                            bl = charSequence.length() > 0;
                        }
                    }
                    object = bl;
                    Intrinsics.checkNotNull((Object)object);
                    if (!((Boolean)object).booleanValue()) break block13;
                }
                if (!Intrinsics.areEqual((Object)((object = this.textLastChange) == null ? null : ((TextChange)object).getOldText()), (Object)((object = this.textLastChange) == null ? null : ((TextChange)object).getNewText()))) {
                    object = this.textLastChange;
                    Intrinsics.checkNotNull((Object)object);
                    this.undoStack.push((TextChange)object);
                    this.redoStack.removeAll();
                }
                break block13;
            }
            this.undoStack.removeAll();
            this.redoStack.removeAll();
        }
        this.textLastChange = null;
        object = this.onUndoRedoChangedListener;
        if (object == null) {
            return;
        }
        object.onUndoRedoChanged();
    }

    @Override
    public void setTextContent(@NotNull PrecomputedTextCompat textParams) {
        Intrinsics.checkNotNullParameter((Object)textParams, (String)"textParams");
        super.setTextContent(textParams);
        OnUndoRedoChangedListener onUndoRedoChangedListener = this.onUndoRedoChangedListener;
        if (onUndoRedoChangedListener != null) {
            onUndoRedoChangedListener.onUndoRedoChanged();
        }
    }

    @Override
    public void clearText() {
        this.undoStack.removeAll();
        this.redoStack.removeAll();
        OnUndoRedoChangedListener onUndoRedoChangedListener = this.onUndoRedoChangedListener;
        if (onUndoRedoChangedListener != null) {
            onUndoRedoChangedListener.onUndoRedoChanged();
        }
        super.clearText();
    }

    public final boolean canUndo() {
        return this.undoStack.canUndo();
    }

    public final boolean canRedo() {
        return this.redoStack.canUndo();
    }

    public final void undo() {
        TextChange textChange = this.undoStack.pop();
        if (textChange.getStart() >= 0) {
            int end;
            this.isDoingUndoRedo = true;
            if (textChange.getStart() > this.getText().length()) {
                textChange.setStart(this.getText().length());
            }
            if ((end = textChange.getStart() + textChange.getNewText().length()) < 0) {
                end = 0;
            }
            if (end > this.getText().length()) {
                end = this.getText().length();
            }
            this.redoStack.push(textChange);
            this.getText().replace(textChange.getStart(), end, (CharSequence)textChange.getOldText());
            this.setSelection(textChange.getStart() + textChange.getOldText().length());
            this.isDoingUndoRedo = false;
        } else {
            this.undoStack.removeAll();
        }
        OnUndoRedoChangedListener onUndoRedoChangedListener = this.onUndoRedoChangedListener;
        if (onUndoRedoChangedListener != null) {
            onUndoRedoChangedListener.onUndoRedoChanged();
        }
    }

    public final void redo() {
        TextChange textChange = this.redoStack.pop();
        if (textChange.getStart() >= 0) {
            this.isDoingUndoRedo = true;
            this.undoStack.push(textChange);
            this.getText().replace(textChange.getStart(), textChange.getStart() + textChange.getOldText().length(), (CharSequence)textChange.getNewText());
            this.setSelection(textChange.getStart() + textChange.getNewText().length());
            this.isDoingUndoRedo = false;
        } else {
            this.undoStack.removeAll();
        }
        OnUndoRedoChangedListener onUndoRedoChangedListener = this.onUndoRedoChangedListener;
        if (onUndoRedoChangedListener != null) {
            onUndoRedoChangedListener.onUndoRedoChanged();
        }
    }

    @JvmOverloads
    public UndoRedoEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public UndoRedoEditText(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

