/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit.utils;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010(\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u0006\u0010\u000e\u001a\u00020\u000bJ\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0096\u0002J\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0016\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/blacksquircle/ui/editorkit/utils/LinesCollection;", "", "Lcom/blacksquircle/ui/editorkit/utils/LinesCollection$Line;", "()V", "lineCount", "", "getLineCount", "()I", "lines", "", "add", "", "line", "index", "clear", "getIndexForLine", "getLine", "getLineForIndex", "iterator", "", "remove", "shiftIndexes", "fromLine", "shiftBy", "Line", "editorkit_release"})
public final class LinesCollection
implements Iterable<Line>,
KMappedMarker {
    @NotNull
    private final List<Line> lines;

    public LinesCollection() {
        Object[] objectArray = new Line[]{new Line(0)};
        this.lines = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    public final int getLineCount() {
        return this.lines.size();
    }

    public final void add(int line, int index) {
        this.lines.add(line, new Line(index));
    }

    public final void remove(int line) {
        if (line != 0) {
            this.lines.remove(line);
        }
    }

    public final void clear() {
        this.lines.clear();
        this.lines.add(new Line(0));
    }

    public final void shiftIndexes(int fromLine, int shiftBy) {
        if (fromLine <= 0) {
            return;
        }
        if (fromLine < this.getLineCount()) {
            int i = fromLine;
            while (i < this.getLineCount()) {
                int n;
                int newIndex = this.getIndexForLine(i) + shiftBy;
                if (i <= 0 || newIndex > 0) {
                    this.lines.get(i).setStart(newIndex);
                } else {
                    this.remove(i);
                    n = i;
                    i = n + -1;
                }
                n = i;
                i = n + 1;
            }
        }
    }

    public final int getIndexForLine(int line) {
        return line >= this.getLineCount() ? -1 : this.lines.get(line).getStart();
    }

    public final int getLineForIndex(int index) {
        int first = 0;
        int last = this.getLineCount() - 1;
        while (first < last) {
            int mid = (first + last) / 2;
            if (index < this.getIndexForLine(mid)) {
                last = mid;
                continue;
            }
            if (index <= this.getIndexForLine(mid) || index < this.getIndexForLine(mid + 1)) {
                return mid;
            }
            first = mid + 1;
        }
        return this.getLineCount() - 1;
    }

    @NotNull
    public final Line getLine(int line) {
        if (line > -1 && line < this.getLineCount()) {
            return this.lines.get(line);
        }
        return new Line(0);
    }

    @Override
    @NotNull
    public Iterator<Line> iterator() {
        return this.lines.iterator();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0000H\u0096\u0002J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\t\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0012"}, d2={"Lcom/blacksquircle/ui/editorkit/utils/LinesCollection$Line;", "", "start", "", "(I)V", "getStart", "()I", "setStart", "compareTo", "other", "component1", "copy", "equals", "", "", "hashCode", "toString", "", "editorkit_release"})
    public static final class Line
    implements Comparable<Line> {
        private int start;

        public Line(int start) {
            this.start = start;
        }

        public final int getStart() {
            return this.start;
        }

        public final void setStart(int n) {
            this.start = n;
        }

        @Override
        public int compareTo(@NotNull Line other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.start - other.start;
        }

        public final int component1() {
            return this.start;
        }

        @NotNull
        public final Line copy(int start) {
            return new Line(start);
        }

        public static /* synthetic */ Line copy$default(Line line, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = line.start;
            }
            return line.copy(n);
        }

        @NotNull
        public String toString() {
            return "Line(start=" + this.start + ')';
        }

        public int hashCode() {
            return Integer.hashCode(this.start);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Line)) {
                return false;
            }
            Line line = (Line)other;
            return this.start == line.start;
        }
    }
}

