/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit.widget;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.text.Editable;
import android.util.AttributeSet;
import android.view.KeyEvent;
import androidx.core.content.ContextCompat;
import androidx.core.text.PrecomputedTextCompat;
import com.blacksquircle.ui.editorkit.R;
import com.blacksquircle.ui.editorkit.exception.LineException;
import com.blacksquircle.ui.editorkit.internal.CodeSuggestsEditText;
import com.blacksquircle.ui.editorkit.listener.OnChangeListener;
import com.blacksquircle.ui.editorkit.listener.OnShortcutListener;
import com.blacksquircle.ui.editorkit.model.Shortcut;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 52\u00020\u0001:\u00015B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aJ\u0006\u0010\u001c\u001a\u00020\u001aJ\u0012\u0010\u001d\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u0006\u0010 \u001a\u00020\u001aJ\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u0007J\u0006\u0010#\u001a\u00020\fJ\u000e\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020\fJ\u0006\u0010(\u001a\u00020\fJ\u0006\u0010)\u001a\u00020\fJ\u0006\u0010*\u001a\u00020\fJ\u001a\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020\u00072\b\u0010-\u001a\u0004\u0018\u00010.H\u0016J\u0006\u0010/\u001a\u00020\u001aJ\u0006\u00100\u001a\u00020\u001aJ\b\u00101\u001a\u00020&H\u0002J\u0010\u00102\u001a\u00020\u001a2\u0006\u00103\u001a\u000204H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u00066"}, d2={"Lcom/blacksquircle/ui/editorkit/widget/TextProcessor;", "Lcom/blacksquircle/ui/editorkit/internal/CodeSuggestsEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "clipboardManager", "Landroid/content/ClipboardManager;", "isNewContent", "", "onChangeListener", "Lcom/blacksquircle/ui/editorkit/listener/OnChangeListener;", "getOnChangeListener", "()Lcom/blacksquircle/ui/editorkit/listener/OnChangeListener;", "setOnChangeListener", "(Lcom/blacksquircle/ui/editorkit/listener/OnChangeListener;)V", "onShortcutListener", "Lcom/blacksquircle/ui/editorkit/listener/OnShortcutListener;", "getOnShortcutListener", "()Lcom/blacksquircle/ui/editorkit/listener/OnShortcutListener;", "setOnShortcutListener", "(Lcom/blacksquircle/ui/editorkit/listener/OnShortcutListener;)V", "copy", "", "cut", "deleteLine", "doAfterTextChanged", "text", "Landroid/text/Editable;", "duplicateLine", "gotoLine", "lineNumber", "hasPrimaryClip", "insert", "delta", "", "moveCaretToEndOfLine", "moveCaretToNextWord", "moveCaretToPrevWord", "moveCaretToStartOfLine", "onKeyDown", "keyCode", "event", "Landroid/view/KeyEvent;", "paste", "selectLine", "selectedText", "setTextContent", "textParams", "Landroidx/core/text/PrecomputedTextCompat;", "Companion", "editorkit_release"})
public final class TextProcessor
extends CodeSuggestsEditText {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private OnChangeListener onChangeListener;
    @Nullable
    private OnShortcutListener onShortcutListener;
    @NotNull
    private final ClipboardManager clipboardManager;
    private boolean isNewContent;
    @NotNull
    private static final String LABEL_CUT = "CUT";
    @NotNull
    private static final String LABEL_COPY = "COPY";

    @JvmOverloads
    public TextProcessor(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        Context $this$getSystemService$iv = context;
        boolean $i$f$getSystemService = false;
        ClipboardManager clipboardManager = (ClipboardManager)ContextCompat.getSystemService((Context)$this$getSystemService$iv, ClipboardManager.class);
        Intrinsics.checkNotNull((Object)clipboardManager);
        this.clipboardManager = clipboardManager;
        this.configure();
        this.colorize();
    }

    public /* synthetic */ TextProcessor(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.autoCompleteTextViewStyle;
        }
        this(context, attributeSet, n);
    }

    @Nullable
    public final OnChangeListener getOnChangeListener() {
        return this.onChangeListener;
    }

    public final void setOnChangeListener(@Nullable OnChangeListener onChangeListener) {
        this.onChangeListener = onChangeListener;
    }

    @Nullable
    public final OnShortcutListener getOnShortcutListener() {
        return this.onShortcutListener;
    }

    public final void setOnShortcutListener(@Nullable OnShortcutListener onShortcutListener) {
        this.onShortcutListener = onShortcutListener;
    }

    @Override
    public void doAfterTextChanged(@Nullable Editable text) {
        OnChangeListener onChangeListener;
        super.doAfterTextChanged(text);
        if (!this.isNewContent && (onChangeListener = this.onChangeListener) != null) {
            onChangeListener.onChange();
        }
    }

    public boolean onKeyDown(int keyCode, @Nullable KeyEvent event) {
        Shortcut shortcut;
        if (event != null && this.onShortcutListener != null && ((shortcut = new Shortcut(event.isCtrlPressed(), event.isShiftPressed(), event.isAltPressed(), keyCode)).getCtrl() || shortcut.getShift() || shortcut.getAlt())) {
            OnShortcutListener onShortcutListener = this.onShortcutListener;
            Intrinsics.checkNotNull((Object)onShortcutListener);
            if (onShortcutListener.onShortcut(shortcut)) {
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public void setTextContent(@NotNull PrecomputedTextCompat textParams) {
        Intrinsics.checkNotNullParameter((Object)textParams, (String)"textParams");
        this.isNewContent = true;
        super.setTextContent(textParams);
        this.isNewContent = false;
    }

    public final void insert(@NotNull CharSequence delta) {
        Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
        this.getText().replace(this.getSelectionStart(), this.getSelectionEnd(), delta);
    }

    public final void cut() {
        ClipData clipData = ClipData.newPlainText((CharSequence)LABEL_CUT, (CharSequence)this.selectedText());
        this.clipboardManager.setPrimaryClip(clipData);
        this.getText().replace(this.getSelectionStart(), this.getSelectionEnd(), (CharSequence)"");
    }

    public final void copy() {
        ClipData clipData = ClipData.newPlainText((CharSequence)LABEL_COPY, (CharSequence)this.selectedText());
        this.clipboardManager.setPrimaryClip(clipData);
    }

    public final void paste() {
        ClipData.Item clipData;
        ClipData clipData2 = this.clipboardManager.getPrimaryClip();
        ClipData.Item item = clipData = clipData2 == null ? null : clipData2.getItemAt(0);
        CharSequence clipText = item == null ? null : item.coerceToText(this.getContext());
        this.getText().replace(this.getSelectionStart(), this.getSelectionEnd(), clipText);
    }

    public final void selectLine() {
        int currentLine = this.getLines().getLineForIndex(this.getSelectionStart());
        int lineStart = this.getIndexForStartOfLine(currentLine);
        int lineEnd = this.getIndexForEndOfLine(currentLine);
        this.setSelection(lineStart, lineEnd);
    }

    public final void deleteLine() {
        int currentLine = this.getLines().getLineForIndex(this.getSelectionStart());
        int lineStart = this.getIndexForStartOfLine(currentLine);
        int lineEnd = this.getIndexForEndOfLine(currentLine);
        this.getText().delete(lineStart, lineEnd);
    }

    public final void duplicateLine() {
        int currentLine = this.getLines().getLineForIndex(this.getSelectionStart());
        int lineStart = this.getIndexForStartOfLine(currentLine);
        int lineEnd = this.getIndexForEndOfLine(currentLine);
        CharSequence lineText = this.getText().subSequence(lineStart, lineEnd);
        this.getText().insert(lineEnd, (CharSequence)Intrinsics.stringPlus((String)"\n", (Object)lineText));
    }

    public final boolean moveCaretToStartOfLine() {
        int currentLine = this.getLines().getLineForIndex(this.getSelectionStart());
        int lineStart = this.getIndexForStartOfLine(currentLine);
        this.setSelection(lineStart);
        return true;
    }

    public final boolean moveCaretToEndOfLine() {
        int currentLine = this.getLines().getLineForIndex(this.getSelectionEnd());
        int lineEnd = this.getIndexForEndOfLine(currentLine);
        this.setSelection(lineEnd);
        return true;
    }

    public final boolean moveCaretToPrevWord() {
        if (this.getSelectionStart() > 0) {
            int i;
            boolean isLetterDigitOrUnderscore;
            int currentChar;
            int n = currentChar = this.getText().charAt(this.getSelectionStart() - 1);
            boolean bl = false;
            boolean bl2 = isLetterDigitOrUnderscore = Character.isLetterOrDigit((char)n) || currentChar == 95;
            if (isLetterDigitOrUnderscore) {
                n = this.getSelectionStart();
                if (0 <= n) {
                    do {
                        char c;
                        i = n--;
                        char c2 = c = this.getText().charAt(i - 1);
                        boolean bl3 = false;
                        if (Character.isLetterOrDigit(c2) || c == '_') continue;
                        this.setSelection(i);
                        break;
                    } while (0 <= n);
                }
            } else {
                n = this.getSelectionStart();
                if (0 <= n) {
                    do {
                        char c;
                        i = n--;
                        char c3 = c = this.getText().charAt(i - 1);
                        boolean bl4 = false;
                        if (!Character.isLetterOrDigit(c3) && c != '_') continue;
                        this.setSelection(i);
                        break;
                    } while (0 <= n);
                }
            }
        }
        return true;
    }

    public final boolean moveCaretToNextWord() {
        if (this.getSelectionStart() < this.getText().length()) {
            boolean isLetterDigitOrUnderscore;
            int currentChar;
            int n = currentChar = this.getText().charAt(this.getSelectionStart());
            int n2 = 0;
            boolean bl = isLetterDigitOrUnderscore = Character.isLetterOrDigit((char)n) || currentChar == 95;
            if (isLetterDigitOrUnderscore) {
                n = this.getSelectionStart();
                if (n < (n2 = this.getText().length())) {
                    do {
                        char c;
                        int i = n++;
                        char c2 = c = this.getText().charAt(i);
                        boolean bl2 = false;
                        if (Character.isLetterOrDigit(c2) || c == '_') continue;
                        this.setSelection(i);
                        break;
                    } while (n < n2);
                }
            } else {
                n = this.getSelectionStart();
                if (n < (n2 = this.getText().length())) {
                    do {
                        char c;
                        int i = n++;
                        char c3 = c = this.getText().charAt(i);
                        boolean bl3 = false;
                        if (!Character.isLetterOrDigit(c3) && c != '_') continue;
                        this.setSelection(i);
                        break;
                    } while (n < n2);
                }
            }
        }
        return true;
    }

    public final void gotoLine(int lineNumber) throws LineException {
        int line = lineNumber - 1;
        if (line < 0 || line >= this.getLines().getLineCount() - 1) {
            throw new LineException(lineNumber);
        }
        this.setSelection(this.getLines().getIndexForLine(line));
    }

    public final boolean hasPrimaryClip() {
        return this.clipboardManager.hasPrimaryClip();
    }

    private final CharSequence selectedText() {
        return this.getText().subSequence(this.getSelectionStart(), this.getSelectionEnd());
    }

    @JvmOverloads
    public TextProcessor(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public TextProcessor(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/blacksquircle/ui/editorkit/widget/TextProcessor$Companion;", "", "()V", "LABEL_COPY", "", "LABEL_CUT", "editorkit_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

