/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.TypedArrayKt;
import com.blacksquircle.ui.editorkit.R;
import com.blacksquircle.ui.editorkit.internal.ScrollableEditText;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 C2\u00020\u00012\u00020\u0002:\u0001CB%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010+\u001a\u00020,2\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010-\u001a\u00020,H\u0002J\b\u0010.\u001a\u00020\"H\u0002J\u0018\u0010/\u001a\u00020\u00162\u0006\u00100\u001a\u00020\"2\u0006\u00101\u001a\u00020\"H\u0002J\b\u00102\u001a\u00020\u0016H\u0002J\u0010\u00103\u001a\u00020,2\u0006\u00104\u001a\u000205H\u0014J0\u00106\u001a\u00020,2\u0006\u00107\u001a\u00020\u00162\u0006\u00108\u001a\u00020\b2\u0006\u00109\u001a\u00020\b2\u0006\u0010:\u001a\u00020\b2\u0006\u0010;\u001a\u00020\bH\u0014J(\u0010<\u001a\u00020,2\u0006\u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020\b2\u0006\u0010=\u001a\u00020\b2\u0006\u0010>\u001a\u00020\bH\u0016J\u0010\u0010?\u001a\u00020\u00162\u0006\u0010@\u001a\u00020AH\u0017J\b\u0010B\u001a\u00020,H\u0002R#\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R#\u0010\u0017\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0010\u001a\u0004\b\u0018\u0010\u000eR\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/blacksquircle/ui/editorkit/widget/TextScroller;", "Landroid/view/View;", "Lcom/blacksquircle/ui/editorkit/internal/ScrollableEditText$OnScrollChangedListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "draggingBitmap", "Landroid/graphics/Bitmap;", "kotlin.jvm.PlatformType", "getDraggingBitmap", "()Landroid/graphics/Bitmap;", "draggingBitmap$delegate", "Lkotlin/Lazy;", "hideCallback", "Ljava/lang/Runnable;", "hideHandler", "Landroid/os/Handler;", "isInitialized", "", "normalBitmap", "getNormalBitmap", "normalBitmap$delegate", "scrollableEditText", "Lcom/blacksquircle/ui/editorkit/internal/ScrollableEditText;", "state", "getState", "()I", "setState", "(I)V", "textScrollMax", "", "textScrollY", "thumbDragging", "Landroid/graphics/drawable/Drawable;", "thumbHeight", "thumbNormal", "thumbPaint", "Landroid/graphics/Paint;", "thumbTop", "attachTo", "", "getMeasurements", "getThumbTop", "isPointInThumb", "x", "y", "isShowScrollerJustified", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onLayout", "changed", "left", "top", "right", "bottom", "onScrollChanged", "oldX", "oldY", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "scrollView", "Companion", "editorkit_release"})
public final class TextScroller
extends View
implements ScrollableEditText.OnScrollChangedListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int state;
    @Nullable
    private ScrollableEditText scrollableEditText;
    @NotNull
    private final Lazy normalBitmap$delegate;
    @NotNull
    private final Lazy draggingBitmap$delegate;
    private final int thumbHeight;
    @NotNull
    private final Drawable thumbNormal;
    @NotNull
    private final Drawable thumbDragging;
    @NotNull
    private final Handler hideHandler;
    @NotNull
    private final Runnable hideCallback;
    @NotNull
    private final Paint thumbPaint;
    private float thumbTop;
    private float textScrollMax;
    private float textScrollY;
    private boolean isInitialized;
    public static final int STATE_HIDDEN = 0;
    public static final int STATE_VISIBLE = 1;
    public static final int STATE_DRAGGING = 2;
    public static final int STATE_EXITING = 3;
    private static final long TIME_EXITING = 2000L;

    @JvmOverloads
    public TextScroller(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Drawable drawable2;
        Drawable drawable3;
        Drawable drawable4;
        Drawable drawable5;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.normalBitmap$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Bitmap>(this){
            final /* synthetic */ TextScroller this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Bitmap invoke() {
                return Bitmap.createBitmap((int)this.this$0.getWidth(), (int)TextScroller.access$getThumbHeight$p(this.this$0), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
        }));
        this.draggingBitmap$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Bitmap>(this){
            final /* synthetic */ TextScroller this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Bitmap invoke() {
                return Bitmap.createBitmap((int)this.this$0.getWidth(), (int)TextScroller.access$getThumbHeight$p(this.this$0), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
        }));
        this.hideHandler = new Handler(Looper.getMainLooper());
        this.hideCallback = () -> TextScroller.hideCallback$lambda-0(this);
        this.thumbPaint = new Paint();
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TextScroller, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyledAttributes(attrs, R.styleable.TextScroller, 0, 0)");
        TypedArray typedArray2 = typedArray;
        boolean hasThumbNormal = typedArray2.hasValue(R.styleable.TextScroller_thumbNormal);
        boolean hasThumbDragging = typedArray2.hasValue(R.styleable.TextScroller_thumbDragging);
        boolean hasThumbTint = typedArray2.hasValue(R.styleable.TextScroller_thumbTint);
        if (hasThumbNormal) {
            drawable5 = TypedArrayKt.getDrawableOrThrow((TypedArray)typedArray2, (int)R.styleable.TextScroller_thumbNormal);
        } else {
            drawable4 = ContextCompat.getDrawable((Context)context, (int)R.drawable.fastscroll_default);
            Intrinsics.checkNotNull((Object)drawable4);
            drawable5 = this.thumbNormal = (drawable3 = drawable4);
        }
        if (hasThumbDragging) {
            drawable2 = TypedArrayKt.getDrawableOrThrow((TypedArray)typedArray2, (int)R.styleable.TextScroller_thumbDragging);
        } else {
            drawable4 = ContextCompat.getDrawable((Context)context, (int)R.drawable.fastscroll_pressed);
            Intrinsics.checkNotNull((Object)drawable4);
            drawable2 = this.thumbDragging = (drawable3 = drawable4);
        }
        if (hasThumbTint) {
            int thumbTint = typedArray2.getColor(R.styleable.TextScroller_thumbTint, -16776961);
            this.thumbNormal.setTint(thumbTint);
            this.thumbDragging.setTint(thumbTint);
        }
        this.thumbHeight = this.thumbNormal.getIntrinsicHeight();
        this.thumbPaint.setAntiAlias(true);
        this.thumbPaint.setDither(false);
        this.thumbPaint.setAlpha(225);
        typedArray2.recycle();
    }

    public /* synthetic */ TextScroller(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final int getState() {
        return this.state;
    }

    public final void setState(int state) {
        int n = state;
        switch (n) {
            case 0: {
                this.hideHandler.removeCallbacks(this.hideCallback);
                this.state = 0;
                this.invalidate();
                break;
            }
            case 1: {
                if (!this.isShowScrollerJustified()) break;
                this.hideHandler.removeCallbacks(this.hideCallback);
                this.state = 1;
                this.invalidate();
                break;
            }
            case 2: {
                this.hideHandler.removeCallbacks(this.hideCallback);
                this.state = 2;
                this.invalidate();
                break;
            }
            case 3: {
                this.hideHandler.removeCallbacks(this.hideCallback);
                this.state = 3;
                this.invalidate();
            }
        }
    }

    private final Bitmap getNormalBitmap() {
        Lazy lazy = this.normalBitmap$delegate;
        boolean bl = false;
        return (Bitmap)lazy.getValue();
    }

    private final Bitmap getDraggingBitmap() {
        Lazy lazy = this.draggingBitmap$delegate;
        boolean bl = false;
        return (Bitmap)lazy.getValue();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!this.isInitialized) {
            this.thumbNormal.setBounds(new Rect(0, 0, this.getWidth(), this.thumbHeight));
            this.thumbNormal.draw(new Canvas(this.getNormalBitmap()));
            this.thumbDragging.setBounds(new Rect(0, 0, this.getWidth(), this.thumbHeight));
            this.thumbDragging.draw(new Canvas(this.getDraggingBitmap()));
            this.isInitialized = true;
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (this.state != 0) {
            super.onDraw(canvas);
            if (this.state == 1 || this.state == 2) {
                this.thumbPaint.setAlpha(225);
                if (this.state == 1) {
                    canvas.drawBitmap(this.getNormalBitmap(), 0.0f, this.thumbTop, this.thumbPaint);
                } else {
                    canvas.drawBitmap(this.getDraggingBitmap(), 0.0f, this.thumbTop, this.thumbPaint);
                }
            } else if (this.state == 3) {
                if (this.thumbPaint.getAlpha() > 25) {
                    this.thumbPaint.setAlpha(this.thumbPaint.getAlpha() - 25);
                    canvas.drawBitmap(this.getNormalBitmap(), 0.0f, this.thumbTop, this.thumbPaint);
                    this.getHandler().postDelayed(this.hideCallback, 17L);
                    return;
                }
                this.thumbPaint.setAlpha(0);
                this.setState(0);
            }
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.scrollableEditText == null || this.state == 0) {
            return false;
        }
        this.getMeasurements();
        int n = event.getAction();
        switch (n) {
            case 0: {
                if (!this.isPointInThumb(event.getX(), event.getY())) break;
                ScrollableEditText scrollableEditText = this.scrollableEditText;
                if (scrollableEditText != null) {
                    scrollableEditText.abortFling();
                }
                this.setState(2);
                this.setPressed(true);
                return true;
            }
            case 1: {
                this.setState(1);
                this.setPressed(false);
                this.hideHandler.postDelayed(this.hideCallback, 2000L);
                break;
            }
            case 2: {
                if (this.state != 2) break;
                this.setPressed(true);
                ScrollableEditText scrollableEditText = this.scrollableEditText;
                if (scrollableEditText != null) {
                    scrollableEditText.abortFling();
                }
                int newThumbTop = (int)event.getY() - this.thumbHeight / 2;
                if (newThumbTop < 0) {
                    newThumbTop = 0;
                } else if (this.thumbHeight + newThumbTop > this.getHeight()) {
                    newThumbTop = this.getHeight() - this.thumbHeight;
                }
                this.thumbTop = newThumbTop;
                this.scrollView();
                this.invalidate();
                return true;
            }
        }
        return false;
    }

    @Override
    public void onScrollChanged(int x, int y, int oldX, int oldY) {
        if (this.state != 2) {
            this.getMeasurements();
            this.setState(1);
            this.hideHandler.postDelayed(this.hideCallback, 2000L);
        }
    }

    public final void attachTo(@NotNull ScrollableEditText scrollableEditText) {
        Intrinsics.checkNotNullParameter((Object)((Object)scrollableEditText), (String)"scrollableEditText");
        ScrollableEditText scrollableEditText2 = this.scrollableEditText = scrollableEditText;
        if (scrollableEditText2 != null) {
            scrollableEditText2.addOnScrollChangedListener(this);
        }
    }

    private final void scrollView() {
        if (this.scrollableEditText != null) {
            float scrollToAsFraction = this.thumbTop / (float)(this.getHeight() - this.thumbHeight);
            ScrollableEditText scrollableEditText = this.scrollableEditText;
            Intrinsics.checkNotNull((Object)((Object)scrollableEditText));
            int lineHeight = scrollableEditText.getLineHeight();
            ScrollableEditText scrollableEditText2 = this.scrollableEditText;
            Intrinsics.checkNotNull((Object)((Object)scrollableEditText2));
            int textAreaHeight = scrollableEditText2.getHeight();
            scrollableEditText2 = this.scrollableEditText;
            if (scrollableEditText2 != null) {
                ScrollableEditText scrollableEditText3 = this.scrollableEditText;
                Intrinsics.checkNotNull((Object)((Object)scrollableEditText3));
                scrollableEditText2.scrollTo(scrollableEditText3.getScrollX(), (int)(this.textScrollMax * scrollToAsFraction - scrollToAsFraction * (float)(textAreaHeight - lineHeight)));
            }
        }
    }

    private final void getMeasurements() {
        ScrollableEditText scrollableEditText = this.scrollableEditText;
        if ((scrollableEditText == null ? null : scrollableEditText.getLayout()) != null) {
            scrollableEditText = this.scrollableEditText;
            Intrinsics.checkNotNull((Object)((Object)scrollableEditText));
            this.textScrollMax = scrollableEditText.getLayout().getHeight();
            scrollableEditText = this.scrollableEditText;
            Intrinsics.checkNotNull((Object)((Object)scrollableEditText));
            this.textScrollY = scrollableEditText.getScrollY();
            this.thumbTop = this.getThumbTop();
        }
    }

    private final float getThumbTop() {
        if (this.scrollableEditText != null) {
            float calculatedThumbTop;
            ScrollableEditText scrollableEditText = this.scrollableEditText;
            Intrinsics.checkNotNull((Object)((Object)scrollableEditText));
            int lineHeight = scrollableEditText.getLineHeight();
            ScrollableEditText scrollableEditText2 = this.scrollableEditText;
            Intrinsics.checkNotNull((Object)((Object)scrollableEditText2));
            int textAreaHeight = scrollableEditText2.getHeight();
            float f = calculatedThumbTop = (float)(this.getHeight() - this.thumbHeight) * (this.textScrollY / (this.textScrollMax - (float)textAreaHeight + (float)lineHeight));
            boolean bl = false;
            float absoluteThumbTop = !Float.isNaN(f) ? calculatedThumbTop : 0.0f;
            return absoluteThumbTop > (float)(this.getHeight() - this.thumbHeight) ? (float)(this.getHeight() - this.thumbHeight) : absoluteThumbTop;
        }
        return 0.0f;
    }

    private final boolean isPointInThumb(float x, float y) {
        return x >= 0.0f && x <= (float)this.getWidth() && y >= this.thumbTop && y <= this.thumbTop + (float)this.thumbHeight;
    }

    private final boolean isShowScrollerJustified() {
        ScrollableEditText scrollableEditText = this.scrollableEditText;
        Intrinsics.checkNotNull((Object)((Object)scrollableEditText));
        return (double)(this.textScrollMax / (float)scrollableEditText.getHeight()) >= 1.5;
    }

    @JvmOverloads
    public TextScroller(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public TextScroller(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void hideCallback$lambda-0(TextScroller this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.setState(3);
    }

    public static final /* synthetic */ int access$getThumbHeight$p(TextScroller $this) {
        return $this.thumbHeight;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/blacksquircle/ui/editorkit/widget/TextScroller$Companion;", "", "()V", "STATE_DRAGGING", "", "STATE_EXITING", "STATE_HIDDEN", "STATE_VISIBLE", "TIME_EXITING", "", "editorkit_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

