/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.text.Editable;
import android.widget.EditText;
import androidx.core.content.ContextCompat;
import com.blacksquircle.ui.editorkit.exception.LineException;
import com.blacksquircle.ui.editorkit.widget.TextProcessor;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\r\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\u0002\u001a\n\u0010\f\u001a\u00020\u000b*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\u000b*\u00020\u000e\u001a\n\u0010\u000f\u001a\u00020\u000b*\u00020\u000e\u001a\u0012\u0010\u0010\u001a\u00020\u000b*\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0007\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u000e\u001a\u0012\u0010\u0014\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016\u001a\n\u0010\u0017\u001a\u00020\u000b*\u00020\u000e\u001a\n\u0010\u0018\u001a\u00020\u0013*\u00020\u000e\u001a\n\u0010\u0019\u001a\u00020\u0013*\u00020\u000e\u001a\n\u0010\u001a\u001a\u00020\u000b*\u00020\u000e\u001a\n\u0010\u001b\u001a\u00020\u000b*\u00020\u0002\u001a\n\u0010\u001c\u001a\u00020\u000b*\u00020\u000e\u001a\u0012\u0010\u001d\u001a\u00020\u000b*\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u0007\u001a\u001a\u0010\u001f\u001a\u00020\u000b*\u00020\u00022\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007\u001a\n\u0010\"\u001a\u00020\u000b*\u00020\u000e\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"!\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006#"}, d2={"selectedText", "", "Landroid/widget/EditText;", "getSelectedText", "(Landroid/widget/EditText;)Ljava/lang/String;", "selectionPair", "Lkotlin/Pair;", "", "getSelectionPair", "(Landroid/widget/EditText;)Lkotlin/Pair;", "copy", "", "cut", "deleteLine", "Lcom/blacksquircle/ui/editorkit/widget/TextProcessor;", "duplicateLine", "gotoLine", "lineNumber", "hasPrimaryClip", "", "insert", "delta", "", "moveCaretToEndOfLine", "moveCaretToNextWord", "moveCaretToPrevWord", "moveCaretToStartOfLine", "paste", "selectLine", "setSelectionIndex", "index", "setSelectionRange", "start", "end", "toggleCase", "editorkit_release"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\ncom/blacksquircle/ui/editorkit/ExtensionsKt\n+ 2 Context.kt\nandroidx/core/content/ContextKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,205:1\n31#2:206\n31#2:207\n31#2:208\n31#2:211\n1064#3,2:209\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\ncom/blacksquircle/ui/editorkit/ExtensionsKt\n*L\n46#1:206\n59#1:207\n69#1:208\n203#1:211\n123#1:209,2\n*E\n"})
public final class ExtensionsKt {
    @NotNull
    public static final Pair<Integer, Integer> getSelectionPair(@NotNull EditText $this$selectionPair) {
        Intrinsics.checkNotNullParameter((Object)$this$selectionPair, (String)"<this>");
        int start = $this$selectionPair.getSelectionStart();
        int end = $this$selectionPair.getSelectionEnd();
        return start > end ? TuplesKt.to((Object)end, (Object)start) : TuplesKt.to((Object)start, (Object)end);
    }

    @NotNull
    public static final String getSelectedText(@NotNull EditText $this$selectedText) {
        Intrinsics.checkNotNullParameter((Object)$this$selectedText, (String)"<this>");
        Pair<Integer, Integer> pair = ExtensionsKt.getSelectionPair($this$selectedText);
        int start = ((Number)pair.component1()).intValue();
        int end = ((Number)pair.component2()).intValue();
        Editable editable = $this$selectedText.getText();
        Intrinsics.checkNotNullExpressionValue((Object)editable, (String)"text");
        return ((Object)((CharSequence)editable).subSequence(start, end)).toString();
    }

    public static final void insert(@NotNull EditText $this$insert, @NotNull CharSequence delta) {
        Intrinsics.checkNotNullParameter((Object)$this$insert, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)delta, (String)"delta");
        Pair<Integer, Integer> pair = ExtensionsKt.getSelectionPair($this$insert);
        int start = ((Number)pair.component1()).intValue();
        int end = ((Number)pair.component2()).intValue();
        $this$insert.getText().replace(start, end, delta);
    }

    public static final void cut(@NotNull EditText $this$cut) {
        Intrinsics.checkNotNullParameter((Object)$this$cut, (String)"<this>");
        try {
            Context context = $this$cut.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            Context $this$getSystemService$iv = context;
            boolean $i$f$getSystemService = false;
            ClipboardManager clipboardManager = (ClipboardManager)ContextCompat.getSystemService((Context)$this$getSystemService$iv, ClipboardManager.class);
            ClipData clipData = ClipData.newPlainText(null, (CharSequence)ExtensionsKt.getSelectedText($this$cut));
            ClipboardManager clipboardManager2 = clipboardManager;
            if (clipboardManager2 != null) {
                clipboardManager2.setPrimaryClip(clipData);
            }
            Pair<Integer, Integer> pair = ExtensionsKt.getSelectionPair($this$cut);
            int start = ((Number)pair.component1()).intValue();
            int end = ((Number)pair.component2()).intValue();
            $this$cut.getText().replace(start, end, (CharSequence)"");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void copy(@NotNull EditText $this$copy) {
        Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"<this>");
        try {
            Context context = $this$copy.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            Context $this$getSystemService$iv = context;
            boolean $i$f$getSystemService = false;
            ClipboardManager clipboardManager = (ClipboardManager)ContextCompat.getSystemService((Context)$this$getSystemService$iv, ClipboardManager.class);
            ClipData clipData = ClipData.newPlainText(null, (CharSequence)ExtensionsKt.getSelectedText($this$copy));
            ClipboardManager clipboardManager2 = clipboardManager;
            if (clipboardManager2 != null) {
                clipboardManager2.setPrimaryClip(clipData);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void paste(@NotNull EditText $this$paste) {
        Intrinsics.checkNotNullParameter((Object)$this$paste, (String)"<this>");
        try {
            ClipData.Item clipData;
            Context context = $this$paste.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            Context $this$getSystemService$iv = context;
            boolean $i$f$getSystemService = false;
            ClipboardManager clipboardManager = (ClipboardManager)ContextCompat.getSystemService((Context)$this$getSystemService$iv, ClipboardManager.class);
            ClipboardManager clipboardManager2 = clipboardManager;
            ClipData.Item item = clipData = clipboardManager2 != null && (clipboardManager2 = clipboardManager2.getPrimaryClip()) != null ? clipboardManager2.getItemAt(0) : null;
            CharSequence clipText = item != null ? item.coerceToText($this$paste.getContext()) : null;
            Pair<Integer, Integer> pair = ExtensionsKt.getSelectionPair($this$paste);
            int start = ((Number)pair.component1()).intValue();
            int end = ((Number)pair.component2()).intValue();
            $this$paste.getText().replace(start, end, clipText);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static final void setSelectionRange(@NotNull EditText $this$setSelectionRange, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)$this$setSelectionRange, (String)"<this>");
        $this$setSelectionRange.setSelection(start > $this$setSelectionRange.getText().length() ? $this$setSelectionRange.getText().length() : start, end > $this$setSelectionRange.getText().length() ? $this$setSelectionRange.getText().length() : end);
    }

    public static final void setSelectionIndex(@NotNull EditText $this$setSelectionIndex, int index) {
        Intrinsics.checkNotNullParameter((Object)$this$setSelectionIndex, (String)"<this>");
        $this$setSelectionIndex.setSelection(index > $this$setSelectionIndex.getText().length() ? $this$setSelectionIndex.getText().length() : index);
    }

    public static final void selectLine(@NotNull TextProcessor $this$selectLine) {
        Intrinsics.checkNotNullParameter((Object)$this$selectLine, (String)"<this>");
        int currentLine = $this$selectLine.getStructure().getLineForIndex($this$selectLine.getSelectionStart());
        int lineStart = $this$selectLine.getStructure().getIndexForStartOfLine(currentLine);
        int lineEnd = $this$selectLine.getStructure().getIndexForEndOfLine(currentLine);
        ExtensionsKt.setSelectionRange((EditText)$this$selectLine, lineStart, lineEnd);
    }

    public static final void deleteLine(@NotNull TextProcessor $this$deleteLine) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteLine, (String)"<this>");
        int currentLine = $this$deleteLine.getStructure().getLineForIndex($this$deleteLine.getSelectionStart());
        int lineStart = $this$deleteLine.getStructure().getIndexForStartOfLine(currentLine);
        int lineEnd = $this$deleteLine.getStructure().getIndexForEndOfLine(currentLine);
        $this$deleteLine.getText().delete(lineStart, lineEnd);
    }

    public static final void duplicateLine(@NotNull TextProcessor $this$duplicateLine) {
        Intrinsics.checkNotNullParameter((Object)$this$duplicateLine, (String)"<this>");
        if ($this$duplicateLine.hasSelection()) {
            Pair<Integer, Integer> pair = ExtensionsKt.getSelectionPair((EditText)$this$duplicateLine);
            int start = ((Number)pair.component1()).intValue();
            int end = ((Number)pair.component2()).intValue();
            $this$duplicateLine.getText().replace(start, end, (CharSequence)(ExtensionsKt.getSelectedText((EditText)$this$duplicateLine) + ExtensionsKt.getSelectedText((EditText)$this$duplicateLine)));
            ExtensionsKt.setSelectionRange((EditText)$this$duplicateLine, end, end + ExtensionsKt.getSelectedText((EditText)$this$duplicateLine).length());
        } else {
            int currentLine = $this$duplicateLine.getStructure().getLineForIndex($this$duplicateLine.getSelectionStart());
            int lineStart = $this$duplicateLine.getStructure().getIndexForStartOfLine(currentLine);
            int lineEnd = $this$duplicateLine.getStructure().getIndexForEndOfLine(currentLine);
            CharSequence lineText = $this$duplicateLine.getText().subSequence(lineStart, lineEnd);
            $this$duplicateLine.getText().insert(lineEnd, (CharSequence)("\n" + lineText));
        }
    }

    public static final void toggleCase(@NotNull TextProcessor $this$toggleCase) {
        String string;
        boolean bl;
        int end;
        int start;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$toggleCase, (String)"<this>");
            Pair<Integer, Integer> pair = ExtensionsKt.getSelectionPair((EditText)$this$toggleCase);
            start = ((Number)pair.component1()).intValue();
            end = ((Number)pair.component2()).intValue();
            CharSequence $this$all$iv = ExtensionsKt.getSelectedText((EditText)$this$toggleCase);
            boolean $i$f$all = false;
            for (int i = 0; i < $this$all$iv.length(); ++i) {
                char element$iv;
                char p0 = element$iv = $this$all$iv.charAt(i);
                boolean bl2 = false;
                if (Character.isUpperCase(p0)) continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        if (bl) {
            String string2 = ExtensionsKt.getSelectedText((EditText)$this$toggleCase).toLowerCase(Locale.ROOT);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        } else {
            String string3 = ExtensionsKt.getSelectedText((EditText)$this$toggleCase).toUpperCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        }
        String replacedText = string;
        $this$toggleCase.getText().replace(start, end, (CharSequence)replacedText);
        ExtensionsKt.setSelectionRange((EditText)$this$toggleCase, start, start + replacedText.length());
    }

    public static final void moveCaretToStartOfLine(@NotNull TextProcessor $this$moveCaretToStartOfLine) {
        Intrinsics.checkNotNullParameter((Object)$this$moveCaretToStartOfLine, (String)"<this>");
        int currentLine = $this$moveCaretToStartOfLine.getStructure().getLineForIndex($this$moveCaretToStartOfLine.getSelectionStart());
        int lineStart = $this$moveCaretToStartOfLine.getStructure().getIndexForStartOfLine(currentLine);
        ExtensionsKt.setSelectionIndex((EditText)$this$moveCaretToStartOfLine, lineStart);
    }

    public static final void moveCaretToEndOfLine(@NotNull TextProcessor $this$moveCaretToEndOfLine) {
        Intrinsics.checkNotNullParameter((Object)$this$moveCaretToEndOfLine, (String)"<this>");
        int currentLine = $this$moveCaretToEndOfLine.getStructure().getLineForIndex($this$moveCaretToEndOfLine.getSelectionEnd());
        int lineEnd = $this$moveCaretToEndOfLine.getStructure().getIndexForEndOfLine(currentLine);
        ExtensionsKt.setSelectionIndex((EditText)$this$moveCaretToEndOfLine, lineEnd);
    }

    public static final boolean moveCaretToPrevWord(@NotNull TextProcessor $this$moveCaretToPrevWord) {
        block4: {
            boolean isLetterDigitOrUnderscore;
            Intrinsics.checkNotNullParameter((Object)$this$moveCaretToPrevWord, (String)"<this>");
            if ($this$moveCaretToPrevWord.getSelectionStart() <= 0) break block4;
            char currentChar = $this$moveCaretToPrevWord.getText().charAt($this$moveCaretToPrevWord.getSelectionStart() - 1);
            boolean bl = isLetterDigitOrUnderscore = Character.isLetterOrDigit(currentChar) || currentChar == '_';
            if (isLetterDigitOrUnderscore) {
                for (int i = $this$moveCaretToPrevWord.getSelectionStart(); -1 < i; --i) {
                    char c = $this$moveCaretToPrevWord.getText().charAt(i - 1);
                    if (Character.isLetterOrDigit(c) || c == '_') continue;
                    ExtensionsKt.setSelectionIndex((EditText)$this$moveCaretToPrevWord, i);
                    break;
                }
            } else {
                for (int i = $this$moveCaretToPrevWord.getSelectionStart(); -1 < i; --i) {
                    char c = $this$moveCaretToPrevWord.getText().charAt(i - 1);
                    if (!Character.isLetterOrDigit(c) && c != '_') continue;
                    ExtensionsKt.setSelectionIndex((EditText)$this$moveCaretToPrevWord, i);
                    break;
                }
            }
        }
        return true;
    }

    public static final boolean moveCaretToNextWord(@NotNull TextProcessor $this$moveCaretToNextWord) {
        block4: {
            boolean isLetterDigitOrUnderscore;
            Intrinsics.checkNotNullParameter((Object)$this$moveCaretToNextWord, (String)"<this>");
            if ($this$moveCaretToNextWord.getSelectionStart() >= $this$moveCaretToNextWord.getText().length()) break block4;
            char currentChar = $this$moveCaretToNextWord.getText().charAt($this$moveCaretToNextWord.getSelectionStart());
            boolean bl = isLetterDigitOrUnderscore = Character.isLetterOrDigit(currentChar) || currentChar == '_';
            if (isLetterDigitOrUnderscore) {
                int n = $this$moveCaretToNextWord.getText().length();
                for (int i = $this$moveCaretToNextWord.getSelectionStart(); i < n; ++i) {
                    char c = $this$moveCaretToNextWord.getText().charAt(i);
                    if (Character.isLetterOrDigit(c) || c == '_') continue;
                    ExtensionsKt.setSelectionIndex((EditText)$this$moveCaretToNextWord, i);
                    break;
                }
            } else {
                int n = $this$moveCaretToNextWord.getText().length();
                for (int i = $this$moveCaretToNextWord.getSelectionStart(); i < n; ++i) {
                    char c = $this$moveCaretToNextWord.getText().charAt(i);
                    if (!Character.isLetterOrDigit(c) && c != '_') continue;
                    ExtensionsKt.setSelectionIndex((EditText)$this$moveCaretToNextWord, i);
                    break;
                }
            }
        }
        return true;
    }

    public static final void gotoLine(@NotNull TextProcessor $this$gotoLine, int lineNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$gotoLine, (String)"<this>");
        int line = lineNumber - 1;
        if (line < 0 || line >= $this$gotoLine.getStructure().getLineCount() - 1) {
            throw new LineException(lineNumber);
        }
        ExtensionsKt.setSelectionIndex((EditText)$this$gotoLine, $this$gotoLine.getStructure().getIndexForLine(line));
    }

    public static final boolean hasPrimaryClip(@NotNull TextProcessor $this$hasPrimaryClip) {
        ClipboardManager clipboardManager;
        Intrinsics.checkNotNullParameter((Object)$this$hasPrimaryClip, (String)"<this>");
        Context context = $this$hasPrimaryClip.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Context $this$getSystemService$iv = context;
        boolean $i$f$getSystemService = false;
        ClipboardManager clipboardManager2 = clipboardManager = (ClipboardManager)ContextCompat.getSystemService((Context)$this$getSystemService$iv, ClipboardManager.class);
        return clipboardManager2 != null ? clipboardManager2.hasPrimaryClip() : false;
    }
}

