/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit.model;

import com.blacksquircle.ui.editorkit.model.TextChange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\b\u0012\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0000J\u0011\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\bH\u0086\u0002J\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0004J\u0006\u0010\u0016\u001a\u00020\u0014J\b\u0010\u0017\u001a\u00020\u000eH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/blacksquircle/ui/editorkit/model/UndoStack;", "", "stack", "", "Lcom/blacksquircle/ui/editorkit/model/TextChange;", "(Ljava/util/List;)V", "()V", "currentSize", "", "size", "getSize", "()I", "", "canUndo", "", "clone", "get", "index", "pop", "push", "", "textChange", "removeAll", "removeLast", "Companion", "editorkit_release"})
public final class UndoStack {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<TextChange> stack = new ArrayList();
    private int currentSize;
    public static final int MAX_SIZE = Integer.MAX_VALUE;

    public UndoStack() {
    }

    public final int getSize() {
        return this.stack.size();
    }

    private UndoStack(List<TextChange> stack) {
        this();
        this.stack = CollectionsKt.toMutableList((Collection)stack);
    }

    @NotNull
    public final TextChange get(int index) {
        return this.stack.get(index);
    }

    @NotNull
    public final TextChange pop() {
        TextChange item = this.stack.get(this.getSize() - 1);
        this.stack.remove(this.getSize() - 1);
        this.currentSize -= item.getNewText().length() + item.getOldText().length();
        return item;
    }

    public final void push(@NotNull TextChange textChange) {
        Intrinsics.checkNotNullParameter((Object)textChange, (String)"textChange");
        int delta = textChange.getNewText().length() + textChange.getOldText().length();
        if (delta < Integer.MAX_VALUE) {
            if (this.getSize() > 0) {
                TextChange previous = this.stack.get(this.getSize() - 1);
                char[] toCharArray = null;
                int length = 0;
                boolean allWhitespace = false;
                boolean allLettersDigits = false;
                if (((CharSequence)textChange.getOldText()).length() == 0 && textChange.getNewText().length() == 1 && ((CharSequence)previous.getOldText()).length() == 0) {
                    if (previous.getStart() + previous.getNewText().length() != textChange.getStart()) {
                        this.stack.add(textChange);
                    } else if (CharsKt.isWhitespace((char)textChange.getNewText().charAt(0))) {
                        allWhitespace = true;
                        char[] cArray = previous.getNewText().toCharArray();
                        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
                        toCharArray = cArray;
                        length = toCharArray.length;
                        for (i = 0; i < length; ++i) {
                            if (CharsKt.isWhitespace((char)toCharArray[i])) continue;
                            allWhitespace = false;
                        }
                        if (allWhitespace) {
                            previous.setNewText(previous.getNewText() + textChange.getNewText());
                        } else {
                            this.stack.add(textChange);
                        }
                    } else if (Character.isLetterOrDigit(textChange.getNewText().charAt(0))) {
                        allLettersDigits = true;
                        char[] cArray = previous.getNewText().toCharArray();
                        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
                        toCharArray = cArray;
                        length = toCharArray.length;
                        while (i < length) {
                            if (!Character.isLetterOrDigit(toCharArray[i])) {
                                allLettersDigits = false;
                            }
                            ++i;
                        }
                        if (allLettersDigits) {
                            previous.setNewText(previous.getNewText() + textChange.getNewText());
                        } else {
                            this.stack.add(textChange);
                        }
                    } else {
                        this.stack.add(textChange);
                    }
                } else if (textChange.getOldText().length() != 1 || ((CharSequence)textChange.getNewText()).length() > 0 || ((CharSequence)previous.getNewText()).length() > 0) {
                    this.stack.add(textChange);
                } else if (previous.getStart() - 1 != textChange.getStart()) {
                    this.stack.add(textChange);
                } else if (CharsKt.isWhitespace((char)textChange.getOldText().charAt(0))) {
                    allWhitespace = true;
                    char[] cArray = previous.getOldText().toCharArray();
                    Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
                    toCharArray = cArray;
                    length = toCharArray.length;
                    while (i < length) {
                        if (!CharsKt.isWhitespace((char)toCharArray[i])) {
                            allWhitespace = false;
                        }
                        ++i;
                    }
                    if (allWhitespace) {
                        previous.setOldText(textChange.getOldText() + previous.getOldText());
                        previous.setStart(previous.getStart() - textChange.getOldText().length());
                    } else {
                        this.stack.add(textChange);
                    }
                } else if (Character.isLetterOrDigit(textChange.getOldText().charAt(0))) {
                    allLettersDigits = true;
                    char[] cArray = previous.getOldText().toCharArray();
                    Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
                    toCharArray = cArray;
                    length = toCharArray.length;
                    while (i < length) {
                        if (!Character.isLetterOrDigit(toCharArray[i])) {
                            allLettersDigits = false;
                        }
                        ++i;
                    }
                    if (allLettersDigits) {
                        previous.setOldText(textChange.getOldText() + previous.getOldText());
                        previous.setStart(previous.getStart() - textChange.getOldText().length());
                    } else {
                        this.stack.add(textChange);
                    }
                } else {
                    this.stack.add(textChange);
                }
            } else {
                this.stack.add(textChange);
            }
            this.currentSize += delta;
            while (this.currentSize > Integer.MAX_VALUE) {
                if (this.removeLast()) continue;
                return;
            }
            return;
        }
        this.removeAll();
    }

    public final void removeAll() {
        this.currentSize = 0;
        this.stack.clear();
    }

    public final boolean canUndo() {
        return this.getSize() > 0;
    }

    @NotNull
    public final UndoStack clone() {
        return new UndoStack(this.stack);
    }

    private final boolean removeLast() {
        if (this.getSize() <= 0) {
            return false;
        }
        TextChange item = this.stack.get(0);
        this.stack.remove(0);
        this.currentSize -= item.getNewText().length() + item.getOldText().length();
        return true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/blacksquircle/ui/editorkit/model/UndoStack$Companion;", "", "()V", "MAX_SIZE", "", "editorkit_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

