/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit.plugin.autoindent;

import android.util.Log;
import android.widget.EditText;
import com.blacksquircle.ui.editorkit.ExtensionsKt;
import com.blacksquircle.ui.editorkit.model.TextChange;
import com.blacksquircle.ui.editorkit.plugin.base.EditorPlugin;
import com.blacksquircle.ui.editorkit.widget.TextProcessor;
import com.blacksquircle.ui.language.base.model.TextStructure;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u001d\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\u0010\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 H\u0016J*\u0010!\u001a\u00020\u00132\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/blacksquircle/ui/editorkit/plugin/autoindent/AutoIndentPlugin;", "Lcom/blacksquircle/ui/editorkit/plugin/base/EditorPlugin;", "()V", "autoCloseBrackets", "", "getAutoCloseBrackets", "()Z", "setAutoCloseBrackets", "(Z)V", "autoCloseQuotes", "getAutoCloseQuotes", "setAutoCloseQuotes", "autoIndentLines", "getAutoIndentLines", "setAutoIndentLines", "isAutoIndenting", "newText", "", "completeIndentation", "", "start", "", "count", "executeIndentation", "", "(I)[Ljava/lang/String;", "getIndentationForLine", "line", "getIndentationForOffset", "offset", "onAttached", "editText", "Lcom/blacksquircle/ui/editorkit/widget/TextProcessor;", "onTextChanged", "text", "", "before", "Companion", "editorkit_release"})
public final class AutoIndentPlugin
extends EditorPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean autoIndentLines = true;
    private boolean autoCloseBrackets = true;
    private boolean autoCloseQuotes = true;
    @NotNull
    private String newText = "";
    private boolean isAutoIndenting;
    @NotNull
    public static final String PLUGIN_ID = "autoindent-7401";

    public AutoIndentPlugin() {
        super(PLUGIN_ID);
    }

    public final boolean getAutoIndentLines() {
        return this.autoIndentLines;
    }

    public final void setAutoIndentLines(boolean bl) {
        this.autoIndentLines = bl;
    }

    public final boolean getAutoCloseBrackets() {
        return this.autoCloseBrackets;
    }

    public final void setAutoCloseBrackets(boolean bl) {
        this.autoCloseBrackets = bl;
    }

    public final boolean getAutoCloseQuotes() {
        return this.autoCloseQuotes;
    }

    public final void setAutoCloseQuotes(boolean bl) {
        this.autoCloseQuotes = bl;
    }

    @Override
    public void onAttached(@NotNull TextProcessor editText) {
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        super.onAttached(editText);
        Log.d((String)PLUGIN_ID, (String)"AutoIndent plugin loaded successfully!");
    }

    @Override
    public void onTextChanged(@Nullable CharSequence text, int start, int before, int count) {
        super.onTextChanged(text, start, before, count);
        CharSequence charSequence = text;
        this.newText = String.valueOf(charSequence != null ? charSequence.subSequence(start, start + count) : null);
        this.completeIndentation(start, count);
        this.newText = "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void completeIndentation(int start, int count) {
        int n;
        Object object;
        if (this.isAutoIndenting) return;
        String[] result = this.executeIndentation(start);
        if (result[0] != null || result[1] != null) {
            String postText;
            String string;
            String preText;
            String string2 = result[0];
            if (string2 == null) {
                string2 = preText = "";
            }
            if ((string = result[1]) == null) {
                string = postText = "";
            }
            if (Intrinsics.areEqual((Object)preText, (Object)"") && Intrinsics.areEqual((Object)postText, (Object)"")) return;
            object = preText + this.newText + postText;
        } else {
            if (result[2] == null) return;
            object = result[2];
            if (object == null) {
                object = "";
            }
        }
        String replacementValue = object;
        if (result[3] != null) {
            String string = result[3];
            Intrinsics.checkNotNull((Object)string);
            n = Integer.parseInt(string);
        } else {
            n = start + replacementValue.length();
        }
        int newCursorPosition = n;
        this.getEditText().post(() -> AutoIndentPlugin.completeIndentation$lambda$0(this, start, count, replacementValue, newCursorPosition));
    }

    private final String[] executeIndentation(int start) {
        String[] strArr = null;
        if (Intrinsics.areEqual((Object)this.newText, (Object)"\n") && this.autoIndentLines) {
            String prevLineIndentation = this.getIndentationForOffset(start);
            StringBuilder indentation = new StringBuilder(prevLineIndentation);
            int newCursorPosition = indentation.length() + start + 1;
            if (start > 0 && this.getEditText().getText().charAt(start - 1) == '{') {
                indentation.append(this.getEditText().tab());
                newCursorPosition = indentation.length() + start + 1;
            }
            if (start + 1 < this.getEditText().getText().length() && this.getEditText().getText().charAt(start + 1) == '}') {
                indentation.append("\n").append(prevLineIndentation);
            }
            strArr = new String[4];
            strArr[1] = indentation.toString();
            strArr[3] = String.valueOf(newCursorPosition);
            return strArr;
        }
        if (Intrinsics.areEqual((Object)this.newText, (Object)"\"") && this.autoCloseQuotes) {
            if (start + 1 >= this.getEditText().getText().length()) {
                strArr = new String[4];
                strArr[1] = "\"";
                strArr[3] = String.valueOf(start + 1);
                return strArr;
            }
            if (this.getEditText().getText().charAt(start + 1) == '\"' && this.getEditText().getText().charAt(start - 1) != '\\') {
                strArr = new String[4];
                strArr[2] = "";
                strArr[3] = String.valueOf(start + 1);
                return strArr;
            }
            if (this.getEditText().getText().charAt(start + 1) != '\"' || this.getEditText().getText().charAt(start - 1) != '\\') {
                strArr = new String[4];
                strArr[1] = "\"";
                strArr[3] = String.valueOf(start + 1);
                return strArr;
            }
        } else if (Intrinsics.areEqual((Object)this.newText, (Object)"'") && this.autoCloseQuotes) {
            if (start + 1 >= this.getEditText().getText().length()) {
                strArr = new String[4];
                strArr[1] = "'";
                strArr[3] = String.valueOf(start + 1);
                return strArr;
            }
            if (start + 1 >= this.getEditText().getText().length()) {
                strArr = new String[4];
                strArr[1] = "'";
                strArr[3] = String.valueOf(start + 1);
                return strArr;
            }
            if (this.getEditText().getText().charAt(start + 1) == '\'' && start > 0 && this.getEditText().getText().charAt(start - 1) != '\\') {
                strArr = new String[4];
                strArr[2] = "";
                strArr[3] = String.valueOf(start + 1);
                return strArr;
            }
            if (this.getEditText().getText().charAt(start + 1) != '\'' || start <= 0 || this.getEditText().getText().charAt(start - 1) != '\\') {
                strArr = new String[4];
                strArr[1] = "'";
                strArr[3] = String.valueOf(start + 1);
                return strArr;
            }
        } else {
            if (Intrinsics.areEqual((Object)this.newText, (Object)"{") && this.autoCloseBrackets) {
                strArr = new String[4];
                strArr[1] = "}";
                strArr[3] = String.valueOf(start + 1);
                return strArr;
            }
            if (Intrinsics.areEqual((Object)this.newText, (Object)"}") && this.autoCloseBrackets) {
                if (start + 1 < this.getEditText().getText().length() && this.getEditText().getText().charAt(start + 1) == '}') {
                    strArr = new String[4];
                    strArr[2] = "";
                    strArr[3] = String.valueOf(start + 1);
                    return strArr;
                }
            } else {
                if (Intrinsics.areEqual((Object)this.newText, (Object)"(") && this.autoCloseBrackets) {
                    strArr = new String[4];
                    strArr[1] = ")";
                    strArr[3] = String.valueOf(start + 1);
                    return strArr;
                }
                if (Intrinsics.areEqual((Object)this.newText, (Object)")") && this.autoCloseBrackets) {
                    if (start + 1 < this.getEditText().getText().length() && this.getEditText().getText().charAt(start + 1) == ')') {
                        strArr = new String[4];
                        strArr[2] = "";
                        strArr[3] = String.valueOf(start + 1);
                        return strArr;
                    }
                } else {
                    if (Intrinsics.areEqual((Object)this.newText, (Object)"[") && this.autoCloseBrackets) {
                        strArr = new String[4];
                        strArr[1] = "]";
                        strArr[3] = String.valueOf(start + 1);
                        return strArr;
                    }
                    if (Intrinsics.areEqual((Object)this.newText, (Object)"]") && this.autoCloseBrackets && start + 1 < this.getEditText().getText().length() && this.getEditText().getText().charAt(start + 1) == ']') {
                        strArr = new String[4];
                        strArr[2] = "";
                        strArr[3] = String.valueOf(start + 1);
                        return strArr;
                    }
                }
            }
        }
        return new String[4];
    }

    private final String getIndentationForOffset(int offset) {
        return this.getIndentationForLine(this.getStructure().getLineForIndex(offset));
    }

    private final String getIndentationForLine(int line) {
        int start;
        char c;
        int i;
        TextStructure.Line realLine = this.getStructure().getLine(line);
        for (i = start = realLine.getStart(); i < this.getEditText().getText().length() && CharsKt.isWhitespace((char)(c = this.getEditText().getText().charAt(i))) && c != '\n'; ++i) {
        }
        return ((Object)this.getEditText().getText().subSequence(start, i)).toString();
    }

    private static final void completeIndentation$lambda$0(AutoIndentPlugin this$0, int $start, int $count, String $replacementValue, int $newCursorPosition) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$replacementValue, (String)"$replacementValue");
        this$0.isAutoIndenting = true;
        this$0.getEditText().getText().replace($start, $start + $count, (CharSequence)$replacementValue);
        this$0.getUndoStack().pop();
        TextChange change = this$0.getUndoStack().pop();
        if (!Intrinsics.areEqual((Object)$replacementValue, (Object)"")) {
            change.setNewText($replacementValue);
            this$0.getUndoStack().push(change);
        }
        ExtensionsKt.setSelectionIndex((EditText)this$0.getEditText(), $newCursorPosition);
        this$0.isAutoIndenting = false;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/blacksquircle/ui/editorkit/plugin/autoindent/AutoIndentPlugin$Companion;", "", "()V", "PLUGIN_ID", "", "editorkit_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

