/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit.plugin.delimiters;

import android.text.style.BackgroundColorSpan;
import android.util.Log;
import com.blacksquircle.ui.editorkit.model.ColorScheme;
import com.blacksquircle.ui.editorkit.plugin.base.EditorPlugin;
import com.blacksquircle.ui.editorkit.widget.TextProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/blacksquircle/ui/editorkit/plugin/delimiters/BracketsHighlightPlugin;", "Lcom/blacksquircle/ui/editorkit/plugin/base/EditorPlugin;", "()V", "closedDelimiterSpan", "Landroid/text/style/BackgroundColorSpan;", "delimiters", "", "openDelimiterSpan", "checkMatchingBracket", "", "pos", "", "onAttached", "editText", "Lcom/blacksquircle/ui/editorkit/widget/TextProcessor;", "onColorSchemeChanged", "colorScheme", "Lcom/blacksquircle/ui/editorkit/model/ColorScheme;", "onSelectionChanged", "selStart", "selEnd", "showBracket", "i", "j", "Companion", "editorkit_release"})
public final class BracketsHighlightPlugin
extends EditorPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final char[] delimiters;
    @NotNull
    private BackgroundColorSpan openDelimiterSpan;
    @NotNull
    private BackgroundColorSpan closedDelimiterSpan;
    @NotNull
    public static final String PLUGIN_ID = "brackets-highlight-1180";

    public BracketsHighlightPlugin() {
        super(PLUGIN_ID);
        char[] cArray = new char[]{'{', '[', '(', '<', '}', ']', ')', '>'};
        this.delimiters = cArray;
        this.openDelimiterSpan = new BackgroundColorSpan(-7829368);
        this.closedDelimiterSpan = new BackgroundColorSpan(-7829368);
    }

    @Override
    public void onAttached(@NotNull TextProcessor editText) {
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        super.onAttached(editText);
        Log.d((String)PLUGIN_ID, (String)"BracketsHighlight plugin loaded successfully!");
    }

    @Override
    public void onColorSchemeChanged(@NotNull ColorScheme colorScheme) {
        Intrinsics.checkNotNullParameter((Object)colorScheme, (String)"colorScheme");
        super.onColorSchemeChanged(colorScheme);
        this.openDelimiterSpan = new BackgroundColorSpan(colorScheme.getDelimiterBackgroundColor());
        this.closedDelimiterSpan = new BackgroundColorSpan(colorScheme.getDelimiterBackgroundColor());
    }

    @Override
    public void onSelectionChanged(int selStart, int selEnd) {
        super.onSelectionChanged(selStart, selEnd);
        if (selStart == selEnd) {
            this.checkMatchingBracket(selStart);
        }
    }

    private final void checkMatchingBracket(int pos) {
        if (this.getEditText().getLayout() == null) {
            return;
        }
        this.getEditText().getText().removeSpan((Object)this.openDelimiterSpan);
        this.getEditText().getText().removeSpan((Object)this.closedDelimiterSpan);
        if (pos > 0 && pos <= this.getEditText().getText().length()) {
            char c1 = this.getEditText().getText().charAt(pos - 1);
            int n = this.delimiters.length;
            block0: for (int i = 0; i < n; ++i) {
                int k;
                if (this.delimiters[i] != c1) continue;
                int half = this.delimiters.length / 2;
                boolean open = i <= half - 1;
                char c2 = this.delimiters[(i + half) % this.delimiters.length];
                if (open) {
                    int nob = 1;
                    for (k = pos; k < this.getEditText().getText().length(); ++k) {
                        if (this.getEditText().getText().charAt(k) == c2) {
                            --nob;
                        }
                        if (this.getEditText().getText().charAt(k) == c1) {
                            ++nob;
                        }
                        if (nob != 0) continue;
                        this.showBracket(pos - 1, k);
                        continue block0;
                    }
                    continue;
                }
                int ncb = 1;
                k -= 2;
                while (k >= 0) {
                    if (this.getEditText().getText().charAt(k) == c2) {
                        --ncb;
                    }
                    if (this.getEditText().getText().charAt(k) == c1) {
                        ++ncb;
                    }
                    if (ncb == 0) {
                        this.showBracket(k, pos - 1);
                        continue block0;
                    }
                    --k;
                }
            }
        }
    }

    private final void showBracket(int i, int j) {
        this.getEditText().getText().setSpan((Object)this.openDelimiterSpan, i, i + 1, 33);
        this.getEditText().getText().setSpan((Object)this.closedDelimiterSpan, j, j + 1, 33);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/blacksquircle/ui/editorkit/plugin/delimiters/BracketsHighlightPlugin$Companion;", "", "()V", "PLUGIN_ID", "", "editorkit_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

