/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit.plugin.linenumbers;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.Editable;
import android.util.Log;
import android.widget.TextView;
import com.blacksquircle.ui.editorkit.model.ColorScheme;
import com.blacksquircle.ui.editorkit.plugin.base.EditorPlugin;
import com.blacksquircle.ui.editorkit.utils.ExtensionsKt;
import com.blacksquircle.ui.editorkit.widget.TextProcessor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\u00020\u0001:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0012\u0010\u001a\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0016J\u0012\u0010#\u001a\u00020\u00172\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&H\u0016J\u0012\u0010'\u001a\u00020\u00172\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\b\u0010*\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000f\"\u0004\b\u0014\u0010\u0011R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/blacksquircle/ui/editorkit/plugin/linenumbers/LineNumbersPlugin;", "Lcom/blacksquircle/ui/editorkit/plugin/base/EditorPlugin;", "()V", "gutterCurrentLineNumberPaint", "Landroid/graphics/Paint;", "gutterDigitCount", "", "gutterDividerPaint", "gutterMargin", "gutterPaint", "gutterTextPaint", "gutterWidth", "highlightCurrentLine", "", "getHighlightCurrentLine", "()Z", "setHighlightCurrentLine", "(Z)V", "lineNumbers", "getLineNumbers", "setLineNumbers", "selectedLinePaint", "afterTextChanged", "", "text", "Landroid/text/Editable;", "drawBehind", "canvas", "Landroid/graphics/Canvas;", "onAttached", "editText", "Lcom/blacksquircle/ui/editorkit/widget/TextProcessor;", "onColorSchemeChanged", "colorScheme", "Lcom/blacksquircle/ui/editorkit/model/ColorScheme;", "onDraw", "setTextSize", "size", "", "setTypeface", "tf", "Landroid/graphics/Typeface;", "updateGutter", "Companion", "editorkit_release"})
public final class LineNumbersPlugin
extends EditorPlugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean lineNumbers = true;
    private boolean highlightCurrentLine = true;
    @NotNull
    private final Paint selectedLinePaint = new Paint();
    @NotNull
    private final Paint gutterPaint = new Paint();
    @NotNull
    private final Paint gutterDividerPaint = new Paint();
    @NotNull
    private final Paint gutterCurrentLineNumberPaint = new Paint();
    @NotNull
    private final Paint gutterTextPaint = new Paint();
    private final int gutterMargin = com.blacksquircle.ui.editorkit.plugin.linenumbers.LineNumbersPlugin$Companion.access$getDp(Companion, 4);
    private int gutterWidth;
    private int gutterDigitCount;
    @NotNull
    public static final String PLUGIN_ID = "line-numbers-1141";

    public LineNumbersPlugin() {
        super(PLUGIN_ID);
    }

    public final boolean getLineNumbers() {
        return this.lineNumbers;
    }

    public final void setLineNumbers(boolean bl) {
        this.lineNumbers = bl;
    }

    public final boolean getHighlightCurrentLine() {
        return this.highlightCurrentLine;
    }

    public final void setHighlightCurrentLine(boolean bl) {
        this.highlightCurrentLine = bl;
    }

    @Override
    public void onAttached(@NotNull TextProcessor editText) {
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        super.onAttached(editText);
        Log.d((String)PLUGIN_ID, (String)"LineNumbers plugin loaded successfully!");
    }

    @Override
    public void onColorSchemeChanged(@NotNull ColorScheme colorScheme) {
        Intrinsics.checkNotNullParameter((Object)colorScheme, (String)"colorScheme");
        super.onColorSchemeChanged(colorScheme);
        this.selectedLinePaint.setColor(colorScheme.getSelectedLineColor());
        this.selectedLinePaint.setAntiAlias(false);
        this.selectedLinePaint.setDither(false);
        this.gutterPaint.setColor(colorScheme.getGutterColor());
        this.gutterPaint.setAntiAlias(false);
        this.gutterPaint.setDither(false);
        this.gutterDividerPaint.setColor(colorScheme.getGutterDividerColor());
        this.gutterDividerPaint.setAntiAlias(false);
        this.gutterDividerPaint.setDither(false);
        this.gutterDividerPaint.setStyle(Paint.Style.STROKE);
        this.gutterDividerPaint.setStrokeWidth(2.6f);
        this.gutterCurrentLineNumberPaint.setTextSize(this.requireContext().getResources().getDisplayMetrics().scaledDensity * this.getEditText().getTextSize());
        this.gutterCurrentLineNumberPaint.setColor(colorScheme.getGutterCurrentLineNumberColor());
        this.gutterCurrentLineNumberPaint.setAntiAlias(true);
        this.gutterCurrentLineNumberPaint.setDither(false);
        this.gutterCurrentLineNumberPaint.setTextAlign(Paint.Align.RIGHT);
        this.gutterTextPaint.setTextSize(this.requireContext().getResources().getDisplayMetrics().scaledDensity * this.getEditText().getTextSize());
        this.gutterTextPaint.setColor(colorScheme.getGutterTextColor());
        this.gutterTextPaint.setAntiAlias(true);
        this.gutterTextPaint.setDither(false);
        this.gutterTextPaint.setTextAlign(Paint.Align.RIGHT);
    }

    @Override
    public void drawBehind(@Nullable Canvas canvas) {
        int currentLineStart;
        super.drawBehind(canvas);
        if (this.highlightCurrentLine && (currentLineStart = this.getStructure().getLineForIndex(this.getEditText().getSelectionStart())) == this.getStructure().getLineForIndex(this.getEditText().getSelectionEnd())) {
            if (this.getEditText().getLayout() == null) {
                return;
            }
            int selectedLineStartIndex = this.getStructure().getIndexForStartOfLine(currentLineStart);
            int selectedLineEndIndex = this.getStructure().getIndexForEndOfLine(currentLineStart);
            int topVisualLine = this.getEditText().getLayout().getLineForOffset(selectedLineStartIndex);
            int bottomVisualLine = this.getEditText().getLayout().getLineForOffset(selectedLineEndIndex);
            int lineTop = this.getEditText().getLayout().getLineTop(topVisualLine) + this.getEditText().getPaddingTop();
            int lineBottom = this.getEditText().getLayout().getLineBottom(bottomVisualLine) + this.getEditText().getPaddingTop();
            int width = this.getEditText().getLayout().getWidth() + this.getEditText().getPaddingLeft() + this.getEditText().getPaddingRight();
            Canvas canvas2 = canvas;
            if (canvas2 != null) {
                canvas2.drawRect((float)this.gutterWidth, (float)lineTop, (float)width, (float)lineBottom, this.selectedLinePaint);
            }
        }
        this.updateGutter();
    }

    @Override
    public void onDraw(@Nullable Canvas canvas) {
        block6: {
            super.onDraw(canvas);
            if (!this.lineNumbers) break block6;
            int currentLineStart = this.getStructure().getLineForIndex(this.getEditText().getSelectionStart());
            Canvas canvas2 = canvas;
            if (canvas2 != null) {
                canvas2.drawRect((float)this.getEditText().getScrollX(), (float)this.getEditText().getScrollY(), (float)(this.gutterWidth + this.getEditText().getScrollX()), (float)(this.getEditText().getScrollY() + this.getEditText().getHeight()), this.gutterPaint);
            }
            int topVisibleLine = ExtensionsKt.getTopVisibleLine((TextView)this.getEditText());
            topVisibleLine = topVisibleLine >= 2 ? (topVisibleLine -= 2) : 0;
            int prevLineNumber = -1;
            int textRight = this.gutterWidth - this.gutterMargin / 2 + this.getEditText().getScrollX();
            while (topVisibleLine <= ExtensionsKt.getBottomVisibleLine((TextView)this.getEditText())) {
                if (this.getEditText().getLayout() == null) {
                    return;
                }
                int number = this.getStructure().getLineForIndex(this.getEditText().getLayout().getLineStart(topVisibleLine));
                if (number != prevLineNumber) {
                    Canvas canvas3 = canvas;
                    if (canvas3 != null) {
                        canvas3.drawText(String.valueOf(number + 1), (float)textRight, (float)this.getEditText().getLayout().getLineBaseline(topVisibleLine) + (float)this.getEditText().getPaddingTop(), number == currentLineStart && this.highlightCurrentLine ? this.gutterCurrentLineNumberPaint : this.gutterTextPaint);
                    }
                }
                prevLineNumber = number;
                ++topVisibleLine;
            }
            Canvas canvas4 = canvas;
            if (canvas4 != null) {
                canvas4.drawLine((float)(this.gutterWidth + this.getEditText().getScrollX()), (float)this.getEditText().getScrollY(), (float)(this.gutterWidth + this.getEditText().getScrollX()), (float)(this.getEditText().getScrollY() + this.getEditText().getHeight()), this.gutterDividerPaint);
            }
        }
    }

    @Override
    public void afterTextChanged(@Nullable Editable text) {
        super.afterTextChanged(text);
        this.updateGutter();
    }

    @Override
    public void setTextSize(float size) {
        super.setTextSize(size);
        this.gutterCurrentLineNumberPaint.setTextSize(this.getEditText().getTextSize());
        this.gutterTextPaint.setTextSize(this.getEditText().getTextSize());
    }

    @Override
    public void setTypeface(@Nullable Typeface tf) {
        super.setTypeface(tf);
        this.gutterCurrentLineNumberPaint.setTypeface(tf);
        this.gutterTextPaint.setTypeface(tf);
    }

    private final void updateGutter() {
        if (this.lineNumbers) {
            int count = 3;
            int widestNumber = 0;
            float widestWidth = 0.0f;
            this.gutterDigitCount = String.valueOf(this.getStructure().getLineCount()).length();
            for (int i = 0; i < 10; ++i) {
                float width = this.getEditText().getPaint().measureText(String.valueOf(i));
                if (!(width > widestWidth)) continue;
                widestNumber = i;
                widestWidth = width;
            }
            if (this.gutterDigitCount >= count) {
                count = this.gutterDigitCount;
            }
            StringBuilder builder = new StringBuilder();
            int n = count;
            for (int i = 0; i < n; ++i) {
                builder.append(String.valueOf(widestNumber));
            }
            this.gutterWidth = (int)this.getEditText().getPaint().measureText(builder.toString());
            this.gutterWidth += this.gutterMargin;
        }
        if (this.getEditText().getPaddingStart() != this.gutterWidth + this.gutterMargin) {
            this.getEditText().setPadding(this.gutterWidth + this.gutterMargin, this.gutterMargin, this.getEditText().getPaddingEnd(), this.getEditText().getPaddingBottom());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/blacksquircle/ui/editorkit/plugin/linenumbers/LineNumbersPlugin$Companion;", "", "()V", "PLUGIN_ID", "", "dp", "", "getDp", "(I)I", "editorkit_release"})
    public static final class Companion {
        private Companion() {
        }

        private final int getDp(int $this$dp) {
            return (int)((float)$this$dp * Resources.getSystem().getDisplayMetrics().density);
        }

        public static final /* synthetic */ int access$getDp(Companion $this, int $receiver) {
            return $this.getDp($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

