/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.TypedArrayKt;
import com.blacksquircle.ui.editorkit.R;
import com.blacksquircle.ui.editorkit.widget.internal.ScrollableEditText;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 ?2\u00020\u00012\u00020\u0002:\u0002?@B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010+\u001a\u00020,2\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010-\u001a\u00020,J\b\u0010.\u001a\u00020,H\u0002J\b\u0010/\u001a\u00020\"H\u0002J\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\"2\u0006\u00103\u001a\u00020\"H\u0002J\b\u00104\u001a\u000201H\u0002J\u0010\u00105\u001a\u00020,2\u0006\u00106\u001a\u000207H\u0014J(\u00108\u001a\u00020,2\u0006\u00102\u001a\u00020\b2\u0006\u00103\u001a\u00020\b2\u0006\u00109\u001a\u00020\b2\u0006\u0010:\u001a\u00020\bH\u0016J\u0010\u0010;\u001a\u0002012\u0006\u0010<\u001a\u00020=H\u0017J\b\u0010>\u001a\u00020,H\u0002R#\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0015\u001a\n \f*\u0004\u0018\u00010\u000b0\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0010\u001a\u0004\b\u0016\u0010\u000eR\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/blacksquircle/ui/editorkit/widget/TextScroller;", "Landroid/view/View;", "Lcom/blacksquircle/ui/editorkit/widget/internal/ScrollableEditText$OnScrollChangedListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "draggingBitmap", "Landroid/graphics/Bitmap;", "kotlin.jvm.PlatformType", "getDraggingBitmap", "()Landroid/graphics/Bitmap;", "draggingBitmap$delegate", "Lkotlin/Lazy;", "hideCallback", "Ljava/lang/Runnable;", "hideHandler", "Landroid/os/Handler;", "normalBitmap", "getNormalBitmap", "normalBitmap$delegate", "scrollableEditText", "Lcom/blacksquircle/ui/editorkit/widget/internal/ScrollableEditText;", "value", "Lcom/blacksquircle/ui/editorkit/widget/TextScroller$State;", "state", "getState", "()Lcom/blacksquircle/ui/editorkit/widget/TextScroller$State;", "setState", "(Lcom/blacksquircle/ui/editorkit/widget/TextScroller$State;)V", "textScrollMax", "", "textScrollY", "thumbDragging", "Landroid/graphics/drawable/Drawable;", "thumbHeight", "thumbNormal", "thumbPaint", "Landroid/graphics/Paint;", "thumbTop", "attachTo", "", "detach", "getMeasurements", "getThumbTop", "isPointInThumb", "", "x", "y", "isShowScrollerJustified", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onScrollChanged", "oldX", "oldY", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "scrollView", "Companion", "State", "editorkit_release"})
public class TextScroller
extends View
implements ScrollableEditText.OnScrollChangedListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private State state;
    @Nullable
    private ScrollableEditText scrollableEditText;
    @NotNull
    private final Lazy normalBitmap$delegate;
    @NotNull
    private final Lazy draggingBitmap$delegate;
    private final int thumbHeight;
    @NotNull
    private final Drawable thumbNormal;
    @NotNull
    private final Drawable thumbDragging;
    @NotNull
    private final Handler hideHandler;
    @NotNull
    private final Runnable hideCallback;
    @NotNull
    private final Paint thumbPaint;
    private float thumbTop;
    private float textScrollMax;
    private float textScrollY;
    private static final int ALPHA_MAX = 225;
    private static final int ALPHA_STEP = 25;
    private static final int ALPHA_MIN = 0;
    private static final long EXITING_DELAY = 17L;
    private static final long TIME_EXITING = 2000L;

    @JvmOverloads
    public TextScroller(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Drawable drawable2;
        Drawable drawable3;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.state = State.HIDDEN;
        this.normalBitmap$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Bitmap>(this){
            final /* synthetic */ TextScroller this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Bitmap invoke() {
                Bitmap bitmap = Bitmap.createBitmap((int)this.this$0.getWidth(), (int)TextScroller.access$getThumbHeight$p(this.this$0), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                TextScroller.access$getThumbNormal$p(this.this$0).setBounds(new Rect(0, 0, this.this$0.getWidth(), TextScroller.access$getThumbHeight$p(this.this$0)));
                TextScroller.access$getThumbNormal$p(this.this$0).draw(new Canvas(bitmap));
                return bitmap;
            }
        }));
        this.draggingBitmap$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Bitmap>(this){
            final /* synthetic */ TextScroller this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Bitmap invoke() {
                Bitmap bitmap = Bitmap.createBitmap((int)this.this$0.getWidth(), (int)TextScroller.access$getThumbHeight$p(this.this$0), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                TextScroller.access$getThumbDragging$p(this.this$0).setBounds(new Rect(0, 0, this.this$0.getWidth(), TextScroller.access$getThumbHeight$p(this.this$0)));
                TextScroller.access$getThumbDragging$p(this.this$0).draw(new Canvas(bitmap));
                return bitmap;
            }
        }));
        this.hideHandler = new Handler(Looper.getMainLooper());
        this.hideCallback = () -> TextScroller.hideCallback$lambda$0(this);
        this.thumbPaint = new Paint();
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TextScroller, 0, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.theme.obtainStyl\u2026eable.TextScroller, 0, 0)");
        TypedArray typedArray2 = typedArray;
        boolean hasThumbNormal = typedArray2.hasValue(R.styleable.TextScroller_thumbNormal);
        boolean hasThumbDragging = typedArray2.hasValue(R.styleable.TextScroller_thumbDragging);
        boolean hasThumbTint = typedArray2.hasValue(R.styleable.TextScroller_thumbTint);
        if (hasThumbNormal) {
            drawable3 = TypedArrayKt.getDrawableOrThrow((TypedArray)typedArray2, (int)R.styleable.TextScroller_thumbNormal);
        } else {
            Drawable drawable4 = ContextCompat.getDrawable((Context)context, (int)R.drawable.fastscroll_default);
            Intrinsics.checkNotNull((Object)drawable4);
            drawable3 = drawable4;
            Intrinsics.checkNotNullExpressionValue((Object)drawable4, (String)"{\n            ContextCom\u2026roll_default)!!\n        }");
        }
        this.thumbNormal = drawable3;
        if (hasThumbDragging) {
            drawable2 = TypedArrayKt.getDrawableOrThrow((TypedArray)typedArray2, (int)R.styleable.TextScroller_thumbDragging);
        } else {
            Drawable drawable5 = ContextCompat.getDrawable((Context)context, (int)R.drawable.fastscroll_pressed);
            Intrinsics.checkNotNull((Object)drawable5);
            drawable2 = drawable5;
            Intrinsics.checkNotNullExpressionValue((Object)drawable5, (String)"{\n            ContextCom\u2026roll_pressed)!!\n        }");
        }
        this.thumbDragging = drawable2;
        if (hasThumbTint) {
            int thumbTint = TypedArrayKt.getColorOrThrow((TypedArray)typedArray2, (int)R.styleable.TextScroller_thumbTint);
            this.thumbNormal.setTint(thumbTint);
            this.thumbDragging.setTint(thumbTint);
        }
        this.thumbHeight = this.thumbNormal.getIntrinsicHeight();
        this.thumbPaint.setAntiAlias(true);
        this.thumbPaint.setDither(false);
        this.thumbPaint.setAlpha(225);
        typedArray2.recycle();
    }

    public /* synthetic */ TextScroller(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @NotNull
    public final State getState() {
        return this.state;
    }

    public final void setState(@NotNull State value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        switch (WhenMappings.$EnumSwitchMapping$0[value.ordinal()]) {
            case 1: {
                this.hideHandler.removeCallbacks(this.hideCallback);
                this.state = value;
                this.invalidate();
                break;
            }
            case 2: {
                if (!this.isShowScrollerJustified()) break;
                this.hideHandler.removeCallbacks(this.hideCallback);
                this.state = value;
                this.invalidate();
                break;
            }
            case 3: {
                this.hideHandler.removeCallbacks(this.hideCallback);
                this.state = value;
                this.invalidate();
                break;
            }
            case 4: {
                this.hideHandler.removeCallbacks(this.hideCallback);
                this.state = value;
                this.invalidate();
            }
        }
    }

    private final Bitmap getNormalBitmap() {
        Lazy lazy = this.normalBitmap$delegate;
        return (Bitmap)lazy.getValue();
    }

    private final Bitmap getDraggingBitmap() {
        Lazy lazy = this.draggingBitmap$delegate;
        return (Bitmap)lazy.getValue();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                return;
            }
            case 2: {
                this.thumbPaint.setAlpha(225);
                canvas.drawBitmap(this.getNormalBitmap(), 0.0f, this.thumbTop, this.thumbPaint);
                break;
            }
            case 3: {
                this.thumbPaint.setAlpha(225);
                canvas.drawBitmap(this.getDraggingBitmap(), 0.0f, this.thumbTop, this.thumbPaint);
                break;
            }
            case 4: {
                if (this.thumbPaint.getAlpha() > 25) {
                    this.thumbPaint.setAlpha(this.thumbPaint.getAlpha() - 25);
                    canvas.drawBitmap(this.getNormalBitmap(), 0.0f, this.thumbTop, this.thumbPaint);
                    this.getHandler().postDelayed(this.hideCallback, 17L);
                    break;
                }
                this.thumbPaint.setAlpha(0);
                this.setState(State.HIDDEN);
            }
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.scrollableEditText == null || this.state == State.HIDDEN) {
            return false;
        }
        this.getMeasurements();
        switch (event.getAction()) {
            case 0: {
                if (!this.isPointInThumb(event.getX(), event.getY())) break;
                ScrollableEditText scrollableEditText = this.scrollableEditText;
                if (scrollableEditText != null) {
                    scrollableEditText.abortFling();
                }
                this.setState(State.DRAGGING);
                this.setPressed(true);
                return true;
            }
            case 1: {
                this.setState(State.VISIBLE);
                this.setPressed(false);
                this.hideHandler.postDelayed(this.hideCallback, 2000L);
                break;
            }
            case 2: {
                if (this.state != State.DRAGGING) break;
                this.setPressed(true);
                ScrollableEditText scrollableEditText = this.scrollableEditText;
                if (scrollableEditText != null) {
                    scrollableEditText.abortFling();
                }
                int newThumbTop = (int)event.getY() - this.thumbHeight / 2;
                if (newThumbTop < 0) {
                    newThumbTop = 0;
                } else if (this.thumbHeight + newThumbTop > this.getHeight() - this.getPaddingBottom()) {
                    newThumbTop = this.getHeight() - this.getPaddingBottom() - this.thumbHeight;
                }
                this.thumbTop = newThumbTop;
                this.scrollView();
                this.invalidate();
                return true;
            }
        }
        return false;
    }

    @Override
    public void onScrollChanged(int x, int y, int oldX, int oldY) {
        if (this.state != State.DRAGGING) {
            this.getMeasurements();
            this.setState(State.VISIBLE);
            this.hideHandler.postDelayed(this.hideCallback, 2000L);
        }
    }

    public final void attachTo(@NotNull ScrollableEditText scrollableEditText) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)scrollableEditText), (String)"scrollableEditText");
            ScrollableEditText scrollableEditText2 = this.scrollableEditText = scrollableEditText;
            if (scrollableEditText2 == null) break block0;
            scrollableEditText2.addOnScrollChangedListener(this);
        }
    }

    public final void detach() {
        ScrollableEditText scrollableEditText = this.scrollableEditText;
        if (scrollableEditText != null) {
            scrollableEditText.removeOnScrollChangedListener(this);
        }
        this.scrollableEditText = null;
    }

    private final void scrollView() {
        block1: {
            if (this.scrollableEditText == null) {
                return;
            }
            float scrollToAsFraction = this.thumbTop / (float)(this.getHeight() - this.getPaddingBottom() - this.thumbHeight);
            ScrollableEditText scrollableEditText = this.scrollableEditText;
            Intrinsics.checkNotNull((Object)((Object)scrollableEditText));
            int lineHeight = scrollableEditText.getLineHeight();
            ScrollableEditText scrollableEditText2 = this.scrollableEditText;
            Intrinsics.checkNotNull((Object)((Object)scrollableEditText2));
            int n = scrollableEditText2.getHeight();
            ScrollableEditText scrollableEditText3 = this.scrollableEditText;
            Intrinsics.checkNotNull((Object)((Object)scrollableEditText3));
            int textAreaHeight = n - scrollableEditText3.getPaddingBottom();
            ScrollableEditText scrollableEditText4 = this.scrollableEditText;
            if (scrollableEditText4 == null) break block1;
            ScrollableEditText scrollableEditText5 = this.scrollableEditText;
            Intrinsics.checkNotNull((Object)((Object)scrollableEditText5));
            scrollableEditText4.scrollTo(scrollableEditText5.getScrollX(), (int)(this.textScrollMax * scrollToAsFraction - scrollToAsFraction * (float)(textAreaHeight - lineHeight)));
        }
    }

    private final void getMeasurements() {
        if (this.scrollableEditText == null) {
            return;
        }
        ScrollableEditText scrollableEditText = this.scrollableEditText;
        this.textScrollMax = scrollableEditText != null && (scrollableEditText = scrollableEditText.getLayout()) != null ? (float)scrollableEditText.getHeight() : 0.0f;
        ScrollableEditText scrollableEditText2 = this.scrollableEditText;
        this.textScrollY = scrollableEditText2 != null ? (float)scrollableEditText2.getScrollY() : 0.0f;
        this.thumbTop = this.getThumbTop();
    }

    private final float getThumbTop() {
        if (this.scrollableEditText == null) {
            return 0.0f;
        }
        ScrollableEditText scrollableEditText = this.scrollableEditText;
        Intrinsics.checkNotNull((Object)((Object)scrollableEditText));
        int lineHeight = scrollableEditText.getLineHeight();
        ScrollableEditText scrollableEditText2 = this.scrollableEditText;
        Intrinsics.checkNotNull((Object)((Object)scrollableEditText2));
        int n = scrollableEditText2.getHeight();
        ScrollableEditText scrollableEditText3 = this.scrollableEditText;
        Intrinsics.checkNotNull((Object)((Object)scrollableEditText3));
        int textAreaHeight = n - scrollableEditText3.getPaddingBottom();
        float calculatedThumbTop = (float)(this.getHeight() - this.getPaddingBottom() - this.thumbHeight) * (this.textScrollY / (this.textScrollMax - (float)textAreaHeight + (float)lineHeight));
        float absoluteThumbTop = !Float.isNaN(calculatedThumbTop) ? calculatedThumbTop : 0.0f;
        return absoluteThumbTop > (float)(this.getHeight() - this.getPaddingBottom() - this.thumbHeight) ? (float)(this.getHeight() - this.getPaddingBottom() - this.thumbHeight) : absoluteThumbTop;
    }

    private final boolean isPointInThumb(float x, float y) {
        return x >= 0.0f && x <= (float)this.getWidth() && y >= this.thumbTop && y <= this.thumbTop + (float)this.thumbHeight;
    }

    private final boolean isShowScrollerJustified() {
        ScrollableEditText scrollableEditText = this.scrollableEditText;
        Intrinsics.checkNotNull((Object)((Object)scrollableEditText));
        int n = scrollableEditText.getHeight();
        ScrollableEditText scrollableEditText2 = this.scrollableEditText;
        Intrinsics.checkNotNull((Object)((Object)scrollableEditText2));
        return (double)(this.textScrollMax / (float)(n - scrollableEditText2.getPaddingBottom())) >= 1.5;
    }

    @JvmOverloads
    public TextScroller(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public TextScroller(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final void hideCallback$lambda$0(TextScroller this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.setState(State.EXITING);
    }

    public static final /* synthetic */ int access$getThumbHeight$p(TextScroller $this) {
        return $this.thumbHeight;
    }

    public static final /* synthetic */ Drawable access$getThumbNormal$p(TextScroller $this) {
        return $this.thumbNormal;
    }

    public static final /* synthetic */ Drawable access$getThumbDragging$p(TextScroller $this) {
        return $this.thumbDragging;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/blacksquircle/ui/editorkit/widget/TextScroller$Companion;", "", "()V", "ALPHA_MAX", "", "ALPHA_MIN", "ALPHA_STEP", "EXITING_DELAY", "", "TIME_EXITING", "editorkit_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/blacksquircle/ui/editorkit/widget/TextScroller$State;", "", "(Ljava/lang/String;I)V", "HIDDEN", "VISIBLE", "DRAGGING", "EXITING", "editorkit_release"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State HIDDEN = new State();
        public static final /* enum */ State VISIBLE = new State();
        public static final /* enum */ State DRAGGING = new State();
        public static final /* enum */ State EXITING = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.HIDDEN, State.VISIBLE, State.DRAGGING, State.EXITING};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.HIDDEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.VISIBLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.DRAGGING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.EXITING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

