/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit.widget.internal;

import android.content.Context;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.widget.Toast;
import com.blacksquircle.ui.editorkit.widget.internal.LineNumbersEditText;
import com.blacksquircle.ui.editorkit.widget.internal.ScrollableEditText;
import com.blacksquircle.ui.language.base.model.TextStructure;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000K\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f*\u0001\u001c\b&\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0007H\u0014J\u0012\u0010\"\u001a\u00020\u001f2\b\u0010#\u001a\u0004\u0018\u00010$H\u0014J*\u0010%\u001a\u00020\u001f2\b\u0010#\u001a\u0004\u0018\u00010\u001a2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020\u0007H\u0014J*\u0010)\u001a\u00020\u001f2\b\u0010#\u001a\u0004\u0018\u00010\u001a2\u0006\u0010&\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0007H\u0014J \u0010+\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u0007H\u0014J\u0010\u0010-\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0007H\u0014J \u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u001aH\u0002J\u0010\u00102\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001aH\u0016R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001d\u00a8\u00063"}, d2={"Lcom/blacksquircle/ui/editorkit/widget/internal/LineNumbersEditText;", "Lcom/blacksquircle/ui/editorkit/widget/internal/ScrollableEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "value", "", "readOnly", "getReadOnly", "()Z", "setReadOnly", "(Z)V", "softKeyboard", "getSoftKeyboard", "setSoftKeyboard", "structure", "Lcom/blacksquircle/ui/language/base/model/TextStructure;", "getStructure", "()Lcom/blacksquircle/ui/language/base/model/TextStructure;", "textChangeEnd", "textChangeStart", "textChangedNewText", "", "textWatcher", "com/blacksquircle/ui/editorkit/widget/internal/LineNumbersEditText$textWatcher$1", "Lcom/blacksquircle/ui/editorkit/widget/internal/LineNumbersEditText$textWatcher$1;", "addLine", "", "lineNumber", "lineStart", "doAfterTextChanged", "text", "Landroid/text/Editable;", "doBeforeTextChanged", "start", "count", "after", "doOnTextChanged", "before", "processLine", "lineEnd", "removeLine", "replaceText", "newStart", "newEnd", "newText", "setTextContent", "editorkit_release"})
public abstract class LineNumbersEditText
extends ScrollableEditText {
    private boolean softKeyboard;
    private boolean readOnly;
    @NotNull
    private final TextStructure structure;
    @NotNull
    private final textWatcher.1 textWatcher;
    private int textChangeStart;
    private int textChangeEnd;
    @NotNull
    private CharSequence textChangedNewText;

    @JvmOverloads
    public LineNumbersEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.structure = new TextStructure((CharSequence)new SpannableStringBuilder());
        this.textWatcher = new TextWatcher(this){
            final /* synthetic */ LineNumbersEditText this$0;
            {
                this.this$0 = $receiver;
            }

            public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
                this.this$0.doBeforeTextChanged(s, start, count, after);
            }

            public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
                this.this$0.doOnTextChanged(s, start, before, count);
            }

            public void afterTextChanged(@Nullable Editable s) {
                this.this$0.doAfterTextChanged(s);
            }
        };
        this.textChangedNewText = "";
        this.setGravity(0x800033);
        this.setInputType(655361);
    }

    public /* synthetic */ LineNumbersEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 16842859;
        }
        this(context, attributeSet, n);
    }

    public final boolean getSoftKeyboard() {
        return this.softKeyboard;
    }

    public final void setSoftKeyboard(boolean value) {
        this.softKeyboard = value;
        this.setImeOptions(value ? 0 : 0x10000000);
    }

    public final boolean getReadOnly() {
        return this.readOnly;
    }

    public final void setReadOnly(boolean value) {
        this.readOnly = value;
        this.setFocusable(!value);
        this.setFocusableInTouchMode(!value);
    }

    @NotNull
    public final TextStructure getStructure() {
        return this.structure;
    }

    protected void doBeforeTextChanged(@Nullable CharSequence text, int start, int count, int after) {
        this.textChangeStart = start;
        this.textChangeEnd = start + count;
    }

    protected void doOnTextChanged(@Nullable CharSequence text, int start, int before, int count) {
        CharSequence charSequence = text;
        if (charSequence == null || (charSequence = charSequence.subSequence(start, start + count)) == null) {
            charSequence = "";
        }
        this.textChangedNewText = charSequence;
        this.replaceText(this.textChangeStart, this.textChangeEnd, this.textChangedNewText);
        int startLine = this.structure.getLineForIndex(this.textChangeStart);
        int endLine = this.structure.getLineForIndex(this.textChangeStart + this.textChangedNewText.length());
        int currentLine = startLine;
        if (currentLine <= endLine) {
            while (true) {
                int lineEnd;
                int lineStart;
                if ((lineStart = this.structure.getIndexForStartOfLine(currentLine)) <= (lineEnd = this.structure.getIndexForEndOfLine(currentLine))) {
                    this.processLine(currentLine, lineStart, lineEnd);
                }
                if (currentLine == endLine) break;
                ++currentLine;
            }
        }
    }

    protected void doAfterTextChanged(@Nullable Editable text) {
    }

    protected void processLine(int lineNumber, int lineStart, int lineEnd) {
    }

    protected void addLine(int lineNumber, int lineStart) {
        this.structure.add(lineNumber, lineStart);
    }

    protected void removeLine(int lineNumber) {
        this.structure.remove(lineNumber);
    }

    public void setTextContent(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.removeTextChangedListener(this.textWatcher);
        try {
            this.setText(text);
            this.replaceText(0, this.structure.getText().length(), text);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.setText("");
            this.replaceText(0, this.structure.getText().length(), "");
            Toast.makeText((Context)this.getContext(), (CharSequence)e.getMessage(), (int)1).show();
        }
        this.addTextChangedListener(this.textWatcher);
    }

    private final void replaceText(int newStart, int newEnd, CharSequence newText) {
        int i;
        int start = newStart < 0 ? 0 : newStart;
        int end = newEnd > this.structure.getText().length() ? this.structure.getText().length() : newEnd;
        int newCharCount = newText.length() - (end - start);
        int startLine = this.structure.getLineForIndex(start);
        for (i = start; i < end; ++i) {
            if (this.structure.getText().charAt(i) != '\n') continue;
            this.removeLine(startLine + 1);
        }
        this.structure.shiftIndexes(this.structure.getLineForIndex(start) + 1, newCharCount);
        int n = newText.length();
        for (i = 0; i < n; ++i) {
            if (newText.charAt(i) != '\n') continue;
            this.addLine(this.structure.getLineForIndex(start + i) + 1, start + i + 1);
        }
        CharSequence editable = this.structure.getText();
        if (editable instanceof Editable) {
            ((Editable)editable).replace(start, end, newText);
        }
    }

    @JvmOverloads
    public LineNumbersEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public LineNumbersEditText(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

