/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit.widget.internal;

import android.content.Context;
import android.text.Layout;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import android.widget.MultiAutoCompleteTextView;
import android.widget.OverScroller;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001:\u0001,B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000fJ\b\u0010\u0018\u001a\u00020\u0015H\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0002J\u0006\u0010\u001a\u001a\u00020\nJ(\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0014J(\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007H\u0014J\u0010\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u0015H\u0002J\u000e\u0010)\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000fJ\u0010\u0010*\u001a\u00020\u00152\u0006\u0010+\u001a\u00020\nH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/blacksquircle/ui/editorkit/widget/internal/ScrollableEditText;", "Landroid/widget/MultiAutoCompleteTextView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "horizontallyScrollable", "", "maximumVelocity", "", "scrollListeners", "", "Lcom/blacksquircle/ui/editorkit/widget/internal/ScrollableEditText$OnScrollChangedListener;", "textScroller", "Landroid/widget/OverScroller;", "velocityTracker", "Landroid/view/VelocityTracker;", "abortFling", "", "addOnScrollChangedListener", "listener", "computeScroll", "initVelocityTrackerIfNotExists", "isHorizontallyScrollableCompat", "onScrollChanged", "horiz", "vert", "oldHoriz", "oldVert", "onSizeChanged", "w", "h", "oldw", "oldh", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "recycleVelocityTracker", "removeOnScrollChangedListener", "setHorizontallyScrolling", "whether", "OnScrollChangedListener", "editorkit_release"})
public abstract class ScrollableEditText
extends MultiAutoCompleteTextView {
    @NotNull
    private final OverScroller textScroller;
    @NotNull
    private final List<OnScrollChangedListener> scrollListeners;
    private final float maximumVelocity;
    @Nullable
    private VelocityTracker velocityTracker;
    private boolean horizontallyScrollable;

    @JvmOverloads
    public ScrollableEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.textScroller = new OverScroller(context);
        this.scrollListeners = new ArrayList();
        this.maximumVelocity = ViewConfiguration.get((Context)context).getScaledMaximumFlingVelocity();
    }

    public /* synthetic */ ScrollableEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 16842859;
        }
        this(context, attributeSet, n);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        for (OnScrollChangedListener listener : this.scrollListeners) {
            listener.onScrollChanged(this.getScrollX(), this.getScrollY(), this.getScrollX(), this.getScrollY());
        }
    }

    protected void onScrollChanged(int horiz, int vert, int oldHoriz, int oldVert) {
        super.onScrollChanged(horiz, vert, oldHoriz, oldVert);
        for (OnScrollChangedListener listener : this.scrollListeners) {
            listener.onScrollChanged(horiz, vert, oldHoriz, oldVert);
        }
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.initVelocityTrackerIfNotExists();
        switch (event.getAction()) {
            case 0: {
                this.abortFling();
                break;
            }
            case 1: {
                int velocityY;
                int n;
                VelocityTracker velocityTracker = this.velocityTracker;
                if (velocityTracker != null) {
                    velocityTracker.computeCurrentVelocity(1000, this.maximumVelocity);
                }
                if (this.isHorizontallyScrollableCompat()) {
                    VelocityTracker velocityTracker2 = this.velocityTracker;
                    n = velocityTracker2 != null ? (int)velocityTracker2.getXVelocity() : 0;
                } else {
                    n = 0;
                }
                int velocityX = n;
                VelocityTracker velocityTracker3 = this.velocityTracker;
                int n2 = velocityY = velocityTracker3 != null ? (int)velocityTracker3.getYVelocity() : 0;
                if (Math.abs(velocityY) < 0 || Math.abs(velocityX) < 0) {
                    this.recycleVelocityTracker();
                    break;
                }
                if (velocityX == 0 && velocityY == 0) break;
                Layout layout = this.getLayout();
                Layout layout2 = this.getLayout();
                this.textScroller.fling(this.getScrollX(), this.getScrollY(), -velocityX, -velocityY, 0, (layout != null ? layout.getWidth() : this.getWidth()) - this.getWidth() + this.getPaddingStart() + this.getPaddingEnd(), 0, (layout2 != null ? layout2.getHeight() : this.getWidth()) - this.getHeight() + this.getPaddingTop() + this.getPaddingBottom());
                break;
            }
            case 2: {
                VelocityTracker velocityTracker = this.velocityTracker;
                if (velocityTracker == null) break;
                velocityTracker.addMovement(event);
                break;
            }
        }
        return super.onTouchEvent(event);
    }

    public void computeScroll() {
        if (this.textScroller.computeScrollOffset()) {
            int currX = this.textScroller.getCurrX();
            int currY = this.textScroller.getCurrY();
            if (currY < 0) {
                boolean isValidPosition;
                boolean bl = isValidPosition = this.getScrollY() - Math.abs(currY) > 0;
                if (isValidPosition) {
                    this.scrollTo(currX, currY);
                }
            } else {
                this.scrollTo(currX, currY);
            }
            this.postInvalidate();
        }
    }

    public void setHorizontallyScrolling(boolean whether) {
        super.setHorizontallyScrolling(whether);
        this.horizontallyScrollable = whether;
    }

    public final boolean isHorizontallyScrollableCompat() {
        return this.horizontallyScrollable;
    }

    public final void addOnScrollChangedListener(@NotNull OnScrollChangedListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.scrollListeners.add(listener);
    }

    public final void removeOnScrollChangedListener(@NotNull OnScrollChangedListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.scrollListeners.remove(listener);
    }

    public final void abortFling() {
        block1: {
            if (!this.textScroller.isFinished()) {
                this.textScroller.abortAnimation();
            }
            VelocityTracker velocityTracker = this.velocityTracker;
            if (velocityTracker == null) break block1;
            velocityTracker.clear();
        }
    }

    private final void initVelocityTrackerIfNotExists() {
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
    }

    private final void recycleVelocityTracker() {
        VelocityTracker velocityTracker = this.velocityTracker;
        if (velocityTracker != null) {
            velocityTracker.recycle();
        }
        this.velocityTracker = null;
    }

    @JvmOverloads
    public ScrollableEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ScrollableEditText(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H&\u00a8\u0006\t"}, d2={"Lcom/blacksquircle/ui/editorkit/widget/internal/ScrollableEditText$OnScrollChangedListener;", "", "onScrollChanged", "", "x", "", "y", "oldX", "oldY", "editorkit_release"})
    public static interface OnScrollChangedListener {
        public void onScrollChanged(int var1, int var2, int var3, int var4);
    }
}

