/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit.widget.internal;

import android.content.Context;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.util.AttributeSet;
import android.widget.EditText;
import android.widget.TextView;
import com.blacksquircle.ui.editorkit.ExtensionsKt;
import com.blacksquircle.ui.editorkit.model.ColorScheme;
import com.blacksquircle.ui.editorkit.model.ErrorSpan;
import com.blacksquircle.ui.editorkit.model.FindParams;
import com.blacksquircle.ui.editorkit.model.FindResult;
import com.blacksquircle.ui.editorkit.model.FindResultSpan;
import com.blacksquircle.ui.editorkit.model.StyleSpan;
import com.blacksquircle.ui.editorkit.model.SyntaxHighlightSpan;
import com.blacksquircle.ui.editorkit.model.TabWidthSpan;
import com.blacksquircle.ui.editorkit.utils.EditorTheme;
import com.blacksquircle.ui.editorkit.utils.ReflectionKt;
import com.blacksquircle.ui.editorkit.utils.StylingTask;
import com.blacksquircle.ui.editorkit.widget.internal.UndoRedoEditText;
import com.blacksquircle.ui.language.base.Language;
import com.blacksquircle.ui.language.base.model.SyntaxHighlightResult;
import com.blacksquircle.ui.language.base.model.TokenType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\r\b&\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010.\u001a\u00020/H\u0002J\u0006\u00100\u001a\u00020/J\u0012\u00101\u001a\u00020/2\b\u00102\u001a\u0004\u0018\u000103H\u0014J*\u00104\u001a\u00020/2\b\u00102\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u0007H\u0014J*\u00109\u001a\u00020/2\b\u00102\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020\u00072\u0006\u0010:\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u0007H\u0014J\u000e\u0010;\u001a\u00020/2\u0006\u0010<\u001a\u00020=J\u0014\u0010;\u001a\u00020/2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150>J\u0006\u0010?\u001a\u00020/J\u0006\u0010@\u001a\u00020/J\b\u0010A\u001a\u00020/H\u0014J\b\u0010B\u001a\u00020/H\u0014J(\u0010C\u001a\u00020/2\u0006\u0010D\u001a\u00020\u00072\u0006\u0010E\u001a\u00020\u00072\u0006\u0010F\u001a\u00020\u00072\u0006\u0010G\u001a\u00020\u0007H\u0014J(\u0010H\u001a\u00020/2\u0006\u0010I\u001a\u00020\u00072\u0006\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020\u00072\u0006\u0010L\u001a\u00020\u0007H\u0014J\u000e\u0010M\u001a\u00020/2\u0006\u0010N\u001a\u00020OJ\u000e\u0010P\u001a\u00020/2\u0006\u0010N\u001a\u00020OJ\b\u0010Q\u001a\u00020/H\u0002J\b\u0010R\u001a\u00020/H\u0002J\u000e\u0010S\u001a\u00020/2\u0006\u0010T\u001a\u00020\u0007J\u0010\u0010U\u001a\u00020/2\u0006\u00102\u001a\u000205H\u0016J\u0018\u0010V\u001a\u00020/2\u0006\u0010W\u001a\u00020\u00072\u0006\u0010X\u001a\u00020\u0007H\u0002J\b\u0010Y\u001a\u00020/H\u0002J\u0006\u0010Z\u001a\u00020OJ\b\u0010[\u001a\u00020/H\u0002R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010\n\u001a\u0004\u0018\u00010\u0019@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u0006\\"}, d2={"Lcom/blacksquircle/ui/editorkit/widget/internal/SyntaxHighlightEditText;", "Lcom/blacksquircle/ui/editorkit/widget/internal/UndoRedoEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "addedTextCount", "value", "Lcom/blacksquircle/ui/editorkit/model/ColorScheme;", "colorScheme", "getColorScheme", "()Lcom/blacksquircle/ui/editorkit/model/ColorScheme;", "setColorScheme", "(Lcom/blacksquircle/ui/editorkit/model/ColorScheme;)V", "findResultStyleSpan", "Lcom/blacksquircle/ui/editorkit/model/StyleSpan;", "findResults", "", "Lcom/blacksquircle/ui/editorkit/model/FindResult;", "isErrorSpansVisible", "", "isSyntaxHighlighting", "Lcom/blacksquircle/ui/language/base/Language;", "language", "getLanguage", "()Lcom/blacksquircle/ui/language/base/Language;", "setLanguage", "(Lcom/blacksquircle/ui/language/base/Language;)V", "selectedFindResult", "syntaxHighlightResults", "Lcom/blacksquircle/ui/language/base/model/SyntaxHighlightResult;", "tabWidth", "getTabWidth", "()I", "setTabWidth", "(I)V", "task", "Lcom/blacksquircle/ui/editorkit/utils/StylingTask;", "useSpacesInsteadOfTabs", "getUseSpacesInsteadOfTabs", "()Z", "setUseSpacesInsteadOfTabs", "(Z)V", "cancelSyntaxHighlighting", "", "clearFindResultSpans", "doAfterTextChanged", "text", "Landroid/text/Editable;", "doBeforeTextChanged", "", "start", "count", "after", "doOnTextChanged", "before", "find", "params", "Lcom/blacksquircle/ui/editorkit/model/FindParams;", "", "findNext", "findPrevious", "onColorSchemeChanged", "onLanguageChanged", "onScrollChanged", "horiz", "vert", "oldHoriz", "oldVert", "onSizeChanged", "w", "h", "oldw", "oldh", "replaceAllFindResults", "replaceText", "", "replaceFindResult", "scrollToFindResult", "selectResult", "setErrorLine", "lineNumber", "setTextContent", "shiftSpans", "from", "byHowMuch", "syntaxHighlight", "tab", "updateSyntaxHighlighting", "editorkit_release"})
@SourceDebugExtension(value={"SMAP\nSyntaxHighlightEditText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SyntaxHighlightEditText.kt\ncom/blacksquircle/ui/editorkit/widget/internal/SyntaxHighlightEditText\n+ 2 SpannedString.kt\nandroidx/core/text/SpannedStringKt\n*L\n1#1,415:1\n34#2:416\n34#2:417\n34#2:418\n34#2:419\n34#2:420\n*S KotlinDebug\n*F\n+ 1 SyntaxHighlightEditText.kt\ncom/blacksquircle/ui/editorkit/widget/internal/SyntaxHighlightEditText\n*L\n238#1:416\n297#1:417\n311#1:418\n351#1:419\n374#1:420\n*E\n"})
public abstract class SyntaxHighlightEditText
extends UndoRedoEditText {
    @Nullable
    private Language language;
    @NotNull
    private ColorScheme colorScheme;
    private boolean useSpacesInsteadOfTabs;
    private int tabWidth;
    @NotNull
    private final List<SyntaxHighlightResult> syntaxHighlightResults;
    @NotNull
    private final List<FindResult> findResults;
    @Nullable
    private StyleSpan findResultStyleSpan;
    @Nullable
    private StylingTask task;
    private int addedTextCount;
    private int selectedFindResult;
    private boolean isSyntaxHighlighting;
    private boolean isErrorSpansVisible;

    @JvmOverloads
    public SyntaxHighlightEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.colorScheme = EditorTheme.INSTANCE.getDARCULA();
        this.useSpacesInsteadOfTabs = true;
        this.tabWidth = 4;
        this.syntaxHighlightResults = new ArrayList();
        this.findResults = new ArrayList();
        InputFilter[] inputFilterArray = new InputFilter[]{(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5) -> SyntaxHighlightEditText._init_$lambda$0(this, arg_0, arg_1, arg_2, arg_3, arg_4, arg_5)};
        this.setFilters(inputFilterArray);
    }

    public /* synthetic */ SyntaxHighlightEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 16842859;
        }
        this(context, attributeSet, n);
    }

    @Nullable
    public final Language getLanguage() {
        return this.language;
    }

    public final void setLanguage(@Nullable Language value) {
        this.language = value;
        this.onLanguageChanged();
    }

    @NotNull
    public final ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public final void setColorScheme(@NotNull ColorScheme value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.colorScheme = value;
        this.onColorSchemeChanged();
    }

    public final boolean getUseSpacesInsteadOfTabs() {
        return this.useSpacesInsteadOfTabs;
    }

    public final void setUseSpacesInsteadOfTabs(boolean bl) {
        this.useSpacesInsteadOfTabs = bl;
    }

    public final int getTabWidth() {
        return this.tabWidth;
    }

    public final void setTabWidth(int n) {
        this.tabWidth = n;
    }

    @Override
    public void setTextContent(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.syntaxHighlightResults.clear();
        this.findResults.clear();
        super.setTextContent(text);
        this.syntaxHighlight();
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.updateSyntaxHighlighting();
        super.onSizeChanged(w, h, oldw, oldh);
    }

    @Override
    protected void onScrollChanged(int horiz, int vert, int oldHoriz, int oldVert) {
        super.onScrollChanged(horiz, vert, oldHoriz, oldVert);
        this.updateSyntaxHighlighting();
    }

    @Override
    protected void doBeforeTextChanged(@Nullable CharSequence text, int start, int count, int after) {
        this.addedTextCount -= count;
        this.cancelSyntaxHighlighting();
        if (!this.isSyntaxHighlighting) {
            super.doBeforeTextChanged(text, start, count, after);
        }
        this.abortFling();
    }

    @Override
    protected void doOnTextChanged(@Nullable CharSequence text, int start, int before, int count) {
        this.addedTextCount += count;
        if (!this.isSyntaxHighlighting) {
            super.doOnTextChanged(text, start, before, count);
        }
    }

    @Override
    protected void doAfterTextChanged(@Nullable Editable text) {
        if (!this.isSyntaxHighlighting) {
            this.shiftSpans(this.getSelectionStart(), this.addedTextCount);
        }
        this.addedTextCount = 0;
        this.syntaxHighlight();
    }

    protected void onLanguageChanged() {
        this.syntaxHighlight();
    }

    protected void onColorSchemeChanged() {
        this.findResultStyleSpan = new StyleSpan(this.colorScheme.getFindResultBackgroundColor(), false, false, false, false, 30, null);
        this.setTextColor(this.colorScheme.getTextColor());
        ReflectionKt.setCursorDrawableColor((TextView)this, this.colorScheme.getCursorColor());
        this.setBackgroundColor(this.colorScheme.getBackgroundColor());
        this.setHighlightColor(this.colorScheme.getSelectionColor());
    }

    @NotNull
    public final String tab() {
        return this.useSpacesInsteadOfTabs ? StringsKt.repeat((CharSequence)" ", (int)this.tabWidth) : "\t";
    }

    public final void setErrorLine(int lineNumber) {
        if (lineNumber > 0) {
            int lineStart = this.getStructure().getIndexForStartOfLine(lineNumber - 1);
            int lineEnd = this.getStructure().getIndexForEndOfLine(lineNumber - 1);
            if (lineStart < this.getText().length() && lineEnd < this.getText().length() && lineStart > -1 && lineEnd > -1) {
                this.isErrorSpansVisible = true;
                this.getText().setSpan((Object)new ErrorSpan(0.0f, 0.0f, 0, 7, null), lineStart, lineEnd, 33);
            }
        }
    }

    public final void find(@NotNull FindParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.clearFindResultSpans();
        if (((CharSequence)params.getQuery()).length() > 0) {
            try {
                Pattern pattern = params.getRegex() && params.getMatchCase() ? Pattern.compile(params.getQuery()) : (params.getRegex() && !params.getMatchCase() ? Pattern.compile(params.getQuery(), 66) : (params.getWordsOnly() && params.getMatchCase() ? Pattern.compile("\\s" + params.getQuery() + "\\s") : (params.getWordsOnly() && !params.getMatchCase() ? Pattern.compile("\\s" + Pattern.quote(params.getQuery()) + "\\s", 66) : (params.getMatchCase() ? Pattern.compile(Pattern.quote(params.getQuery())) : Pattern.compile(Pattern.quote(params.getQuery()), 66)))));
                Matcher matcher = pattern.matcher((CharSequence)this.getText());
                while (matcher.find()) {
                    FindResult findResult = new FindResult(matcher.start(), matcher.end());
                    this.findResults.add(findResult);
                }
                if (!((Collection)this.findResults).isEmpty()) {
                    this.selectResult();
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        this.updateSyntaxHighlighting();
    }

    public final void find(@NotNull List<FindResult> findResults) {
        Intrinsics.checkNotNullParameter(findResults, (String)"findResults");
        this.clearFindResultSpans();
        if (!((Collection)findResults).isEmpty()) {
            this.findResults.addAll((Collection<FindResult>)findResults);
            this.selectResult();
        }
        this.updateSyntaxHighlighting();
    }

    public final void findNext() {
        if (this.selectedFindResult < this.findResults.size() - 1) {
            ++this.selectedFindResult;
            this.selectResult();
        }
    }

    public final void findPrevious() {
        if (this.selectedFindResult > 0 && this.selectedFindResult < this.findResults.size()) {
            --this.selectedFindResult;
            this.selectResult();
        }
    }

    public final void replaceFindResult(@NotNull String replaceText) {
        Intrinsics.checkNotNullParameter((Object)replaceText, (String)"replaceText");
        if (!((Collection)this.findResults).isEmpty()) {
            FindResult findResult = this.findResults.get(this.selectedFindResult);
            this.getText().replace(findResult.getStart(), findResult.getEnd(), (CharSequence)replaceText);
            this.findResults.remove(findResult);
            if (this.selectedFindResult >= this.findResults.size()) {
                int n = this.selectedFindResult;
                this.selectedFindResult = n + -1;
            }
        }
    }

    public final void replaceAllFindResults(@NotNull String replaceText) {
        Intrinsics.checkNotNullParameter((Object)replaceText, (String)"replaceText");
        if (!((Collection)this.findResults).isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder((CharSequence)this.getText());
            for (int index = this.findResults.size() - 1; -1 < index; --index) {
                FindResult findResultSpan = this.findResults.get(index);
                stringBuilder.replace(findResultSpan.getStart(), findResultSpan.getEnd(), replaceText);
                this.findResults.remove(index);
            }
            this.setText(stringBuilder.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void clearFindResultSpans() {
        void start$iv;
        void $this$getSpans$iv;
        this.selectedFindResult = 0;
        this.findResults.clear();
        Editable editable = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)editable, (String)"text");
        Spanned spanned = (Spanned)editable;
        int n = 0;
        int end$iv = this.getText().length();
        boolean $i$f$getSpans = false;
        Object[] objectArray = $this$getSpans$iv.getSpans((int)start$iv, end$iv, FindResultSpan.class);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSpans(start, end, T::class.java)");
        for (FindResultSpan span : (FindResultSpan[])objectArray) {
            this.getText().removeSpan((Object)span);
        }
    }

    private final void selectResult() {
        FindResult findResult = this.findResults.get(this.selectedFindResult);
        ExtensionsKt.setSelectionRange((EditText)this, findResult.getStart(), findResult.getEnd());
        this.scrollToFindResult();
    }

    private final void scrollToFindResult() {
        if (this.selectedFindResult < this.findResults.size()) {
            FindResult findResult = this.findResults.get(this.selectedFindResult);
            if (findResult.getStart() >= this.getLayout().getLineStart(com.blacksquircle.ui.editorkit.utils.ExtensionsKt.getTopVisibleLine((TextView)this)) && findResult.getEnd() <= this.getLayout().getLineEnd(com.blacksquircle.ui.editorkit.utils.ExtensionsKt.getBottomVisibleLine((TextView)this))) {
                return;
            }
            int height = this.getLayout().getHeight() - this.getHeight() + this.getPaddingBottom() + this.getPaddingTop();
            int lineTop = this.getLayout().getLineTop(this.getLayout().getLineForOffset(findResult.getStart()));
            if (lineTop > height) {
                lineTop = height;
            }
            int scrollX = this.isHorizontallyScrollableCompat() ? (int)this.getLayout().getPrimaryHorizontal(findResult.getStart()) : this.getScrollX();
            this.scrollTo(scrollX, lineTop);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void shiftSpans(int from, int byHowMuch) {
        for (SyntaxHighlightResult span : this.syntaxHighlightResults) {
            if (span.getStart() >= from) {
                span.setStart(span.getStart() + byHowMuch);
            }
            if (span.getEnd() < from) continue;
            span.setEnd(span.getEnd() + byHowMuch);
        }
        for (FindResult findResult : this.findResults) {
            if (findResult.getStart() > from) {
                findResult.setStart(findResult.getStart() + byHowMuch);
            }
            if (findResult.getEnd() < from) continue;
            findResult.setEnd(findResult.getEnd() + byHowMuch);
        }
        if (this.isErrorSpansVisible) {
            void start$iv;
            void $this$getSpans$iv;
            FindResult findResult;
            Editable editable = this.getText();
            Intrinsics.checkNotNullExpressionValue((Object)editable, (String)"text");
            findResult = (Spanned)editable;
            int n = 0;
            int end$iv = this.getText().length();
            boolean $i$f$getSpans = false;
            Object[] objectArray = $this$getSpans$iv.getSpans((int)start$iv, end$iv, ErrorSpan.class);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSpans(start, end, T::class.java)");
            for (ErrorSpan span : (ErrorSpan[])objectArray) {
                this.getText().removeSpan((Object)span);
            }
            this.isErrorSpansVisible = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateSyntaxHighlighting() {
        if (this.getLayout() != null) {
            int start$iv4;
            void $this$getSpans$iv;
            boolean isInText;
            int start$iv2;
            void $this$getSpans$iv2;
            int lineStart = this.getLayout().getLineStart(com.blacksquircle.ui.editorkit.utils.ExtensionsKt.getTopVisibleLine((TextView)this));
            int lineEnd = this.getLayout().getLineEnd(com.blacksquircle.ui.editorkit.utils.ExtensionsKt.getBottomVisibleLine((TextView)this));
            this.isSyntaxHighlighting = true;
            Editable editable = this.getText();
            Intrinsics.checkNotNullExpressionValue((Object)editable, (String)"text");
            Spanned spanned = (Spanned)editable;
            boolean bl = false;
            int end$iv = this.getText().length();
            boolean $i$f$getSpans = false;
            Object[] objectArray = $this$getSpans$iv2.getSpans(start$iv2, end$iv, SyntaxHighlightSpan.class);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSpans(start, end, T::class.java)");
            for (SyntaxHighlightSpan span : (SyntaxHighlightSpan[])objectArray) {
                this.getText().removeSpan((Object)span);
            }
            for (SyntaxHighlightResult result : this.syntaxHighlightResults) {
                boolean isVisible;
                isInText = result.getStart() >= 0 && result.getEnd() <= this.getText().length();
                boolean isValid = result.getStart() <= result.getEnd();
                int n = result.getStart();
                boolean bl2 = isVisible = (lineStart <= n ? n <= lineEnd : false) || result.getStart() <= lineEnd && result.getEnd() >= lineStart;
                if (!isInText || !isValid || !isVisible) continue;
                Editable editable2 = this.getText();
                editable2.setSpan((Object)new SyntaxHighlightSpan(new StyleSpan(switch (WhenMappings.$EnumSwitchMapping$0[result.getTokenType().ordinal()]) {
                    case 1 -> this.colorScheme.getNumberColor();
                    case 2 -> this.colorScheme.getOperatorColor();
                    case 3 -> this.colorScheme.getKeywordColor();
                    case 4 -> this.colorScheme.getTypeColor();
                    case 5 -> this.colorScheme.getLangConstColor();
                    case 6 -> this.colorScheme.getPreprocessorColor();
                    case 7 -> this.colorScheme.getVariableColor();
                    case 8 -> this.colorScheme.getMethodColor();
                    case 9 -> this.colorScheme.getStringColor();
                    case 10 -> this.colorScheme.getCommentColor();
                    case 11 -> this.colorScheme.getTagColor();
                    case 12 -> this.colorScheme.getTagNameColor();
                    case 13 -> this.colorScheme.getAttrNameColor();
                    case 14 -> this.colorScheme.getAttrValueColor();
                    case 15 -> this.colorScheme.getEntityRefColor();
                    default -> throw new NoWhenBranchMatchedException();
                }, false, false, false, false, 30, null)), result.getStart() < lineStart ? lineStart : result.getStart(), result.getEnd() > lineEnd ? lineEnd : result.getEnd(), 33);
            }
            this.isSyntaxHighlighting = false;
            Editable editable3 = this.getText();
            Intrinsics.checkNotNullExpressionValue((Object)editable3, (String)"text");
            Spanned result = (Spanned)editable3;
            isInText = false;
            int end$iv2 = this.getText().length();
            boolean $i$f$getSpans2 = false;
            Object[] objectArray2 = $this$getSpans$iv.getSpans(start$iv4, end$iv2, FindResultSpan.class);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"getSpans(start, end, T::class.java)");
            for (FindResultSpan span : (FindResultSpan[])objectArray2) {
                this.getText().removeSpan((Object)span);
            }
            StyleSpan styleSpan = this.findResultStyleSpan;
            if (styleSpan != null) {
                StyleSpan styleSpan2 = styleSpan;
                boolean bl3 = false;
                for (FindResult result2 : this.findResults) {
                    boolean isVisible;
                    boolean isInText2 = result2.getStart() >= 0 && result2.getEnd() <= this.getText().length();
                    boolean isValid = result2.getStart() <= result2.getEnd();
                    int n = result2.getStart();
                    boolean bl4 = isVisible = (lineStart <= n ? n <= lineEnd : false) || result2.getStart() <= lineEnd && result2.getEnd() >= lineStart;
                    if (!isInText2 || !isValid || !isVisible) continue;
                    this.getText().setSpan((Object)new FindResultSpan(styleSpan2), result2.getStart() < lineStart ? lineStart : result2.getStart(), result2.getEnd() > lineEnd ? lineEnd : result2.getEnd(), 33);
                }
            }
            if (!this.useSpacesInsteadOfTabs) {
                int start$iv3;
                void $this$getSpans$iv3;
                Editable editable4 = this.getText();
                Intrinsics.checkNotNullExpressionValue((Object)editable4, (String)"text");
                Spanned start$iv4 = (Spanned)editable4;
                boolean styleSpan2 = false;
                int end$iv3 = this.getText().length();
                boolean $i$f$getSpans3 = false;
                Object[] objectArray3 = $this$getSpans$iv3.getSpans(start$iv3, end$iv3, TabWidthSpan.class);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"getSpans(start, end, T::class.java)");
                for (TabWidthSpan span : (TabWidthSpan[])objectArray3) {
                    this.getText().removeSpan((Object)span);
                }
                Pattern tabPattern = Pattern.compile("\t");
                Matcher matcher = tabPattern.matcher(this.getText().subSequence(lineStart, lineEnd));
                while (matcher.find()) {
                    int start = matcher.start() + lineStart;
                    int end = matcher.end() + lineStart;
                    if (start < 0 || end > this.getText().length()) continue;
                    this.getText().setSpan((Object)new TabWidthSpan(this.tabWidth), start, end, 18);
                }
            }
            this.postInvalidate();
        }
    }

    private final void syntaxHighlight() {
        block0: {
            this.cancelSyntaxHighlighting();
            StylingTask stylingTask = this.task = new StylingTask((Function0<? extends List<SyntaxHighlightResult>>)((Function0)new Function0<List<? extends SyntaxHighlightResult>>(this){
                final /* synthetic */ SyntaxHighlightEditText this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final List<SyntaxHighlightResult> invoke() {
                    Object object = this.this$0.getLanguage();
                    if (object == null || (object = object.getStyler()) == null || (object = object.execute(this.this$0.getStructure())) == null) {
                        object = CollectionsKt.emptyList();
                    }
                    return object;
                }
            }), (Function1<? super List<SyntaxHighlightResult>, Unit>)((Function1)new Function1<List<? extends SyntaxHighlightResult>, Unit>(this){
                final /* synthetic */ SyntaxHighlightEditText this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull List<SyntaxHighlightResult> spans) {
                    Intrinsics.checkNotNullParameter(spans, (String)"spans");
                    SyntaxHighlightEditText.access$getSyntaxHighlightResults$p(this.this$0).clear();
                    SyntaxHighlightEditText.access$getSyntaxHighlightResults$p(this.this$0).addAll((Collection)spans);
                    SyntaxHighlightEditText.access$updateSyntaxHighlighting(this.this$0);
                }
            }));
            if (stylingTask == null) break block0;
            stylingTask.execute();
        }
    }

    private final void cancelSyntaxHighlighting() {
        StylingTask stylingTask = this.task;
        if (stylingTask != null) {
            stylingTask.cancel();
        }
        this.task = null;
    }

    @JvmOverloads
    public SyntaxHighlightEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public SyntaxHighlightEditText(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    private static final CharSequence _init_$lambda$0(SyntaxHighlightEditText this$0, CharSequence source, int start, int end, Spanned dest, int dstart, int n) {
        char c;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (end - start == 1 && start < source.length() && dstart < dest.length() && (c = source.charAt(start)) == '\t') {
            return this$0.tab();
        }
        return source;
    }

    public static final /* synthetic */ List access$getSyntaxHighlightResults$p(SyntaxHighlightEditText $this) {
        return $this.syntaxHighlightResults;
    }

    public static final /* synthetic */ void access$updateSyntaxHighlighting(SyntaxHighlightEditText $this) {
        $this.updateSyntaxHighlighting();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TokenType.values().length];
            try {
                nArray[TokenType.NUMBER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.OPERATOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.KEYWORD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.TYPE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.LANG_CONST.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.PREPROCESSOR.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.VARIABLE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.METHOD.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.STRING.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.COMMENT.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.TAG.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.TAG_NAME.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.ATTR_NAME.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.ATTR_VALUE.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TokenType.ENTITY_REF.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

