/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.editorkit.widget.internal;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.EditText;
import com.blacksquircle.ui.editorkit.ExtensionsKt;
import com.blacksquircle.ui.editorkit.model.TextChange;
import com.blacksquircle.ui.editorkit.model.UndoStack;
import com.blacksquircle.ui.editorkit.widget.internal.LineNumbersEditText;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\n\b&\u0018\u00002\u00020\u0001:\u0001+B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001c\u001a\u00020\nJ\u0006\u0010\u001d\u001a\u00020\nJ\u0006\u0010\u001e\u001a\u00020\u001fJ*\u0010 \u001a\u00020\u001f2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u0007H\u0014J*\u0010&\u001a\u00020\u001f2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007H\u0014J\u0006\u0010(\u001a\u00020\u001fJ\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0016J\u0006\u0010*\u001a\u00020\u001fR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0014\"\u0004\b\u001b\u0010\u0016\u00a8\u0006,"}, d2={"Lcom/blacksquircle/ui/editorkit/widget/internal/UndoRedoEditText;", "Lcom/blacksquircle/ui/editorkit/widget/internal/LineNumbersEditText;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "isDoingUndoRedo", "", "onUndoRedoChangedListener", "Lcom/blacksquircle/ui/editorkit/widget/internal/UndoRedoEditText$OnUndoRedoChangedListener;", "getOnUndoRedoChangedListener", "()Lcom/blacksquircle/ui/editorkit/widget/internal/UndoRedoEditText$OnUndoRedoChangedListener;", "setOnUndoRedoChangedListener", "(Lcom/blacksquircle/ui/editorkit/widget/internal/UndoRedoEditText$OnUndoRedoChangedListener;)V", "redoStack", "Lcom/blacksquircle/ui/editorkit/model/UndoStack;", "getRedoStack", "()Lcom/blacksquircle/ui/editorkit/model/UndoStack;", "setRedoStack", "(Lcom/blacksquircle/ui/editorkit/model/UndoStack;)V", "textLastChange", "Lcom/blacksquircle/ui/editorkit/model/TextChange;", "undoStack", "getUndoStack", "setUndoStack", "canRedo", "canUndo", "clearUndoHistory", "", "doBeforeTextChanged", "text", "", "start", "count", "after", "doOnTextChanged", "before", "redo", "setTextContent", "undo", "OnUndoRedoChangedListener", "editorkit_release"})
public abstract class UndoRedoEditText
extends LineNumbersEditText {
    @NotNull
    private UndoStack undoStack;
    @NotNull
    private UndoStack redoStack;
    @Nullable
    private OnUndoRedoChangedListener onUndoRedoChangedListener;
    private boolean isDoingUndoRedo;
    @Nullable
    private TextChange textLastChange;

    @JvmOverloads
    public UndoRedoEditText(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.undoStack = new UndoStack();
        this.redoStack = new UndoStack();
    }

    public /* synthetic */ UndoRedoEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 16842859;
        }
        this(context, attributeSet, n);
    }

    @NotNull
    public final UndoStack getUndoStack() {
        return this.undoStack;
    }

    public final void setUndoStack(@NotNull UndoStack undoStack) {
        Intrinsics.checkNotNullParameter((Object)undoStack, (String)"<set-?>");
        this.undoStack = undoStack;
    }

    @NotNull
    public final UndoStack getRedoStack() {
        return this.redoStack;
    }

    public final void setRedoStack(@NotNull UndoStack undoStack) {
        Intrinsics.checkNotNullParameter((Object)undoStack, (String)"<set-?>");
        this.redoStack = undoStack;
    }

    @Nullable
    public final OnUndoRedoChangedListener getOnUndoRedoChangedListener() {
        return this.onUndoRedoChangedListener;
    }

    public final void setOnUndoRedoChangedListener(@Nullable OnUndoRedoChangedListener onUndoRedoChangedListener) {
        this.onUndoRedoChangedListener = onUndoRedoChangedListener;
    }

    @Override
    protected void doBeforeTextChanged(@Nullable CharSequence text, int start, int count, int after) {
        super.doBeforeTextChanged(text, start, count, after);
        if (!this.isDoingUndoRedo) {
            TextChange textChange;
            if (count < Integer.MAX_VALUE) {
                CharSequence charSequence = text;
                textChange = new TextChange("", String.valueOf(charSequence != null ? charSequence.subSequence(start, start + count) : null), start);
            } else {
                this.undoStack.removeAll();
                this.redoStack.removeAll();
                textChange = null;
            }
            this.textLastChange = textChange;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void doOnTextChanged(@Nullable CharSequence text, int start, int before, int count) {
        block4: {
            block3: {
                block5: {
                    super.doOnTextChanged(text, start, before, count);
                    if (this.isDoingUndoRedo) return;
                    if (this.textLastChange == null) return;
                    if (count >= Integer.MAX_VALUE) break block3;
                    TextChange textChange = this.textLastChange;
                    if (textChange != null) {
                        CharSequence charSequence = text;
                        textChange.setNewText(String.valueOf(charSequence != null ? charSequence.subSequence(start, start + count) : null));
                    }
                    TextChange textChange2 = this.textLastChange;
                    boolean bl = textChange2 != null ? start == textChange2.getStart() : false;
                    if (!bl) break block4;
                    Object object = this.textLastChange;
                    Boolean bl2 = object != null && (object = ((TextChange)object).getOldText()) != null ? Boolean.valueOf(((CharSequence)object).length() > 0) : null;
                    Intrinsics.checkNotNull(bl2);
                    if (bl2.booleanValue()) break block5;
                    Object object2 = this.textLastChange;
                    Boolean bl3 = object2 != null && (object2 = ((TextChange)object2).getNewText()) != null ? Boolean.valueOf(((CharSequence)object2).length() > 0) : null;
                    Intrinsics.checkNotNull(bl3);
                    if (!bl3.booleanValue()) break block4;
                }
                TextChange textChange = this.textLastChange;
                TextChange textChange3 = this.textLastChange;
                if (!Intrinsics.areEqual((Object)(textChange != null ? textChange.getOldText() : null), (Object)(textChange3 != null ? textChange3.getNewText() : null))) {
                    TextChange textChange4 = this.textLastChange;
                    Intrinsics.checkNotNull((Object)textChange4);
                    this.undoStack.push(textChange4);
                    this.redoStack.removeAll();
                }
                break block4;
            }
            this.undoStack.removeAll();
            this.redoStack.removeAll();
        }
        this.textLastChange = null;
        OnUndoRedoChangedListener onUndoRedoChangedListener = this.onUndoRedoChangedListener;
        if (onUndoRedoChangedListener == null) return;
        onUndoRedoChangedListener.onUndoRedoChanged();
    }

    @Override
    public void setTextContent(@NotNull CharSequence text) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            super.setTextContent(text);
            OnUndoRedoChangedListener onUndoRedoChangedListener = this.onUndoRedoChangedListener;
            if (onUndoRedoChangedListener == null) break block0;
            onUndoRedoChangedListener.onUndoRedoChanged();
        }
    }

    public final void clearUndoHistory() {
        block0: {
            this.undoStack.removeAll();
            this.redoStack.removeAll();
            OnUndoRedoChangedListener onUndoRedoChangedListener = this.onUndoRedoChangedListener;
            if (onUndoRedoChangedListener == null) break block0;
            onUndoRedoChangedListener.onUndoRedoChanged();
        }
    }

    public final boolean canUndo() {
        return this.undoStack.canUndo();
    }

    public final boolean canRedo() {
        return this.redoStack.canUndo();
    }

    public final void undo() {
        block5: {
            TextChange textChange = this.undoStack.pop();
            if (textChange.getStart() >= 0) {
                int end;
                this.isDoingUndoRedo = true;
                if (textChange.getStart() > this.getText().length()) {
                    textChange.setStart(this.getText().length());
                }
                if ((end = textChange.getStart() + textChange.getNewText().length()) < 0) {
                    end = 0;
                }
                if (end > this.getText().length()) {
                    end = this.getText().length();
                }
                this.redoStack.push(textChange);
                this.getText().replace(textChange.getStart(), end, (CharSequence)textChange.getOldText());
                ExtensionsKt.setSelectionIndex((EditText)this, textChange.getStart() + textChange.getOldText().length());
                this.isDoingUndoRedo = false;
            } else {
                this.undoStack.removeAll();
            }
            OnUndoRedoChangedListener onUndoRedoChangedListener = this.onUndoRedoChangedListener;
            if (onUndoRedoChangedListener == null) break block5;
            onUndoRedoChangedListener.onUndoRedoChanged();
        }
    }

    public final void redo() {
        block2: {
            TextChange textChange = this.redoStack.pop();
            if (textChange.getStart() >= 0) {
                this.isDoingUndoRedo = true;
                this.undoStack.push(textChange);
                this.getText().replace(textChange.getStart(), textChange.getStart() + textChange.getOldText().length(), (CharSequence)textChange.getNewText());
                ExtensionsKt.setSelectionIndex((EditText)this, textChange.getStart() + textChange.getNewText().length());
                this.isDoingUndoRedo = false;
            } else {
                this.undoStack.removeAll();
            }
            OnUndoRedoChangedListener onUndoRedoChangedListener = this.onUndoRedoChangedListener;
            if (onUndoRedoChangedListener == null) break block2;
            onUndoRedoChangedListener.onUndoRedoChanged();
        }
    }

    @JvmOverloads
    public UndoRedoEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public UndoRedoEditText(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/blacksquircle/ui/editorkit/widget/internal/UndoRedoEditText$OnUndoRedoChangedListener;", "", "onUndoRedoChanged", "", "editorkit_release"})
    public static interface OnUndoRedoChangedListener {
        public void onUndoRedoChanged();
    }
}

