/*
 * Decompiled with CFR 0.152.
 */
package com.blacksquircle.ui.language.base.model;

import android.text.SpannableStringBuilder;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006J\u0006\u0010\u0012\u001a\u00020\u000fJ\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006J\u000e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006J\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006J\u0016\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0006R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/blacksquircle/ui/language/base/model/TextStructure;", "", "text", "Landroid/text/SpannableStringBuilder;", "(Landroid/text/SpannableStringBuilder;)V", "lineCount", "", "getLineCount", "()I", "lines", "", "Lcom/blacksquircle/ui/language/base/model/TextStructure$Line;", "getText", "()Landroid/text/SpannableStringBuilder;", "add", "", "line", "index", "clear", "getIndexForEndOfLine", "lineNumber", "getIndexForLine", "getIndexForStartOfLine", "getLine", "getLineForIndex", "remove", "shiftIndexes", "fromLine", "shiftBy", "Line", "language-base_release"})
public final class TextStructure {
    @NotNull
    private final SpannableStringBuilder text;
    @NotNull
    private final List<Line> lines;

    public TextStructure(@NotNull SpannableStringBuilder text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.text = text;
        this.lines = new ArrayList();
        this.lines.add(new Line(0));
    }

    @NotNull
    public final SpannableStringBuilder getText() {
        return this.text;
    }

    public final int getLineCount() {
        return this.lines.size();
    }

    public final void add(int line, int index) {
        if (line != 0) {
            this.lines.add(line, new Line(index));
        }
    }

    public final void remove(int line) {
        if (line != 0) {
            this.lines.remove(line);
        }
    }

    public final void clear() {
        this.lines.clear();
        this.lines.add(new Line(0));
    }

    public final void shiftIndexes(int fromLine, int shiftBy) {
        boolean bl = 1 <= fromLine ? fromLine < this.getLineCount() : false;
        if (bl) {
            for (int i = fromLine; i < this.getLineCount(); ++i) {
                int newIndex = this.getIndexForLine(i) + shiftBy;
                if (i <= 0 || newIndex > 0) {
                    this.lines.get(i).setStart(newIndex);
                    continue;
                }
                this.remove(i);
                --i;
            }
        }
    }

    public final int getIndexForLine(int line) {
        return line >= this.getLineCount() ? -1 : this.lines.get(line).getStart();
    }

    public final int getIndexForStartOfLine(int lineNumber) {
        return this.getIndexForLine(lineNumber);
    }

    public final int getIndexForEndOfLine(int lineNumber) {
        if (lineNumber == this.getLineCount() - 1) {
            return this.text.length();
        }
        return this.getIndexForLine(lineNumber + 1) - 1;
    }

    public final int getLineForIndex(int index) {
        int first = 0;
        int last = this.getLineCount() - 1;
        while (first < last) {
            int mid = (first + last) / 2;
            if (index < this.getIndexForLine(mid)) {
                last = mid;
                continue;
            }
            if (index <= this.getIndexForLine(mid) || index < this.getIndexForLine(mid + 1)) {
                return mid;
            }
            first = mid + 1;
        }
        return this.getLineCount() - 1;
    }

    @NotNull
    public final Line getLine(int line) {
        if (line > -1 && line < this.getLineCount()) {
            return this.lines.get(line);
        }
        return new Line(0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0010"}, d2={"Lcom/blacksquircle/ui/language/base/model/TextStructure$Line;", "", "start", "", "(I)V", "getStart", "()I", "setStart", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "language-base_release"})
    public static final class Line {
        private int start;

        public Line(int start) {
            this.start = start;
        }

        public final int getStart() {
            return this.start;
        }

        public final void setStart(int n) {
            this.start = n;
        }

        public final int component1() {
            return this.start;
        }

        @NotNull
        public final Line copy(int start) {
            return new Line(start);
        }

        public static /* synthetic */ Line copy$default(Line line, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = line.start;
            }
            return line.copy(n);
        }

        @NotNull
        public String toString() {
            return "Line(start=" + this.start + ')';
        }

        public int hashCode() {
            return Integer.hashCode(this.start);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Line)) {
                return false;
            }
            Line line = (Line)other;
            return this.start == line.start;
        }
    }
}

