/*
 * Copyright 2021 Squircle IDE contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.blacksquircle.ui.language.json.lexer;

import org.jetbrains.annotations.NotNull;

@SuppressWarnings("all")

/**
 * This class is a scanner generated by
 * <a href="http://www.jflex.de/">JFlex</a> 1.8.2
 * from the specification file <tt>json.flex</tt>
 */
public class JsonLexer {

  /** This character denotes the end of file. */
  public static final int YYEOF = -1;

  /** Initial size of the lookahead buffer. */
  private static final int ZZ_BUFFERSIZE = 16384;

  // Lexical states.
  public static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0, 0
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\1\u0100\1\u0200\1\u0300\1\u0400\1\u0500\1\u0600\1\u0700"+
    "\1\u0800\1\u0900\1\u0a00\1\u0b00\1\u0c00\1\u0d00\1\u0e00\1\u0f00"+
    "\1\u1000\1\u0100\1\u1100\1\u1200\1\u1300\1\u0100\1\u1400\1\u1500"+
    "\1\u1600\1\u1700\1\u1800\1\u1900\1\u1a00\1\u1b00\1\u0100\1\u1c00"+
    "\1\u1d00\1\u1e00\12\u1f00\1\u2000\1\u2100\1\u2200\1\u1f00\1\u2300"+
    "\1\u2400\2\u1f00\31\u0100\1\u2500\121\u0100\1\u2600\4\u0100\1\u2700"+
    "\1\u0100\1\u2800\1\u2900\1\u2a00\1\u2b00\1\u2c00\1\u2d00\53\u0100"+
    "\1\u2e00\10\u2f00\31\u1f00\1\u0100\1\u3000\1\u3100\1\u0100\1\u3200"+
    "\1\u3300\1\u3400\1\u3500\1\u3600\1\u3700\1\u3800\1\u3900\3\u1f00"+
    "\1\u3a00\1\u3b00\1\u3c00\1\u3d00\1\u3e00\3\u1f00\1\u3f00\1\u4000"+
    "\4\u1f00\1\u4100\11\u1f00\3\u0100\1\u4200\1\u4300\13\u1f00\4\u0100"+
    "\1\u4400\63\u1f00\2\u0100\1\u4500\4\u1f00\1\u4600\100\u1f00\1\u4700"+
    "\40\u1f00\1\u4800\1\u4900\1\u1f00\1\u4a00\1\u4b00\1\u4c00\1\u4d00"+
    "\26\u1f00\1\u4e00\21\u1f00\246\u0100\1\u4f00\20\u0100\1\u5000\1\u5100"+
    "\77\u1f00\2\u0100\1\u5100\u0b05\u1f00\1\u5200\1\u5300\u02fe\u1f00";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\11\0\1\1\1\2\1\3\1\4\1\5\16\0\4\6"+
    "\1\1\1\0\1\7\1\6\1\0\2\6\1\10\2\0"+
    "\1\11\1\12\1\13\1\14\1\15\1\16\1\17\11\20"+
    "\1\21\1\6\3\0\1\6\1\0\4\22\1\23\1\22"+
    "\2\0\1\24\4\0\1\25\11\0\1\26\2\0\1\27"+
    "\1\30\1\31\2\0\1\6\1\32\3\22\1\33\1\34"+
    "\2\0\1\35\2\0\1\36\1\0\1\37\3\0\1\40"+
    "\1\41\1\42\1\43\2\0\1\26\1\44\1\0\1\45"+
    "\1\6\1\46\7\0\1\47\32\0\1\50\1\6\4\0"+
    "\4\6\1\0\2\6\1\0\7\6\1\0\4\6\1\0"+
    "\5\6\27\0\1\6\37\0\1\6\u01ca\0\4\6\14\0"+
    "\16\6\5\0\7\6\1\0\1\6\1\0\21\6\165\0"+
    "\1\6\2\0\2\6\4\0\10\6\1\0\1\6\3\0"+
    "\1\6\1\0\1\6\24\0\1\6\123\0\1\6\213\0"+
    "\1\6\5\0\2\6\236\0\11\6\46\0\2\6\1\0"+
    "\7\6\47\0\7\6\1\0\1\6\55\0\1\6\1\0"+
    "\1\6\2\0\1\6\2\0\1\6\1\0\10\6\33\0"+
    "\5\6\3\0\15\6\5\0\6\6\1\0\4\6\13\0"+
    "\5\6\112\0\4\6\146\0\1\6\11\0\1\6\12\0"+
    "\1\6\23\0\2\6\1\0\17\6\74\0\2\6\145\0"+
    "\16\6\66\0\4\6\1\0\5\6\56\0\22\6\34\0"+
    "\104\6\1\0\1\6\13\0\67\6\33\0\1\6\144\0"+
    "\2\6\12\0\1\6\7\0\1\6\7\0\1\6\3\0"+
    "\1\6\10\0\2\6\2\0\2\6\26\0\1\6\7\0"+
    "\1\6\1\0\3\6\4\0\2\6\11\0\2\6\2\0"+
    "\2\6\4\0\10\6\1\0\4\6\2\0\1\6\5\0"+
    "\2\6\16\0\7\6\1\0\5\6\3\0\1\6\6\0"+
    "\4\6\2\0\2\6\26\0\1\6\7\0\1\6\2\0"+
    "\1\6\2\0\1\6\2\0\2\6\1\0\1\6\5\0"+
    "\4\6\2\0\2\6\3\0\3\6\1\0\7\6\4\0"+
    "\1\6\1\0\7\6\20\0\13\6\3\0\1\6\11\0"+
    "\1\6\3\0\1\6\26\0\1\6\7\0\1\6\2\0"+
    "\1\6\5\0\2\6\12\0\1\6\3\0\1\6\3\0"+
    "\2\6\1\0\17\6\4\0\2\6\12\0\1\6\1\0"+
    "\17\6\3\0\1\6\10\0\2\6\2\0\2\6\26\0"+
    "\1\6\7\0\1\6\2\0\1\6\5\0\2\6\11\0"+
    "\2\6\2\0\2\6\3\0\10\6\2\0\4\6\2\0"+
    "\1\6\5\0\2\6\12\0\1\6\1\0\20\6\2\0"+
    "\1\6\6\0\3\6\3\0\1\6\4\0\3\6\2\0"+
    "\1\6\1\0\1\6\2\0\3\6\2\0\3\6\3\0"+
    "\3\6\14\0\4\6\5\0\3\6\3\0\1\6\4\0"+
    "\2\6\1\0\6\6\1\0\16\6\12\0\11\6\1\0"+
    "\7\6\3\0\1\6\10\0\1\6\3\0\1\6\27\0"+
    "\1\6\12\0\1\6\5\0\3\6\10\0\1\6\3\0"+
    "\1\6\4\0\7\6\2\0\1\6\2\0\6\6\4\0"+
    "\2\6\12\0\22\6\2\0\1\6\10\0\1\6\3\0"+
    "\1\6\27\0\1\6\12\0\1\6\5\0\2\6\11\0"+
    "\1\6\3\0\1\6\4\0\7\6\2\0\7\6\1\0"+
    "\1\6\4\0\2\6\12\0\1\6\2\0\17\6\2\0"+
    "\1\6\10\0\1\6\3\0\1\6\51\0\2\6\10\0"+
    "\1\6\3\0\1\6\5\0\10\6\1\0\10\6\4\0"+
    "\2\6\12\0\12\6\6\0\2\6\2\0\1\6\22\0"+
    "\3\6\30\0\1\6\11\0\1\6\1\0\2\6\7\0"+
    "\3\6\1\0\4\6\6\0\1\6\1\0\1\6\10\0"+
    "\22\6\2\0\15\6\72\0\4\6\20\0\1\6\12\0"+
    "\47\6\2\0\1\6\1\0\2\6\2\0\1\6\1\0"+
    "\2\6\1\0\6\6\4\0\1\6\7\0\1\6\3\0"+
    "\1\6\1\0\1\6\1\0\2\6\2\0\1\6\15\0"+
    "\1\6\3\0\2\6\5\0\1\6\1\0\1\6\6\0"+
    "\2\6\12\0\2\6\4\0\40\6\1\0\27\6\2\0"+
    "\6\6\12\0\13\6\1\0\1\6\1\0\1\6\1\0"+
    "\4\6\12\0\1\6\44\0\4\6\24\0\1\6\22\0"+
    "\1\6\44\0\11\6\1\0\71\6\112\0\6\6\116\0"+
    "\2\6\46\0\1\6\1\0\5\6\1\0\2\6\53\0"+
    "\1\6\115\0\1\6\4\0\2\6\7\0\1\6\1\0"+
    "\1\6\4\0\2\6\51\0\1\6\4\0\2\6\41\0"+
    "\1\6\4\0\2\6\7\0\1\6\1\0\1\6\4\0"+
    "\2\6\17\0\1\6\71\0\1\6\4\0\2\6\103\0"+
    "\2\6\3\0\40\6\20\0\20\6\125\0\14\6\u016c\0"+
    "\2\6\21\0\1\50\32\0\5\6\113\0\3\6\3\0"+
    "\17\6\15\0\1\6\7\0\13\6\25\0\13\6\24\0"+
    "\14\6\15\0\1\6\3\0\1\6\2\0\14\6\124\0"+
    "\3\6\1\0\3\6\3\0\2\6\12\0\41\6\3\0"+
    "\2\6\12\0\6\6\130\0\10\6\53\0\5\6\106\0"+
    "\12\6\35\0\3\6\14\0\4\6\14\0\12\6\50\0"+
    "\2\6\5\0\13\6\54\0\4\6\32\0\6\6\12\0"+
    "\46\6\34\0\4\6\77\0\1\6\35\0\2\6\13\0"+
    "\6\6\12\0\15\6\1\0\130\6\114\0\4\6\12\0"+
    "\21\6\11\0\14\6\164\0\14\6\70\0\10\6\12\0"+
    "\3\6\61\0\122\6\3\0\1\6\43\0\11\6\347\0"+
    "\25\6\32\0\2\6\6\0\2\6\46\0\2\6\6\0"+
    "\2\6\10\0\1\6\1\0\1\6\1\0\1\6\1\0"+
    "\1\6\37\0\2\6\65\0\1\6\7\0\1\6\1\0"+
    "\3\6\3\0\1\6\7\0\3\6\4\0\2\6\6\0"+
    "\4\6\15\0\5\6\3\0\1\6\7\0\3\6\13\50"+
    "\5\0\30\6\2\3\5\0\1\50\17\6\2\0\23\6"+
    "\1\0\12\6\1\50\5\0\5\6\6\0\1\6\1\0"+
    "\15\6\1\0\20\6\15\0\3\6\33\0\25\6\15\0"+
    "\4\6\1\0\3\6\14\0\21\6\1\0\4\6\1\0"+
    "\2\6\12\0\1\6\1\0\3\6\5\0\6\6\1\0"+
    "\1\6\1\0\1\6\1\0\1\6\4\0\1\6\13\0"+
    "\2\6\4\0\5\6\5\0\4\6\1\0\21\6\51\0"+
    "\u0177\6\57\0\1\6\57\0\1\6\205\0\6\6\11\0"+
    "\14\6\46\0\1\6\1\0\5\6\1\0\2\6\70\0"+
    "\7\6\1\0\17\6\30\0\11\6\7\0\1\6\7\0"+
    "\1\6\7\0\1\6\7\0\1\6\7\0\1\6\7\0"+
    "\1\6\7\0\1\6\7\0\1\6\40\0\57\6\1\0"+
    "\320\6\1\50\4\6\3\0\31\6\17\0\1\6\5\0"+
    "\2\6\5\0\4\6\126\0\2\6\2\0\2\6\3\0"+
    "\1\6\132\0\1\6\4\0\5\6\51\0\3\6\136\0"+
    "\21\6\33\0\65\6\306\0\112\6\315\0\63\6\215\0"+
    "\103\6\56\0\2\6\15\0\3\6\34\0\24\6\60\0"+
    "\4\6\12\0\1\6\31\0\7\6\123\0\45\6\11\0"+
    "\2\6\147\0\2\6\4\0\1\6\4\0\14\6\13\0"+
    "\115\6\60\0\20\6\1\0\7\6\64\0\14\6\105\0"+
    "\13\6\12\0\6\6\30\0\3\6\1\0\4\6\56\0"+
    "\2\6\44\0\14\6\35\0\3\6\101\0\16\6\13\0"+
    "\46\6\67\0\11\6\16\0\2\6\12\0\6\6\27\0"+
    "\3\6\2\0\4\6\103\0\30\6\3\0\2\6\20\0"+
    "\2\6\5\0\12\6\6\0\2\6\6\0\2\6\6\0"+
    "\11\6\7\0\1\6\7\0\221\6\53\0\1\6\2\0"+
    "\2\6\12\0\6\6\244\0\14\6\27\0\4\6\61\0"+
    "\4\6\u0100\51\156\0\2\6\152\0\46\6\7\0\14\6"+
    "\5\0\5\6\14\0\1\6\15\0\1\6\5\0\1\6"+
    "\1\0\1\6\2\0\1\6\2\0\1\6\154\0\41\6"+
    "\153\0\22\6\100\0\2\6\66\0\50\6\15\0\3\6"+
    "\20\0\20\6\7\0\14\6\2\0\30\6\3\0\31\6"+
    "\1\0\6\6\5\0\1\6\207\0\2\6\1\0\4\6"+
    "\1\0\13\6\12\0\7\6\32\0\4\6\1\0\1\6"+
    "\32\0\13\6\131\0\3\6\6\0\2\6\6\0\2\6"+
    "\6\0\2\6\3\0\3\6\2\0\3\6\2\0\22\6"+
    "\3\0\4\6\14\0\1\6\32\0\1\6\23\0\1\6"+
    "\2\0\1\6\17\0\2\6\16\0\42\6\173\0\105\6"+
    "\65\0\210\6\1\0\202\6\35\0\3\6\61\0\57\6"+
    "\37\0\21\6\33\0\65\6\36\0\2\6\44\0\4\6"+
    "\10\0\1\6\5\0\52\6\236\0\2\6\12\0\126\6"+
    "\6\0\2\6\1\0\1\6\54\0\1\6\2\0\3\6"+
    "\1\0\2\6\27\0\252\6\26\0\12\6\32\0\106\6"+
    "\70\0\6\6\2\0\100\6\4\0\1\6\2\0\5\6"+
    "\10\0\1\6\3\0\1\6\33\0\4\6\3\0\4\6"+
    "\1\0\40\6\35\0\203\6\66\0\12\6\26\0\12\6"+
    "\23\0\215\6\111\0\267\6\107\0\37\6\12\0\20\6"+
    "\73\0\2\6\1\0\22\6\31\0\7\6\12\0\6\6"+
    "\65\0\1\6\12\0\100\6\105\0\13\6\12\0\246\6"+
    "\70\0\10\6\12\0\66\6\157\0\221\6\143\0\235\6"+
    "\57\0\321\6\71\0\307\6\105\0\13\6\57\0\20\6"+
    "\21\0\140\6\2\0\u0163\6\5\0\3\6\26\0\2\6"+
    "\7\0\36\6\4\0\224\6\3\0\273\6\125\0\1\6"+
    "\107\0\1\6\2\0\2\6\1\0\2\6\2\0\2\6"+
    "\4\0\1\6\14\0\1\6\1\0\1\6\7\0\1\6"+
    "\101\0\1\6\4\0\2\6\10\0\1\6\7\0\1\6"+
    "\34\0\1\6\4\0\1\6\5\0\1\6\1\0\3\6"+
    "\7\0\1\6\u0154\0\2\6\31\0\1\6\31\0\1\6"+
    "\37\0\1\6\31\0\1\6\37\0\1\6\31\0\1\6"+
    "\37\0\1\6\31\0\1\6\37\0\1\6\31\0\1\6"+
    "\10\0\2\6\66\0\1\6\33\0\1\6\2\0\1\6"+
    "\1\0\2\6\1\0\1\6\12\0\1\6\4\0\1\6"+
    "\1\0\1\6\1\0\6\6\1\0\4\6\1\0\1\6"+
    "\1\0\1\6\1\0\1\6\3\0\1\6\2\0\1\6"+
    "\1\0\2\6\1\0\1\6\1\0\1\6\1\0\1\6"+
    "\1\0\1\6\1\0\1\6\2\0\1\6\1\0\2\6"+
    "\4\0\1\6\7\0\1\6\4\0\1\6\4\0\1\6"+
    "\1\0\1\6\12\0\1\6\21\0\5\6\3\0\1\6"+
    "\5\0\1\6\21\0\104\6\327\0\51\6\65\0\13\6"+
    "\336\0\343\6\1\0\36\6\140\0\200\6\360\0\20\6";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[21504];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\1\1\2\1\3\1\4\1\5\1\6\1\1\1\7"+
    "\2\1\1\2\2\1\1\10\1\1\2\2\1\11\1\12"+
    "\3\2\1\13\1\14\1\3\1\5\1\0\1\6\1\0"+
    "\4\1\2\0\1\15\1\16\1\2\2\1\5\2\2\5"+
    "\2\6\3\0\1\15\1\2\1\16\1\1\1\2\1\1"+
    "\3\2\1\1\1\0\1\1\1\0\1\15\2\2\1\17"+
    "\1\20\1\0\1\15\1\2\1\21\1\0\1\2\1\0"+
    "\1\2\1\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[79];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\52\0\124\0\176\0\250\0\322\0\374\0\176"+
    "\0\u0126\0\u0150\0\u017a\0\u01a4\0\u01ce\0\176\0\u01f8\0\u0222"+
    "\0\u024c\0\176\0\176\0\u0276\0\u02a0\0\u02ca\0\176\0\176"+
    "\0\u02f4\0\176\0\u031e\0\176\0\u0348\0\u0372\0\u039c\0\u03c6"+
    "\0\u03f0\0\u041a\0\u0444\0\u046e\0\u0498\0\u04c2\0\u04ec\0\u0516"+
    "\0\u0540\0\u056a\0\u0594\0\u05be\0\u05e8\0\u0612\0\u063c\0\u0666"+
    "\0\u0690\0\u06ba\0\u06e4\0\u070e\0\u0738\0\u0762\0\u078c\0\u04c2"+
    "\0\u07b6\0\52\0\u07e0\0\u080a\0\u0834\0\u06ba\0\u085e\0\176"+
    "\0\u0888\0\52\0\u08b2\0\u08dc\0\52\0\52\0\u0906\0\176"+
    "\0\u0930\0\52\0\u095a\0\u0984\0\u09ae\0\u09d8\0\u0a02";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[79];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\5\3\1\4\1\5\1\6\1\2\1\7\1\10"+
    "\1\11\1\12\1\13\1\14\1\15\1\16\1\2\1\17"+
    "\1\20\1\21\1\2\1\22\1\4\1\23\1\2\1\17"+
    "\1\24\2\2\1\25\2\2\1\26\2\2\1\27\1\30"+
    "\1\31\1\3\1\4\1\2\10\0\1\2\2\0\5\2"+
    "\1\0\5\2\3\0\13\2\2\0\1\2\3\0\5\3"+
    "\41\0\2\3\53\0\2\5\1\0\2\5\1\0\1\5"+
    "\1\32\20\5\1\33\21\5\2\6\1\0\2\6\1\0"+
    "\2\6\1\34\17\6\1\35\21\6\15\0\1\36\1\0"+
    "\1\37\1\40\2\0\1\41\1\42\1\43\5\0\1\41"+
    "\16\0\1\2\10\0\1\2\2\0\1\2\1\12\1\2"+
    "\1\14\1\15\1\0\1\2\1\17\1\20\1\21\1\2"+
    "\3\0\1\2\1\17\11\2\2\0\1\2\2\0\1\2"+
    "\10\0\1\2\2\0\3\2\2\12\1\0\1\2\1\17"+
    "\3\2\3\0\1\2\1\17\11\2\2\0\1\2\2\0"+
    "\1\2\10\0\1\44\2\0\2\2\1\45\2\2\1\0"+
    "\5\2\3\0\13\2\2\0\1\2\2\0\1\2\10\0"+
    "\1\2\2\0\1\2\1\12\1\2\2\12\1\0\1\2"+
    "\1\17\2\2\1\46\3\0\1\2\1\17\11\2\2\0"+
    "\1\2\2\0\1\2\10\0\1\2\2\0\1\2\1\12"+
    "\1\2\2\15\1\0\1\2\1\17\3\2\3\0\1\2"+
    "\1\17\11\2\2\0\1\2\2\0\1\2\10\0\1\2"+
    "\1\47\1\0\1\50\2\2\2\50\1\0\5\2\3\0"+
    "\13\2\2\0\1\2\2\0\1\2\10\0\1\2\2\0"+
    "\5\2\1\0\5\2\3\0\5\2\1\51\5\2\2\0"+
    "\1\2\2\0\1\2\10\0\1\2\2\0\5\2\1\0"+
    "\5\2\3\0\1\52\12\2\2\0\1\2\2\0\1\2"+
    "\10\0\1\2\2\0\5\2\1\0\5\2\3\0\1\53"+
    "\12\2\2\0\1\2\2\0\1\2\10\0\1\2\2\0"+
    "\5\2\1\0\5\2\3\0\11\2\1\54\1\2\2\0"+
    "\1\2\2\0\1\2\10\0\1\2\2\0\5\2\1\0"+
    "\5\2\3\0\6\2\1\55\4\2\2\0\1\2\2\0"+
    "\1\2\5\3\3\0\1\2\2\0\5\2\1\0\5\2"+
    "\3\0\13\2\2\0\1\31\1\3\1\0\1\5\1\56"+
    "\2\5\1\56\1\57\44\5\1\6\1\60\2\6\1\60"+
    "\1\61\44\6\17\0\2\36\2\0\1\41\7\0\1\41"+
    "\33\0\1\36\1\0\2\36\2\0\1\41\2\0\1\62"+
    "\4\0\1\41\33\0\1\36\1\0\2\40\2\0\1\41"+
    "\7\0\1\41\30\0\1\47\1\0\1\47\2\0\2\47"+
    "\70\0\1\63\44\0\1\64\17\0\1\44\10\65\1\66"+
    "\2\65\5\44\1\65\5\44\3\65\13\44\2\65\1\44"+
    "\2\65\1\45\1\67\4\0\3\67\1\45\2\67\5\45"+
    "\1\67\5\45\3\67\13\45\2\67\1\2\1\67\1\0"+
    "\1\2\10\0\1\2\2\0\3\2\2\70\1\0\2\70"+
    "\3\2\3\0\3\70\10\2\2\0\1\2\21\0\2\47"+
    "\31\0\1\2\10\0\1\2\2\0\3\2\2\50\1\0"+
    "\5\2\3\0\13\2\2\0\1\2\2\0\1\2\10\0"+
    "\1\2\2\0\5\2\1\0\5\2\3\0\2\2\1\71"+
    "\10\2\2\0\1\2\2\0\1\2\10\0\1\2\2\0"+
    "\5\2\1\0\3\2\1\72\1\2\3\0\13\2\2\0"+
    "\1\2\2\0\1\2\10\0\1\2\2\0\5\2\1\0"+
    "\5\2\3\0\4\2\1\73\6\2\2\0\1\2\2\0"+
    "\1\2\10\0\1\2\2\0\5\2\1\0\5\2\3\0"+
    "\4\2\1\74\6\2\2\0\1\2\2\0\1\2\10\0"+
    "\1\2\2\0\5\2\1\0\5\2\3\0\11\2\1\75"+
    "\1\2\2\0\1\2\2\0\1\5\1\56\2\5\1\56"+
    "\1\57\1\5\1\32\20\5\1\33\26\5\1\0\1\5"+
    "\1\32\20\5\1\33\21\5\1\6\1\60\2\6\1\60"+
    "\1\61\2\6\1\34\17\6\1\35\26\6\1\0\2\6"+
    "\1\34\17\6\1\35\21\6\17\0\2\76\1\0\2\76"+
    "\6\0\3\76\51\0\1\77\42\0\1\100\24\0\11\65"+
    "\1\101\40\65\1\44\10\65\1\66\2\65\2\44\1\102"+
    "\2\44\1\65\5\44\3\65\13\44\2\65\1\44\2\65"+
    "\2\67\4\0\41\67\1\0\1\67\1\0\1\2\10\0"+
    "\1\2\2\0\5\2\1\0\5\2\3\0\3\2\1\103"+
    "\7\2\2\0\1\2\2\0\1\2\10\0\1\2\2\0"+
    "\5\2\1\0\5\2\3\0\7\2\1\104\3\2\2\0"+
    "\1\2\2\0\1\2\10\0\1\2\2\0\5\2\1\0"+
    "\5\2\3\0\4\2\1\105\6\2\2\0\1\2\2\0"+
    "\1\2\10\0\1\2\2\0\5\2\1\0\5\2\3\0"+
    "\1\2\1\106\11\2\2\0\1\2\37\0\1\107\14\0"+
    "\11\65\1\101\4\65\1\110\33\65\1\2\10\0\1\2"+
    "\2\0\5\2\1\0\5\2\3\0\5\2\1\111\5\2"+
    "\2\0\1\2\2\0\1\2\10\0\1\2\2\0\5\2"+
    "\1\0\5\2\3\0\1\2\1\112\11\2\2\0\1\2"+
    "\41\0\1\113\12\0\1\2\10\0\1\2\2\0\5\2"+
    "\1\0\5\2\3\0\3\2\1\114\7\2\2\0\1\2"+
    "\37\0\1\115\14\0\1\2\10\0\1\2\2\0\5\2"+
    "\1\0\5\2\3\0\10\2\1\116\2\2\2\0\1\2"+
    "\44\0\1\117\7\0\1\2\10\0\1\2\2\0\5\2"+
    "\1\0\5\2\3\0\12\2\1\72\2\0\1\2\46\0"+
    "\1\100\5\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[2604];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** Error code for "Unknown internal scanner error". */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  /** Error code for "could not match input". */
  private static final int ZZ_NO_MATCH = 1;
  /** Error code for "pushback value was too large". */
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /**
   * Error messages for {@link #ZZ_UNKNOWN_ERROR}, {@link #ZZ_NO_MATCH}, and
   * {@link #ZZ_PUSHBACK_2BIG} respectively.
   */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\3\1\1\11\3\1\1\11\5\1\1\11\3\1\2\11"+
    "\3\1\2\11\1\1\1\11\1\0\1\11\1\0\4\1"+
    "\2\0\16\1\3\0\12\1\1\0\1\11\1\0\5\1"+
    "\1\0\1\11\2\1\1\0\1\1\1\0\1\1\1\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[79];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** Input device. */
  private java.io.Reader zzReader;

  /** Current state of the DFA. */
  private int zzState;

  /** Current lexical state. */
  private int zzLexicalState = YYINITIAL;

  /**
   * This buffer contains the current text to be matched and is the source of the {@link #yytext()}
   * string.
   */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** Text position at the last accepting state. */
  private int zzMarkedPos;

  /** Current text position in the buffer. */
  private int zzCurrentPos;

  /** Marks the beginning of the {@link #yytext()} string in the buffer. */
  private int zzStartRead;

  /** Marks the last character in the buffer, that has been read from input. */
  private int zzEndRead;

  /**
   * Whether the scanner is at the end of file.
   * @see #yyatEOF
   */
  private boolean zzAtEOF;

  /**
   * The number of occupied positions in {@link #zzBuffer} beyond {@link #zzEndRead}.
   *
   * <p>When a lead/high surrogate has been read from the input stream into the final
   * {@link #zzBuffer} position, this will have a value of 1; otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /** Number of newlines encountered up to the start of the matched text. */
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  private int yycolumn;

  /** Number of characters up to the start of the matched text. */
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  @SuppressWarnings("unused")
  private boolean zzEOFDone;

  /* user code: */
  public final int getTokenStart() {
      return (int) yychar;
  }

  public final int getTokenEnd() {
      return getTokenStart() + yylength();
  }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public JsonLexer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  /**
   * Refills the input buffer.
   *
   * @return {@code false} iff there was new input.
   * @exception java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead - zzStartRead);

      /* translate stored positions */
      zzEndRead -= zzStartRead;
      zzCurrentPos -= zzStartRead;
      zzMarkedPos -= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length * 2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException(
          "Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
        if (numRead == requested) { // We requested too few chars to encode a full Unicode character
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        } else {                    // There is room in the buffer for at least one more char
          int c = zzReader.read();  // Expecting to read a paired low surrogate char
          if (c == -1) {
            return true;
          } else {
            zzBuffer[zzEndRead++] = (char)c;
          }
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Closes the input reader.
   *
   * @throws java.io.IOException if the reader could not be closed.
   */
  public final void yyclose() throws java.io.IOException {
    zzAtEOF = true; // indicate end of file
    zzEndRead = zzStartRead; // invalidate buffer

    if (zzReader != null) {
      zzReader.close();
    }
  }


  /**
   * Resets the scanner to read from a new input stream.
   *
   * <p>Does not close the old reader.
   *
   * <p>All internal variables are reset, the old input stream <b>cannot</b> be reused (internal
   * buffer is discarded and lost). Lexical state is set to {@code ZZ_INITIAL}.
   *
   * <p>Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader The new input stream.
   */
  public final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzEOFDone = false;
    yyResetPosition();
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE) {
      zzBuffer = new char[ZZ_BUFFERSIZE];
    }
  }

  /**
   * Resets the input position.
   */
  private final void yyResetPosition() {
      zzAtBOL  = true;
      zzAtEOF  = false;
      zzCurrentPos = 0;
      zzMarkedPos = 0;
      zzStartRead = 0;
      zzEndRead = 0;
      zzFinalHighSurrogate = 0;
      yyline = 0;
      yycolumn = 0;
      yychar = 0L;
  }


  /**
   * Returns whether the scanner has reached the end of the reader it reads from.
   *
   * @return whether the scanner has reached EOF.
   */
  public final boolean yyatEOF() {
    return zzAtEOF;
  }


  /**
   * Returns the current lexical state.
   *
   * @return the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state.
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   *
   * @return the matched text.
   */
  public final String yytext() {
    return new String(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
  }


  /**
   * Returns the character at the given position from the matched text.
   *
   * <p>It is equivalent to {@code yytext().charAt(pos)}, but faster.
   *
   * @param position the position of the character to fetch. A value from 0 to {@code yylength()-1}.
   *
   * @return the character at {@code position}.
   */
  public final char yycharat(int position) {
    return zzBuffer[zzStartRead + position];
  }


  /**
   * How many characters were matched.
   *
   * @return the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * <p>In a well-formed scanner (no or only correct usage of {@code yypushback(int)} and a
   * match-all fallback rule) this method will only be called with things that
   * "Can't Possibly Happen".
   *
   * <p>If this method is called, something is seriously wrong (e.g. a JFlex bug producing a faulty
   * scanner etc.).
   *
   * <p>Usual syntax/scanner level error handling should be done in error fallback rules.
   *
   * @param errorCode the code of the error message to display.
   */
  private static void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    } catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * <p>They will be read again by then next call of the scanning method.
   *
   * @param number the number of characters to be read again. This number must not be greater than
   *     {@link #yylength()}.
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }




  /**
   * Resumes scanning until the next regular expression is matched, the end of input is encountered
   * or an I/O-Error occurs.
   *
   * @return the next token.
   * @exception java.io.IOException if any I/O-Error occurs.
   */
  @NotNull
  public JsonToken advance() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char[] zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      yychar+= zzMarkedPosL-zzStartRead;

      boolean zzR = false;
      int zzCh;
      int zzCharCount;
      for (zzCurrentPosL = zzStartRead  ;
           zzCurrentPosL < zzMarkedPosL ;
           zzCurrentPosL += zzCharCount ) {
        zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
        zzCharCount = Character.charCount(zzCh);
        switch (zzCh) {
        case '\u000B':  // fall through
        case '\u000C':  // fall through
        case '\u0085':  // fall through
        case '\u2028':  // fall through
        case '\u2029':
          yyline++;
          yycolumn = 0;
          zzR = false;
          break;
        case '\r':
          yyline++;
          yycolumn = 0;
          zzR = true;
          break;
        case '\n':
          if (zzR)
            zzR = false;
          else {
            yyline++;
            yycolumn = 0;
          }
          break;
        default:
          zzR = false;
          yycolumn += zzCharCount;
        }
      }

      if (zzR) {
        // peek one character ahead if it is
        // (if we have counted one line too much)
        boolean zzPeek;
        if (zzMarkedPosL < zzEndReadL)
          zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        else if (zzAtEOF)
          zzPeek = false;
        else {
          boolean eof = zzRefill();
          zzEndReadL = zzEndRead;
          zzMarkedPosL = zzMarkedPos;
          zzBufferL = zzBuffer;
          if (eof)
            zzPeek = false;
          else
            zzPeek = zzBufferL[zzMarkedPosL] == '\n';
        }
        if (zzPeek) yyline--;
      }
      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
              {
                return JsonToken.EOF;
              }
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { return JsonToken.NUMBER;
            }
            // fall through
          case 18: break;
          case 2:
            { return JsonToken.IDENTIFIER;
            }
            // fall through
          case 19: break;
          case 3:
            { return JsonToken.WHITESPACE;
            }
            // fall through
          case 20: break;
          case 4:
            { return JsonToken.BAD_CHARACTER;
            }
            // fall through
          case 21: break;
          case 5:
            { return JsonToken.DOUBLE_QUOTED_STRING;
            }
            // fall through
          case 22: break;
          case 6:
            { return JsonToken.SINGLE_QUOTED_STRING;
            }
            // fall through
          case 23: break;
          case 7:
            { return JsonToken.COMMA;
            }
            // fall through
          case 24: break;
          case 8:
            { return JsonToken.COLON;
            }
            // fall through
          case 25: break;
          case 9:
            { return JsonToken.LBRACK;
            }
            // fall through
          case 26: break;
          case 10:
            { return JsonToken.RBRACK;
            }
            // fall through
          case 27: break;
          case 11:
            { return JsonToken.LBRACE;
            }
            // fall through
          case 28: break;
          case 12:
            { return JsonToken.RBRACE;
            }
            // fall through
          case 29: break;
          case 13:
            { return JsonToken.BLOCK_COMMENT;
            }
            // fall through
          case 30: break;
          case 14:
            { return JsonToken.LINE_COMMENT;
            }
            // fall through
          case 31: break;
          case 15:
            { return JsonToken.NULL;
            }
            // fall through
          case 32: break;
          case 16:
            { return JsonToken.TRUE;
            }
            // fall through
          case 33: break;
          case 17:
            { return JsonToken.FALSE;
            }
            // fall through
          case 34: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
