/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.atrace;

import android.content.Context;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.Keep;
import androidx.annotation.MainThread;
import androidx.annotation.RestrictTo;
import com.bytedance.android.bytehook.ByteHook;
import com.bytedance.android.bytehook.ILibLoader;
import com.bytedance.rheatrace.atrace.BinaryTrace;
import com.bytedance.rheatrace.atrace.BlockTrace;
import com.bytedance.rheatrace.atrace.TraceEnableTagsHelper;
import com.bytedance.rheatrace.atrace.render.RenderTracer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class RheaATrace {
    private static final AtomicBoolean jniLoadSuccess = new AtomicBoolean(false);
    private static final String TAG = "rhea:atrace";
    private static boolean started;
    private static boolean inited;
    private static File externalDirectory;

    public static boolean isStartWhenAppLaunch() {
        return RheaATrace.nativeStartWhenAppLaunch();
    }

    public static boolean isMainThreadOnly() {
        return RheaATrace.nativeMainThreadOnly();
    }

    public static int getHttpServerPort() {
        return RheaATrace.nativeGetHttpServerPort();
    }

    @MainThread
    public static boolean start(Context context, File externalDir) {
        externalDirectory = externalDir;
        if (started) {
            Log.d((String)TAG, (String)"rhea atrace has been started!");
            return true;
        }
        if (!RheaATrace.init()) {
            return false;
        }
        if (!externalDir.exists() && !externalDir.mkdirs()) {
            Log.e((String)TAG, (String)("failed to create directory " + externalDir.getAbsolutePath()));
            return false;
        }
        BinaryTrace.init(new File(externalDir, "rhea-atrace.bin"));
        BlockTrace.init();
        int resultCode = RheaATrace.nativeStart(externalDir.getAbsolutePath());
        if (RheaATrace.nativeRenderCategoryEnabled()) {
            RenderTracer.onTraceStart();
        }
        if (resultCode != 1) {
            Log.d((String)TAG, (String)("failed to start rhea-trace, errno: " + resultCode));
        } else if (TraceEnableTagsHelper.updateEnableTags()) {
            started = true;
            return true;
        }
        return false;
    }

    @MainThread
    public static boolean stop() {
        if (!started) {
            Log.d((String)TAG, (String)"rhea atrace has not been started!");
            return true;
        }
        BinaryTrace.stop();
        int resultCode = RheaATrace.nativeStop();
        if (resultCode != 1) {
            Log.d((String)TAG, (String)("failed to stop rhea-trace, errno: " + resultCode));
        } else {
            try {
                RheaATrace.writeBinderInterfaceTokens();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"failed to write binder interface tokens", (Throwable)e);
            }
            if (TraceEnableTagsHelper.updateEnableTags()) {
                started = false;
                return true;
            }
        }
        return false;
    }

    private static void writeBinderInterfaceTokens() throws IOException {
        String[] tokens = RheaATrace.nativeGetBinderInterfaceTokens();
        if (tokens == null) {
            Log.e((String)TAG, (String)"writerBinderInterfaceTokens error. may be oom");
            return;
        }
        try (FileWriter writer = new FileWriter(new File(externalDirectory, "binder.txt"));){
            long now = SystemClock.uptimeMillis();
            for (String token : tokens) {
                writer.write("#");
                writer.write(token);
                writer.write("\n");
                try {
                    for (Field field : Class.forName(token + "$Stub").getDeclaredFields()) {
                        if (!Modifier.isStatic(field.getModifiers()) || field.getType() != Integer.TYPE) continue;
                        RheaATrace.appendFieldValue(writer, field);
                    }
                }
                catch (ClassNotFoundException e) {
                    try {
                        for (Field field : Class.forName(token).getDeclaredFields()) {
                            if (!Modifier.isStatic(field.getModifiers()) || field.getType() != Integer.TYPE) continue;
                            RheaATrace.appendFieldValue(writer, field);
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            long cost = SystemClock.uptimeMillis() - now;
            Log.d((String)TAG, (String)("writeBinderInterfaceTokens cost " + cost + "ms"));
        }
    }

    private static void appendFieldValue(FileWriter writer, Field field) throws IllegalAccessException, IOException {
        field.setAccessible(true);
        Object value = field.get(null);
        if (value instanceof Integer) {
            writer.write(field.getName());
            writer.write(":");
            writer.write(value.toString());
            writer.write("\n");
        }
    }

    private static boolean init() {
        if (inited) {
            return true;
        }
        if (!RheaATrace.loadJni()) {
            return false;
        }
        int retCode = ByteHook.init((ByteHook.Config)new ByteHook.ConfigBuilder().setLibLoader(new ILibLoader(){

            public void loadLibrary(String libName) {
                RheaATrace.loadLib(libName);
            }
        }).build());
        if (retCode != 0) {
            Log.d((String)TAG, (String)("bytehook init failed, errno: " + retCode));
            return false;
        }
        inited = true;
        return true;
    }

    @Keep
    private static void loadLib(String libName) {
        try {
            System.loadLibrary(libName);
        }
        catch (Throwable e) {
            throw new UnsatisfiedLinkError("failed to load bytehook lib:" + libName);
        }
    }

    private static boolean loadJni() {
        if (jniLoadSuccess.get()) {
            return true;
        }
        System.loadLibrary("rhea-trace");
        return true;
    }

    public static int getArch() {
        return RheaATrace.nativeGetArch();
    }

    @MainThread
    private static native int nativeStart(String var0);

    @MainThread
    private static native int nativeStop();

    private static native boolean nativeStartWhenAppLaunch();

    public static native boolean nativeMainThreadOnly();

    public static native boolean nativeRenderCategoryEnabled();

    public static native int nativeGetHttpServerPort();

    private static native String[] nativeGetBinderInterfaceTokens();

    private static native int nativeGetArch();

    static {
        jniLoadSuccess.set(RheaATrace.loadJni());
        started = false;
        inited = false;
    }

    public static class Configuration {
        final List<String> categories;
        final boolean mainThreadOnly;
        final long atraceBufferSize;
        final long methodIdBufferSize;
        final String blockHookLibs;

        public Configuration(List<String> categories, boolean mainThreadOnly, long atraceBufferSize, long methodIdBufferSize, String blockHookLibs) {
            this.categories = categories;
            this.mainThreadOnly = mainThreadOnly;
            this.atraceBufferSize = atraceBufferSize;
            this.methodIdBufferSize = methodIdBufferSize;
            this.blockHookLibs = blockHookLibs;
        }
    }
}

