/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.atrace.render;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import com.bytedance.rheatrace.atrace.render.RenderUtils;

class AttachRenderLayoutInflater
extends LayoutInflater {
    private static final String TAG = "rhea:Inflater";
    private static final String[] sClassPrefixList = new String[]{"android.widget.", "android.webkit.", "android.app."};

    AttachRenderLayoutInflater(Context context) {
        super(context);
    }

    AttachRenderLayoutInflater(LayoutInflater original, Context newContext) {
        super(original, newContext);
    }

    public LayoutInflater cloneInContext(Context newContext) {
        return new AttachRenderLayoutInflater(this, newContext);
    }

    public View inflate(int resource, @Nullable ViewGroup root, boolean attachToRoot) {
        View result = super.inflate(resource, root, attachToRoot);
        try {
            Resources resources = this.getContext().getResources();
            String xml = resources.getResourceName(resource);
            RenderUtils.onViewInflated(result, xml, result == root);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString());
        }
        return result;
    }

    protected View onCreateView(String name, AttributeSet attrs) throws ClassNotFoundException {
        for (String prefix : sClassPrefixList) {
            try {
                View view = this.createView(name, prefix, attrs);
                if (view == null) continue;
                return view;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return super.onCreateView(name, attrs);
    }
}

