/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.atrace.render;

import android.os.Build;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import androidx.annotation.Keep;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

@Keep
class RenderUtils {
    private static final String TAG = "rhea:RenderUtils";
    private static final int VIEW_ATTACHED_TAG_INDEX = -1;
    private static final int VIEW_ROOT_ATTACHED_TAG_INDEX = Integer.MAX_VALUE;
    private static Field sRenderNodeFieldOfView = null;
    private static Field sNativeRenderNodeOfRenderNode = null;
    private static Field sAttachInfoFieldOfView = null;
    private static Field sViewRootImplFieldOfAttachInfo = null;
    private static Field sThreadedRendererFieldOfAttachInfo = null;
    private static Field sRootNodeFieldOfThreadedRenderer = null;
    private static Method sGetRootNodeMethodOfThreadRenderer = null;
    private static Field sWindowAttributesFieldOfViewRootImpl = null;
    private static Field sAttachInfoFieldOfViewRootImpl = null;
    private static Field sViewFieldOfViewRootImpl = null;

    RenderUtils() {
    }

    private static Object getRenderNode(View view) {
        if (view == null) {
            Log.e((String)TAG, (String)"Trying to get render node from null view.");
            return null;
        }
        try {
            if (sRenderNodeFieldOfView == null) {
                sRenderNodeFieldOfView = View.class.getDeclaredField("mRenderNode");
                sRenderNodeFieldOfView.setAccessible(true);
            }
            return sRenderNodeFieldOfView.get(view);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString());
            return null;
        }
    }

    private static long getNativeRenderNode(Object renderNode) {
        if (renderNode == null) {
            Log.e((String)TAG, (String)"Trying to get native render node from null render node object.");
            return 0L;
        }
        try {
            if (sNativeRenderNodeOfRenderNode == null) {
                sNativeRenderNodeOfRenderNode = renderNode.getClass().getDeclaredField("mNativeRenderNode");
                sNativeRenderNodeOfRenderNode.setAccessible(true);
            }
            return (Long)sNativeRenderNodeOfRenderNode.get(renderNode);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString());
            return 0L;
        }
    }

    private static Object getAttachInfo(View view) {
        if (view == null) {
            Log.e((String)TAG, (String)"Trying to get attach info from null view.");
            return null;
        }
        try {
            if (sAttachInfoFieldOfView == null) {
                sAttachInfoFieldOfView = View.class.getDeclaredField("mAttachInfo");
                sAttachInfoFieldOfView.setAccessible(true);
            }
            return sAttachInfoFieldOfView.get(view);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString());
            return null;
        }
    }

    private static Object getAttachInfoFromViewRoot(Object viewRoot) {
        if (viewRoot == null) {
            Log.e((String)TAG, (String)"Trying to get attach info from null view root.");
            return null;
        }
        try {
            if (sAttachInfoFieldOfViewRootImpl == null) {
                sAttachInfoFieldOfViewRootImpl = viewRoot.getClass().getDeclaredField("mAttachInfo");
                sAttachInfoFieldOfViewRootImpl.setAccessible(true);
            }
            return sAttachInfoFieldOfViewRootImpl.get(viewRoot);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString());
            return null;
        }
    }

    private static Object getViewRootImpl(Object attachInfo) {
        if (attachInfo == null) {
            Log.e((String)TAG, (String)"Trying to get view root from null attach info.");
            return null;
        }
        try {
            if (sViewRootImplFieldOfAttachInfo == null) {
                sViewRootImplFieldOfAttachInfo = attachInfo.getClass().getDeclaredField("mViewRootImpl");
                sViewRootImplFieldOfAttachInfo.setAccessible(true);
            }
            return sViewRootImplFieldOfAttachInfo.get(attachInfo);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString());
            return null;
        }
    }

    private static Object getThreadedRenderer(Object attachInfo) {
        if (attachInfo == null) {
            Log.e((String)TAG, (String)"Trying to get threaded renderer from null attach info.");
            return null;
        }
        try {
            if (sThreadedRendererFieldOfAttachInfo == null) {
                sThreadedRendererFieldOfAttachInfo = attachInfo.getClass().getDeclaredField("mThreadedRenderer");
                sThreadedRendererFieldOfAttachInfo.setAccessible(true);
            }
            return sThreadedRendererFieldOfAttachInfo.get(attachInfo);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString());
            return null;
        }
    }

    private static Object getRootNode(Object threadedRenderer) {
        if (threadedRenderer == null) {
            Log.e((String)TAG, (String)"Trying to get root node from null threaded renderer.");
            return null;
        }
        if (Build.VERSION.SDK_INT > 28) {
            try {
                if (sGetRootNodeMethodOfThreadRenderer == null) {
                    sGetRootNodeMethodOfThreadRenderer = threadedRenderer.getClass().getDeclaredMethod("getRootNode", new Class[0]);
                    sGetRootNodeMethodOfThreadRenderer.setAccessible(true);
                }
                return sGetRootNodeMethodOfThreadRenderer.invoke(threadedRenderer, new Object[0]);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.toString());
            }
        }
        try {
            if (sRootNodeFieldOfThreadedRenderer == null) {
                sRootNodeFieldOfThreadedRenderer = threadedRenderer.getClass().getDeclaredField("mRootNode");
                sRootNodeFieldOfThreadedRenderer.setAccessible(true);
            }
            return sRootNodeFieldOfThreadedRenderer.get(threadedRenderer);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString());
            return null;
        }
    }

    private static WindowManager.LayoutParams getWindowAttributes(Object viewRootImpl) {
        if (viewRootImpl == null) {
            Log.e((String)TAG, (String)"Trying get window attributes from null view root.");
            return null;
        }
        try {
            if (sWindowAttributesFieldOfViewRootImpl == null) {
                sWindowAttributesFieldOfViewRootImpl = viewRootImpl.getClass().getDeclaredField("mWindowAttributes");
                sWindowAttributesFieldOfViewRootImpl.setAccessible(true);
            }
            return (WindowManager.LayoutParams)sWindowAttributesFieldOfViewRootImpl.get(viewRootImpl);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString());
            return null;
        }
    }

    private static View getRootView(Object viewRootImpl) {
        if (viewRootImpl == null) {
            Log.e((String)TAG, (String)"Trying to get root view from null view root.");
            return null;
        }
        try {
            if (sViewFieldOfViewRootImpl == null) {
                sViewFieldOfViewRootImpl = viewRootImpl.getClass().getDeclaredField("mView");
                sViewFieldOfViewRootImpl.setAccessible(true);
            }
            return (View)sViewFieldOfViewRootImpl.get(viewRootImpl);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.toString());
            return null;
        }
    }

    private static void attachViewInfo(View view, String xmlName) {
        long nativeRenderNode;
        Object renderNode;
        int colonIndex;
        Object attachedTag = view.getTag(-1);
        if (attachedTag != null) {
            return;
        }
        if (xmlName == null) {
            xmlName = "unknown";
        }
        if ((colonIndex = xmlName.indexOf(58)) >= 0 && !xmlName.startsWith("android:")) {
            xmlName = xmlName.substring(colonIndex + 1);
        }
        if ((renderNode = RenderUtils.getRenderNode(view)) != null && (nativeRenderNode = RenderUtils.getNativeRenderNode(renderNode)) != 0L) {
            RenderUtils.nAttachViewInfo(nativeRenderNode, view.getClass().getCanonicalName(), xmlName, view.getId());
            view.setTag(-1, new Object());
        }
    }

    private static void rAttachViewInfo(View view, String xml) {
        RenderUtils.attachViewInfo(view, xml);
        if (view instanceof ViewGroup) {
            ViewGroup container = (ViewGroup)view;
            int childCount = container.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                RenderUtils.rAttachViewInfo(container.getChildAt(i), xml);
            }
        }
    }

    public static void onViewInflated(View root, String xml, boolean ignoreRoot) {
        if (ignoreRoot) {
            if (root instanceof ViewGroup) {
                ViewGroup container = (ViewGroup)root;
                int childCount = container.getChildCount();
                View lastAddedChild = container.getChildAt(childCount - 1);
                RenderUtils.rAttachViewInfo(lastAddedChild, xml);
            }
        } else {
            RenderUtils.rAttachViewInfo(root, xml);
        }
    }

    private static void rAttachViewInfo(View view, SparseArray<String> cache) {
        int layoutId = 0;
        if (Build.VERSION.SDK_INT >= 29) {
            layoutId = view.getSourceLayoutResId();
        }
        if (layoutId == 0) {
            layoutId = 0;
        }
        String xml = null;
        if (layoutId != 0 && (xml = (String)cache.get(layoutId)) == null) {
            xml = view.getResources().getResourceName(layoutId);
            cache.put(layoutId, (Object)xml);
        }
        RenderUtils.attachViewInfo(view, xml);
        if (view instanceof ViewGroup) {
            ViewGroup container = (ViewGroup)view;
            int childCount = container.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = container.getChildAt(i);
                if (child == null || child.getParent() != container) continue;
                RenderUtils.rAttachViewInfo(child, cache);
            }
        }
    }

    private static void attachRootViewInfo(View root) {
        Object attachedTag = root.getTag(Integer.MAX_VALUE);
        if (attachedTag != null) {
            return;
        }
        Object attachInfo = RenderUtils.getAttachInfo(root);
        long nativeRootRenderNode = RenderUtils.getNativeRenderNode(RenderUtils.getRootNode(RenderUtils.getThreadedRenderer(attachInfo)));
        WindowManager.LayoutParams layoutParams = RenderUtils.getWindowAttributes(RenderUtils.getViewRootImpl(attachInfo));
        if (nativeRootRenderNode != 0L && layoutParams != null) {
            RenderUtils.nAttachRootViewInfo(nativeRootRenderNode, layoutParams.getTitle().toString());
            root.setTag(Integer.MAX_VALUE, new Object());
        } else {
            Log.e((String)TAG, (String)("root view info attach failed, nativeRootRenderNode=" + nativeRootRenderNode + ",layoutParams=" + layoutParams));
        }
    }

    private static void attachViewRootInfo(Object viewRootImpl) {
        if (viewRootImpl == null) {
            Log.e((String)TAG, (String)"trying to attach view root info from null view root impl");
        }
        Object attachInfo = RenderUtils.getAttachInfoFromViewRoot(viewRootImpl);
        long nativeRootRenderNode = RenderUtils.getNativeRenderNode(RenderUtils.getRootNode(RenderUtils.getThreadedRenderer(attachInfo)));
        WindowManager.LayoutParams layoutParams = RenderUtils.getWindowAttributes(RenderUtils.getViewRootImpl(attachInfo));
        if (nativeRootRenderNode != 0L && layoutParams != null) {
            RenderUtils.nAttachRootViewInfo(nativeRootRenderNode, layoutParams.getTitle().toString());
        } else {
            Log.e((String)TAG, (String)("root view info attach failed, nativeRootRenderNode=" + nativeRootRenderNode + ",layoutParams=" + layoutParams));
        }
    }

    public static void attachViewInfo(View root) {
        if (root != null) {
            RenderUtils.attachRootViewInfo(root);
            RenderUtils.rAttachViewInfo(root, (SparseArray<String>)new SparseArray());
        }
    }

    public static void attachViewRoot(Object viewRootImpl) {
        RenderUtils.attachViewRootInfo(viewRootImpl);
        View rootView = RenderUtils.getRootView(viewRootImpl);
        if (rootView != null) {
            RenderUtils.rAttachViewInfo(rootView, (SparseArray<String>)new SparseArray());
        }
    }

    private static native void nAttachViewInfo(long var0, String var2, String var3, int var4);

    private static native void nAttachRootViewInfo(long var0, String var2);
}

