/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.atrace;

import androidx.annotation.Keep;
import dalvik.annotation.optimization.CriticalNative;
import java.io.File;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class BinaryTrace {
    private static final String TAG = "BinaryTrace";
    private static volatile boolean on;

    public static void init(File file) {
        BinaryTrace.nativeInit(file.getAbsolutePath());
        on = true;
    }

    public static String getThreadsInfo() {
        return BinaryTrace.nativeGetThreadsInfo();
    }

    public static long beginMethod(int methodID) {
        if (on) {
            return BinaryTrace.nativeBeginMethod(methodID);
        }
        return -1L;
    }

    public static void endMethod(int methodId, long begin) {
        if (on) {
            BinaryTrace.nativeEndMethod(methodId, begin);
        }
    }

    public static void stop() {
        on = false;
        BinaryTrace.nativeStop();
    }

    public static long currentBufferUsage() {
        return BinaryTrace.nativeGetCurrentAppTraceBufferSize();
    }

    private static native void nativeInit(String var0);

    private static native void nativeStop();

    private static native String nativeGetThreadsInfo();

    @CriticalNative
    private static native long nativeBeginMethod(int var0);

    @CriticalNative
    private static native void nativeEndMethod(int var0, long var1);

    private static native long nativeGetCurrentAppTraceBufferSize();

    private static native long nativeGetMaxAppTraceBufferSize();

    public static String debugInfo() throws JSONException {
        JSONObject json = new JSONObject();
        JSONObject traceBuffer = new JSONObject();
        traceBuffer.put("currentSize", BinaryTrace.nativeGetCurrentAppTraceBufferSize());
        traceBuffer.put("maxSize", BinaryTrace.nativeGetMaxAppTraceBufferSize());
        json.put("appTraceBuffer", (Object)traceBuffer);
        return json.toString();
    }
}

