/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.atrace.render;

import android.content.Context;
import android.view.LayoutInflater;
import com.bytedance.rheatrace.atrace.render.AttachRenderLayoutInflater;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;

class LayoutInflaterFetcher {
    private static LayoutInflater sInflater = null;
    private static Object sOriginFetcher = null;

    LayoutInflaterFetcher() {
    }

    static void setOriginFetcher(Class<?> systemServiceRegistryClazz) {
        try {
            Field serviceFetchersField = systemServiceRegistryClazz.getDeclaredField("SYSTEM_SERVICE_FETCHERS");
            serviceFetchersField.setAccessible(true);
            HashMap fetchers = (HashMap)serviceFetchersField.get(null);
            if (fetchers != null) {
                sOriginFetcher = fetchers.get("layout_inflater");
            }
        }
        catch (Exception e) {
            sOriginFetcher = null;
        }
    }

    static synchronized LayoutInflater getInflater(Object contextImpl) {
        if (sInflater != null) {
            return sInflater;
        }
        Context context = LayoutInflaterFetcher.getContext(contextImpl);
        if (context == null && sOriginFetcher != null) {
            return LayoutInflaterFetcher.getInflaterFromOriginFetcher(sOriginFetcher, contextImpl);
        }
        sInflater = new AttachRenderLayoutInflater(context);
        return sInflater;
    }

    private static LayoutInflater getInflaterFromOriginFetcher(Object serviceFetcher, Object contextImpl) {
        try {
            Method getService = serviceFetcher.getClass().getDeclaredMethod("getService", contextImpl.getClass());
            getService.setAccessible(true);
            return (LayoutInflater)getService.invoke(serviceFetcher, contextImpl);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Context getContext(Object contextImpl) {
        try {
            Method getOuterContext = contextImpl.getClass().getDeclaredMethod("getOuterContext", new Class[0]);
            getOuterContext.setAccessible(true);
            return (Context)getOuterContext.invoke(contextImpl, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }
}

