/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.atrace.render;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import com.bytedance.rheatrace.atrace.render.LayoutInflaterFetcher;
import com.bytedance.rheatrace.atrace.render.RenderUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;

public class RenderTracer {
    private static final String TAG = "rhea:RenderTracer";

    public static void onTraceStart() {
        RenderTracer.installInflaterHook();
        RenderTracer.tryAttachWindowViews();
    }

    @SuppressLint(value={"PrivateApi"})
    private static void installInflaterHook() {
        try {
            Class<?> systemServiceRegistryClazz = Class.forName("android.app.SystemServiceRegistry");
            Class<?> serviceFetcherClazz = Class.forName("android.app.SystemServiceRegistry$ServiceFetcher");
            LayoutInflaterFetcher.setOriginFetcher(systemServiceRegistryClazz);
            Method registerService = systemServiceRegistryClazz.getDeclaredMethod("registerService", String.class, Class.class, serviceFetcherClazz);
            registerService.setAccessible(true);
            Object serviceFetcher = Proxy.newProxyInstance(serviceFetcherClazz.getClassLoader(), new Class[]{serviceFetcherClazz}, (proxy, method, args) -> LayoutInflaterFetcher.getInflater(args[0]));
            registerService.invoke(null, "layout_inflater", LayoutInflater.class, serviceFetcher);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("install inflater hook failed, error: " + e.toString()));
        }
    }

    private static void registerWindowViewAddMonitor() {
    }

    private static void tryAttachWindowViews() {
        try {
            Class<?> windowManagerGlobalClazz = Class.forName("android.view.WindowManagerGlobal");
            Method getInstance = windowManagerGlobalClazz.getDeclaredMethod("getInstance", new Class[0]);
            getInstance.setAccessible(true);
            Object windowManagerGlobal = getInstance.invoke(null, new Object[0]);
            Field mRoots = windowManagerGlobalClazz.getDeclaredField("mRoots");
            mRoots.setAccessible(true);
            ArrayList roots = (ArrayList)mRoots.get(windowManagerGlobal);
            MonitoredArrayList monitoredRoots = new MonitoredArrayList(roots, true);
            mRoots.set(windowManagerGlobal, monitoredRoots);
            Field mViews = windowManagerGlobalClazz.getDeclaredField("mViews");
            mViews.setAccessible(true);
            ArrayList views = (ArrayList)mViews.get(windowManagerGlobal);
            for (View view : views) {
                RenderUtils.attachViewInfo(view);
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("attach window views failed, error: " + e.toString()));
        }
    }

    private static class MonitoredArrayList<E>
    extends ArrayList<E> {
        private final Handler mHandler = new Handler(Looper.getMainLooper());
        private final boolean mIsViewRootList;

        MonitoredArrayList(Collection<E> c, boolean isViewRootList) {
            super(c);
            this.mIsViewRootList = isViewRootList;
        }

        @Override
        public boolean add(E e) {
            if (this.mIsViewRootList) {
                this.mHandler.post(() -> RenderUtils.attachViewRoot(e));
            }
            return super.add(e);
        }
    }
}

