/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.common.utils;

import com.bytedance.rheatrace.common.utils.ReflectUtil;
import java.io.File;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.file.DefaultFilePropertyFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/bytedance/rheatrace/common/utils/AGPCompat;", "", "()V", "getMergedManifestFile", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "variantName", "", "getMergedManifestFileInternal", "processManifestTask", "Lorg/gradle/api/Task;", "rhea-build-common"})
public final class AGPCompat {
    public static final AGPCompat INSTANCE;

    @NotNull
    public final File getMergedManifestFile(@NotNull Project project, @NotNull String variantName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)variantName, (String)"variantName");
        String mergeManifestTaskName = "process" + StringsKt.capitalize((String)variantName) + "Manifest";
        Task processManifest = (Task)project.getTasks().findByName(mergeManifestTaskName);
        return this.getMergedManifestFileInternal(processManifest);
    }

    private final File getMergedManifestFileInternal(Task processManifestTask) {
        File manifestOutputFile = null;
        String manifestOutputBaseDir = null;
        Method method = null;
        try {
            method = ReflectUtil.INSTANCE.getDeclaredMethodRecursive("com.android.build.gradle.tasks.ManifestProcessorTask", "getManifestOutputDirectory", new Class[0]);
            Object object = method.invoke((Object)processManifestTask, new Object[0]);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.file.DirectoryProperty");
            }
            manifestOutputBaseDir = ((DirectoryProperty)object).get().toString();
            manifestOutputFile = new File(manifestOutputBaseDir, "AndroidManifest.xml");
        }
        catch (Throwable e1) {
            try {
                method = ReflectUtil.INSTANCE.getDeclaredMethodRecursive("com.android.build.gradle.tasks.ProcessMultiApkApplicationManifest", "getMainMergedManifest", new Class[0]);
                Object object = method.invoke((Object)processManifestTask, new Object[0]);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.internal.file.DefaultFilePropertyFactory.DefaultRegularFileVar");
                }
                manifestOutputFile = (File)((DefaultFilePropertyFactory.DefaultRegularFileVar)object).getAsFile().get();
            }
            catch (Throwable e2) {
                try {
                    method = ReflectUtil.INSTANCE.getDeclaredMethodRecursive("com.android.build.gradle.tasks.ProcessTestManifest", "getPackagedManifestOutputDirectory", new Class[0]);
                    Object object = method.invoke((Object)processManifestTask, new Object[0]);
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.file.DirectoryProperty");
                    }
                    manifestOutputBaseDir = ((DirectoryProperty)object).get().toString();
                    manifestOutputFile = new File(manifestOutputBaseDir, "AndroidManifest.xml");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (manifestOutputFile == null) {
            throw (Throwable)new GradleException("Can't find merged manifest!");
        }
        return manifestOutputFile;
    }

    private AGPCompat() {
    }

    static {
        AGPCompat aGPCompat;
        INSTANCE = aGPCompat = new AGPCompat();
    }
}

