/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.core;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.bytedance.rheatrace.atrace.BinaryTrace;
import com.bytedance.rheatrace.atrace.RheaATrace;
import fi.iki.elonen.NanoHTTPD;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.json.JSONException;
import org.json.JSONObject;

public class HttpServer {
    private static Server server;
    private static final String MINE_BIN = "application/octet-stream";
    private static final String ASSETS_MAPPING = "methodMapping.txt";
    private static final String BINARY_FILE = "rhea-atrace.bin";

    public static void start(Context context, File hostDir) {
        if (server != null && server.isAlive()) {
            Log.i((String)"RheaServer", (String)("stop previous server on port " + server.getListeningPort()));
            server.stop();
        }
        server = new Server(context, hostDir, RheaATrace.getHttpServerPort());
        try {
            server.start();
            Log.i((String)"RheaServer", (String)("start new http server on port " + server.getListeningPort()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String deviceInfo() {
        JSONObject json = new JSONObject();
        try {
            json.put("brand", (Object)Build.MANUFACTURER);
            json.put("model", (Object)Build.MODEL);
            json.put("os", Build.VERSION.SDK_INT);
            json.put("arch", RheaATrace.getArch());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json.toString();
    }

    private static class Server
    extends NanoHTTPD {
        private final File hostDir;
        private final Context context;

        public Server(Context context, File hostDir, int port) {
            super(port);
            this.context = context;
            this.hostDir = hostDir;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
            try {
                String name = (String)session.getParms().get("name");
                if (name == null) {
                    return Server.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND, (String)"text/plain", (String)"not found");
                }
                switch (name) {
                    case "debug": {
                        return Server.newFixedLengthResponse((String)BinaryTrace.debugInfo());
                    }
                    case "deviceInfo": {
                        return Server.newFixedLengthResponse((String)HttpServer.deviceInfo());
                    }
                    case "threads": {
                        return Server.newFixedLengthResponse((String)BinaryTrace.getThreadsInfo());
                    }
                    case "mappingVersion": {
                        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.context.getAssets().open(HttpServer.ASSETS_MAPPING)));){
                            NanoHTTPD.Response response = Server.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (String)br.readLine());
                            return response;
                        }
                    }
                    case "mapping": {
                        return Server.newChunkedResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)"text/plain", (InputStream)this.context.getAssets().open(HttpServer.ASSETS_MAPPING));
                    }
                    case "trace": {
                        return Server.newFixedLengthResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)HttpServer.MINE_BIN, (InputStream)new FileInputStream(new File(this.hostDir, HttpServer.BINARY_FILE)), (long)BinaryTrace.currentBufferUsage());
                    }
                }
                return Server.newChunkedResponse((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK, (String)HttpServer.MINE_BIN, (InputStream)new FileInputStream(new File(this.hostDir, name)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

