/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.core;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import com.bytedance.rheatrace.core.TraceSwitch;

public final class TraceReceiver
extends BroadcastReceiver {
    static final String ACTION_RHEA_TRACE_SWITCH = "com.bytedance.rheatrace.switch";
    static final String ACTION_RHEA_TRACE_SWITCH_START = "com.bytedance.rheatrace.switch.start";
    static final String ACTION_RHEA_TRACE_SWITCH_STOP = "com.bytedance.rheatrace.switch.stop";

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if (action != null) {
            switch (action) {
                case "com.bytedance.rheatrace.switch": {
                    this.startOrStopTracing(context);
                    break;
                }
                case "com.bytedance.rheatrace.switch.start": {
                    this.startTracing(context);
                    break;
                }
                case "com.bytedance.rheatrace.switch.stop": {
                    this.stopTracing(context);
                }
            }
        }
    }

    private void startOrStopTracing(final Context context) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (TraceSwitch.isStarted()) {
                    TraceSwitch.stop(context);
                } else {
                    TraceSwitch.start(context);
                }
            }
        });
    }

    private void startTracing(final Context context) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                TraceSwitch.start(context);
            }
        });
    }

    private void stopTracing(final Context context) {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                TraceSwitch.stop(context);
            }
        });
    }
}

