/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.rheatrace.core;

import android.content.Context;
import android.os.Build;
import android.os.Trace;
import android.util.Log;
import android.widget.Toast;
import androidx.annotation.MainThread;
import com.bytedance.rheatrace.atrace.RheaATrace;
import com.bytedance.rheatrace.common.ReflectUtil;
import com.bytedance.rheatrace.core.HttpServer;
import com.bytedance.rheatrace.core.ProcessUtil;
import com.bytedance.rheatrace.core.RheaTrace;
import java.io.File;
import java.lang.reflect.Method;

class TraceSwitch {
    private static final String TAG = "Rhea:TraceSwitch";
    private static boolean started;

    TraceSwitch() {
    }

    @MainThread
    static void init(Context context) {
        boolean isMainProcess = context.getPackageName().equals(ProcessUtil.getProcessName(context));
        if (!isMainProcess) {
            return;
        }
        RheaTrace.isMainProcess = true;
        RheaTrace.mainThreadOnly = RheaATrace.isMainThreadOnly();
        TraceSwitch.enableAppTracing();
        if (RheaATrace.isStartWhenAppLaunch()) {
            Log.d((String)TAG, (String)"start tracing when launch app.");
            TraceSwitch.start(context);
        }
    }

    @MainThread
    static void start(Context context) {
        if (started) {
            Log.d((String)TAG, (String)"RheaTrace has been started, just ignore!");
        } else {
            File rheaTraceDir = TraceSwitch.getRheaTraceDir(context);
            HttpServer.start(context, rheaTraceDir);
            boolean result = RheaATrace.start((Context)context, (File)rheaTraceDir);
            if (result) {
                started = true;
            } else {
                Toast.makeText((Context)context, (CharSequence)"unfortunately, start trace failed!", (int)1).show();
            }
        }
    }

    @MainThread
    static void stop(Context context) {
        if (started) {
            boolean result = RheaATrace.stop();
            if (result) {
                started = false;
            } else {
                Toast.makeText((Context)context, (CharSequence)"unfortunately, stop trace failed!", (int)1).show();
            }
        } else {
            Log.d((String)TAG, (String)"RheaTrace has not been started, just ignore!");
        }
    }

    static boolean isStarted() {
        return started;
    }

    static File getRheaTraceDir(Context context) {
        return new File(context.getExternalFilesDir(""), "rhea-trace");
    }

    private static void enableAppTracing() {
        if (Build.VERSION.SDK_INT < 18) {
            return;
        }
        try {
            Method setAppTracingAllowed_method = ReflectUtil.INSTANCE.getDeclaredMethodRecursive(Trace.class, "setAppTracingAllowed", new Class[]{Boolean.TYPE});
            setAppTracingAllowed_method.invoke(null, true);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

