/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ttvideosetting;

import android.content.Context;
import com.bytedance.ttvideosetting.TTVideoSettingListener;
import com.bytedance.ttvideosetting.TTVideoSettingsUtil;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.json.JSONException;
import org.json.JSONObject;

public class TTVideoSettingsManager {
    private Context mContext;
    public JSONObject mSettingJson;
    public JSONObject mFreezedSettings;
    public static String mTTVideoSettingsStoreKey = "TTVideoSettingsStoreKey";
    public static final int MsgIsSettingUpdate = 0;
    private static TTVideoSettingsManager instance;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock linstenerLock = new ReentrantReadWriteLock();
    private ArrayList<TTVideoSettingListener> arrayListener = new ArrayList();
    private boolean isSaveLocal = false;

    public void addListener(TTVideoSettingListener listener) {
        this.linstenerLock.writeLock().lock();
        this.arrayListener.add(listener);
        this.linstenerLock.writeLock().unlock();
    }

    public static synchronized TTVideoSettingsManager getInstance(Context context) throws JSONException {
        if (instance == null) {
            instance = new TTVideoSettingsManager(context.getApplicationContext());
        }
        return instance;
    }

    public void setIsSaveLocal(boolean saveLocal) {
        this.isSaveLocal = saveLocal;
    }

    public JSONObject getSettingValue(String key, JSONObject defaultValue, boolean freeze) throws JSONException {
        this.rwl.readLock().lock();
        JSONObject ret = this._getSettingValue(key, defaultValue, freeze);
        this.rwl.readLock().unlock();
        return ret;
    }

    public void saveSettingJson(JSONObject settings) {
        this.rwl.writeLock().lock();
        this.mSettingJson = settings;
        if (this.isSaveLocal) {
            TTVideoSettingsUtil.putString(this.mContext, mTTVideoSettingsStoreKey, settings.toString());
        }
        this.rwl.writeLock().unlock();
        this.hanldeMessage(0);
    }

    public void hanldeMessage(int msg) {
        this.linstenerLock.readLock().lock();
        for (TTVideoSettingListener listener : this.arrayListener) {
            listener.oNotify(msg);
        }
        this.linstenerLock.readLock().unlock();
    }

    private TTVideoSettingsManager(Context ctx) throws JSONException {
        this.mContext = ctx;
        if (this.isSaveLocal) {
            String setingString = TTVideoSettingsUtil.getString(this.mContext, mTTVideoSettingsStoreKey);
            if (setingString != null && !setingString.isEmpty()) {
                this.mSettingJson = new JSONObject(setingString);
                this.mFreezedSettings = new JSONObject(setingString);
            } else {
                this.mSettingJson = new JSONObject();
                this.mFreezedSettings = new JSONObject();
            }
        }
    }

    private JSONObject _getSettingValue(String key, JSONObject defaultValue, boolean freeze) throws JSONException {
        if (key == null || key.isEmpty()) {
            return defaultValue;
        }
        JSONObject ret = this.mFreezedSettings != null && !this.mFreezedSettings.isNull(key) ? this.mFreezedSettings.getJSONObject(key) : (this.mSettingJson != null && !this.mSettingJson.isNull(key) ? this.mSettingJson.getJSONObject(key) : defaultValue);
        if (freeze && this.mFreezedSettings != null && !this.mFreezedSettings.isNull(key) && ret != null) {
            this.mFreezedSettings.put(key, (Object)ret);
        }
        return ret;
    }
}

