/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.ttvideosetting;

import android.accounts.NetworkErrorException;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class TTVideoSettingsUtil {
    public static String TAG = "TTVideoSetting";
    private static SharedPreferences sp;

    private static SharedPreferences getSp(Context context) {
        if (sp == null) {
            sp = context.getSharedPreferences("com.video.ttvideosetting", 0);
        }
        return sp;
    }

    public static String getCallerName() {
        return "VideoCloud";
    }

    public static String settingURLString(String host) {
        return String.format("%s/service/settings/v2/", host);
    }

    public static String getSystemVersion() {
        return Build.VERSION.RELEASE;
    }

    public static int getSystemAPI() {
        return Build.VERSION.SDK_INT;
    }

    public static String getSystemModel() {
        return Build.MODEL;
    }

    public static String getDeviceBrand() {
        return Build.BRAND;
    }

    public static String getDeviceModel() {
        return Build.MODEL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, String content) {
        HttpURLConnection connect = null;
        try {
            URL mURL = new URL(url);
            connect = (HttpURLConnection)mURL.openConnection();
            connect.setReadTimeout(6000);
            connect.setConnectTimeout(11000);
            connect.setRequestMethod("POST");
            connect.setDoOutput(true);
            String data = content;
            OutputStream out = connect.getOutputStream();
            out.write(data.getBytes());
            out.flush();
            out.close();
            int responseCode = connect.getResponseCode();
            if (responseCode == 200) {
                String response;
                InputStream is = connect.getInputStream();
                String string = response = TTVideoSettingsUtil.getStringFromInputStream(is);
                return string;
            }
            try {
                throw new NetworkErrorException("response status is " + responseCode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            if (connect != null) {
                connect.disconnect();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url) {
        HttpURLConnection connect = null;
        if (url == null || url.isEmpty()) {
            return null;
        }
        try {
            URL mURL = new URL(url);
            connect = (HttpURLConnection)mURL.openConnection();
            connect.setReadTimeout(6000);
            connect.setConnectTimeout(11000);
            connect.setRequestMethod("GET");
            int responseCode = connect.getResponseCode();
            if (responseCode == 200) {
                String response;
                InputStream is = connect.getInputStream();
                String string = response = TTVideoSettingsUtil.getStringFromInputStream(is);
                return string;
            }
            try {
                throw new NetworkErrorException("response status is " + responseCode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            if (connect != null) {
                connect.disconnect();
            }
        }
        return null;
    }

    private static String getStringFromInputStream(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = -1;
        while ((len = is.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
        is.close();
        String state = os.toString();
        os.close();
        return state;
    }

    public static String getString(Context context, String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        SharedPreferences preferences = TTVideoSettingsUtil.getSp(context);
        return preferences.getString(key, "");
    }

    public static String getString(Context context, String key, String value) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        SharedPreferences preferences = TTVideoSettingsUtil.getSp(context);
        return preferences.getString(key, value);
    }

    public static void putString(Context context, String key, String value) {
        if (key == null || key.isEmpty() || value == null || value.isEmpty()) {
            return;
        }
        SharedPreferences preferences = TTVideoSettingsUtil.getSp(context);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(key, value);
        editor.commit();
    }

    public static void putLong(Context context, String key, long value) {
        if (key == null || key.isEmpty()) {
            return;
        }
        SharedPreferences sp = TTVideoSettingsUtil.getSp(context);
        SharedPreferences.Editor editor = sp.edit();
        editor.putLong(key, value);
        editor.commit();
    }

    public static long getLong(Context context, String key, long defValue) {
        SharedPreferences sp = TTVideoSettingsUtil.getSp(context);
        return sp.getLong(key, defValue);
    }

    public static void v(String tag, String msg) {
        if (tag == null || tag.length() == 0 || msg == null || msg.length() == 0) {
            return;
        }
        int segmentSize = 3072;
        long length = msg.length();
        if (length <= (long)segmentSize) {
            Log.v((String)tag, (String)msg);
        } else {
            while (msg.length() > segmentSize) {
                String logContent = msg.substring(0, segmentSize);
                msg = msg.replace(logContent, "");
                Log.e((String)tag, (String)logContent);
            }
            Log.v((String)tag, (String)msg);
        }
    }
}

