/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.common.globalsettings;

import com.pandora.common.globalsettings.GlobalSdkParamsListener;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class GlobalSdkParams {
    private JSONObject settings;
    private CopyOnWriteArrayList<GlobalSdkParamsListener> arrayListener = new CopyOnWriteArrayList();

    private GlobalSdkParams() {
    }

    public static GlobalSdkParams getInstance() {
        return GlobalSdkParamsHolder.INSTANCE;
    }

    public void addListener(GlobalSdkParamsListener listener) {
        this.arrayListener.add(listener);
    }

    public synchronized boolean setSettings(JSONObject settings) {
        if (this.settings == null) {
            try {
                this.settings = new JSONObject(settings.toString());
                this.onUpdate();
            }
            catch (JSONException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private void onUpdate() {
        for (GlobalSdkParamsListener listener : this.arrayListener) {
            listener.onNotify(0);
        }
    }

    public JSONObject getSettings() {
        if (this.settings != null) {
            try {
                return new JSONObject(this.settings.toString());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static class GlobalSdkParamsHolder {
        private static final GlobalSdkParams INSTANCE = new GlobalSdkParams();

        private GlobalSdkParamsHolder() {
        }
    }
}

