/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.common.globalsettings;

import android.accounts.NetworkErrorException;
import android.os.Build;
import android.text.TextUtils;
import com.pandora.common.env.Env;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;

public class GlobalSdkParamsUtil {
    public static final String TAG = "GlobalSdkParamsUtil";
    public static final String CN_HOST = "https://stream.snssdk.com";

    public static String settingURLString(String host) {
        if (host == null) {
            return null;
        }
        HashMap<String, String> queryItems = new HashMap<String, String>();
        queryItems.put("device_platform", "android");
        queryItems.put("aid", GlobalSdkParamsUtil.getAppID());
        queryItems.put("device_id", GlobalSdkParamsUtil.getDeviceId());
        queryItems.put("user_id", GlobalSdkParamsUtil.getUserId());
        queryItems.put("device_type", GlobalSdkParamsUtil.getSystemModel());
        queryItems.put("os_version", GlobalSdkParamsUtil.getSystemVersion());
        queryItems.put("sdk_version", GlobalSdkParamsUtil.getSdkVersion());
        queryItems.put("app_version_code", GlobalSdkParamsUtil.getAppVersionCode());
        queryItems.put("project_key", GlobalSdkParamsUtil.getProjectKey());
        StringBuilder queryStr = new StringBuilder();
        try {
            for (String key : queryItems.keySet()) {
                if (TextUtils.isEmpty((CharSequence)((CharSequence)queryItems.get(key)))) continue;
                String encodedValue = URLEncoder.encode((String)queryItems.get(key), "UTF-8");
                queryStr.append("&").append(key).append("=").append(encodedValue);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (queryStr.length() == 0) {
            return null;
        }
        return String.format("%s/neptune/platform/v2/external/sched_config/GetGlobalSdkParams?%s", host, queryStr.substring(1));
    }

    public static String getAppID() {
        return Env.getAppID();
    }

    public static String getDeviceId() {
        if (Env.getAppLogClient() == null) {
            return "";
        }
        return Env.getAppLogClient().getDeviceID();
    }

    public static String getUserId() {
        if (Env.getAppLogClient() == null) {
            return "";
        }
        return Env.getAppLogClient().getUUID();
    }

    public static String getSystemVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getSystemModel() {
        return Build.MODEL;
    }

    public static String getSdkVersion() {
        return Env.getVersion();
    }

    public static String getAppVersionCode() {
        return null;
    }

    public static String getProjectKey() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url) {
        HttpURLConnection conn = null;
        String response = null;
        if (!TextUtils.isEmpty((CharSequence)url)) {
            try {
                URL mURL = new URL(url);
                conn = (HttpURLConnection)mURL.openConnection();
                conn.setRequestMethod("GET");
                conn.setReadTimeout(5000);
                conn.setConnectTimeout(10000);
                int responseCode = conn.getResponseCode();
                if (responseCode != 200) {
                    throw new NetworkErrorException("response status is " + responseCode);
                }
                InputStream is = conn.getInputStream();
                response = GlobalSdkParamsUtil.getStringFromInputStream(is);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
        return response;
    }

    private static String getStringFromInputStream(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = is.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
        is.close();
        String state = os.toString();
        os.close();
        return state;
    }
}

