/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.common.utils;

import android.text.TextUtils;
import android.text.format.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public final class TimeUtil {
    private TimeUtil() {
    }

    public static Calendar getCalendar(long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        return calendar;
    }

    public static long getUtcMillis(long millis) {
        Calendar calendar = TimeUtil.getCalendar(millis);
        long offset = calendar.get(15);
        return millis - offset;
    }

    public static long getMillis(long millis) {
        return TimeUtil.getUtcMillis(millis) + 28800000L;
    }

    public static long getPhpSeconds(long millis) {
        return millis / 1000L;
    }

    public static long getAndroidMillis(long seconds) {
        return seconds * 1000L;
    }

    public static long getCurMillis() {
        return TimeUtil.getMillis(System.currentTimeMillis());
    }

    public static int getCurSeconds() {
        return (int)(TimeUtil.getCurMillis() / 1000L);
    }

    public static String getCurDateText() {
        long curMillis = TimeUtil.getCurMillis();
        return TimeUtil.format(curMillis, "yyyy-MM-dd");
    }

    public static String getCurDateTimeText() {
        long curMillis = TimeUtil.getCurMillis();
        return TimeUtil.format(curMillis, "yyyy-MM-dd kk:mm:ss");
    }

    public static long parseMillis(String dateText, String fmt) throws ParseException {
        if (TextUtils.isEmpty((CharSequence)dateText)) {
            throw new NullPointerException("dateText\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)fmt)) {
            throw new NullPointerException("fmt\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(fmt, Locale.getDefault());
        Date date = sdf.parse(dateText);
        return date.getTime();
    }

    public static String format(long millis, String fmt) {
        if (TextUtils.isEmpty((CharSequence)fmt)) {
            throw new NullPointerException("fmt\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return (String)DateFormat.format((CharSequence)fmt, (long)millis);
    }

    public static String format(String inDateText, String inFmt, String outFmt) throws ParseException {
        if (TextUtils.isEmpty((CharSequence)inDateText)) {
            throw new NullPointerException("inDateText\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)inFmt)) {
            throw new NullPointerException("inFmt\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)outFmt)) {
            throw new NullPointerException("outFmt\u4e0d\u80fd\u4e3a\u7a7a");
        }
        long millis = TimeUtil.parseMillis(inDateText, inFmt);
        return TimeUtil.format(millis, outFmt);
    }

    public static String modDays(String timeText, String format, int days) throws ParseException {
        if (TextUtils.isEmpty((CharSequence)timeText)) {
            throw new NullPointerException("timeText\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)format)) {
            throw new NullPointerException("format\u4e0d\u80fd\u4e3a\u7a7a");
        }
        long millis = TimeUtil.parseMillis(timeText, format);
        Calendar calendar = TimeUtil.getCalendar(millis);
        calendar.set(5, calendar.get(5) + days);
        millis = calendar.getTimeInMillis();
        return TimeUtil.format(millis, format);
    }

    public static boolean isThisYear(String timeText, String format) throws ParseException {
        if (TextUtils.isEmpty((CharSequence)timeText)) {
            throw new NullPointerException("timeText\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (TextUtils.isEmpty((CharSequence)format)) {
            throw new NullPointerException("format\u4e0d\u80fd\u4e3a\u7a7a");
        }
        long millis = TimeUtil.parseMillis(timeText, format);
        Calendar calendar = TimeUtil.getCalendar(millis);
        Calendar curCalendar = Calendar.getInstance();
        return calendar.get(1) == curCalendar.get(1);
    }

    public static long getRelativeDays(long lastMillis) {
        return (TimeUtil.getCurMillis() - TimeUtil.getAndroidMillis(lastMillis)) / 86400000L;
    }
}

