/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers;

import android.content.ContentResolver;
import android.content.Context;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.SystemClock;
import android.os.Vibrator;
import android.provider.Settings;

public class HapticFeedbackController {
    private static final int VIBRATE_DELAY_MS = 125;
    private static final int VIBRATE_LENGTH_MS = 5;
    private final Context mContext;
    private final ContentObserver mContentObserver;
    private Vibrator mVibrator;
    private boolean mIsGloballyEnabled;
    private boolean mHasPermissions;
    private long mLastVibrate;

    public HapticFeedbackController(Context context) {
        this.mContext = context;
        this.mContentObserver = new ContentObserver(null){

            public void onChange(boolean selfChange) {
                HapticFeedbackController.this.mIsGloballyEnabled = HapticFeedbackController.checkGlobalSetting(HapticFeedbackController.this.mContext);
            }
        };
    }

    private static boolean checkGlobalSetting(Context context) {
        return Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"haptic_feedback_enabled", (int)0) == 1;
    }

    private static boolean checkAppPermissions(Context context) {
        return context.checkCallingOrSelfPermission("android.permission.VIBRATE") == 0;
    }

    public void start() {
        this.mVibrator = (Vibrator)this.mContext.getSystemService("vibrator");
        this.mIsGloballyEnabled = HapticFeedbackController.checkGlobalSetting(this.mContext);
        this.mHasPermissions = HapticFeedbackController.checkAppPermissions(this.mContext);
        Uri uri = Settings.System.getUriFor((String)"haptic_feedback_enabled");
        this.mContext.getContentResolver().registerContentObserver(uri, false, this.mContentObserver);
    }

    public void stop() {
        this.mVibrator = null;
        this.mContext.getContentResolver().unregisterContentObserver(this.mContentObserver);
    }

    public void tryVibrate() {
        long now;
        if (this.mVibrator != null && this.mIsGloballyEnabled && this.mHasPermissions && (now = SystemClock.uptimeMillis()) - this.mLastVibrate >= 125L) {
            this.mVibrator.vibrate(5L);
            this.mLastVibrate = now;
        }
    }
}

