/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.datepicker;

import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.datepicker.DatePicker;
import java.util.Vector;

public class DatePickerDialogFragment
extends DialogFragment {
    private static final String REFERENCE_KEY = "DatePickerDialogFragment_ReferenceKey";
    private static final String THEME_RES_ID_KEY = "DatePickerDialogFragment_ThemeResIdKey";
    private static final String MONTH_KEY = "DatePickerDialogFragment_MonthKey";
    private static final String DAY_KEY = "DatePickerDialogFragment_DayKey";
    private static final String YEAR_KEY = "DatePickerDialogFragment_YearKey";
    private Button mSet;
    private Button mCancel;
    private DatePicker mPicker;
    private int mMonthOfYear = -1;
    private int mDayOfMonth = 0;
    private int mYear = 0;
    private int mReference = -1;
    private int mTheme = -1;
    private View mDividerOne;
    private View mDividerTwo;
    private int mDividerColor;
    private ColorStateList mTextColor;
    private int mButtonBackgroundResId;
    private int mDialogBackgroundResId;
    private Vector<DatePickerDialogHandler> mDatePickerDialogHandlers = new Vector();

    public static DatePickerDialogFragment newInstance(int reference, int themeResId, Integer monthOfYear, Integer dayOfMonth, Integer year) {
        DatePickerDialogFragment frag = new DatePickerDialogFragment();
        Bundle args = new Bundle();
        args.putInt(REFERENCE_KEY, reference);
        args.putInt(THEME_RES_ID_KEY, themeResId);
        if (monthOfYear != null) {
            args.putInt(MONTH_KEY, monthOfYear.intValue());
        }
        if (dayOfMonth != null) {
            args.putInt(DAY_KEY, dayOfMonth.intValue());
        }
        if (year != null) {
            args.putInt(YEAR_KEY, year.intValue());
        }
        frag.setArguments(args);
        return frag;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle args = this.getArguments();
        if (args != null && args.containsKey(REFERENCE_KEY)) {
            this.mReference = args.getInt(REFERENCE_KEY);
        }
        if (args != null && args.containsKey(THEME_RES_ID_KEY)) {
            this.mTheme = args.getInt(THEME_RES_ID_KEY);
        }
        if (args != null && args.containsKey(MONTH_KEY)) {
            this.mMonthOfYear = args.getInt(MONTH_KEY);
        }
        if (args != null && args.containsKey(DAY_KEY)) {
            this.mDayOfMonth = args.getInt(DAY_KEY);
        }
        if (args != null && args.containsKey(YEAR_KEY)) {
            this.mYear = args.getInt(YEAR_KEY);
        }
        this.setStyle(1, 0);
        this.mTextColor = this.getResources().getColorStateList(R.color.dialog_text_color_holo_dark);
        this.mButtonBackgroundResId = R.drawable.button_background_dark;
        this.mDividerColor = this.getResources().getColor(R.color.default_divider_color_dark);
        this.mDialogBackgroundResId = R.drawable.dialog_full_holo_dark;
        if (this.mTheme != -1) {
            TypedArray a = this.getActivity().getApplicationContext().obtainStyledAttributes(this.mTheme, R.styleable.BetterPickersDialogFragment);
            this.mTextColor = a.getColorStateList(R.styleable.BetterPickersDialogFragment_bpTextColor);
            this.mButtonBackgroundResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpButtonBackground, this.mButtonBackgroundResId);
            this.mDividerColor = a.getColor(R.styleable.BetterPickersDialogFragment_bpDividerColor, this.mDividerColor);
            this.mDialogBackgroundResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpDialogBackground, this.mDialogBackgroundResId);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.date_picker_dialog, null);
        this.mSet = (Button)v.findViewById(R.id.set_button);
        this.mCancel = (Button)v.findViewById(R.id.cancel_button);
        this.mCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DatePickerDialogFragment.this.dismiss();
            }
        });
        this.mPicker = (DatePicker)v.findViewById(R.id.date_picker);
        this.mPicker.setSetButton(this.mSet);
        this.mPicker.setDate(this.mYear, this.mMonthOfYear, this.mDayOfMonth);
        this.mSet.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                for (DatePickerDialogHandler handler : DatePickerDialogFragment.this.mDatePickerDialogHandlers) {
                    handler.onDialogDateSet(DatePickerDialogFragment.this.mReference, DatePickerDialogFragment.this.mPicker.getYear(), DatePickerDialogFragment.this.mPicker.getMonthOfYear(), DatePickerDialogFragment.this.mPicker.getDayOfMonth());
                }
                FragmentActivity activity = DatePickerDialogFragment.this.getActivity();
                Fragment fragment = DatePickerDialogFragment.this.getTargetFragment();
                if (activity instanceof DatePickerDialogHandler) {
                    DatePickerDialogHandler act = (DatePickerDialogHandler)activity;
                    act.onDialogDateSet(DatePickerDialogFragment.this.mReference, DatePickerDialogFragment.this.mPicker.getYear(), DatePickerDialogFragment.this.mPicker.getMonthOfYear(), DatePickerDialogFragment.this.mPicker.getDayOfMonth());
                } else if (fragment instanceof DatePickerDialogHandler) {
                    DatePickerDialogHandler frag = (DatePickerDialogHandler)fragment;
                    frag.onDialogDateSet(DatePickerDialogFragment.this.mReference, DatePickerDialogFragment.this.mPicker.getYear(), DatePickerDialogFragment.this.mPicker.getMonthOfYear(), DatePickerDialogFragment.this.mPicker.getDayOfMonth());
                }
                DatePickerDialogFragment.this.dismiss();
            }
        });
        this.mDividerOne = v.findViewById(R.id.divider_1);
        this.mDividerTwo = v.findViewById(R.id.divider_2);
        this.mDividerOne.setBackgroundColor(this.mDividerColor);
        this.mDividerTwo.setBackgroundColor(this.mDividerColor);
        this.mSet.setTextColor(this.mTextColor);
        this.mSet.setBackgroundResource(this.mButtonBackgroundResId);
        this.mCancel.setTextColor(this.mTextColor);
        this.mCancel.setBackgroundResource(this.mButtonBackgroundResId);
        this.mPicker.setTheme(this.mTheme);
        this.getDialog().getWindow().setBackgroundDrawableResource(this.mDialogBackgroundResId);
        return v;
    }

    public void setDatePickerDialogHandlers(Vector<DatePickerDialogHandler> handlers) {
        this.mDatePickerDialogHandlers = handlers;
    }

    public static interface DatePickerDialogHandler {
        public void onDialogDateSet(int var1, int var2, int var3, int var4);
    }
}

