/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.datepicker;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Typeface;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.View;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.widget.PickerLinearLayout;
import com.codetroopers.betterpickers.widget.UnderlinePageIndicatorPicker;
import com.codetroopers.betterpickers.widget.ZeroTopPaddingTextView;

public class DateView
extends PickerLinearLayout {
    private ZeroTopPaddingTextView mMonth;
    private ZeroTopPaddingTextView mDate;
    private ZeroTopPaddingTextView mYearLabel;
    private final Typeface mAndroidClockMonoThin;
    private Typeface mOriginalNumberTypeface;
    private UnderlinePageIndicatorPicker mUnderlinePageIndicatorPicker;
    private ColorStateList mTitleColor;

    public DateView(Context context) {
        this(context, null);
    }

    public DateView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mAndroidClockMonoThin = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/AndroidClockMono-Thin.ttf");
        this.mOriginalNumberTypeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/Roboto-Bold.ttf");
        this.mTitleColor = this.getResources().getColorStateList(R.color.dialog_text_color_holo_dark);
        this.setWillNotDraw(false);
    }

    public void setTheme(int themeResId) {
        if (themeResId != -1) {
            TypedArray a = this.getContext().obtainStyledAttributes(themeResId, R.styleable.BetterPickersDialogFragment);
            this.mTitleColor = a.getColorStateList(R.styleable.BetterPickersDialogFragment_bpTitleColor);
        }
        this.restyleViews();
    }

    private void restyleViews() {
        if (this.mMonth != null) {
            this.mMonth.setTextColor(this.mTitleColor);
        }
        if (this.mDate != null) {
            this.mDate.setTextColor(this.mTitleColor);
        }
        if (this.mYearLabel != null) {
            this.mYearLabel.setTextColor(this.mTitleColor);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mMonth = (ZeroTopPaddingTextView)this.findViewById(R.id.month);
        this.mDate = (ZeroTopPaddingTextView)this.findViewById(R.id.date);
        this.mYearLabel = (ZeroTopPaddingTextView)this.findViewById(R.id.year_label);
        char[] dateFormatOrder = DateFormat.getDateFormatOrder((Context)this.getContext());
        this.removeAllViews();
        block5: for (int i = 0; i < dateFormatOrder.length; ++i) {
            switch (dateFormatOrder[i]) {
                case 'd': {
                    this.addView((View)this.mDate);
                    continue block5;
                }
                case 'M': {
                    this.addView((View)this.mMonth);
                    continue block5;
                }
                case 'y': {
                    this.addView((View)this.mYearLabel);
                }
            }
        }
        if (this.mMonth != null) {
            // empty if block
        }
        if (this.mDate != null) {
            this.mDate.setTypeface(this.mAndroidClockMonoThin);
            this.mDate.updatePadding();
        }
        if (this.mMonth != null) {
            this.mMonth.setTypeface(this.mAndroidClockMonoThin);
            this.mMonth.updatePadding();
        }
        this.restyleViews();
    }

    public void setDate(String month, int dayOfMonth, int year) {
        if (this.mMonth != null) {
            if (month.equals("")) {
                this.mMonth.setText("-");
                this.mMonth.setTypeface(this.mAndroidClockMonoThin);
                this.mMonth.setEnabled(false);
                this.mMonth.updatePadding();
            } else {
                this.mMonth.setText(month);
                this.mMonth.setTypeface(this.mOriginalNumberTypeface);
                this.mMonth.setEnabled(true);
                this.mMonth.updatePaddingForBoldDate();
            }
        }
        if (this.mDate != null) {
            if (dayOfMonth <= 0) {
                this.mDate.setText("-");
                this.mDate.setEnabled(false);
                this.mDate.updatePadding();
            } else {
                this.mDate.setText(Integer.toString(dayOfMonth));
                this.mDate.setEnabled(true);
                this.mDate.updatePadding();
            }
        }
        if (this.mYearLabel != null) {
            if (year <= 0) {
                this.mYearLabel.setText("----");
                this.mYearLabel.setEnabled(false);
                this.mYearLabel.updatePadding();
            } else {
                String yearString = Integer.toString(year);
                while (yearString.length() < 4) {
                    yearString = "-" + yearString;
                }
                this.mYearLabel.setText(yearString);
                this.mYearLabel.setEnabled(true);
                this.mYearLabel.updatePadding();
            }
        }
    }

    public void setUnderlinePage(UnderlinePageIndicatorPicker indicator) {
        this.mUnderlinePageIndicatorPicker = indicator;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mUnderlinePageIndicatorPicker.setTitleView(this);
    }

    public void setOnClick(View.OnClickListener mOnClickListener) {
        this.mDate.setOnClickListener(mOnClickListener);
        this.mMonth.setOnClickListener(mOnClickListener);
        this.mYearLabel.setOnClickListener(mOnClickListener);
    }

    public ZeroTopPaddingTextView getDate() {
        return this.mDate;
    }

    public ZeroTopPaddingTextView getMonth() {
        return this.mMonth;
    }

    public ZeroTopPaddingTextView getYear() {
        return this.mYearLabel;
    }

    @Override
    public View getViewAt(int index) {
        return this.getChildAt(index);
    }
}

