/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.hmspicker;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.hmspicker.HmsView;

public class HmsPicker
extends LinearLayout
implements View.OnClickListener,
View.OnLongClickListener {
    protected int mInputSize = 5;
    protected final Button[] mNumbers = new Button[10];
    protected int[] mInput = new int[this.mInputSize];
    protected int mInputPointer = -1;
    protected ImageButton mDelete;
    protected Button mLeft;
    protected Button mRight;
    protected HmsView mEnteredHms;
    protected final Context mContext;
    private TextView mHoursLabel;
    private TextView mMinutesLabel;
    private TextView mSecondsLabel;
    private Button mSetButton;
    protected View mDivider;
    private ColorStateList mTextColor;
    private int mKeyBackgroundResId;
    private int mButtonBackgroundResId;
    private int mDividerColor;
    private int mDeleteDrawableSrcResId;
    private int mTheme = -1;

    public HmsPicker(Context context) {
        this(context, null);
    }

    public HmsPicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        LayoutInflater layoutInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        layoutInflater.inflate(this.getLayoutId(), (ViewGroup)this);
        this.mTextColor = this.getResources().getColorStateList(R.color.dialog_text_color_holo_dark);
        this.mKeyBackgroundResId = R.drawable.key_background_dark;
        this.mButtonBackgroundResId = R.drawable.button_background_dark;
        this.mDividerColor = this.getResources().getColor(R.color.default_divider_color_dark);
        this.mDeleteDrawableSrcResId = R.drawable.ic_backspace_dark;
    }

    protected int getLayoutId() {
        return R.layout.hms_picker_view;
    }

    public void setTheme(int themeResId) {
        this.mTheme = themeResId;
        if (this.mTheme != -1) {
            TypedArray a = this.getContext().obtainStyledAttributes(themeResId, R.styleable.BetterPickersDialogFragment);
            this.mTextColor = a.getColorStateList(R.styleable.BetterPickersDialogFragment_bpTextColor);
            this.mKeyBackgroundResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpKeyBackground, this.mKeyBackgroundResId);
            this.mButtonBackgroundResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpButtonBackground, this.mButtonBackgroundResId);
            this.mDividerColor = a.getColor(R.styleable.BetterPickersDialogFragment_bpDividerColor, this.mDividerColor);
            this.mDeleteDrawableSrcResId = a.getResourceId(R.styleable.BetterPickersDialogFragment_bpDeleteIcon, this.mDeleteDrawableSrcResId);
        }
        this.restyleViews();
    }

    private void restyleViews() {
        for (Button number : this.mNumbers) {
            if (number == null) continue;
            number.setTextColor(this.mTextColor);
            number.setBackgroundResource(this.mKeyBackgroundResId);
        }
        if (this.mDivider != null) {
            this.mDivider.setBackgroundColor(this.mDividerColor);
        }
        if (this.mHoursLabel != null) {
            this.mHoursLabel.setTextColor(this.mTextColor);
            this.mHoursLabel.setBackgroundResource(this.mKeyBackgroundResId);
        }
        if (this.mMinutesLabel != null) {
            this.mMinutesLabel.setTextColor(this.mTextColor);
            this.mMinutesLabel.setBackgroundResource(this.mKeyBackgroundResId);
        }
        if (this.mSecondsLabel != null) {
            this.mSecondsLabel.setTextColor(this.mTextColor);
            this.mSecondsLabel.setBackgroundResource(this.mKeyBackgroundResId);
        }
        if (this.mDelete != null) {
            this.mDelete.setBackgroundResource(this.mButtonBackgroundResId);
            this.mDelete.setImageDrawable(this.getResources().getDrawable(this.mDeleteDrawableSrcResId));
        }
        if (this.mEnteredHms != null) {
            this.mEnteredHms.setTheme(this.mTheme);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        View v1 = this.findViewById(R.id.first);
        View v2 = this.findViewById(R.id.second);
        View v3 = this.findViewById(R.id.third);
        View v4 = this.findViewById(R.id.fourth);
        this.mEnteredHms = (HmsView)this.findViewById(R.id.hms_text);
        this.mDelete = (ImageButton)this.findViewById(R.id.delete);
        this.mDelete.setOnClickListener((View.OnClickListener)this);
        this.mDelete.setOnLongClickListener((View.OnLongClickListener)this);
        this.mNumbers[1] = (Button)v1.findViewById(R.id.key_left);
        this.mNumbers[2] = (Button)v1.findViewById(R.id.key_middle);
        this.mNumbers[3] = (Button)v1.findViewById(R.id.key_right);
        this.mNumbers[4] = (Button)v2.findViewById(R.id.key_left);
        this.mNumbers[5] = (Button)v2.findViewById(R.id.key_middle);
        this.mNumbers[6] = (Button)v2.findViewById(R.id.key_right);
        this.mNumbers[7] = (Button)v3.findViewById(R.id.key_left);
        this.mNumbers[8] = (Button)v3.findViewById(R.id.key_middle);
        this.mNumbers[9] = (Button)v3.findViewById(R.id.key_right);
        this.mLeft = (Button)v4.findViewById(R.id.key_left);
        this.mNumbers[0] = (Button)v4.findViewById(R.id.key_middle);
        this.mRight = (Button)v4.findViewById(R.id.key_right);
        this.setLeftRightEnabled(false);
        for (int i = 0; i < 10; ++i) {
            this.mNumbers[i].setOnClickListener((View.OnClickListener)this);
            this.mNumbers[i].setText((CharSequence)String.format("%d", i));
            this.mNumbers[i].setTag(R.id.numbers_key, (Object)new Integer(i));
        }
        this.updateHms();
        this.mHoursLabel = (TextView)this.findViewById(R.id.hours_label);
        this.mMinutesLabel = (TextView)this.findViewById(R.id.minutes_label);
        this.mSecondsLabel = (TextView)this.findViewById(R.id.seconds_label);
        this.mDivider = this.findViewById(R.id.divider);
        this.restyleViews();
        this.updateKeypad();
    }

    public void updateDeleteButton() {
        boolean enabled;
        boolean bl = enabled = this.mInputPointer != -1;
        if (this.mDelete != null) {
            this.mDelete.setEnabled(enabled);
        }
    }

    public void onClick(View v) {
        v.performHapticFeedback(1);
        this.doOnClick(v);
        this.updateDeleteButton();
    }

    protected void doOnClick(View v) {
        Integer val = (Integer)v.getTag(R.id.numbers_key);
        if (val != null) {
            this.addClickedNumber(val);
        } else if (v == this.mDelete && this.mInputPointer >= 0) {
            for (int i = 0; i < this.mInputPointer; ++i) {
                this.mInput[i] = this.mInput[i + 1];
            }
            this.mInput[this.mInputPointer] = 0;
            --this.mInputPointer;
        }
        this.updateKeypad();
    }

    public boolean onLongClick(View v) {
        v.performHapticFeedback(0);
        if (v == this.mDelete) {
            this.mDelete.setPressed(false);
            this.reset();
            this.updateKeypad();
            return true;
        }
        return false;
    }

    public void reset() {
        for (int i = 0; i < this.mInputSize; ++i) {
            this.mInput[i] = 0;
        }
        this.mInputPointer = -1;
        this.updateHms();
    }

    private void updateKeypad() {
        this.updateHms();
        this.enableSetButton();
        this.updateDeleteButton();
    }

    protected void updateHms() {
        this.mEnteredHms.setTime(this.mInput[4], this.mInput[3], this.mInput[2], this.mInput[1], this.mInput[0]);
    }

    private void addClickedNumber(int val) {
        if (this.mInputPointer < this.mInputSize - 1) {
            for (int i = this.mInputPointer; i >= 0; --i) {
                this.mInput[i + 1] = this.mInput[i];
            }
            ++this.mInputPointer;
            this.mInput[0] = val;
        }
    }

    private void enableSetButton() {
        if (this.mSetButton == null) {
            return;
        }
        if (this.mInputPointer == -1) {
            this.mSetButton.setEnabled(false);
            return;
        }
        this.mSetButton.setEnabled(this.mInputPointer >= 0);
    }

    public void setSetButton(Button b) {
        this.mSetButton = b;
        this.enableSetButton();
    }

    public int getHours() {
        int hours = this.mInput[4];
        return hours;
    }

    public int getMinutes() {
        return this.mInput[3] * 10 + this.mInput[2];
    }

    public int getSeconds() {
        return this.mInput[1] * 10 + this.mInput[0];
    }

    public void setTime(int hours, int minutes, int seconds) {
        this.mInput[4] = hours;
        this.mInput[3] = minutes / 10;
        this.mInput[2] = minutes % 10;
        this.mInput[1] = seconds / 10;
        this.mInput[0] = seconds % 10;
        for (int i = 4; i >= 0; --i) {
            if (this.mInput[i] <= 0) continue;
            this.mInputPointer = i;
            break;
        }
        this.updateKeypad();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable parcel = super.onSaveInstanceState();
        SavedState state = new SavedState(parcel);
        state.mInput = this.mInput;
        state.mInputPointer = this.mInputPointer;
        return state;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mInputPointer = savedState.mInputPointer;
        this.mInput = savedState.mInput;
        if (this.mInput == null) {
            this.mInput = new int[this.mInputSize];
            this.mInputPointer = -1;
        }
        this.updateKeypad();
    }

    public int getTime() {
        return this.mInput[4] * 3600 + this.mInput[3] * 600 + this.mInput[2] * 60 + this.mInput[1] * 10 + this.mInput[0];
    }

    public void saveEntryState(Bundle outState, String key) {
        outState.putIntArray(key, this.mInput);
    }

    public void restoreEntryState(Bundle inState, String key) {
        int[] input = inState.getIntArray(key);
        if (input != null && this.mInputSize == input.length) {
            for (int i = 0; i < this.mInputSize; ++i) {
                this.mInput[i] = input[i];
                if (this.mInput[i] == 0) continue;
                this.mInputPointer = i;
            }
            this.updateHms();
        }
    }

    protected void setLeftRightEnabled(boolean enabled) {
        this.mLeft.setEnabled(enabled);
        this.mRight.setEnabled(enabled);
        if (!enabled) {
            this.mLeft.setContentDescription(null);
            this.mRight.setContentDescription(null);
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        int mInputPointer;
        int[] mInput;
        int mAmPmState;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.mInputPointer = in.readInt();
            in.readIntArray(this.mInput);
            this.mAmPmState = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mInputPointer);
            dest.writeIntArray(this.mInput);
            dest.writeInt(this.mAmPmState);
        }
    }
}

