/*
 * Decompiled with CFR 0.152.
 */
package com.codetroopers.betterpickers.hmspicker;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.widget.LinearLayout;
import com.codetroopers.betterpickers.R;
import com.codetroopers.betterpickers.widget.ZeroTopPaddingTextView;

public class HmsView
extends LinearLayout {
    private ZeroTopPaddingTextView mHoursOnes;
    private ZeroTopPaddingTextView mMinutesOnes;
    private ZeroTopPaddingTextView mMinutesTens;
    private ZeroTopPaddingTextView mSecondsOnes;
    private ZeroTopPaddingTextView mSecondsTens;
    private final Typeface mAndroidClockMonoThin;
    private Typeface mOriginalHoursTypeface;
    private ColorStateList mTextColor;

    public HmsView(Context context) {
        this(context, null);
    }

    public HmsView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mAndroidClockMonoThin = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/AndroidClockMono-Thin.ttf");
        this.mTextColor = this.getResources().getColorStateList(R.color.dialog_text_color_holo_dark);
    }

    public void setTheme(int themeResId) {
        if (themeResId != -1) {
            TypedArray a = this.getContext().obtainStyledAttributes(themeResId, R.styleable.BetterPickersDialogFragment);
            this.mTextColor = a.getColorStateList(R.styleable.BetterPickersDialogFragment_bpTextColor);
        }
        this.restyleViews();
    }

    private void restyleViews() {
        if (this.mHoursOnes != null) {
            this.mHoursOnes.setTextColor(this.mTextColor);
        }
        if (this.mMinutesOnes != null) {
            this.mMinutesOnes.setTextColor(this.mTextColor);
        }
        if (this.mMinutesTens != null) {
            this.mMinutesTens.setTextColor(this.mTextColor);
        }
        if (this.mSecondsOnes != null) {
            this.mSecondsOnes.setTextColor(this.mTextColor);
        }
        if (this.mSecondsTens != null) {
            this.mSecondsTens.setTextColor(this.mTextColor);
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mHoursOnes = (ZeroTopPaddingTextView)this.findViewById(R.id.hours_ones);
        this.mMinutesTens = (ZeroTopPaddingTextView)this.findViewById(R.id.minutes_tens);
        this.mMinutesOnes = (ZeroTopPaddingTextView)this.findViewById(R.id.minutes_ones);
        this.mSecondsTens = (ZeroTopPaddingTextView)this.findViewById(R.id.seconds_tens);
        this.mSecondsOnes = (ZeroTopPaddingTextView)this.findViewById(R.id.seconds_ones);
        if (this.mHoursOnes != null) {
            this.mOriginalHoursTypeface = this.mHoursOnes.getTypeface();
            this.mHoursOnes.updatePaddingForBoldDate();
        }
        if (this.mMinutesTens != null) {
            this.mMinutesTens.updatePaddingForBoldDate();
        }
        if (this.mMinutesOnes != null) {
            this.mMinutesOnes.updatePaddingForBoldDate();
        }
        if (this.mSecondsTens != null) {
            this.mSecondsTens.setTypeface(this.mAndroidClockMonoThin);
            this.mSecondsTens.updatePadding();
        }
        if (this.mSecondsOnes != null) {
            this.mSecondsOnes.setTypeface(this.mAndroidClockMonoThin);
            this.mSecondsOnes.updatePadding();
        }
    }

    public void setTime(int hoursOnesDigit, int minutesTensDigit, int minutesOnesDigit, int secondsTensDigit, int secondsOnesDigit) {
        if (this.mHoursOnes != null) {
            this.mHoursOnes.setText(String.format("%d", hoursOnesDigit));
        }
        if (this.mMinutesTens != null) {
            this.mMinutesTens.setText(String.format("%d", minutesTensDigit));
        }
        if (this.mMinutesOnes != null) {
            this.mMinutesOnes.setText(String.format("%d", minutesOnesDigit));
        }
        if (this.mSecondsTens != null) {
            this.mSecondsTens.setText(String.format("%d", secondsTensDigit));
        }
        if (this.mSecondsOnes != null) {
            this.mSecondsOnes.setText(String.format("%d", secondsOnesDigit));
        }
    }
}

